<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Library
Librairie js et php globale à Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

/** 
 * @file lib_global_rss.php
 * @package Alkanet_Library
 * @brief Initialise les objects oSpace, oAppli et récupères les variables de bases
 */

// on interdit l'appel direct au lib_global.php
if( isset($_SERVER["PHP_SELF"]) && !(strpos($_SERVER["PHP_SELF"], "lib_global_rss.php") === false) ) {
  exit();
}

// chargement multilingue
AlkFactory::initLocale();

if ( !AlkRequest::readToken() ) {
  echo "<html><head><script type='text/javascript'>".
    " function onLoadWind() {".
    "   window.top.location = '".ALK_ALKANET_IDENT."?err=7';".
    " } </script></head><body onload='onLoadWind()'></body></html>";
  exit();
}
$cont_id = AlkRequest::getToken("cont_id", "-1");
$appli_id = AlkRequest::getToken("appli_id", "-1");

/** 
 * @brief applitype_id permet d'instancier une application n'ayant pas de appli_id
 *        comme l'éditeur, le circuit de validation
 *        Ces applis sont instanciés avec le appli_id qui utilise cette sous-appli
 */
$applitype_id = AlkRequest::getToken("applitype_id", "-1");

if( !(is_numeric($cont_id) && floor($cont_id)==$cont_id && $cont_id > 0) ) {
  echo "<html><head><script type='text/javascript'>".
    " function onLoadWind() {".
    "   window.top.location = '".ALK_ALKANET_IDENT."?err=7';".
    " } </script></head><body onload='onLoadWind()'></body></html>";
  exit();
}

if( !defined("ALK_B_ATYPE_ESPACE") ) define("ALK_B_ATYPE_ESPACE", true);
if( !defined("ALK_B_ATYPE_ABREV_".ALK_ATYPE_ID_ESPACE) ) define("ALK_B_ATYPE_ABREV_".ALK_ATYPE_ID_ESPACE, "Espace");

/** chargement des constantes */
// paramètres liés au chargement des constantes génériques 
$tabAtype[] = -1;
$tabAtype[] = 1;
$tabAtype[] = 0;
$tabCont[] = -1;
$tabAppli[] = -1;

//AlkFactory::loadConstants($cont_id, $appli_id);

$oQueryEspace = AlkFactory::getQuery(ALK_ATYPE_ID_ESPACE);
if( $applitype_id == "-1" ) {
  $atype_id = $oQueryEspace->getATypeID($appli_id);
} else {
  $atype_id = $applitype_id;
}

$tabCont[] = $cont_id;
$tabAppli[] = $appli_id;
$tabAtype[] = $atype_id;

AlkFactory::loadConstants($tabCont, $tabAppli, $tabAtype);

AlkFactory::setSProperty("cont_id", $cont_id);
AlkFactory::setSProperty("appli_id", $appli_id);
AlkFactory::setSProperty("atype_id", $atype_id);

$oSpace = AlkFactory::getSpace($cont_id);
if( $atype_id > 0 ) {
  $oAppli = AlkFactory::getAppli($atype_id, $appli_id);
} else {
  $oAppli = null;
}
if( file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CONF."app_conf_template.php") ) { 
  require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CONF."app_conf_template.php");
}
if( !defined("ALK_ROOT_TEMPLATE") )  define("ALK_ROOT_TEMPLATE",  ALK_ROOT_CONF."templates/");
/**
 * @brief oAppli->verifSecu() 
 *        met à jour user_priv et user_right par rapport 
 *        à l'espace courant et à l'application courante
 */
$binternet = AlkFactory::getSProperty("bInternet", false);
if( is_null($oAppli) ) {
  echo "<html><head><script type='text/javascript'>".
    " function onLoadWind() {".
    "   window.top.location = '".ALK_ALKANET_IDENT."?err=6';".
    " } </script></head><body onload='onLoadWind()'><!--<a href='javascript:onLoadWind()'>Aucun droit, redirection vers l'authentification.</a>--></body></html>";
  exit();
}
else {
  /* l'utilisateur est authentifié et ses droits vérifiés */
  
  /* on autorise $oAppli à null : cas prodigedist par exemple */
}

if( $oSpace!=null ) {
  $oSpace->updateStat($cont_id, $appli_id);
}

// traduction des éléments déclarés avant l'appel de AlkFactory::initLocale()
translateConf();

?>