<?php
/*licence/

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Class::Pattern
Module fournissant les classes de base Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.
**/

session_start();
require_once("../libconf/app_conf.php");
require_once(ALK_ALKANET_ROOT_PATH."lib/app_conf_alkanet.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkobject.class.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkrequest.class.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkfactory.class.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlfactory.class.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_LIB."lib_file.php");
AlkRequest::readToken();
$iAjax = AlkRequest::getToken("iAjax", "0");
$user = AlkRequest::getToken("user", "internet");
$password = AlkRequest::getToken("password", "");
$page = str_replace("|", "&", AlkRequest::getToken("page", Request("page", REQ_GET, "")));
if ( $page == "" ) {
  $page = "main.home";
}
// chemin d'un fichier thésaurus pour upload
$fileThesaurus = AlkRequest::getToken("fileThesaurus", Request("fileThesaurus", REQ_GET, ""));

$geosourceInterface = new Geosource($user, $password, ALK_GEOSOURCE_DIRECTORY);

// upload du fichier thésaurus si défini
if ( $fileThesaurus != "" ) {
  $geosourceInterface->uploadThesaurus($fileThesaurus);
  return;
}

$bOK = true;
if ( $user != "internet" && $password != "" ) {   // connexion à Géosource
  //déjà connecté et avec le même compte
  if(!$geosourceInterface->_isConnected){
    $geosourceInterface->disconnect();
    $bOK = $geosourceInterface->connect();
  }
} else {  // déconnection de Géosource si paramètre d'authentification manquant
  $geosourceInterface->disconnect();
}

if($bOK) {
  if ( $iAjax == 0 ) {
    header("location:".ALK_ROOT_URL."/".ALK_GEOSOURCE_DIRECTORY."/srv/fr/".urldecode($page));
  } else {
    $opts = array
      (
        'http'=>array
      (
        'method'=>"GET",
        'header'=>"Cookie: ".$geosourceInterface->_setCoockies
      )
    );
    $context = stream_context_create($opts);
    $response = @file_get_contents(ALK_ROOT_URL."/".ALK_GEOSOURCE_DIRECTORY."/srv/fr/".urldecode($page), false, $context);
    if ( $geosourceInterface->hasQueryFail($response) ) {
      echo 2;
    } else {
      echo 0;
    }
  }
} else {
  if ( $iAjax == 0 ) {
    die("Problème de connexion à Géosource");
  } else {
    echo 1;
  }
} 

/**
 * 
 * @author Alkante
 * @brief classe de connexion à Géosource
 *  
 */
class Geosource
{
  var $_urlBase;
  var $_isConnected;
  var $_setCoockies;
  var $page;
  var $username;
  var $password;
  
  /**
   *
   * @param $username nom de l'utilisateur
   * @param $password password de l'utilisateur
   * @param $tomcatDirectory répertoire virtuel geosource
   * @return unknown_type
   */
  function Geosource($username, $password, $tomcatDirectory)
  {
    $this->_urlBase = ALK_ROOT_URL;
    $this->_isConnected = false;
    $this->_isNotConnected = false;
    $this->_setCoockies = '';
    $this->tomcat_dir = $tomcatDirectory;
   /* if (isset($_COOKIE['JSESSIONID']) )//&& isset($_COOKIE['SRV_Path']))
    {
      //if(isset($_SESSION['userConnected']) && $_SESSION['userConnected']==$username)
        //$this->_isConnected = true;
      //$this->_setCoockies = 'JSESSIONID='.$_COOKIE['JSESSIONID'];//.'; Path='.$_COOKIE['SRV_Path'];
    }
*/
    $this->username = $username;
    $this->password = $password;
  }
  /**
   * @brief déconnecte l'utilisateur de Géosource
   * @todo vérifier la déconnexion
   */
  function disconnect()
  {
    setcookie("JSESSIONID", false, time() - 3600); 
    unset($_COOKIE['JSESSIONID']);
    $url = '/'.$this->tomcat_dir.'/srv/fr/user.logout';
    $headers = $this->read_headers($this->_urlBase.$url);
    if (isset($headers['Set-Cookie']))
      $this->_setCoockies = $headers['Set-Cookie'];
    else
      $this->_setCoockies = '';
    $cookies = explode('; ', $this->_setCoockies);
    foreach ($cookies as $cookie)
    {
      $param = explode('=', $cookies[0]);
      if (count($param) > 1)
        setcookie($param[0], implode('=', array_slice($param, 1)), null, "/".ALK_GEOSOURCE_DIRECTORY);
    }
    /*$opts = array
    (
          'http'=>array
    (
            'method'=>"GET",
            'header'=>"Cookie: ".$this->_setCoockies
    )
    );
    $context = stream_context_create($opts);
    $reponse = @file_get_contents($this->_urlBase.$url, false, $context);
    $this->_isNotConnected = !$this->hasQueryFail($reponse);*/
    //$_SESSION['userConnected'] = "internet";
    return true;  
    
  }
  /**
   * @brief connecte l'utilisateur à Géosource (enregistrement en cookie)
   * @return true si connecté
   */
  function connect()
  {
    $url = '/'.$this->tomcat_dir.'/srv/fr/user.login?username='.$this->username.'&password='.$this->password;
    $headers = $this->read_headers($this->_urlBase.$url);
    if (isset($headers['Set-Cookie']))
      $this->_setCoockies = $headers['Set-Cookie'];
    else
      $this->_setCoockies = '';
    $cookies = preg_split('(;\s*)', $this->_setCoockies);
    foreach ($cookies as $cookie)
    {
      $param = explode('=', $cookies[0]);
      if (count($param) > 1)
      setcookie($param[0], implode('=', array_slice($param, 1)), null, "/".ALK_GEOSOURCE_DIRECTORY);
    }
    $opts = array
    (
          'http'=>array
    (
            'method'=>"GET",
            'header'=>"Cookie: ".$this->_setCoockies
    )
    );
    $context = stream_context_create($opts);
    $reponse = @file_get_contents($this->_urlBase.$url, false, $context);
    $this->_isConnected = !$this->hasQueryFail($reponse);
    /*if($this->_isConnected)
      $_SESSION['userConnected'] = $this->username;*/
    return $this->_isConnected;
    
  }
  
  /**
   * @brief détecte si la connexion est active
   * @param contenu contenu HTML
   * @return true si la requete contient des erreurs
   */
  function hasQueryFail($contenu)
  {
    $rslt = false;
    if (is_null($contenu) || ($contenu == false) || ($contenu == ""))
      $rslt = true;
    if (($rslt == false) && (strpos($contenu, '<div id="error">') !== false))
      $rslt = true;
    return $rslt;
  }
  
  /**
   * @brief lit une entete HTML
   * @param $url url de lecture
   * @return entete
   */
  function read_headers($url)
  {
    $url_info = parse_url($url);
    $port = isset($url_info['port']) ? $url_info['port'] : 80;
    $fp = @fsockopen($url_info['host'], $port, $errno, $errstr, 30);
    if (!$fp)
    return false;// erreur fsockopen

    $head = 'HEAD '.@$url_info['path'];
    $head .= '?'.@$url_info['query'];
    $head .= " HTTP/1.0\r\nHost: ".@$url_info['host']."\r\n\r\n";
    fputs($fp, $head);
    while (!feof($fp))
    {
      if ($header = trim(fgets($fp, 1024)))
      {
        $key = array_shift(explode(':', $header));
        if($key == $header)
        $headers[] = $header;
        else
        $headers[$key] = substr($header, strlen($key) + 2);
        unset($key);
      }
    }

    if (isset($headers['Location']) && (substr($headers['Location'], -1) == '?'))
    $headers['Location'] = substr($headers['Location'], 0, -1);

    return $headers;
  }
  
  /**
   * @brief effectue l'upoad d'un thésaurus en Post
   * @param fileThesaurus   chemin du fichier thésaurus
   */
  function uploadThesaurus($fileThesaurus){
    $data = "";
    
    // générère le séparateur
    $strBoundary = "";
    for ( $i=0; $i<29; $i++ ) {
      $strBoundary .= rand(0, 9);
    }
    $boundary = "---------------------------".$strBoundary;   // séparateur
    
    // paramètre catégorie (place)
    $data .= "--$boundary\n"; 
    $data .= "Content-Disposition: form-data; name=\"dir\"\r\n";
    $data .= "\r\n";
    $data .= "place\r\n";
    
    // contenu du fichier thésaurus
    $data .= "--$boundary\r\n"; 
    $fileContents = file_get_contents($fileThesaurus);
    $data .= "Content-Disposition: form-data; name=\"fname\"; filename=\"".extractFileName($fileThesaurus)."\"\r\n";
    $data .= "Content-Type: application/rdf+xml\r\n";
    $data .= "\r\n";
    $data .= $fileContents."\r\n";
    $data .= "--$boundary--\r\n"; 
    
    // effectue une connexion et récupère les cookies
    $url = '/'.$this->tomcat_dir.'/srv/fr/user.login?username='.$this->username.'&password='.$this->password;
    $headers = $this->read_headers($this->_urlBase.$url);
    if (isset($headers['Set-Cookie']))
      $this->_setCoockies = $headers['Set-Cookie'];
    else
      $this->_setCoockies = '';
    $cookies = explode('; ', $this->_setCoockies);
    foreach ($cookies as $cookie)
    {
      $param = explode('=', $cookies[0]);
      if (count($param) > 1)
      setcookie($param[0], implode('=', array_slice($param, 1)), null, "/".ALK_GEOSOURCE_DIRECTORY);
    }
    
    // supprime le fichier thésaurus s'il existe
    if ( file_exists($fileThesaurus) ) {
      $url = '/'.$this->tomcat_dir.'/srv/fr/thesaurus.delete?ref=external.place.'.getFileRadical(extractFileName($fileThesaurus));
      $params = array('http' => array(
            'method'  => 'GET',
            'header'  => "Cookie: ".$this->_setCoockies
        ));
      $ctx = stream_context_create($params);
      $response = @file_get_contents($this->_urlBase.$url, false, $ctx);
    }
    
    // crée la requête
    $header = 'Content-Type: multipart/form-data; boundary='.$boundary."\r\n"."Cookie: ".$this->_setCoockies;
    
    $params = array('http' => array(
          'method'  => 'POST',
          'header'  => $header,
          'content' => $data
        ));
    
    // post la requête
    $ctx = stream_context_create($params);
    $url = '/'.$this->tomcat_dir.'/srv/fr/thesaurus.upload';
    $response = @file_get_contents($this->_urlBase.$url, false, $ctx);
    
//    echo $response;
//    $data = str_replace("<", "&lt;", $data);
//    $data = str_replace(">", "&gt;", $data);
//    $data = str_replace("\n", "<br/>", $data);
//    $data = str_replace("\t", "&nbsp;&nbsp;&nbsp;&nbsp;", $data);
//    echo $data;
  }
}

?>