/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Library
Librairie js et php globale à Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

function AlertMessageNum(Ctrl, iBorneInf, iBorneSup)
{
  var strAlert = ( !(iBorneInf==0 && iBorneSup==0)
                   ? _gtf("Ce champ doit être un nombre compris entre %s et %s", iBorneInf, iBorneSup)
                   : _gt("Ce champ doit être un nombre.") );
   
  alkAlert(strAlert);
  Ctrl.focus();
  return;
}
function isNumValid(strNum, iBorneInf, iBorneSup) 
{
  if (strNum == "") return false;
  var bOk = false;
  strNum = strNum.replace(/,/i, ".");
  var n = new Number(strNum);
  if( n.toString() == "NaN" ) {
    bOk = false;
  } else {
    if( !(iBorneInf == 0 && iBorneSup == 0) )
      if( iBorneInf <= n && n <= iBorneSup )
        bOk = true;
      else
        bOk = false;
    else
      bOk = true;
  }

  return bOk;
}
function ControlNumber(Objet, iBorneInf, iBorneSup) 
{
  var strNb = Objet.value;
  if( isNumValid(strNb, iBorneInf, iBorneSup) )
    return true;
  else {
    AlertMessageNum(Objet, iBorneInf, iBorneSup);
    return false;
  }
}
function verifNumValid(strNum, iBorneInf, iBorneSup, bStrict, strLabel) 
{
  if( typeof(bStrict)=="undefined" ) bStrict = true;
  var strReason = ".";
  if (strNum == "") return strReason;
  var iInfBorne = ( iBorneInf == "" ? 0 :  new Number(iBorneInf.replace(/,/i, ".")) );
  var iSupBorne = ( iBorneSup == "" ? 0 :  new Number(iBorneSup.replace(/,/i, ".")) );

  var bOk = false;
  strNum = strNum.replace(/,/i, ".");
  var n = new Number(strNum);
  if( n.toString() == "NaN" ) {
    bOk = false;
  } else {
    bOk = true;
    strReason = "";
  }
 
  if( bOk == true && ( iBorneInf != "" || iBorneSup != "" ) ) {
    strReason = "";
    if( iBorneInf=="" && iBorneSup!=""){
      if( (bStrict && n >= iSupBorne) || (!bStrict && n > iSupBorne) ) {
    	strReason = ( bStrict
    	              ? _gtf("Le champ %s nécessite un nombre strictement inférieur à %s.", strLabel, iBorneSup) 
    	              : _gtf("Le champ %s nécessite un nombre inférieur à %s.", strLabel, iBorneSup) );
      }
    } else if( iBorneInf!="" && iBorneSup=="" ) {
      if ( (bStrict && iInfBorne >= n) || (!bStrict && iInfBorne > n) ) {
        strReason = ( bStrict
    	                ? _gtf("Le champ %s nécessite un nombre strictement supérieur à %s.", strLabel, iBorneInf) 
    	                : _gtf("Le champ %s nécessite un nombre supérieur à %s.", strLabel, iBorneInf) );
      }
    } else if( (bStrict && (n<=iInfBorne || n>=iSupBorne)) || (!bStrict && (n<iInfBorne || n>iSupBorne)) ) {
      strReason = ( bStrict
    	                ? _gtf("Le champ %s nécessite un nombre compris strictement entre %s et %s.", strLabel, iBorneInf, iBorneSup) 
    	                : _gtf("Le champ %s nécessite un nombre compris entre %s et %s.", strLabel, iBorneInf, iBorneSup) ); 
    }
  }

  return strReason;
}
