/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Library
Librairie js et php globale à Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

function alertMsgDate(Ctrl, strMsg)
{
  alkAlert(strMsg);
  Ctrl.value = "";
  Ctrl.focus();
  return;
}

function isDateValidJJMMAAAA(strDate) 
{
  if( strDate.length != 10 ) return false;
  var bOk = false;
  var bBisex = false;
  var dd = new Number(strDate.substring(0, 2));
  var mm = new Number(strDate.substring(3, 5));
  var aaaa = new Number(strDate.substring(6, 10));
  if( strDate.charAt(2) != "\/" || strDate.charAt(5) != "\/" ) 
    bOk = false;
  else
    if( aaaa.toString() == "NaN" || aaaa<1900 || aaaa>2500 ) 
      bOk = false;
    else {
      if( (aaaa%4==0 && aaaa%100!=0) || (aaaa%400==0 && aaaa%100==0) ) bBisex = true;
      if( mm.toString() == "NaN" || mm<1 || mm>12 )
        bOk = false;
      else
        if( dd.toString() == "NaN" ||
          (dd<1 || dd>31) ||
          ((dd<1 || dd>30) && (mm==4 || mm==6 || mm==9 || mm==11)) ||
          ((dd<1 || dd>29) && mm==2 && bBisex==true) ||
          ((dd<1 || dd>28) && mm==2 && bBisex==false) )
          bOk = false;
        else
          bOk = true;
    }
  delete dd;
  delete mm;
  delete aaaa;
  return bOk;
}
function isDateValidJJMM(strDate) 
{
  if( strDate.length != 5 ) return false;
  var bOk = false;
  var dd = new Number(strDate.substring(0, 2));
  var mm = new Number(strDate.substring(3, 5));
  if( strDate.charAt(2) != "\/" ) 
    bOk = false;
  else {
    if( mm.toString() == "NaN" || mm<1 || mm>12 )
      bOk = false;
    else {
      if( dd.toString() == "NaN" ||
        (dd<1 || dd>31) ||
        ((dd<1 || dd>30) && (mm==4 || mm==6 || mm==9 || mm==11)) ||
        ((dd<1 || dd>29) && mm==2) )
        bOk = false;
      else
        bOk = true;
    }
  }
  delete dd;
  delete mm;
  return bOk;
}
function isDateValidMMAAAA(strDate) 
{
  if( strDate.length != 7 ) return false;
  var bOk = false;
  var mm = new Number(strDate.substring(0, 2));
  var aaaa = new Number(strDate.substring(3, 7));
  if( strDate.charAt(2) != "\/" ) 
    bOk = false;
  else {
    if( mm.toString() == "NaN" || mm<1 || mm>12 )
      bOk = false;
    else if( aaaa.toString() == "NaN" || aaaa<1900 || aaaa>2500 ) 
      bOk = false;
    else 
      bOk = true;
  }
  delete aaaa;
  delete mm;
  return bOk;
}
function isMonthValidMM(strMonth) 
{
  if( strMonth.length != 2 ) return false;
  var bOk = false;
  var mm = new Number(strMonth);
  if( mm.toString() == "NaN" || mm<1 || mm>12 )
	bOk = false;
  else 
	bOk = true;
  delete mm;
  return bOk;
}
function isYearValidAAAA(strYear) 
{
  if( strYear.length != 4 ) return false;
  var bOk = false;
  var aaaa = new Number(strYear);
  if( aaaa.toString() == "NaN" || aaaa<1900 || aaaa>2500 ) 
    bOk = false;
  else 
    bOk = true;
  delete aaaa;
  return bOk;
}
function ControleDate(Objet, lg)
{
  var strDate = Objet.value;
  if( strDate == "" )
    return true;
  if( lg == 5 ) {
    if( isDateValidJJMM(strDate) )
      return true;
    else {
      alertMsgDate(Objet, _gt("La date doit être dans un format JJ/MM valide !"));
      return false;
    }
  } else {
    if( isDateValidJJMMAAAA(strDate) )
      return true;
    else {
      alertMsgDate(Objet, _gt("La date doit être dans un format JJ/MM/AAAA valide !"));
      return false;
    }
  }
}


function isHeureValideHHMN(strHeure) 
{
  if( strHeure.length != 5 ) return false;
  var bOk = false;
  var hh = new Number(strHeure.substring(0, 2));
  var mn = new Number(strHeure.substring(3, 5));
  if( strHeure.charAt(2) != ":" ) 
    bOk = false;
  else {
    if( hh.toString() == "NaN" || hh<0 || hh>23 )
      bOk = false;
    else {
      if( mn.toString() == "NaN" || mn<0 || mn>59 )
        bOk = false;
      else
        bOk = true;
    }
  }
  delete hh;
  delete mn;
  return bOk;
}
function ControleHeure(Objet) 
{
  var strHeure = Objet.value;
  if( strHeure=="" || isHeureValideHHMN(strHeure) )
    return true;
  else {
    alertMsgDate(Objet, _gt("L'heure doit être dans un format HH:MN valide !"));
    return false;
  }
}
function verifDateValidJJMMAAAA(strDate, strDateMin, strDateMax, strLabel) 
{
  var strReason = _gtf("Le champ %s nécessite une date au format JJ/MM/AAAA.", strLabel);
  if( strDate.length != 10 ) return strReason;
  
  var strMinDate = ( strDateMin == "" ? "00010101" : strDateMin.substring(6, 10)+strDateMin.substring(3, 5)+strDateMin.substring(0, 2));
  var strMaxDate = ( strDateMax == "" ? "99991231" : strDateMax.substring(6, 10)+strDateMax.substring(3, 5)+strDateMax.substring(0, 2));

  var bOk = false;
  var bBisex = false;
  var dd = new Number(strDate.substring(0, 2));
  var mm = new Number(strDate.substring(3, 5));
  var aaaa = new Number(strDate.substring(6, 10));

  if( strDate.charAt(2) != "\/" || strDate.charAt(5) != "\/" ) 
    bOk = false;
  else
    if( aaaa.toString() == "NaN" ) 
      bOk = false;
    else {
      if( (aaaa%4==0 && aaaa%100!=0) || (aaaa%400==0 && aaaa%100==0) ) bBisex = true;
      if( mm.toString() == "NaN" || mm<1 || mm>12 )
        bOk = false;
      else
        if( dd.toString() == "NaN" ||
          (dd<1 || dd>31) ||
          ((dd<1 || dd>30) && (mm==4 || mm==6 || mm==9 || mm==11)) ||
          ((dd<1 || dd>29) && mm==2 && bBisex==true) ||
          ((dd<1 || dd>28) && mm==2 && bBisex==false) )
          bOk = false;
        else {
          bOk = true;
          strReason = "";
        }
    }

  if( bOk == true && ( strDateMin != "" || strDateMax != "" ) ) {
    var strCurDate = strDate.substring(6, 10)+strDate.substring(3, 5)+strDate.substring(0, 2);
    strReason = "";
    if( !(strMinDate<=strCurDate && strCurDate<=strMaxDate) ) {
      if( strDateMin == "" ) {
        strReason = _gtf("Le champ %s nécessite une date antérieure au %s.", strLabel, strDateMax);        
      } else if( strDateMax == "" ) {
        strReason = _gtf("Le champ %s nécessite une date postérieure au %s.", strLabel, strDateMin);
      } else {
        strReason = _gtf("Le champ %s nécessite une date comprise entre %s et %s.", strLabel, strDateMin, strDateMax);
      }      
    }
  }

  delete dd;
  delete mm;
  delete aaaa;

  return strReason;
}

function verifHeureValidHHMN(strHeure,strHeureMin, strHeureMax, strLabel)
{
  var strReason = _gtf("Le champ %s nécessite une heure au format HH:MN.", strLabel);
  if( strHeure.length != 5 ) return strReason;

  var strMinHeure = ( strHeureMin == "" ? "0000" : strHeureMin.substring(0, 2)+strHeureMin.substring(3, 5) );
  var strMaxHeure = ( strHeureMax == "" ? "2359" : strHeureMax.substring(0, 2)+strHeureMax.substring(3, 5) );

  var bOk = false;
  var hh = new Number(strHeure.substring(0, 2));
  var mn = new Number(strHeure.substring(3, 5));
  if( strHeure.charAt(2) != ":" ) {
    bOk = false;
  } else {
    if( hh.toString() == "NaN" || hh<0 || hh>23 ) {
      bOk = false;
    } else {
      if( mn.toString() == "NaN" || mn<0 || mn>59 ) {
        bOk = false;
       } else {
        bOk = true;
        strReason="";
       }
    }
  }
  
   if( bOk == true && ( strMinHeure != "" || strMaxHeure != "" ) ) {
    var strCurHeure = strHeure.substring(0, 2)+strHeure.substring(3, 5);
    strReason = "";
    if( !(strMinHeure<=strCurHeure && strCurHeure<=strMaxHeure) ) {
      if( strHeureMin == "" ) {
        strReason = _gtf("Le champ %s nécessite une heure antérieure à %s.", strLabel, strHeureMax);        
      } else if( strHeureMax == "" ) {
        strReason = _gtf("Le champ %s nécessite une heure postérieure à %s.", strLabel, strHeureMin);
      } else {
        strReason = _gtf("Le champ %s nécessite une heure comprise entre %s et %s.", strLabel, strHeureMin, strHeureMax);
      }      
    }
  }
  delete hh;
  delete mn;
  return strReason;
}
function verifDateTimeValidJJMMAAAA_HHMN(strDateTime, oMin, oMax, bStrict, strLabel)
{
  var strReason = _gtf("Le champ %s nécessite une date et une heure au format JJ/MM/AAAA HH:MN.", strLabel);
  if( strDateTime.length != 16 ) return strReason;
  
  if( typeof(bStrict)=="undefined" ) bStrict = false;

  var strDate = strDateTime.substring(0, 10);
  var strTime = strDateTime.substring(11, 16);

  if( !isDateValidJJMMAAAA(strDate) || !isHeureValideHHMN(strTime) )
     return strReason;

  strReason = "";
  if( oMin != "" || oMax != "" ) {
    var strDateMin = ( oMin == "" ? "" : oMin.substring(0, 10) );
    var strDateMax = ( oMax == "" ? "" : oMax.substring(0, 10) );
    var strHeureMin = ( oMin == "" ? "" : oMin.substring(11, 16) );
    var strHeureMax = ( oMax == "" ? "" : oMax.substring(11, 16) );

    var strMinDate = ( strDateMin == "" ? "00010101" : strDateMin.substring(6, 10)+strDateMin.substring(3, 5)+strDateMin.substring(0, 2));
    var strMaxDate = ( strDateMax == "" ? "99991231" : strDateMax.substring(6, 10)+strDateMax.substring(3, 5)+strDateMax.substring(0, 2));
    var strMinHeure = ( strHeureMin == "" ? "0000" : strHeureMin.substring(0, 2)+strHeureMin.substring(3, 5) );
    var strMaxHeure = ( strHeureMax == "" ? "2359" : strHeureMax.substring(0, 2)+strHeureMax.substring(3, 5) );
  
    strMinDate = strMinDate + "" + strMinHeure;
    strMaxDate = strMaxDate + "" + strMaxHeure;
    var strCurDate = strDate.substring(6, 10)+strDate.substring(3, 5)+strDate.substring(0, 2)+strTime.substring(0, 2)+strTime.substring(3, 5);

    if( (!bStrict && !(strMinDate<=strCurDate && strCurDate<=strMaxDate)) || 
        (bStrict && !(strMinDate<strCurDate && strCurDate<strMaxDate)) ) {
      if( strDateMin == "" ) {
        strReason = _gtf("Le champ %s nécessite une date et une heure antérieure au %s.", strLabel, strDateMax);        
      } else if( strDateMax == "" ) {
        strReason = _gtf("Le champ %s nécessite une date et une heure postérieure au %s.", strLabel, strDateMin);
      } else {
        strReason = _gtf("Le champ %s nécessite une date et une heure comprise entre %s et %s.", strLabel, strDateMin, strDateMax);
      }      
    }
  }

  return strReason;
}
