<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Library
Librairie js et php globale à Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

/** 
 * @file app_conf_sig.php
 * @package Alkanet_Library
 * @brief Initialise les constantes SIG communes
 */
 
/** Répertoire d"upload SIG */
define("ALK_SIG_DIR_UPLOAD",            ALK_ROOT_UPLOAD."sigadmin/");

/** Répertoire d"upload SIG pour les fiches mdata */
define("ALK_SIG_DIR_FICHES",            ALK_SIG_DIR_UPLOAD."fiches/");

/** Répertoire d"upload SIG pour les images */
define("ALK_SIG_DIR_IMAGES",            ALK_SIG_DIR_UPLOAD."images/");

/** Répertoire d"upload SIG pour les imgms */
define("ALK_SIG_DIR_IMGMS",             ALK_SIG_DIR_UPLOAD."imgms/");

/** Répertoire d"upload SIG pour les jointures */
define("ALK_SIG_DIR_JOINTURES",         ALK_SIG_DIR_UPLOAD."jointures/");

/** Répertoire d"upload SIG pour les keymap */
define("ALK_SIG_DIR_KEYMAP",            ALK_SIG_DIR_UPLOAD."keymap/");

/** Répertoire d"upload SIG pour les legende */
define("ALK_SIG_DIR_LEGENDE",           ALK_SIG_DIR_UPLOAD."legende/");

/** Répertoire d"upload SIG pour les legende */
define("ALK_SIG_DIR_LOGOS",             ALK_SIG_DIR_UPLOAD."logos/");

/** Répertoire d"upload SIG pour les mapfiles */
define("ALK_SIG_DIR_MAPFILES",          ALK_SIG_DIR_UPLOAD."mapfiles/");

/** Répertoire d"upload SIG pour les aperçus */
define("ALK_SIG_DIR_APERCU",            ALK_SIG_DIR_MAPFILES."apercu/");

/** Répertoire d"upload SIG pour les themes */
define("ALK_SIG_DIR_THEMES",            ALK_SIG_DIR_UPLOAD."themes/");

/** Répertoire d"upload SIG pour les symbols */
define("ALK_SIG_DIR_MAFILEIMGS",        ALK_SIG_DIR_MAPFILES."images/");

/** Répertoire d"upload SIG pour les symbols */
define("ALK_SIG_DIR_ETC",               ALK_SIG_DIR_MAPFILES."etc/");

/** Répertoire d'upload SIG pour les conversions */
define("ALK_SIG_DIR_CONV",              ALK_SIG_DIR_UPLOAD."conversions/");

/** Répertoire d'upload SIG pour les fichiers de conversions en entrée */
define("ALK_SIG_DIR_CONVINPUT",         ALK_SIG_DIR_CONV."input/");

/** Répertoire d'upload SIG pour les fichiers de conversions en sortie */
define("ALK_SIG_DIR_CONVOUTPUT",         ALK_SIG_DIR_CONV."output/");

/** Répertoire d"upload SIG pour les symbols */
define("ALK_SIG_DIR_SYMBOLS",           ALK_SIG_DIR_ETC."symboles/");

/** Répertoire d"upload SIG pour les symbols par défaut */
define("ALK_SIG_DIR_SYMBOLSDEFAULT",    ALK_SIG_DIR_SYMBOLS."default/");

/** Fichier listant les polices */
define("ALK_SIG_FILE_FONTS",            ALK_SIG_DIR_ETC."fonts.txt");

/** Fichier listant les symboles existants */
define("ALK_SIG_FILE_SYMBOLSET",        ALK_SIG_DIR_SYMBOLS."symbols.sym");

define("ALK_SIG_DIR_PICTOS",            ALK_MEDIA_PATH."sigsite/pictos/");
define("ALK_SIG_URL_PICTOS",            ALK_MEDIA_URL."sigsite/pictos/");

define("ALK_SIG_DIR_CHARTE",            ALK_MEDIA_PATH."sigsite/charte/");
define("ALK_SIG_URL_CHARTE",            ALK_MEDIA_URL."sigsite/charte/");

/** Constantes de config d"administration */
define("ALK_B_SIG_ADMIN_WMS",        true);
define("ALK_B_SIG_ADMIN_WFS",        true);

/////////////////////////////////////////Constantes de config//////////////////////////////////

define("ALK_B_SIG_STANDARD_WMS", true);

/** Valeurs par défaut */
define("ALK_SIG_DEFAULT_FDP",             0); 
define("ALK_SIG_DEFAULT_PROJECTION",      "epsg:27582");
define("ALK_SIG_DEFAULT_COPYRIGHT",       "(c) Alkante");


////////////////////////////////////constantes module GIS//////////////////////////////////////

/** constantes concernant l'id du type de projet en base de données (table GIS_PROJET_TYPE) */
define("ALK_GIS_PROJET_TYPE_CARTE",     1);
define("ALK_GIS_PROJET_TYPE_FDP",       2);
define("ALK_GIS_PROJET_TYPE_VIGNETTE",  3);

/** constantes concernant le type de support d'une couche */
define("ALK_GIS_SUPPORT_TYPE_FICHIER",    1);
define("ALK_GIS_SUPPORT_TYPE_SGBD",       2);
define("ALK_GIS_SUPPORT_TYPE_WMS",        3);
define("ALK_GIS_SUPPORT_TYPE_WFS",        4);

/** constantes concernant le convertisseur */
define("ALK_GIS_CONV_STRING_INPUT",      "input");
define("ALK_GIS_CONV_STRING_OUTPUT",     "output");

define("ALK_GIS_CONV_SUPPORT_FICHIER",    1);
define("ALK_GIS_CONV_SUPPORT_POSTGIS",    2);

/** constante concernant les symboles */
define("ALK_GIS_SYMBOL_DEFAULT_MAXSIZE", 15);
?>