<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Library
Librairie js et php globale à Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

/** 
 * @package Alkanet_Library
 * Contient toute la librairie commune javascript et php Alkanet
 *
 * @file app_conf_gedit.php
 * Contient les constantes partagés par le gedit, iedit, form, forum, ... permettant l'ordonnancement des valeurs
 */

/**
 * Champs iField de la méthode getGEditBlocTypeUpdate appelée par le GEDIT sur les applications associées aux pages
 */
define("IFIELD_ALAUNE",      1); // =pow(2,  0)
define("IFIELD_ARCHIVE",     2); // =pow(2,  1)
define("IFIELD_PUBLIEE",     4); // =pow(2,  2)
define("IFIELD_AVALIDER",    8); // =pow(2,  3)
define("IFIELD_SYNDIC",      16); // =pow(2,  4)
define("IFIELD_VALIDATION",  32); // =pow(2,  5)
define("IFIELD_30J_PUBLIE",  64); // =pow(2,  6)
define("IFIELD_30J_INFO",    128); // =pow(2,  7)
define("IFIELD_30J_MODIF",   256); // =pow(2,  8)
define("IFIELD_NOUVEAUTE",   512); // =pow(2,  9)
define("IFIELD_CATEGORIE",   1024); // =pow(2, 10)
define("IFIELD_INTITULE",    2048); // =pow(2, 11)
define("IFIELD_DATEPUB",     4096); // =pow(2, 12)
define("IFIELD_DATEINFO",    8192); // =pow(2, 13)
define("IFIELD_DATEMODIF",   16384); // =pow(2, 14)
define("IFIELD_INTERVPUB",   32768); // =pow(2, 15)
define("IFIELD_INTERVINFO",  65536); // =pow(2, 16)
define("IFIELD_INTERVMODIF", 131072); // =pow(2, 17)
define("IFIELD_DATARANG",    262144); // =pow(2, 18)



/**
 * TASSOC_xxx : Toutes les propriétés caractérisant l'association des données dans les blocs de gestion editoriale
 */
 
/** Constantes pour niveau d'association  des données dans les blocs */
define("TASSOC_EMPTY",                  0); // =0
define("TASSOC_BYAPPLI",                1); // =pow(2, 0)
define("TASSOC_BYCATEG",                2); // =pow(2, 1)
define("TASSOC_BYDATA",                 3); // =3

/** Constantes pour etat de publication des données dans les blocs */
define("TASSOC_ALAUNE",                 4); // =pow(2, 2)
define("TASSOC_ARCHIVE",                8); // =pow(2, 3)
define("TASSOC_PUBLIE",                 16); // =pow(2, 4)
define("TASSOC_AVALIDER",               32); // =pow(2, 5)

define("TASSOC_ESTSYNDIQUE",            128); // =pow(2,  7)
define("TASSOC_VALIDATION",             67108864); // ex 512=pow(2,  9)
define("TASSOC_TOUTETATPUB",            2048); // =pow(2,  11)

/** Constantes pour combinaisons d'ordre des données dans les blocs prédéfinies */
define("TASSOCORDER_CATEGORIE",         64); // =pow(2,  6)   
define("TASSOCORDER_NOUVEAUTE",         256); // =pow(2,  8)  
define("TASSOCORDER_DATEINFOPUBDESC",   1024); // =pow(2, 10)
define("TASSOCORDER_DATEINFOPUB",       4096); // =pow(2, 12)


/** Constantes pour critères d'association et d'ordre des données dans les blocs */
define("TASSOC_NOUVEAUTE",              8192); // =pow(2, 13)
define("TASSOC_CATEGORIE",              16384); // =pow(2, 14)
define("TASSOC_INTITULE",               32768); // =pow(2, 15)
define("TASSOC_DATEPUB_DESC",           65536); // =pow(2, 16)
define("TASSOC_DATEPUB",                131072); // =pow(2, 17)
define("TASSOC_DATEINFO_DESC",          262144); // =pow(2, 18)
define("TASSOC_DATEINFO",               524288); // =pow(2, 19)
define("TASSOC_DATEMODIF_DESC",         1048576); // =pow(2, 20)
define("TASSOC_DATEMODIF",              2097152); // =pow(2, 21)
define("TASSOC_INTERVPUB",              4194304); // =pow(2, 22)
define("TASSOC_INTERVINFO",             8388608); // =pow(2, 23)
define("TASSOC_INTERVMODIF",            16777216); // =pow(2, 24)
define("TASSOC_SYNDIC",                 33554432); // =pow(2, 25)
define("TASSOC_ENVALIDATION",           67108864); // =pow(2, 26)
define("TASSOC_30J_PUBLIE",             134217728); // =pow(2, 27)
define("TASSOC_30J_INFO",               268435456); // =pow(2, 28)
define("TASSOC_30J_MODIF",              536870912); // =pow(2, 29)
define("TASSOC_DATARANG_DESC",          1073741824); // =pow(2, 30)
define("TASSOC_DATARANG",               2147483648); // =pow(2, 31)

/**
 * Evalue si une valeur binaire est un masque positif dans une combinaison binaire
 * @param int binary      Valeur obtenue par combinaison (somme) binaire
 * @param int binMask     Masque binaire à évaluer
 * @param int searchValue (default null) Valeur du masque à obtenir si non null, sinon valeur à obtenir = binMask
 * @return boolean        True si le résultat du masque correspond à searchValue ou à binMask, False sinon    
 */
function binmask_match($binary, $binMask, $searchValue=null)
{
  return ($binary & $binMask) == (is_null($searchValue) ? $binMask : $searchValue);
}

?>