<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Class::Pattern
Module fournissant les classes de base Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

/**
 * @package Alkanet_Class_Pattern
 * 
 * @class AlkOptionsBuilder
 * @brief Classe de construction standardisée des options d'applications.
 *        Cette classe implémente les interfaces SPL IteratorAggregate, ArrayAccess et Countable.
 *        Exemple d'utilisation :
 * <pre>
 * $options = new AlkOptionsBuilder();
 * $options->addOption('a1', 'i1', 'd1')->addoption('a2', 'i2', 'd2');
 * echo count( $options );
 * foreach( $options as $option ) {
 *   echo $option['alias'] . $option['intitule'] . $option['description']
 * }
 * </pre>
 */
class AlkOptionsBuilder implements IteratorAggregate, ArrayAccess, Countable
{

  private $options = array();
  
  /**
   * Ajouter une option
   * @param string $alias
   * @param string $intitule
   * @param string $desc
   * @return AlkOptionsBuilder
   */
  public function addOption($alias, $intitule, $description)
  {
    if ( ! isset( $this->options[$alias] ) ) {
      $this->options[$alias] = array('alias' => $alias, 'intitule' => $intitule, 'description' => $description);
    }
    return $this;
  }
  
  /**
   * Retourne l'objet sous la forme d'un tableau associatif
   * @return array le tableau d'options
   */
  public function toArray()
  {
    return $this->options;
  }
  
  /**
   * @see IteratorAggregate::getIterator()
   */
  public function getIterator()
  {
    return new ArrayIterator( $this->options );
  }
  
  /**
   * @see ArrayAccess::offsetExists()
   */
  public function offsetExists($offset)
  {
    return isset( $this->options[$offset] );
  }
  
  /**
   * @see ArrayAccess::offsetGet()
   */
  public function offsetGet($offset)
  {
    return isset( $this->options[$offset] ) ? $this->options[$offset] : null;
  }
  
  /**
   * @see ArrayAccess::offsetSet()
   */
  public function offsetSet($offset, $value)
  {
    if ( is_null($offset) ) {
      $this->options[] = $value;
    } else {
      $this->options[$offset] = $value;
    }
  }
  
  /**
   * @see ArrayAccess::offsetUnset()
   */
  public function offsetUnset($offset)
  {
    unset( $this->options[$offset] );
  }
  
  /**
   * @see Countable::count()
   */
  public function count()
  {
    return count( $this->options );
  }

}

?>