<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Class::Pattern
Module fournissant les classes de base Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkds.class.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkdroracle.class.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkerrororacle.class.php");

/**
 * @package Alkanet_Class_Pattern
 * 
 * @class AlkDsOracle
 * @brief DataSet basé sur oracle, hérite de la classe AlkDs
 */
final class AlkDsOracle extends AlkDs
{
  /** mémorise le premier dataRow lu */
  protected $tabFirstDr;

  /**
   *  Constructeur par défaut de la classe
   *
   * @param conn           handle de la connexion ouverte
   * @param strSql         requête sql
   * @param idFirst        indice de début pour la pagination (=0 par défaut)
   * @param idLast         indice de fin pour la pagination (=-1 par défaut)
   * @param bErr           true si gestion des erreurs, false pour passer sous silence l'erreur
   * @param strDbEncoding  encodage du client sgbd
   */
  public function __construct($conn, $strSql, $idFirst=0, $idLast=-1, $bErr=true, $strDbEncoding=ALK_SGBD_ENCODING)
  {
    parent::__construct($conn, $strSql, $idFirst, $idLast, $bErr, $strDbEncoding);
    
    // liste des champs reconnu par Oracle
    $this->tabTypeAssoc = array("VARCHAR2" => 0, "NUMBER" => 1, "DATE" => 2, "FLOAT" => 3);
  
    if( $bErr == true ) startErrorHandlerOracle(); else ob_start();
    
    $this->lastErr = "";
    $this->tabFirstDr = array();
    $this->iCountDr = 0;
    $this->iCurDr = -1;
    $this->bEof = true;
    
    $strSqlFetch = $strSql;
    
    // ajout spécifique du code si utilisation du jQuery DATATABLE
    $_columns    = AlkFactory::getSQLParamsName("columns", "");
    if ($_columns != ""){
      $_limit      = AlkFactory::getSQLParamsName("limit", -2);
      $_sortable   = AlkFactory::getSQLParamsName("sortable", array());
      $_searchable = AlkFactory::getSQLParamsName("searchable", array());
      $_start      = AlkFactory::getSQLParamsName("start", -2);
      $_columns    = AlkFactory::getSQLParamsName("columns", "");
      $_iColSort   = AlkFactory::getSQLParamsName("iColumSort", -2);
      $_sSortDir   = AlkFactory::getSQLParamsName("sSortDir", "");
      $_nbColumns  = AlkFactory::getSQLParamsName("nbColumns", "");
      $_sSearch    = AlkFactory::getSQLParamsName("sSearch", "");
      $tabWhere    = array();
      $tabOrderBy  = array();
      $strEndStart = "";

      $tabColumns = explode(",", $_columns);
      foreach ($tabColumns as $index => $strColumName){
        // filtre
        if ($_sSearch != "" && isset($_searchable[$index]) && $_searchable[$index]=="true")
          $tabWhere[] = "COALESCE(LOWER( CAST(".$strColumName." as CHAR)), '')";
      }
      
      // order by 
      foreach ($_iColSort as $i => $itemICol){
        if (isset($_sortable[$itemICol]))
          $tabOrderBy[] = $tabColumns[$itemICol]." ".$_sSortDir[$i];
      }

      // analyseSql()
      $strEndStart = (!empty($tabWhere) ? " where CONCAT(".implode(",", $tabWhere).") like '%".AlkFactory::getDbConn()->analyseSql(strtolower($_sSearch))."%'" : "").
                     (!empty($tabOrderBy) ? "order by ".implode(",", $tabOrderBy) : "");
      
      $strSql = "select foo.* from (".$strSql.") foo ".$strEndStart;
      $idFirst = $_start;
      $idLast  = $idFirst+$_limit-1;
    }
    
    // requête de pagination, si demandé
    if( $idLast>=$idFirst && $idFirst>=0 ) {
      // WARNING : Oracle ROWNUM starts at 1
      $strSqlFetch = "select count(*) over() as ALK_NB_RES, a.* ".
        " from (select q.*, RowNum as ocirnum ".
        "       from (select count(*) over() as ALK_NB_TOT, q.*
                      from (".$strSql.") q) q where RowNum <= ".($idLast+1).") a ".
        " where ocirnum >= ".($idFirst+1);
    } else {
      $strSqlFetch = "select count(*) over() as ALK_NB_RES, -1 as ALK_NB_TOT, q.* from (".$strSql.") q";
    }
    
    $this->oRes = oci_parse($conn, $strSqlFetch);
    
    if( is_ressource($this->oRes) ) {
      // prefetch - reduce network traffic
      $defaultPrefetch = 20;
      @oci_set_prefetch($this->oRes, ($idLast >= $idFirst ? max(1, $idLast-$idFirst) : $defaultPrefetch));
      
      // exécution de la requête
      $bRes = @oci_execute($this->oRes, OCI_COMMIT_ON_SUCCESS);
      
      if( $bRes ) {
        // récupère le premier enregistrement
        $this->tabFirstDr = @oci_fetch_array($this->oRes, OCI_ASSOC);
        if( is_array($this->tabFirstDr) ) {
          $this->iCountDr = $this->tabFirstDr["ALK_NB_RES"];
          $this->iCountTotDr = $this->tabFirstDr["ALK_NB_TOT"];
          if( $this->iCountTotDr == -1 ) {
            $this->iCountTotDr = $this->iCountDr;
          }
        } else {
          $this->tabFirstDr = array();
        }
      } else {
        $tabError = oci_error($this->oRes);
        if( $this->bErr == true ) {
          trigger_error("AlkdsOracle - Erreur requête (".$strSql.", Oracle : ".
          $error['code'].", ".$error['message'].")", E_USER_ERROR);
        } else {
          $this->_SetError("Erreur requête (".$strSql.", Oracle : ".$error['code'].", ".$error['message'].")");
        }
      }
    } else {
      if( $this->bErr == true ) {
        trigger_error("AlkdsOracle - oci_parse, erreur requête (".$strSql.")", E_USER_ERROR);
      } else {
        $this->_SetError("AlkdsOracle - oci_parse, erreur requête (".$strSql.")");
      }
    }

    if( $this->iCountDr > 0 ) {
      $this->iCurDr = 0;
      $this->bEof = false;
    } else {
      $this->iCountDr = 0;
      $this->iCountTotDr = 0;
    }
  
    if( $bErr == true ) endErrorHandlerOracle(); else ob_end_clean();
  }

  /**
   * Méthode qui lit et mémorise tout le flux résultat de la requête
   * Cette méthode doit suivre l'appel à initDataSet() ou est appelée automatiquement par la méthode setTree()
   */
  public function fetchAll()
  {
    if( $this->bFetchAll ) return;
  
    if( $this->bErr == true ) startErrorHandlerOracle(); else ob_start();
  
    $this->bUseInternalCache = true;
  
    // mémorise les types de champs
    if( empty($this->tabType) ) {
      $nbFields = @oci_num_fields($this->oRes);
      for($i=0; $i<$nbFields; $i++) {
        $strType = @oci_field_type($this->oRes, $i+1);
        $this->tabType[$i] = ( isset($this->tabTypeAssoc[$strType]) == true ? $this->tabTypeAssoc[$strType] : 0 );
        $this->tabFields[$i] = @oci_field_name($this->oRes, $i+1);
      }
    }
    
    if( $this->iCountDr > 0 ) {
      $this->iCurDr = 0;
      $this->bEof = false;
      $bRes = @oci_fetch_all($this->oRes, $this->tabDr); // OCI_ASSOC par défaut
      if( is_bool($bRes) ) {
        $this->tabDr = array();
        $this->iCurDr = -1;
        $this->bEof = true;
        $tabError = @oci_error($this->oRes);
        if( $this->bErr == true ) {
          trigger_error("AlkDsOracle -  fonction ".__FUNCTION__." : Erreur oci_fetch_all : ".
                        $tabError['code'].", ".$tabError['message'].")", E_USER_ERROR);
        } else {
          $this->_SetError("AlkDsOracle - fonction ".__FUNCTION__." : Erreur oci_fetch_all : ".
                           $tabError['code'].", ".$tabError['message'].")");
        }
      }
  
      if( $this->strCacheFieldIndex!="" ) {
        foreach($this->tabDr as $i => $tabDr) {
          if( isset($tabDr[$this->strCacheFieldIndex]) ) {
            $strKey = $tabDr[$this->strCacheFieldIndex];
          } else {
            trigger_error("AlkdsOracle - fonction ".__FUNCTION__." : cacheFieldIndex non trouvé.", E_USER_ERROR);
          }
          $this->tabDrIndex[$strKey] = $i;
        }
      }
    }
  
    if( !$this->bEof ) {
      $this->bFetchAll = true;
      if( $this->bUseCache ) {
        AlkFactory::memCacheSetData($this->strCacheName, $this->strSql, $this, $this->iCacheExpire);
      }
    }  
    if( $this->bErr == true ) endErrorHandlerOracle(); else ob_end_clean();
  }
  
  /**
   * mémorise le contenu du dataSet en mémoire pour permettre la mise en cache par la suite
   * @param tabDr  contenu du dataRow représenté par un tableau associatif
   */
  protected function saveDataRow($tabDr)
  {
    if( !is_array($tabDr) ) {
      $tabError = @oci_error($this->oRes);
      if( $this->bErr == true ) {
        trigger_error("AlkDsOracle[".__LINE__."] - oci_fetch_array error (Indice :".
                      count($this->tabDr)." , Oracle : ".$tabError['code'].", ".$tabError['message'].")", E_USER_ERROR);
      } else {
        $this->_setError($tabError['code'].", ".$tabError['message']);
        $this->tabDr[] = false;
        return;
      }
    }
  
    if( empty($this->tabType) ) {
      // mémorise les types
      $nbFields = @oci_num_fields($this->oRes);
      for($i=0; $i<$nbFields; $i++) {
        $strType = @oci_field_type($this->oRes, $i+1);
        $this->tabType[$i] = ( isset($this->tabTypeAssoc[$strType]) == true ? $this->tabTypeAssoc[$strType] : 0 );
        $this->tabFields[$i] = @oci_field_name($this->oRes, $i+1);
      }
    }
  
    // mémorise
    $this->tabDr[] = $tabDr;
    $iNewCount = count($this->tabDr);

    if( $this->strCacheFieldIndex!="" ) {
      if( isset($tabDr[$this->strCacheFieldIndex]) ) {
        $strKey = $tabDr[$this->strCacheFieldIndex];
      } else {
        trigger_error("AlkdsOracle - fonction ".__FUNCTION__." : cacheFieldIndex non trouvé.", E_USER_ERROR);
      }
      $this->tabDrIndex[$strKey] = $iNewCount-1;
    }
  
    if( $iNewCount == $this->iCountDr && !$this->bFetchAll ) {
      $this->bFetchAll = true;
      if( $this->bUseCache ) {
        //echo "ADD Cache<br>";
        AlkFactory::memCacheSetData($this->strCacheName, $this->strSql, $this, $this->iCacheExpire);
      }
    }
  }
  
  /**
   *  Retourne le datarow (dr) correspondant à l'indice courant ($iCurDr)
   *
   * @return Retourne un dataRow si ok, false sinon
   */
  public function GetRow()
  {
    trigger_error("AlkdsOracle - fonction ".__FUNCTION__." obsolète.", E_USER_ERROR);
    
    /*$drRes = false;
    if( $this->iCurDr>=0 && $this->iCurDr<$this->iCountDr ) {
      $drOracletmp = $this->tabDr[$this->iCurDr];
      $drRes = new AlkDrOracle($drOracletmp, $this);
    } else {
      $this->iCurDr = -1;
      $this->bEof = true;
    }

    return $drRes;*/
  }

  /**
   *  Retourne le datarow (dr) correspondant à l'indice courant ($iCurDr) puis passe au suivant
   *        Retourne false si EOF est atteint
   *
   * @return Retourne un dataRow si ok, false sinon
   */
  public function getRowIter()
  {
    $drRes = false;
    if( $this->iCurDr>=0 && $this->iCurDr<$this->iCountDr ) {
      if( $this->bErr == true ) startErrorHandlerOracle(); else ob_start();
      
      if( !$this->bFetchAll ) {
        if( $this->bUseInternalCache ) {
          if( $this->iCurDr == 0 ) {
            $this->saveDataRow($this->tabFirstDr);
          } else {
            // nécessaire pour getValueNum()
            if( empty($this->tabType) ) {
              // mémorise les types
              $nbFields = @oci_num_fields($this->oRes);
              for($i=0; $i<$nbFields; $i++) {
                $strType = @oci_field_type($this->oRes, $i+1);
                $this->tabType[$i] = ( isset($this->tabTypeAssoc[$strType]) == true ? $this->tabTypeAssoc[$strType] : 0 );
                $this->tabFields[$i] = @oci_field_name($this->oRes, $i+1);
              }
            }
          
            $this->saveDataRow(@oci_fetch_array($this->oRes, OCI_ASSOC));
          }
          $drRes = new AlkDrOracle($this->tabDr[$this->iCurDr], $this);
        } else {
          $tabDr = ( $this->iCurDr == 0
                     ? $this->tabFirstDr
                     : @oci_fetch_array($this->oRes, MYSQL_ASSOC) );
          if( is_array($tabDr) ) {
            $drRes = new AlkDrOracle($tabDr, $this);
          }
        }
      } else {
        $drRes = new AlkDrOracle($this->tabDr[$this->iCurDr], $this);
      }
      $this->moveNext();
      
      if( $this->bErr == true ) endErrorHandlerOracle(); else ob_end_clean();
    }

    return $drRes;
  }

  /**
   *  Retourne un tableau associatif du datarow correspondant à l'indice courant ($iCurDr) puis passe au suivant
   *  Les clés correspondantes au nom des champs avec la casse Majuscule
   *  Retourne false si EOF est atteint
   *
   * @return array : Retourne un tableau associatif si ok, false sinon
   */
  public function getAssocIter()
  {
    $drRes = false;
    if( $this->iCurDr>=0 && $this->iCurDr<$this->iCountDr ) {
      if( $this->bErr == true ) startErrorHandlerOracle(); else ob_start();
  
      if( !$this->bFetchAll ) {
        if( $this->bUseInternalCache ) {
          if( $this->iCurDr == 0 ) {
            $this->saveDataRow($this->tabFirstDr);
          } else {
            // nécessaire pour getValueNum()
            if( empty($this->tabType) ) {
              // mémorise les types
              $nbFields = @oci_num_fields($this->oRes);
              for($i=0; $i<$nbFields; $i++) {
                $strType = @oci_field_type($this->oRes, $i+1);
                $this->tabType[$i] = ( isset($this->tabTypeAssoc[$strType]) == true ? $this->tabTypeAssoc[$strType] : 0 );
                $this->tabFields[$i] = @oci_field_name($this->oRes, $i+1);
              }
            }
            
            $this->saveDataRow(@oci_fetch_array($this->oRes, OCI_ASSOC));
          }
          $tabDr = $this->tabDr[$this->iCurDr];
        } else {
          $tabDr = ( $this->iCurDr == 0
                     ? $this->tabFirstDr
                     : @oci_fetch_array($this->oRes, OCI_ASSOC) );
        }
      } else {
        $tabDr = $this->tabDr[$this->iCurDr];
      }
  
      if( is_array($tabDr) ) {
        $drRes = array_change_key_case($tabDr, CASE_UPPER);
      }
      $this->moveNext();
  
      if( $this->bErr == true ) endErrorHandlerOracle(); else ob_end_clean();
    }
  
    return $drRes;
  }
  
  /**
   *  Retourne le datarow (dr) positionné à l'indice id
   *        Retourne false si l'indice n'est pas satisfaisant
   *         n'agit ni sur bEOF, ni sur le pointeur 
   *
   * @param id Indice du dataRow
   * @return Retourne un dataRow si ok, false sinon
   */
  public function getRowAt( $id )
  {
    trigger_error("AlkdsOracle - fonction ".__FUNCTION__." obsolète.", E_USER_ERROR);
    /*$drRes = false;      
    if( $this->iCountDr>0 && $id>=0 && $id<$this->iCountDr ){
      $drOracletmp = $this->tabDr[$id];
      $drRes = new AlkDrOracle($drOracletmp, $this);
    }
  
    return $drRes;*/
  }

  /**
   *  Place le pointeur du dataset sur le premier datarow
   *        Met à jour l'indice courant du dataset
   */
  public function moveFirst() 
  {
    if( $this->iCountDr > 0 ) {
      $this->iCurDr = 0;
      $this->bEof = false;
    } else {
      $this->iCurDr = -1;
      $this->bEof = true;
    }
  }

  /**
   *  Place le pointeur du dataset sur le datarow précédent
   *        Met à jour l'indice courant du dataset
   */
  public function movePrev() 
  {
    if( !$this->bFetchAll ) {
      trigger_error("AlkdsOracle - fonction ".__FUNCTION__." non autorisée en mode FetchItem.", E_USER_ERROR);
    }    
    
    if( $this->iCountDr>0 && $this->iCurDr>0 ) {
      $this->iCurDr--;
    } else {
      $this->iCurDr = -1;
      $this->bEof = true;
    }
  }

  /**
   *  Place le pointeur du dataset sur le datarow suivant
   *        Met à jour l'indice courant du dataset
   */
  public function moveNext() 
  {
    if( $this->iCountDr>0 && $this->iCurDr<$this->iCountDr ) {
      $this->iCurDr++;
      
      if( $this->iCurDr >= $this->iCountDr ) {
        $this->bEof = true;
      }
    } else {
      $this->iCurDr = -1;
      $this->bEof = true;
    }
  }

  /**
   *  Place le pointeur du dataset sur le dernier datarow
   *        Met à jour l'indice courant du dataset
   */
  public function moveLast() 
  {
    if( !$this->bFetchAll ) {
      trigger_error("AlkdsOracle - fonction ".__FUNCTION__." non autorisée en mode FetchItem.", E_USER_ERROR);
    }    
        
    if ( $this->iCountDr > 0 ) {
      $this->iCurDr = $this->iCountDr-1;
    } else {
      $this->iCurDr = -1;
      $this->bEof = true;
    }
  }

  /**
   *  Place le pointeur du dataset sur le (iCurDr+iNb) ième datarow
   *        Met à jour l'indice courant du dataset
   *
   * @param iNb Décalage positive ou négatif par rapport au dataRow courant
   */
  public function move($iNb) 
  {
    if( !$this->bFetchAll ) {
      trigger_error("AlkdsOracle - fonction ".__FUNCTION__." non autorisée en mode FetchItem.", E_USER_ERROR);
    }    
    
    if( $this->iCountDr > 0 && $this->iCurDr+$iNb>=0 && $this->iCurDr+$iNb<$this->iCountDr ) {
      $this->iCurDr += $iNb;
    } else {
      $this->iCurDr = -1;
      $this->bEof = true;
    }
  }
    
  /**
   *  Tri le dataSet après lecture dans la source donnée
   *        Effectue un tri à plusieurs niveaux
   *        Nécessite de connaite les noms de champ : ID et ID_PERE
   *        le dataset doit être déjà trié par niv puis par rang
   *
   * @param strFieldId  Nom du champ ID dans la requeête
   * @param strFieldIdp Nom du champ ID_PERE dans la requête
   */
  public function setTree($strFieldId, $strFieldIdp)
  {
    $tabNoeud = array();   // contient l'ensemble des noeuds
    $tabIndex = array();   // contient l'index inverse id -> cpt
    $stack = array();
    
    for ($i=0; $i< $this->iCountTotDr; $i++) {
      //$drOracletmp = Oracle_fetch_array($this->oRes);
      $drOracletmp = $this->tabDr[$i];
      
      $idFils = $drOracletmp[strtolower($strFieldId)];
      $idPere = $drOracletmp[strtolower($strFieldIdp)];
      $tabNoeud[$i]["FILS"] = array();
      $tabNoeud[$i]["ID"] = $idFils;
      $tabNoeud[$i]["OK"] = false;

      // memorize the first level id in a stack
      array_push($stack, $i);

      // met a jour la table index secondaire
      $tabIndex[$idFils] = $i;

      // ajoute l'id fils a l'id pere
      if( $idPere > 0 )
        if( array_key_exists($idPere, $tabIndex) == true ) {
          $iPere = $tabIndex[$idPere];
          array_push($tabNoeud[$iPere]["FILS"], $i);
        }
    }

    // parse the sons
    $tabDr2 = array();
    $j = 0;
    while( count($stack) > 0 ) {
      $i = array_shift($stack);
      if( $tabNoeud[$i]["OK"] == false ) {
        $id = $tabNoeud[$i]["ID"];
        $tabNoeud[$i]["OK"] = true;
        $tabDr2[$j] = $this->tabDr[$i];
        $j++;
        
        $nbFils = count($tabNoeud[$i]["FILS"]);
        for ($k=$nbFils-1; $k>=0; $k--) {
          $if = $tabNoeud[$i]["FILS"][$k];
          array_unshift($stack, $if);
        }
      }
      $i++;
    }

    $tabNoeud = null;
    $tabIndex = null;
    $this->tabDr = $tabDr2;
  }
  
}
?>