/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Class::Form
Module fournissant les classes d'affichage Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

/**
 * Constructor AlkFormSheets
 * @brief Manager d'un groupe de DIV représentant des onglets d'un même panel
 * 
 * @param iSheet             Indice de l'onglet sélectionné
 * @param strBaseName        Nom de base pour les layers sheetHeader et sheetBody
 * @param strClassName       Nom de la classes css pour le mode normal
 * @param strClassNameSelect Nom de la classes css pour le mode select
 */
AlkFormSheets.prototype.constructor = AlkFormSheets;
function AlkFormSheets(strBaseName, iSheet, strClassName, strClassNameSelect)
{
	this.iSheet = iSheet;
	this.strBaseName = strBaseName;
  this.strClassName = strClassName;
  this.strClassNameSelect = strClassNameSelect;
}

/**
 * @method AlkFormSheets::SwitchSheet
 * @brief permute l'aspect de l'onglet
 * 
 * @param oLayer  référence sur le layder représentant l'onglet
 * @param bSelect true si l'onglet est sélectionné, false sinon
 */
AlkFormSheets.prototype.switchSheet = function (oLayer, bSelect)
{
  if( oLayer ) {
    oLayer.className = oLayer.className.replace(/selected/g, '');
    if ( bSelect )
      oLayer.className = oLayer.className + " selected";
  }
}

/**
 * @method AlkFormSheets::SwitchSheet
 * @brief permute l'état de l'onglet courant et celui donné en param qui devient la sélection
 * 
 * @param iSheet  Identifiant de l'onglet sélectionné
 */
AlkFormSheets.prototype.SwitchSheet = function(iSheet)
{
  var iOldSheet = this.iSheet;
  var oOldSheet = document.getElementById("sheetHeader_"+this.strBaseName+"_"+iOldSheet);
  var oOldLayer = document.getElementById("sheetBoby_"+this.strBaseName+"_"+iOldSheet);

  this.switchSheet(oOldSheet, false);
  this.switchSheet(oOldLayer, false);
  //this.ShowHideLayerSheet(oOldLayer, false);

  var oSheet = document.getElementById("sheetHeader_"+this.strBaseName+"_"+iSheet);
  var oLayer = document.getElementById("sheetBoby_"+this.strBaseName+"_"+iSheet);

  this.switchSheet(oSheet, true);
  this.switchSheet(oLayer, true);
  //this.ShowHideLayerSheet(oLayer, true);
  this.iSheet = iSheet;
}

/**
 * @method AlkTdSheets::ShowHideLayerSheet
 * @brief Rend visible ou non un layer associé à l'onglet sélectionné
 * 
 * @param oLayer  référence sur le layer contenant les infos de l'onglet
 * @param bShow   true pour rendre visible le layer, false pour le cacher
 */
AlkFormSheets.prototype.ShowHideLayerSheet = function(oLayer, bShow)
{
	if( !oLayer ) return;
  var oStyle = ( oLayer.style ? oLayer.style : oLayer );
  if( bShow ) {
    oStyle.display = "block"; 
  } else {
    oStyle.display = "none";
  }
}
/*
function AlkSheetOnMouseOver(oObject, strClassName)
{
  if( oObject ) {
    oObject.className = strClassName;
    if( oObject.style ) {
      oObject.style.cursor = 'pointer';
    } else {
      oObject.cursor = 'pointer';
    }
  }
}
function AlkSheetOnMouseOut(oObject, strClassName)
{
  if( oObject ) {
    oObject.className = strClassName;
    if( oObject.style ) {
      oObject.style.cursor = '';
    } else {
      oObject.cursor = '';
    }
  }
}*/
function AlkSheetOnClick(strName, iSheet)
{
	var oSheetsManager = eval("oSheetsManager_"+strName);
  if( oSheetsManager )
  	oSheetsManager.SwitchSheet(iSheet);
}
function AlkSheetGoUrl(strUrl)
{
  window.location = strUrl;
}
