<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Class::Form
Module fournissant les classes d'affichage Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkobject.class.php");

/**
 * @package Alkanet_Class_Form
 * @class AlkSheetsManager
 * 
 * Classe manageur d'onglets
 */
class AlkSheetsManager extends AlkObject 
{
  
  /** liste des manager créés sur une page */
  static private $tabManagerId;
  
  /** tableau des onglets */
  protected $tabSheets;

  /** tableau des onglets */
  protected $tabTypeSheets;

  /** iTypeSheet sélectionné, =0 par défaut */
  protected $iTypeSheet;
  /** iSheet sélectionné, =-1 par défaut */
  protected $iSheet;
  /** iSSheet sélectionné, =-1 par défaut */
  protected $iSSheet;
  
  /** panel propriétaire du manager */
  private $oPanel;
  
  /** onglet sélectionné */
  private $oSheetSelected;
  
  /** css appliqué sur le cadre englobant les onglets */
  private $cssMngHeader;

  /** css appliqué sur le cadre engloblant le contenu */
  private $cssMngBody;

  /** css appliqué sur les onglets normal et en sélection */
  private $cssSheetHeader;
  private $cssSheetHeaderSelect;

  /** css appliqué sur le cadre contenant l'information de l'onglet affiché, display:none à positionner par défaut en mode formulaire */
  private $cssSheetBody;
  
  private $cssSheetSelect;
  
  /** true pour rendre visible les onglets (par défaut), false pour le cacher */
  protected $bVisible;

  /**
   *  Constructeur par défaut
   */
  public function __construct(AlkHtmlPanel $oPanel) 
  {
    parent::__construct();
    $this->oPanel = $oPanel;
    $this->tabSheets = array();   
    $this->tabTypeSheets = array();
    $this->oSheetSelected = null; 
    $this->iTypeSheet = 0;
    $this->iSheet  = -1;
    $this->iSSheet = -1;
    $this->bVisible = true;
  }
  
  /**
   *  Destructeur par défaut
   */
  public function __destruct() 
  {
    parent::__destruct();
    unset($this->tabSheets);
    unset($this->tabTypeSheets);
  }
   
  /**
   *  Initialise les classes de CSS en fonction du conteneur (onglets de page ou de formulaire)
   *        Cette initialisation doit avoir lieu lors du getHtml pour prendre en compte toute la structure finale
   */
  private function initCss()
  {
    $bInHtmlForm = $this->oPanel->isInHtmlForm();
    $this->cssMngHeader            = ( $bInHtmlForm ? "" : "p")."sheetMngHeader";
    $this->cssSheetHeader          = ( $bInHtmlForm ? "" : "p")."sheetHeader";
    $this->cssSheetSelect          = "selected";
    $this->cssSheetType            = "typeSheet";
    $this->cssSheetTypeOther       = "typeSheetOther";
    $this->cssMngBody              = ( $bInHtmlForm ? "" : "p")."sheetMngBody";
    $this->cssSheetBody            = ( $bInHtmlForm ? "" : "p")."sheetBody";
  }
  
  /**
   * Fixe la visibilité des onglets
   * @param bVisible  booleen, true pour afficher (par défaut), false pour cacher les onglets
   */
  public function setVisible($bVisible=true)
  {
    $this->bVisible = $bVisible;
  }
  
  /**
   * Fixe la visibilité des onglets
   * @param bVisible  booleen, true pour afficher (par défaut), false pour cacher les onglets
   */
  public function getSelectedSheet()
  {
    return $this->oSheetSelected;
  }
  
  /**
   *  Ajoute un onglet
   * @param oSheet      Onglet à ajouter de type AlkHtmlSheet
   * @param iTypeSheet  identifiant du type d'onglet, =0 par défaut
   * @return boolean : ajout réussi (pas de doublons)
   */
  public function addSheet(AlkHtmlSheet $oSheet, $iTypeSheet=0)
  {
    if( !empty($this->tabTypeSheets) && !array_key_exists("_".$iTypeSheet, $this->tabTypeSheets) )
      return false;
    
    if ( $iTypeSheet==0 && empty($this->tabSheets) ){
      $this->tabSheets["_".$iTypeSheet] = array();
      $oSheet->setDefaultCss("alksheetsmanager.css");
    }
    if ( !array_key_exists($oSheet->getGUID(), $this->tabSheets["_".$iTypeSheet]) ){
      if ( empty($this->tabSheets["_".$iTypeSheet]) )
        $this->oSheetSelected = $oSheet;
      $this->tabSheets["_".$iTypeSheet][$oSheet->getGUID()] = $oSheet;
      return true;
    }
    return false;
  }
   
  /**
   *  Supprime un onglet du panel
   * @param idSheet     Identifiant de l'onglet
   * @param iTypeSheet  identifiant du type d'onglet, =0 par défaut
   * @return boolean : suppression réussi (pas de doublons)
   */
  public function removeSheet($idSheet, $iTypeSheet=0)
  {
    if ( array_key_exists("_".$iTypeSheet, $this->tabSheets) && array_key_exists($idSheet, $this->tabSheets["_".$iTypeSheet]) ){
      if ( !is_null($this->oSheetSelected) && $this->oSheetSelected->getGUID()==$idSheet ){
        $this->oSheetSelected = null; 
      }
      unset($this->tabSheets["_".$iTypeSheet][$idSheet]);
      return true;
    }
    return false;
  }

  /**
   *  Ajoute un typeSheet à la barre onglet
   * @param iTypeSheet identifiant du type onglet
   * @param strTitle   titre de l'onglet
   * @param oUrl       Url sur l'onglet
   */
  public function addTypeSheet($iTypeSheet, $strTitle, $oUrl)
  {
    $this->tabTypeSheets["_".$iTypeSheet] = array("title" => $strTitle, "url" => $oUrl);
    $this->tabSheets["_".$iTypeSheet] = array();
  }

  /**
   *  Met à jour l'onglet sélectionné à partir des identifiants
   * @param iTypeSheet identifiant du type d'onglet
   * @param iSheet     identifiant de l'onglet
   * @param iSSheet    identifiant du sous onglet
   */
  public function setSelectedSheetByID($iTypeSheet, $iSheet, $iSSheet=-1)
  {
    $this->iTypeSheet = $iTypeSheet;
    $this->iSheet  = $iSheet;
    $this->iSSheet = $iSSheet;
  }

  /**
   *  Sélectionne un onglet
   * 
   * @param oSheet     Onglet à sélectionner de type AlkHtmlSheet ou null
   * @param iTypeSheet identifiant du type d'onglet, =0 par défaut
   */
  public function setSelectedSheetByGUID($idSheet, $iTypeSheet=0)
  {
    if ( array_key_exists($idSheet, $this->tabSheets["_".$iTypeSheet]) )
      $this->setSelectedSheet($this->tabSheets["_".$iTypeSheet][$idSheet], $iTypeSheet);
  }

  /**
   *  Sélectionne un onglet
   * 
   * @param oSheet     Onglet à sélectionner de type AlkHtmlSheet ou null
   * @param iTypeSheet identifiant du type d'onglet, =0 par défaut
   */
  public function setSelectedSheet($oSheet, $iTypeSheet=0)
  {
    if ( !is_null($oSheet) && !$oSheet->isTypeOf("alkhtmlsheet") ) return false;
    if ( !is_null($oSheet) ) {
      if ( array_key_exists($oSheet->getGUID(), $this->tabSheets["_".$iTypeSheet]) ) {
        $this->oSheetSelected = $oSheet;
        $this->iTypeSheet = $iTypeSheet;
        $this->iSheet = $oSheet->getGUID();
        $this->iSSheet = -1;
        return true;
      }
    }
    else {
      $this->oSheetSelected = $oSheet;
      $this->iTypeSheet = 0;
      $this->iSheet     = -1;
      $this->iSSheet    = -1;
        return true;
    }
    return false;
  }

  protected function checkVisibility()
  {
    if (!array_key_exists("_".$this->iTypeSheet, $this->tabSheets)) return;
    foreach ($this->tabSheets["_".$this->iTypeSheet] as $iSheet => $oSheet) {
      $this->bVisible &= $oSheet->getSheetVisible();
    }
  }

  /**
   *  Retourne le code html du manager
   * @return string html
   */
  public function getHtml()
  {
    if( empty($this->tabSheets) ) return "";
    
    $this->checkVisibility();
    $strHtml = "";

    if( $this->bVisible ) {
      $this->initCss();
      $this->oPanel->setDefaultCss("alksheetsmanager.css");
      $this->oPanel->addDefaultCss();
      $this->oPanel->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_CLASSE."form/alksheetsmanager.js");
    
      // layer contenant l'ensemble des oreilles onglet
      $strHtml .= '<div class="'.$this->cssMngHeader.'">'.
        '<div id="sheetMngHeader_'.$this->oPanel->getGUID().'" class="'.$this->cssSheetHeader.'">'.
        '<ul>';
    
      $iDefaultSheet = -1;
      if ( array_key_exists("_".$this->iTypeSheet, $this->tabSheets) ){
        foreach ($this->tabSheets["_".$this->iTypeSheet] as $iSheet => $oSheet) {
          $iDefaultSheet = ( $iDefaultSheet==-1 ? $iSheet : $iDefaultSheet);
          if ( is_null($this->oSheetSelected) ){
            $this->oSheetSelected = $oSheet;
          }
          $strTooltip = preg_replace("!<[^>]+>!", " ", $oSheet->getTitle());
          $strTitle = $oSheet->getTitle();
          $strUrl   = $oSheet->getUrl();
          $strId    = 'sheetHeader_'.$this->oPanel->getGUID().'_'.$iSheet;
          $strHtml .= '<li id="'.$strId.'"' .
            ' class="'.
            $this->cssSheetType.$this->iTypeSheet.
            ( $oSheet->cssSpecific!=""  
              ? " ".$oSheet->cssSpecific
              : "" ).
            ( !is_null($this->oSheetSelected) && $oSheet->equals($this->oSheetSelected) 
              ? " ".$this->cssSheetSelect
              : "" ).
            '"'.
            ' title="'.$strTooltip.'"'.
            '>'.
            '<a href="#'.$this->oPanel->getGUID()."_".$iSheet.'" onclick="'.
            ( $strUrl == "" 
              ? 'javascript:AlkSheetOnClick(\''.$this->oPanel->getGUID().'\', \''.$iSheet.'\');return false;'
              : ( preg_match("!javascript:!", $strUrl) 
                  ? $strUrl 
                  : 'javascript:AlkSheetGoUrl(\''.$strUrl.'\');return false;') ).
            '">'.$strTitle.'</a>'.
            '</li>';
        }
      }
      
      if( !empty($this->tabTypeSheets) ) {

        // onglets représentant les types d'onglets
        $tabTmp = array_reverse($this->tabTypeSheets);
        foreach ($tabTmp as $iTypeSheet => $tabType) {
          if( $iTypeSheet != "_".$this->iTypeSheet ) {
            $strTitle = $tabType["title"];
            $strUrl   = $tabType["url"];
            $strId    = "sheetHeader_".$this->oPanel->getGUID()."_".$iTypeSheet;
            $strHtml .= '<li id="'.$strId.'"'.
              ' class="'.$this->cssSheetTypeOther." ".$this->cssSheetTypeOther.mb_substr($iTypeSheet, 1).'"'.
              ' title="'.$strTitle.'"'.
              '>'.
              '<a href="#'.$this->oPanel->getGUID()."_".$iTypeSheet.'" onclick="javascript:AlkSheetGoUrl(\''.$strUrl.'\')">'.$strTitle.'</a>'.
              '</li>';
          }
        }    
      }

      $strHtml .= '</ul></div>'.
        /* barre sous les onglets */
        '<div class="'.$this->cssMngHeader.'BottomLine"></div></div>';

      $iDefaultSheet = ( !is_null($this->oSheetSelected) ? $this->oSheetSelected->getGUID() : $iDefaultSheet );
    }

    // layer contenant le contenu de l'onglet courant (cas ou parent non AlkHtmlForm) 
    // ou tout le contenu du form avec gestion du sélectionné visible en js
    $strHtml .= '<div id="sheetMngBody_'.$this->oPanel->getGUID().'" class="'.$this->cssMngBody.'">'.
      ( $this->oPanel->isInHtmlForm()
        ? $this->getHtmlSheetsForForm()
        : ( !is_null($this->oSheetSelected) 
            ? '<a name="'.$this->oPanel->getGUID()."_".$this->oSheetSelected->getGUID().'">'.
              '<h2 class="offscreen">'.$this->oSheetSelected->getTooltip().'</h2></a>'.
              $this->oSheetSelected->getHtml()
            : "" )).
      '</div>';
      
    if( $this->oPanel->isInHtmlForm() && $this->bVisible ) {
      $strHtmlJS = " var oSheetsManager_".$this->oPanel->getGUID().
        " = new AlkFormSheets('".$this->oPanel->getGUID()."', '".$iDefaultSheet."', '".$this->cssSheetHeader."', '".$this->cssSheetHeaderSelect."');";

      $this->oPanel->addJs($strHtmlJS);
    }
    
    return $strHtml;
  }
  
  /**
   *  Retourne le code html des onglets d'un formulaire : 
   *        tous les onglets sont écrits, seul celui sélectionné est visible
   *
   * @return Retourne un string
   */
  private function getHtmlSheetsForForm()
  {
    $strHtml = "";
    foreach ($this->tabSheets["_0"] as $iSheet => $oSheet) {
      $strHtml .= '<a name="'.$this->oPanel->getGUID()."_".$iSheet.'">' .
        '<h3 class="offscreen">'.$oSheet->getTooltip().'</h3></a>' .
        '<div id="sheetBoby_'.$this->oPanel->getGUID()."_".$iSheet.'"'.
        ' class="'.$this->cssSheetBody.
        ( !is_null($this->oSheetSelected) && $oSheet->equals($this->oSheetSelected)
          ? " ".$this->cssSheetSelect
          : "" ).'">'.
        $oSheet->getHtml().
        '</div>';
    }
    return $strHtml;
  }
}

?>