/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Class::Form
Module fournissant les classes d'affichage Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/


/**
 * Affiche/masque les métadonnées associées à la pièce jointe dont l'identifiant est passé en paramètre
 * @param pj_id    identifiant de la pièce jointe 
 */
function ShowHidePJDetails(pj_id)
{
  var oDiv = document.getElementById("div_pj_details_"+pj_id);
  var oLink = document.getElementById("link_pj_show_hide_details");
  if ( oDiv && oLink ) {
    if ( oDiv.style.display == "" ) {
      oLink.title = _gt("Afficher les métadonnées");
      oDiv.style.display = "none";
    } else {
       oLink.title = _gt("Masquer les métadonnées");
      oDiv.style.display = "";
    }
  }
}

/**
 * initialise le champ caché correspondant au controle pour permettre de détecter une modification du champ
 */
function setControlHiddenValue(ctrlName)
{
  var oCtrl = document.getElementById(ctrlName);
  var oCtrlHidden = document.getElementById("hidden_"+ctrlName);
  if ( oCtrl && oCtrlHidden  && oCtrlHidden.value == "0-0-0-0-0" ) {
    oCtrlHidden.value = oCtrl.value;
  }
}

/**
 * Enregistre en Ajax les métadonnées associées à une pièce jointe
 * vérifie la validité des champs avant traitement
 * @param formName    nom du formulaire
 * @param pj_id       identifiant de la pièce jointe à sauvegarder et à prendre en compte pour les valeurs de propagation
 * @param strToken    token de l'url
 * @param bForAll     boolean true pour propager les valeurs à tous les fichiers de la liste
 */ 
function ValidatePJDetails(formName, ctrlUploadName, pj_id, strToken, bForAll)
{
  var form = eval("document."+formName);
  if ( !form ) return;
  
  var tabCtrlPJ = new Array();
  for ( var i=0; i<jsonPJDetails.length; i++ ) {
    var oCtrl = document.getElementById(jsonPJDetails[i].field+"_"+pj_id);
    tabCtrlPJ.push(oCtrl);
  }
  if ( !AlkVerifCtrl(form, tabCtrlPJ) ) return;
  
  var titre = null;
  var strParam = "";
  for ( var i=0; i<jsonPJDetails.length; i++ ) {
    var oField = document.getElementById(jsonPJDetails[i].field+"_"+pj_id);
    if ( oField ) {
      strParam+= ( oField ? "&"+jsonPJDetails[i].field+"="+encodeURIComponent(oField.value) : "" );
    }
    if ( jsonPJDetails[i].field == "pj_title" ) {
      titre = oField.value;
    }
  }
   
  if ( bForAll ) {
    /* récupère toutes les pièces jointes du controle d'upload */
    var tabPJ = new Array();
    var tabCtrlPJHidden = document.getElementsByName("pj_"+ctrlUploadName+"_id");
    for(var i=0; i<tabCtrlPJHidden.length; i++) {
      tabPJ.push(tabCtrlPJHidden[i].value);
    }
    if ( tabPJ ) {
      for ( var i=0; i<tabPJ.length; i++ ) {
        strParam+= "&pj_id[]="+tabPJ[i];
      }
    }
  } else {
    strParam+= "&pj_id[]="+pj_id;
  }
  
  var oAjax = new AlkAjax('validatePJDetails', '', ALK_FORM_METHOD_GET, 
                          ALK_ALKANET_PROCESS+'?iMode=11&token='+strToken+strParam, null, false);
  if ( oAjax.returnValue ) {
    // actions effectuées en cas de succès
    // propage les valeurs aux hidden de la pièce jointe
    for ( var i=0; i<jsonPJDetails.length; i++ ) {
      var oCtrl = document.getElementById(jsonPJDetails[i].field+"_"+pj_id);
      var oCtrlHidden = document.getElementById("hidden_"+jsonPJDetails[i].field+"_"+pj_id);
      if ( oCtrl && oCtrlHidden && oCtrlHidden.value != "0-0-0-0-0" ) {
        oCtrlHidden.value = oCtrl.value;
      }
    }
    // acutalise le titre de la pièce jointe
    var oSpan = document.getElementById("span_pj_title_"+pj_id);
    if ( oSpan ) {
      if ( titre != null && titre.toString() != "" ) {
          oSpan.innerHTML = titre;
      } else {
        var oPJName = document.getElementById("pj_name_"+pj_id);
        if ( oPJName ) {
          oSpan.innerHTML = oPJName.value;
        }
      }
    }
    // propage les valeurs aux autres fichiers
    if ( bForAll ) {
      for ( var i=0; i<jsonPJDetails.length; i++ ) {
        oField = document.getElementById(jsonPJDetails[i].field+"_"+pj_id);
        if ( oField ) {
          if ( tabPJ ) {
            for ( var j=0; j<tabPJ.length; j++ ) {
              if ( tabPJ[j] != pj_id ) {
                var oCtrl = document.getElementById(jsonPJDetails[i].field+"_"+tabPJ[j]);
                if ( oCtrl ) {
                  oCtrl.value = oField.value;
                }
                // propage les valeurs aux hidden des autres fichiers
                var oCtrlHidden = document.getElementById("hidden_"+jsonPJDetails[i].field+"_"+tabPJ[j]);
                if ( oCtrlHidden && oCtrlHidden != "0-0-0-0-0" ) {
                  oCtrlHidden.value = oField.value;
                }
                // acutalise le titre des autres fichiers
                var oSpan = document.getElementById("span_pj_title_"+tabPJ[j]);
                if ( oSpan ) {
                  if ( titre != null && titre.toString() != "" ) {
                      oSpan.innerHTML = titre;
                  } else {
                    var oPJName = document.getElementById("pj_name_"+tabPJ[j]);
                    if ( oPJName ) {
                      oSpan.innerHTML = oPJName.value;
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
    alkAlert(_gt("Les métadonnées ont bien été mises à jour."));
  } else {
    // actions effectuées en cas d'echec
    alkAlert(_gt("Une erreur est survenue lors de la mise à jour des métadonnées."));
  }
}

/**
 * ajoute les proriétés à un controle pour permettre sa validation
 * @param bAddToForm   booléen à vrai pour ajouter le controle au formulaire englobant, false sinon
 */
function AddValidatorPJDetails(bAddToForm)
{
  var formNameGlobal = document.getElementById("formNameGlobal");
  if ( !formNameGlobal ) return;
  
  var form = eval("document."+formNameGlobal.value);
  if ( !form ) return;
  
  var tabCtrlUploadName = document.getElementsByName("uploadName");
  for ( var iCtrlUpload=0; iCtrlUpload<tabCtrlUploadName.length; iCtrlUpload++ ) { // on parcourt tous les controles d'upload
    
    var tabPJ = document.getElementsByName("pj_"+tabCtrlUploadName[iCtrlUpload].value+"_id"); // on récupère tous les champs de chaque pièce jointe
    
    if ( tabPJ ) {
      for ( var i=0; i<tabPJ.length; i++ ) {
        for ( var j=0; j<jsonPJDetails.length; j++ ) {
          var min = ( jsonPJDetails[j].min ? jsonPJDetails[j].min : "" );
          var max = ( jsonPJDetails[j].max ? jsonPJDetails[j].max : "" );
          if ( bAddToForm ) {
            AlkAddCtrl(formNameGlobal.value, jsonPJDetails[j].field+"_"+tabPJ[i].value, jsonPJDetails[j].type, jsonPJDetails[j].required, jsonPJDetails[j].label, min, max, "", "", true, validatorPJInfo.iSheet, validatorPJInfo.sheetManager);
          }
          var oCtrl = document.getElementById(jsonPJDetails[j].field+"_"+tabPJ[i].value);
          if( oCtrl ) {
            oCtrl.alkPJDetailsType = jsonPJDetails[j].type;
            oCtrl.alkPJDetailsRequire = jsonPJDetails[j].required;
            oCtrl.alkPJDetailsLabel = jsonPJDetails[j].label;
            oCtrl.alkPJDetailsMin = min;
            oCtrl.alkPJDetailsMax = max;
            oCtrl.alkPJDetailsMsgErr = "";
            oCtrl.alkPJDetailsExcept = "";
            oCtrl.alkPJDetailsStrict = "";
            oCtrl.alkPJDetailsFormName = "";
            oCtrl.alkPJDetailsFormSheetIndex = "";
            oCtrl.alkPJDetailsSheetManager   = "";
          }
          // ajoute les paramètres de calendrier pour les champs date
          if ( jsonPJDetails[j].type == "date10" ) {
            window.oParamCalendar[jsonPJDetails[j].field+"_"+tabPJ[i].value] = jsonPJDetails[j].field+"_"+tabPJ[i].value;
          }
        }
      }
      initCalendar();
    }
  }
}

/**
 * vérifie si les formulaires de pièces jointe ont été sauvegardés ou non
 * @param formName   nom du formulaire
 * @return false si au moins un formulaire de pièces jointe n'a pas été sauvegardé, true sinon
 */
function VerifPJDetailsSaved(formName)
{
  var form = eval("document."+formName);
  if ( !form ) return;
  
  var tabPJ = new Array();
  var pattern = new RegExp('^pj_.*_id$', 'g'); // on retrouve tous les champs cachés contenant les pièces jointes
  for(var i=0; i<form.elements.length; i++) {
    var elt = form.elements[i];
    if(elt.name) {
      if(elt.name.match(pattern)!=null) {
        tabPJ.push (elt.value);
      }
    }
  }
  
  if ( tabPJ ) {
    for ( var i=0; i<tabPJ.length; i++ ) {
      for ( var j=0; j<jsonPJDetails.length; j++ ) {
        var oCtrl = document.getElementById(jsonPJDetails[j].field+"_"+tabPJ[i]);
        var oCtrlHidden = document.getElementById("hidden_"+jsonPJDetails[j].field+"_"+tabPJ[i]);
        if ( oCtrl && oCtrlHidden && oCtrlHidden.value != "0-0-0-0-0" ) {
          if ( oCtrl.value != oCtrlHidden.value ) {
            return false;
          }
        }
      }
    }
  }
  return true;
}

/**
 * Fonction d'ajout de pièces jointes pour les upload dynamiques
 */
function AjouterPJ(formName, ctrlName, token){
  var oForm = eval('document.'+formName);
  var bSelect = false;
  var bSelectExists = false;
  var iMode = 1;
  if (oForm){
    var oCtrl = oForm.elements["files_"+ctrlName];
    if( oCtrl ) {
      bSelectExists = true;
      bSelect = ( oCtrl.selectedIndex > 0 );
    }
    if( !bSelect ) {
     oCtrl = oForm.elements["file_"+ctrlName];
    }
    if( oCtrl ) {
      var bVal = ( bSelect ? true : (oCtrl.value!='') );   
      var nbMaxPj = oForm.elements["nbMaxPj_"+ctrlName];
      var nbPJ = oForm.elements["nbPJ_"+ctrlName];
      if ( nbMaxPj && nbPJ ){
        if ( nbMaxPj.value==nbPJ.value ){
          alkAlert(_gtf("Nombre maximal de fichiers acceptés atteint.%sUtiliser la suppression pour substituer un fichier.", "\n"));
          return;
        }
      }
      if( bVal ) {
        SupprimerPJ(formName, ctrlName, token, iMode);
      } else {
        alkAlert(_gt("Utilisez le bouton Parcourir pour sélectionner le fichier à ajouter")+
              ( bSelectExists 
                ? "\n"+_gt("ou bien sélectionnez un fichier présent sur le FTP.")
                : "" ));
      }
    }
  }
}

/**
 * Fonction de suppression de pièces jointes pour les upload dynamiques
 */
function SupprimerPJ(formName, ctrlName, token){
  var nbArgs = 3;
  var iMode = 2;
  if (arguments.length>nbArgs){
    iMode = arguments[nbArgs];
  }
  var oForm = eval('document.'+formName);
  if (oForm){
    if ( iMode==2 ){
      var bCheck = false;
      var nbPJ = oForm.elements["nbPJ_"+ctrlName].value;
      for (var i=0; i<nbPJ; i++){
        var oCheck = oForm.elements["suppj_"+ctrlName+"_"+i];
        bCheck = (oCheck && oCheck.checked);
        if (bCheck) break;
      }
      if ( !bCheck || !AlkConfirm(_gt("Confirmer la suppression des pièces jointes sélectionnées ?")) ){
        var oCheckAll = oForm.elements["check_all_"+ctrlName];
        if ( oCheckAll ) {
          oCheckAll.checked = false;
          if ( oCheckAll.onclick )
            oCheckAll.onclick();
        }
        return;
      }
    }
    var strUrl = ALK_ALKANET_PROCESS+"?iMode="+iMode+"&token=" + token;
    var oldAction = oForm.action;
    var oldTarget = oForm.target;
    oForm.target = 'ifr_upload_'+ctrlName;
    oForm.action = strUrl;
    oForm.submit();
    oForm.target = oldTarget;
    oForm.action = oldAction;
    
    var oCheckAll = oForm.elements["check_all_"+ctrlName];
    if ( oCheckAll ) {
      oCheckAll.checked = false;
      if ( oCheckAll.onclick )
        oCheckAll.onclick();
    }
    
  }
}

function CheckAll(formName, ctrlName, oCheckAll){
  var oForm = eval('document.'+formName);
  if (oForm){
    var nbPJ = oForm.elements["nbPJ_"+ctrlName].value;
    for (var i=0; i<nbPJ; i++){
      var oCheck = oForm.elements["suppj_"+ctrlName+"_"+i];
      if (!oCheck) continue;
      oCheck.checked = oCheckAll.checked;
    }
  }
}

function OpenCloseMenu(oSrc, destName, action, bSelf)
{
  bSelf = bSelf || false;
  var oDiv = (bSelf ? oSrc : document.getElementById(destName));
  if( oDiv ) {
    var oStyle = ( oDiv.style ? oDiv.style : oDiv );  
    if ( action=='over' ){
      oDiv.className = oDiv.className.replace(/ over/g, "")+" over";
    } else {
      oDiv.className = oDiv.className.replace(/ over/g, "");
    }
  }
}

function DownloadMedia(strToken)
{
  OpenWindow(ALK_ALKANET_DOWNLOAD+"?token="+strToken, "425", "600", "_pluginMultiMedia", "yes");
}
function Download(strToken)
{
  OpenFooterExec(ALK_ALKANET_DOWNLOAD+"?token="+strToken);
}
function DownloadAll(strToken)
{
  OpenFooterExec(ALK_ALKANET_DOWNLOAD+"?token="+strToken);
}


/**
 * Function appelée après qu'un upload swf s'est terminé avec succès
 * @param server_data retour de l'opération
 */
function AlkUploadSuccess(server_data)
{
  var layerName = ""; 
  var htmlContents = "";
  
  if( arguments.length == 2 ) {
    layerName    = arguments[1];
    htmlContents = server_data;
  } else {
    var oRes = eval("("+server_data+")");
    layerName     = oRes.layerName;
    htmlContents  = oRes.htmlContents;
    strAlert      = oRes.strAlert;
  }
  oDiv = document.getElementById(layerName);
  if( oDiv ) {
    oDiv.innerHTML = htmlContents;
  }
  
  if ( strAlert ) {
    alkAlert(strAlert);
  }
  
  AddValidatorPJDetails(true);
}

function AlkUploadSuccessByUrl(strUrl)
{
  var oAjax = new AlkAjax('updatePj', 'AlkUploadSuccess', ALK_FORM_METHOD_GET, strUrl, null);
}

function delPJ(formName, ctrlName, strToken)
{
  var oForm = eval('document.'+formName);
  if (oForm){
    var bCheck = false;
    var nbPJ = oForm.elements["nbPJ_"+ctrlName].value;
    for (var i=0; i<nbPJ; i++){
      var oCheck = oForm.elements["suppj_"+ctrlName+"_"+i];
      bCheck = (oCheck && oCheck.checked);
      if (bCheck) break;
    }
    if ( !bCheck || !alkConfirm(_gt("Confirmer la suppression des pièces jointes sélectionnées ?")) ){
      var oCheckAll = oForm.elements["check_all_"+ctrlName];
      if ( oCheckAll ) {
        oCheckAll.checked = false;
        if ( oCheckAll.onclick )
          oCheckAll.onclick();
      }
      return;
    }
  }
  var oAjax = new AlkAjax('delPj', 'AlkUploadSuccess', ALK_FORM_METHOD_POST, 
                          ALK_ALKANET_PROCESS+'?iMode=6&token='+strToken, formName);
  var oCBAll = oForm.elements["check_all_"+ctrlName];
  oCBAll.checked = false; 
}

function delVersionPJ(strToken)
{
  var oAjax = new AlkAjax('delPj', 'AlkUploadSuccess', ALK_FORM_METHOD_GET, 
                          ALK_ALKANET_PROCESS+'?iMode=10&token='+strToken, null);
}

/**
 * Fonctions upload ajax, un seul téléchargement possible à la fois
 */
var alkHtmlUploadTabInfo = new Array();
var alkHtmlUploadStartTime = 0;

/**
 * Retourne la taille d'un fichier avec l'unité adéquate
 */
function getFilesizeFormat(num, space)
{
  var unit;
  if( num < 1024 ) { 
    unit = 'o';
  } else if( num < 1024*1024 ) { 
    num = Math.round((num*100)/1024);
    num = num/100;
    num = num.toString();
    unit = 'ko';
  } else { 
    num = Math.round((num*100)/(1024*1024));
    num = num/100;
    num = num.toString();
    unit = 'Mo';
  }
  return num + space + unit;
}

/**
 * Retourne le temps restant avec l'unité adéquate
 */
function getTimeFormat(num, space)
{
  var unit;
  if( num >= (60*60) ) {
    var secs_left = num % (60*60);
    var mins_left = secs_left / 60;
    mins_left = mins_left.toString();
    // note extra escaping necessary since we're printing this JS code from Perl...
    mins_left = mins_left.replace( /^(\d+)\..*/, '$1' ); // show no decimal places.
    mins_left = mins_left.replace( /^(\d)$/, '0$1' ); // for single-digits, prepend a zero.

    num = num/(60*60);
    num = num.toString();
    // note extra escaping necessary since we're printing this JS code from Perl...
    num = num.replace( /^(\d+)\..*/, '$1' ); // show no decimal places.

    num = num + space + 'h' + space + mins_left + space + 'mn';
    space = '';
    unit = '';
  }
  else if(num >= 60) {
    var secs_left = num % 60;
    secs_left = secs_left.toString().replace( /^(\d)$/, '0$1' ); // for single-digits, prepend a zero.

    num = num/60;
    num = num.toString();
    // note extra escaping necessary since we're printing this JS code from Perl...
    num = num.replace( /^(\d+)\..*/, '$1' ); // show no decimal places.
    num = num.replace( /^(\d)$/, '0$1' ); // for single-digits, prepend a zero.

    num = num + space + 'mn' + space + secs_left + space + 's';
    space = '';
    unit = '';
  }
  else {
    unit = 's';
  }
  return num + space + unit;
}

function alkHtmlUploadInfo()
{
  strUrl = ALK_ALKANET_PROCESS+"?iMode=9&token="+
    alkHtmlUploadTabInfo["token"]+"&ids=" + alkHtmlUploadTabInfo["session"];
  var oAjax = new AlkAjax("", "alkHtmlUploadUpdateProgress", "GET", strUrl, null);
}

function alkHtmlUploadUpdateProgress(strResponse)
{
  // mise à jour de la barre de progression, appel cyclique jusqu'à error ou fin de transfert
  var tabUpdate = new Array();
  tabUpdate = strResponse.split('|');

  var oDiv = document.getElementById(alkHtmlUploadTabInfo["divProgressBar"]);
  if( !oDiv ) return;
  var oStyle = ( oDiv.style ? oDiv.style : oDiv ); 

  var iStatus = tabUpdate[0];
  var strError = "";
  var completedUploadSize = 0;
  var totalUploadSize = 0;
  if( alkHtmlUploadStartTime == 0 ) {
    // transfert annulé, affichage durant 2s avant d'effacer la barre de progression
    oDiv.innerHTML = _gt("Transfert annulé.");
    oStyle.backgroundPosition = "0px 0px";
    window.setTimeout("alkHtmlUploadEndProgress()", 2000);
    return;
  } else if( iStatus == 0 ) {
    // erreur détectée, affichage de l'erreur durant 2s avant d'effacer la barre de progression
    oDiv.innerHTML = tabUpdate[1];
    oStyle.backgroundPosition = "0px 0px";
    window.setTimeout("alkHtmlUploadHideProgress()", 2000);
    return;
  } else if( iStatus == 2 ) {
    // info non reçue, on réitère la progression
    oDiv.innerHTML = _gt("Transfert en cours...");
    window.setTimeout("alkHtmlUploadInfo()", 1000);
    return;
  } else {
    totalUploadSize = tabUpdate[1];
    completedUploadSize = tabUpdate[2];
  }

  if( completedUploadSize == 0 && totalUploadSize == 0 ) {
    // transfert non démarré, réitère la progression
    window.setTimeout("alkHtmlUploadInfo()", 1000);
    return;
  } 
  if( totalUploadSize == completedUploadSize ) {
    // fin de transfert, appelle la phase d'enregistrement
    oDiv.innerHTML = _gt("Traitement serveur en cours...");
    oStyle.backgroundPosition = oStyle.width+" 0px"; 
    alkHtmlUploadEndProgress();
    return;
  }

  var d = new Date();
  var elapsedTime = parseInt(d.getTime()/1000) - alkHtmlUploadStartTime;

  var progressPercent = ( totalUploadSize>0 ? Math.ceil((completedUploadSize/totalUploadSize)*100) : 0 );
  var totalTime = (  totalUploadSize>0 ? parseInt( elapsedTime/(completedUploadSize/totalUploadSize) ) : 0 );
  var strTransferRate = getFilesizeFormat((elapsedTime>0 ? completedUploadSize/elapsedTime : 0), '&nbsp;');
  var strRemainingTime = getTimeFormat( (totalTime - elapsedTime), '&nbsp;');

  oDiv.innerHTML = 
    ( progressPercent > 0
      ? _gtf("Transfert en cours... %s% - %s/s - %s restant", progressPercent, strTransferRate, strRemainingTime)
      : _gt("Transfert en cours...") );

  var iWidth = parseInt(oStyle.width);
  oStyle.backgroundPosition = Math.round(iWidth*progressPercent/100)+"px 0px"; 
  
  // transfert en cours, réitère la progression
  window.setTimeout("alkHtmlUploadInfo()", 1000);
}

function alkHtmlUploadStartProgress()
{
  var oDiv = document.getElementById(alkHtmlUploadTabInfo["divProgressBar"]);
  if( !oDiv ) return;
  var oStyle = ( oDiv.style ? oDiv.style : oDiv ); 
  oStyle.display = "block";
  oDiv.innerHTML = _gt("Envoi en cours... 0%");

  var d = new Date();
  alkHtmlUploadStartTime = parseInt(d.getTime()/1000);

  window.setTimeout("alkHtmlUploadInfo()", 1000);
}

function alkHtmlUploadEndProgress()
{
  // le transfert est terminé, phase de renommage et enregistrement en base
  strUrl = ALK_ALKANET_PROCESS+"?iMode=8&token="+
    alkHtmlUploadTabInfo["token"]+"&fn=" + alkHtmlUploadTabInfo["fileName"];
  var oAjax = new AlkAjax("", "alkHtmlUploadHideProgress", "GET", strUrl, null);
}

function alkHtmlUploadHideProgress(pj_id)
{
  // enregistrement terminé, cache la barre de progression
  var oDiv = document.getElementById(alkHtmlUploadTabInfo["divProgressBar"]);
  if( !oDiv ) return;
  var oStyle = ( oDiv.style ? oDiv.style : oDiv ); 
  oDiv.innerHTML = _gt("Terminé.");
  oStyle.display = "none";
  alkHtmlUploadStartTime = 0;
  AlkUploadSuccessByUrl(alkHtmlUploadTabInfo["urlRefreshList"]);
  
  var oCtrlFile = alkHtmlUploadTabInfo["ctrlFile"];
  if( !alkHtmlUploadTabInfo["bIE"] ) {
    var oTag = document.getElementById(alkHtmlUploadTabInfo["parentCtrlFileId"]);
    oTag.appendChild(oCtrlFile);
  }
  var oStyleF = ( oCtrlFile.style ? oCtrlFile.style : oCtrlFile ); 
  oStyleF.display = "";
  oCtrlFile.value = "";
  
  if( alkHtmlUploadTabInfo["ctrlPjId"] ) {
    alkHtmlUploadTabInfo["ctrlPjId"].value = pj_id;
  }
}

function getUploadForm(f)
{
  var d = document;
  var strNewName = f.name+"_send";
  var fu = d.forms[strNewName];
  if( fu ) {
    return fu;
  }
  
  var oParent = document.getElementById(f.parentNode.id);
  if( !oParent ) {
    oParent = document.getElementsByTagName("body")[0];
  }
  fu = d.createElement("FORM");
  fu.id = strNewName;
  fu.name = strNewName;
  fu.enctype = f.enctype;
  fu.method = f.method;
  var oStyle = ( fu.style ? fu.style : fu );
  oStyle.width = "0px";
  oStyle.height = "0px";
  oStyle.overflow = "hidden";
  oStyle.padding = "0px";
  oStyle.margin = "0px";
  
  oParent.appendChild(fu);
  
  return fu;
}

function doAjaxUpload(strFormName, strTarget, strParentCtrlFileId, strDivProgressBar, oCtrlFile, 
                                   strTokenSave, strSession, strTmpPath, strAlkanetRootUrl, strUrlRefreshList, strCtrlPjIdName)
{
  var bIE = ( navigator.appName.indexOf("Explorer") != -1 ? true : false );

  if( alkHtmlUploadStartTime > 0 ) return;
    
  var f = document.forms[strFormName];
  if( !f ) return;

  var nbMaxPj = f.elements["nbMaxPj_"+oCtrlFile.name.substr(5)];
  var nbPJ = f.elements["nbPJ_"+oCtrlFile.name.substr(5)];
  if ( nbMaxPj && nbPJ && nbMaxPj.value==nbPJ.value ) {
    alkAlert(_gtf("Nombre maximal de fichiers acceptés atteint.%sUtiliser la suppression pour substituer un fichier.", "\n"));
    return;
  }

  var strFileName = oCtrlFile.value;
  if( strFileName == "" ) return;

  var iPos = strFileName.lastIndexOf("/");
  if( iPos == -1 ) {
    iPos = strFileName.lastIndexOf("\\");
  }
  if( iPos != -1 ) {
    strFileName = strFileName.substr(iPos+1);
  }
  strFileName = strFileName.replace(/&/g, "");
  
  // initialisation et démarrage de la phase de transfert
  alkHtmlUploadTabInfo["parentCtrlFileId"] = strParentCtrlFileId;
  alkHtmlUploadTabInfo["ctrlFile"]       = oCtrlFile;
  alkHtmlUploadTabInfo["token"]          = strTokenSave;
  alkHtmlUploadTabInfo["session"]        = strSession.substr(0, strSession.indexOf("_"));
  alkHtmlUploadTabInfo["fileName"]       = strFileName;
  alkHtmlUploadTabInfo["alkanetRootUrl"] = strAlkanetRootUrl;
  alkHtmlUploadTabInfo["divProgressBar"] = strDivProgressBar;
  alkHtmlUploadTabInfo["urlRefreshList"] = strUrlRefreshList;
  alkHtmlUploadTabInfo["bIE"]            = bIE;
  alkHtmlUploadTabInfo["ctrlPjId"]       = ( strCtrlPjIdName != "" ? f.elements[strCtrlPjIdName]: null );

  var fu = null;
  if( !bIE ) {
    fu = getUploadForm(f);
    fu.appendChild(oCtrlFile);
  } else {
    fu = f;
    var oStyle = ( oCtrlFile.style ? oCtrlFile.style : oCtrlFile );
    oStyle.display = "none"; 
  }

  fu.enctype = "multipart/form-data";
  fu.action = strAlkanetRootUrl+ALK_ROOT_MODULE+"alkanet/cgi-bin/alkanet_upload.cgi?ids="+strSession+"_"+oCtrlFile.name+"&dtmp="+strTmpPath;
  fu.targetOld = fu.target; 
  fu.target = strTarget;
  alkHtmlUploadStartProgress();
  fu.submit();
  fu.target = fu.targetOld;
}

function cancelAjaxUpload(strTarget)
{
  if( alkHtmlUploadStartTime > 0 ) {
    alkHtmlUploadStartTime = 0;
    var oIFrame = document.getElementById(strTarget);
    if( oIFrame ) {
      var oWind = oIFrame.contentWindow;
      if( oWind ) {
        if( oWind.stop ) 
          oWind.stop();
      }
    }
  }
}

/**
 * Décompresse la pièce jointe
 */
var alkHtmlUnzipStartTime = 0;
var alkHtmlAddPJStartTime = 0;
var alkHtmlUnzipTabInfo = new Array();
function UnzipPJ(strTokenUnzip, strTokenProgress, strTokenAddPJ, strTokenRefreshList, strDivProgressBar, strCtrlFileId)
{
  if ( !alkConfirm(_gtf("Confirmer la décompression de ce fichier ?%s(Celui-ci sera supprimé à la fin de l'opération)", "\n")) ) return;
  
  if( alkHtmlUnzipTabInfo > 0 ) return;
  
  alkHtmlUnzipTabInfo["strTokenUnzip"]       = strTokenUnzip;
  alkHtmlUnzipTabInfo["strTokenProgress"]    = strTokenProgress;
  alkHtmlUnzipTabInfo["strTokenAddPJ"]       = strTokenAddPJ;
  alkHtmlUnzipTabInfo["strTokenRefreshList"] = strTokenRefreshList;
  alkHtmlUnzipTabInfo["divProgressBar"]      = strDivProgressBar;
  alkHtmlUnzipTabInfo["strCtrlFileId"]       = strCtrlFileId;
  
  var oCtrlFile = document.getElementById(strCtrlFileId);
  if ( oCtrlFile ) {
    oCtrlFileStyle = ( oCtrlFile.style ? oCtrlFile.style : oCtrlFile );
    oCtrlFileStyle.display = "none";
  }
  
  OpenFooterExec(ALK_ALKANET_ROOT_URL+ALK_ROOT_MODULE+"alkanet/alkanet_unzip.php?token="+strTokenUnzip);
  
  alkHtmlUnzipStartProgress();
}

function alkHtmlUnzipStartProgress()
{
  var oDiv = document.getElementById(alkHtmlUnzipTabInfo["divProgressBar"]);
  if( !oDiv ) return;
  var oStyle = ( oDiv.style ? oDiv.style : oDiv ); 
  oStyle.display = "block";
  oDiv.innerHTML = _gt("Décompression en cours... 0%");

  var d = new Date();
  alkHtmlUnzipStartTime = parseInt(d.getTime()/1000);

  window.setTimeout("alkHtmlUnzipInfo()", 1000);
}
function alkHtmlAddPJStartProgress()
{
  var oDiv = document.getElementById(alkHtmlUnzipTabInfo["divProgressBar"]);
  if( !oDiv ) return;
  var oStyle = ( oDiv.style ? oDiv.style : oDiv ); 
  oStyle.display = "block";
  oDiv.innerHTML = _gt("Ajout des pièces jointes en cours... 0%");

  var d = new Date();
  alkHtmlAddPJStartTime = parseInt(d.getTime()/1000);

  window.setTimeout("alkHtmlAddPJInfo()", 1000);
}

function alkHtmlUnzipInfo()
{
  var strUrl = ALK_ALKANET_PROCESS+"?iMode=12&token="+alkHtmlUnzipTabInfo["strTokenProgress"];
  var oAjax = new AlkAjax("", "alkHtmlUnzipUpdateProgress", "GET", strUrl, null);
}
function alkHtmlAddPJInfo()
{
  var strUrl = ALK_ALKANET_PROCESS+"?iMode=13&token="+alkHtmlUnzipTabInfo["strTokenProgress"];
  var oAjax = new AlkAjax("", "alkHtmlAddPJUpdateProgress", "GET", strUrl, null);
}

function alkHtmlUnzipUpdateProgress(strResponse)
{
  // mise à jour de la barre de progression, appel cyclique jusqu'à error ou fin de décompression
  var tabUpdate = new Array();
  tabUpdate = strResponse.split('|');

  var oDiv = document.getElementById(alkHtmlUnzipTabInfo["divProgressBar"]);
  if( !oDiv ) return;
  var oStyle = ( oDiv.style ? oDiv.style : oDiv ); 

  var iStatus = tabUpdate[0];
  var strError = "";
  var nbFilesExtracted = 0;
  var nbFileTotal = 0;
  if( alkHtmlUnzipStartTime == 0 ) {
    // Décompression annulée, affichage durant 2s avant d'effacer la barre de progression
    oDiv.innerHTML = _gt("Décompression annulée.");
    oStyle.backgroundPosition = "0px 0px";
    window.setTimeout("alkHtmlUnzipEndProgress()", 2000);
    return;
  } else if( iStatus == 0 ) {
    // erreur détectée, affichage de l'erreur durant 2s avant d'effacer la barre de progression
    oDiv.innerHTML = tabUpdate[1];
    oStyle.backgroundPosition = "0px 0px";
    window.setTimeout("alkHtmlUnzipHideProgress()", 2000);
    return;
  } else if( iStatus == 2 ) {
    // info non reçue, on réitère la progression
    oDiv.innerHTML = _gt("Décompression en cours...");
    window.setTimeout("alkHtmlUnzipInfo()", 1000);
    return;
  } else {
    nbFilesExtracted = tabUpdate[1];
    nbFileTotal = tabUpdate[2];
  }

  if( nbFilesExtracted == 0 && nbFileTotal == 0 ) {
    // transfert non démarré, réitère la progression
    window.setTimeout("alkHtmlUploadInfo()", 1000);
    return;
  } 
  if( nbFilesExtracted == nbFileTotal ) {
    // fin de décompression, appelle la phase d'enregistrement
    oDiv.innerHTML = _gt("Ajout des pièces jointes en cours... 0%");
    oStyle.backgroundPosition = oStyle.width+" 0px"; 
    alkHtmlUnzipEndProgress();
    return;
  }

  var d = new Date();

  var progressPercent = ( nbFileTotal>0 ? Math.ceil((nbFilesExtracted/nbFileTotal)*100) : 0 );

  oDiv.innerHTML = 
    ( progressPercent > 0
      ? _gtf("Décompression en cours... %s%", progressPercent)
      : _gt("Décompression en cours...") );

  var iWidth = parseInt(oStyle.width);
  oStyle.backgroundPosition = Math.round(iWidth*progressPercent/100)+"px 0px"; 
  
  // décompression en cours, réitère la progression
  window.setTimeout("alkHtmlUnzipInfo()", 1000);
}
function alkHtmlAddPJUpdateProgress(strResponse)
{
  // mise à jour de la barre de progression, appel cyclique jusqu'à error ou fin d'ajout
  var tabUpdate = new Array();
  tabUpdate = strResponse.split('|');

  var oDiv = document.getElementById(alkHtmlUnzipTabInfo["divProgressBar"]);
  if( !oDiv ) return;
  var oStyle = ( oDiv.style ? oDiv.style : oDiv ); 

  var iStatus = tabUpdate[0];
  var strError = "";
  var nbFilesAdded = 0;
  var nbFileTotal = 0;
  if( alkHtmlAddPJStartTime == 0 ) {
    // Ajout des pièces jointes annulée, affichage durant 2s avant d'effacer la barre de progression
    oDiv.innerHTML = _gt("Ajout des pièces jointes annulé.");
    oStyle.backgroundPosition = "0px 0px";
    window.setTimeout("alkHtmlUnzipEndProgress()", 2000);
    return;
  } else if( iStatus == 0 ) {
    // erreur détectée, affichage de l'erreur durant 2s avant d'effacer la barre de progression
    oDiv.innerHTML = tabUpdate[1];
    oStyle.backgroundPosition = "0px 0px";
    window.setTimeout("alkHtmlUnzipHideProgress()", 2000);
    return;
  } else if( iStatus == 2 ) {
    // info non reçue, on réitère la progression
    oDiv.innerHTML = _gt("Ajout des pièces jointes en cours...");
    window.setTimeout("alkHtmlAddPJInfo()", 1000);
    return;
  } else {
    nbFilesAdded = tabUpdate[1];
    nbFileTotal = tabUpdate[2];
  }

  if( nbFilesAdded == 0 && nbFileTotal == 0 ) {
    // transfert non démarré, réitère la progression
    window.setTimeout("alkHtmlAddPJInfo()", 1000);
    return;
  } 
  if( nbFilesAdded == nbFileTotal ) {
    // fin d'ajout des pièces jointes, appelle la phase finale
    oDiv.innerHTML = _gt("Traitement serveur...");
    oStyle.backgroundPosition = oStyle.width+" 0px"; 
    alkHtmlAddPJEndProgress();
    return;
  }

  var d = new Date();

  var progressPercent = ( nbFileTotal>0 ? Math.ceil((nbFilesAdded/nbFileTotal)*100) : 0 );

  oDiv.innerHTML =
    ( progressPercent > 0
      ? _gtf("Ajout des pièces jointes en cours... %s%", progressPercent)
      : _gt("Ajout des pièces jointes en cours...") );

  var iWidth = parseInt(oStyle.width);
  oStyle.backgroundPosition = Math.round(iWidth*progressPercent/100)+"px 0px"; 
  
  // décompression en cours, réitère la progression
  window.setTimeout("alkHtmlAddPJInfo()", 1000);
}

function alkHtmlUnzipEndProgress()
{
  alkHtmlUnzipStartTime = 0;
  // la décompression est terminée, lancement de la phase d'ajout des pièces jointes
  OpenFooterExec(ALK_ALKANET_ROOT_URL+ALK_ROOT_MODULE+"alkanet/alkanet_addpj.php?token="+alkHtmlUnzipTabInfo["strTokenAddPJ"]);
  alkHtmlAddPJStartProgress();
}
function alkHtmlAddPJEndProgress()
{
  // l'ajout des pièces jointes est terminé, lancement de la phase finale
  alkHtmlUnzipHideProgress();
}

function alkHtmlUnzipHideProgress()
{
  // enregistrement terminé, cache la barre de progression
  var oDiv = document.getElementById(alkHtmlUnzipTabInfo["divProgressBar"]);
  if( !oDiv ) return;
  var oStyle = ( oDiv.style ? oDiv.style : oDiv ); 
  oDiv.innerHTML = _gt("Terminé.");
  oStyle.display = "none";
  alkHtmlAddPJStartTime = 0;
  
  var oCtrlFile = document.getElementById(alkHtmlUnzipTabInfo["strCtrlFileId"]);
  if ( oCtrlFile ) {
    oCtrlFileStyle = ( oCtrlFile.style ? oCtrlFile.style : oCtrlFile );
    oCtrlFileStyle.display = "";
  }
  
  AlkUploadSuccessByUrl(ALK_ALKANET_PROCESS+"?iMode=7&token="+alkHtmlUnzipTabInfo["strTokenRefreshList"]);
}

function OpenFileManager(strToken, champ_pj, formName, tokenCopy)
{
	OpenWindow(strToken+"&champ_pj="+champ_pj+"&formName="+formName+"&tokenCopy="+tokenCopy, "580", "1000", "windViewer");
}

/**
 * fonction utilisée par le filemanager pour la recopie des fichiers sur le serveur
 */
function CopyPjFromServer(strFileName, oCtrFile, strFormName, strTokenCopy){
  var f = document.forms[strFormName];
  if( !f ) return;

  var nbMaxPj = f.elements["nbMaxPj_"+oCtrFile];
  var nbPJ = f.elements["nbPJ_"+oCtrFile];
  if ( nbMaxPj && nbPJ && nbMaxPj.value==nbPJ.value ) {
    alkAlert(_gtf("Nombre maximal de fichiers acceptés atteint.%sUtiliser la suppression pour substituer un fichier.", "\n"));
    return;
  }
   
  var oAjax = new AlkAjax('CopyPjFromServer', 'AlkUploadSuccess', ALK_FORM_METHOD_POST, 
                          ALK_ALKANET_PROCESS+'?iMode=14&token='+strTokenCopy+"&strPath="+strFileName, strFormName);
  
}

/**
 * surcharge de AlkAlertMsg pour afficher le bloc de métadonnées des pièces-jointes du champ fautif
 */
var AlkAlertMsgOld = AlkAlertMsg;
var AlkAlertMsg = function (oCtrl, strMsg) {
  var pattern = new RegExp(/^(pj)_.*_(\d*)$/);
  matches = oCtrl.id.match(pattern);
  if ( matches != null && matches.length == 3 ) {
    var bloc = document.getElementById('div_'+matches[1]+'_details_'+matches[2]);
    if ( bloc ) {
      var style = ( bloc.style ? bloc.style : bloc );
      style.display = '';
    }
  }
  return AlkAlertMsgOld(oCtrl, strMsg);
}