/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Class::Form
Module fournissant les classes d'affichage Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

var MWJ_slider_controls = 0;

function getRefToDivNest( divID, oDoc ) {
  //get a reference to the slider control, even through nested layers
  if( !oDoc ) { oDoc = document; }
  if( document.layers ) {
    if( oDoc.layers[divID] ) { return oDoc.layers[divID]; } else {
      for( var x = 0, y; !y && x < oDoc.layers.length; x++ ) {
        y = getRefToDivNest(divID, oDoc.layers[x].document); }
      return y; } }
  if( document.getElementById ) { return document.getElementById(divID); }
  if( document.all ) { return document.all[divID]; }
  return document[divID];
}

function sliderMousePos(e) {
  //get the position of the mouse
  if( !e ) { e = window.event; } if( !e || ( typeof( e.pageX ) != 'number' && typeof( e.clientX ) != 'number' ) ) { return [0, 0]; }
  if( typeof( e.pageX ) == 'number' ) { var xcoord = e.pageX; var ycoord = e.pageY; } else {
    var xcoord = e.clientX; var ycoord = e.clientY;
    if( !( ( window.navigator.userAgent.indexOf( 'Opera' ) + 1 ) || ( window.ScriptEngine && ScriptEngine().indexOf( 'InScript' ) + 1 ) || window.navigator.vendor == 'KDE' ) ) {
      if( document.documentElement && ( document.documentElement.scrollTop || document.documentElement.scrollLeft ) ) {
        xcoord += document.documentElement.scrollLeft; ycoord += document.documentElement.scrollTop;
      } else if( document.body && ( document.body.scrollTop || document.body.scrollLeft ) ) {
        xcoord += document.body.scrollLeft; ycoord += document.body.scrollTop; } } }
  return [xcoord, ycoord];
}

function slideIsDown(e) {
  //make note of starting positions and detect mouse movements
  window.msStartCoord = sliderMousePos(e); window.lyStartCoord = this.style?[parseInt(this.style.left.replace("px", "")), parseInt(this.style.top.replace("px", ""))]:[parseInt(this.left.replace("px", "")), parseInt(this.top.replace("px", ""))];
  if( document.captureEvents && Event.MOUSEMOVE ) { document.captureEvents(Event.MOUSEMOVE); document.captureEvents(Event.MOUSEUP); }
  window.storeMOUSEMOVE = document.onmousemove; window.storeMOUSEUP = document.onmouseup; window.storeLayer = this;
  document.onmousemove = slideIsMove; document.onmouseup = slideIsMove; return false;
}

function slideIsMove(e) {
  //move the slider to its newest position
  var msMvCo = sliderMousePos(e); if( !e ) { e = window.event ? window.event : ( new Object() ); }
  var theLayer = window.storeLayer.style ? window.storeLayer.style : window.storeLayer;
  if( window.storeLayer.hor ) {
    var theNewPos = window.lyStartCoord[0] + ( msMvCo[0] - window.msStartCoord[0] );
    if( theNewPos < 0 ) { theNewPos = 0; } 
    if( theNewPos > window.storeLayer.maxLength ) { theNewPos = window.storeLayer.maxLength; }
    theLayer.left = theNewPos+"px";
  } else {
    var theNewPos = window.lyStartCoord[1] + ( msMvCo[1] - window.msStartCoord[1] );
    if( theNewPos < 0 ) { theNewPos = 0; } if( theNewPos > window.storeLayer.maxLength ) { theNewPos = window.storeLayer.maxLength; }
    theLayer.top = theNewPos+"px";
  }
  //run the user's functions and reset the mouse monitoring as before
  if( e.type && e.type.toLowerCase() == 'mousemove' ) {
    if( window.storeLayer.moveFunc ) { window.storeLayer.moveFunc(this, theNewPos/window.storeLayer.maxLength); }
  } else {
    if( document.releaseEvents && Event.MOUSEMOVE ) { document.releaseEvents(Event.MOUSEMOVE); document.releaseEvents(Event.MOUSEUP); }
    document.onmousemove = storeMOUSEMOVE; document.onmouseup = window.storeMOUSEUP;
    if( window.storeLayer.stopFunc ) { window.storeLayer.stopFunc(window.storeLayer, theNewPos/window.storeLayer.maxLength); }
  }
}

function setSliderPosition(oPortion) {
  //set the slider's position
  if( isNaN( oPortion ) || oPortion < 0 ) { oPortion = 0; } if( oPortion > 1 ) { oPortion = 1; }
  var theDiv = getRefToDivNest(this.id); if( theDiv.style ) { theDiv = theDiv.style; }
  oPortion = Math.round( oPortion * this.maxLength );
  if( this.align ) { theDiv.left = oPortion+"px"; } else { theDiv.top = oPortion+"px"; }
}



function slider(idContainer, oThght, oTwdth, oTcol, oTBthk, oTBcol, oTRthk, oTRcol, oBhght, oBwdth, oBcol, oBthk, oBtxt, oAlgn, oMf, oSf) {
  //draw the slider using huge amounts of nested layers (makes the borders look normal in as many browsers as possible)
  var strHtml = "";
  if( document.layers ) {
    strHtml += 
      '<ilayer left="0" top="0" height="'+(oThght+(2*oTBthk))+'" width="'+(oTwdth+(2*oTBthk))+'" bgcolor="'+oTBcol+'">'+
      '<ilayer left="'+oTBthk+'" top="'+oTBthk+'" height="'+oThght+'" width="'+oTwdth+'" bgcolor="'+oTcol+'">'+
      '<layer left="'+(oAlgn?0:Math.floor((oTwdth-oTRthk)/2))+'" top="'+(oAlgn?Math.floor((oThght-oTRthk)/2):0)+'" height="'+(oAlgn?oTRthk:oThght)+'" width="'+(oAlgn?oTwdth:oTRthk)+'" bgcolor="'+oTRcol+'"></layer>'+
      '<layer left="'+(oAlgn?0:Math.floor((oTwdth-(oBwdth+(2*oBthk)))/2))+'" top="'+(oAlgn?Math.floor((oThght-(oBhght+(2*oBthk)))/2):0)+'" height="'+(oBhght+(2*oBthk))+'" width="'+(oBwdth+(2*oBthk))+'" bgcolor="#000000" onmouseover="this.captureEvents(Event.MOUSEDOWN);this.hor='+oAlgn+';this.maxLength='+((oAlgn?oTwdth:oThght)-((oAlgn?oBwdth:oBhght)+(2*oBthk)))+';this.moveFunc='+oMf+';this.stopFunc='+oSf+';this.onmousedown=slideIsDown;" name="MWJ_slider_controls'+MWJ_slider_controls+'">'+
      '<layer left="0" top="0" height="'+(oBhght+oBthk)+'" width="'+(oBwdth+oBthk)+'" bgcolor="#ffffff"></layer>'+
      '<layer left="'+oBthk+'" top="'+oBthk+'" height="'+oBhght+'" width="'+oBwdth+'" bgcolor="'+oBcol+'">'+
      oBtxt+'</layer></layer></ilayer></ilayer>'
    ;
  } else {
    strHtml += 
      '<div style="position:relative;left:0px;top:0px;height:'+(oThght+(2*oTBthk))+'px;width:'+(oTwdth+(2*oTBthk))+'px;background-color:'+oTBcol+';font-size:0px;">'+
      '<div style="float:left;position:relative;left:'+oTBthk+'px;top:'+oTBthk+'px;height:'+oThght+'px;width:'+oTwdth+'px;background-color:'+oTcol+';font-size:0px;">'+
      '<div style="position:absolute;left:'+(oAlgn?0:Math.floor((oTwdth-oTRthk)/2))+'px;top:'+(oAlgn?Math.floor((oThght-oTRthk)/2):0)+'px;height:'+(oAlgn?oTRthk:oThght)+'px;width:'+(oAlgn?oTwdth:oTRthk)+'px;background-color:'+oTRcol+';font-size:0px;"></div>'+
      '<div style="position:absolute;left:'+(oAlgn?0:Math.floor((oTwdth-(oBwdth+(2*oBthk)))/2))+'px;top:'+(oAlgn?Math.floor((oThght-(oBhght+(2*oBthk)))/2):0)+'px;height:'+(oBhght+(2*oBthk))+'px;width:'+(oBwdth+(2*oBthk))+'px;font-size:0px;"' +
      ' ondragstart="return false;" onselectstart="return false;"' +
      ' onmouseover="this.hor='+oAlgn+';this.maxLength='+((oAlgn?oTwdth:oThght)-((oAlgn?oBwdth:oBhght)+(2*oBthk)))+';this.moveFunc='+oMf+';this.stopFunc='+oSf+';this.onmousedown=slideIsDown;"' +
      ' id="MWJ_slider_controls'+MWJ_slider_controls+'">'+
      '<div style="border-top:'+oBthk+'px solid #ffffff;border-left:'+oBthk+'px solid #ffffff;border-right:'+oBthk+'px solid #000000;border-bottom:'+oBthk+'px solid #000000;">'+
      '<div style="height:'+oBhght+'px;width:'+oBwdth+'px;font-size:0px;background-color:'+oBcol+';cursor:default;">'+
      '<span style="width:100%;text-align:center;">'+oBtxt+'</span></div></div></div></div></div>'
    ;
  }
  if ( document.getElementById && document.getElementById(idContainer) ){
    document.getElementById(idContainer).innerHTML = strHtml;
  }
  else {
    document.write(strHtml);
  }
  this.idContainer = idContainer;
  this.id = 'MWJ_slider_controls'+MWJ_slider_controls; 
  this.maxLength = (oAlgn?oTwdth:oThght)-((oAlgn?oBwdth:oBhght)+(2*oBthk));
  this.align = oAlgn; 
  this.setPosition = setSliderPosition; 
  MWJ_slider_controls++;
}


///////////////////////////////////////// Fonctions utilisateur ////////////////////////////////

var tabSliders = new Array() ;
function MoveSlider(objSlider, iPosition)
{
  StopSlider(objSlider, iPosition)
}

function StopSlider(objSlider, iPosition)
{
  var iDepart ;
  var iFin ;

  //on force la valeur à maximum 2 chiffres derrière la virgule
  for (var i=0; i<tabSliders.length; i++)
  {
    if (tabSliders[i][0] == objSlider.id)
    {
      var j = 1;
      idSlider        = tabSliders[i][j++];
      strFctIncrement = tabSliders[i][j++];
      iDepart         = tabSliders[i][j++];
      iFin            = tabSliders[i][j++];
      
      
      iValeur = eval(strFctIncrement+'(iPosition, iDepart, iFin)') ;
    
      if ( document.getElementById && document.getElementById(idSlider) ){
        var oCtrl = document.getElementById(idSlider);
        if ( oCtrl.tagName=="INPUT" || oCtrl.tagName=="SELECT" )
          oCtrl.value = iValeur;
        else
          oCtrl.innerHTML = iValeur;
      }
      break ;
    }
  }
}

function CreateSlider(idSlider, iDefaut, strFctIncrement, iDepart, iFin, iWidthTrack)
{
  var objSlider = new slider(
              "slider_"+idSlider,
              18,             //height of track (excluding border)
              parseInt(iWidthTrack),            //width of track (excluding border)
              '#E7E3E7',      //colour of track
              1,              //thickness of track border
              '#E7E3E7',      //colour of track border
              1,              //thickness of runner (in the middle of the track)
              '#000000',      //colour of runner
              14,             //height of button (excluding border)
              parseInt(iWidthTrack)/15,             //width of button (excluding border)
              '#ACA8AC',      //colour of button
              2,              //thickness of button border (shaded to give 3D effect)
              '',             //text of button (if any) - the font declaration is important - size it to suit your slider
              true,           //direction of travel (true = horizontal [0 is left], false = vertical [0 is top])
              'MoveSlider',   //the name of the function to execute as the slider moves (null if none)
              'StopSlider'    //the name of the function to execute when the slider stops (null if none)
                              //the functions must have already been defined (or use null for none)
  );
  objSlider.setPosition(parseInt(iDefaut/iFin)) ;
  
  tabSliders[tabSliders.length] = [objSlider.id, idSlider, strFctIncrement, iDepart, iFin] ;
  return objSlider;
}

function numericIncrementSlider(iPosition, iDepart, iFin)
{
  var iValeur = 0;
  iValeur = (parseInt(iPosition*100)/100) ;
  iValeur = Math.ceil(parseFloat(iDepart) + parseFloat(iValeur*(iFin-iDepart))) ;
  return iValeur;
}
