<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Class::Form
Module fournissant les classes d'affichage Alkanet pour les site internet
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlpage.class.php");

/**
 * @package Alkanet_Class_Form
 * @class AlkHtmlPageSite
 * 
 * Classe représentant la page html affichée spécifique au site internet
 */
abstract class AlkHtmlPageSite extends AlkHtmlPage
{

  /**
   *  Constructeur par défaut
   * @param oSpace Référence 
   * @param oAppli Référence 
   */
  public function __construct(&$oSpace, &$oAppli)
  {
    parent::__construct($oSpace, $oAppli);
    
    // cas de l'impression pdf
    $this->bPrint = AlkRequest::_REQUESTint("bprint", 0);
    
    $cont_id    = AlkRequest::getToken("cont_id",    "-1");
    $user_id = AlkFactory::getSProperty("user_id", ALK_USER_ID_INTERNET); 
    
    $this->setEncoding(ALK_HTML_ENCODING);
    
    // chargement de la librairie jQuery ici pour pouvoir utiliser l'objet jQuery dans les fichiers js qui suivent + surchage CSS
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."jquery/jquery-1.6.4.min.js", "", true);
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."jquery/jquery-ui-1.8.16.custom.min.js", "", true);
    $this->addScriptCss(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."jquery/jquery-ui-1.8.16.custom.alkmin.css");
    if( defined("ALK_LG_JSON") ) {
      $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."jquery/jquery.ui.datepicker-".ALK_LG_LOCALE.".js");
      $this->addScriptJs(ALK_LG_JSON);
    } else {
      $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."jquery/jquery.ui.datepicker-fr_FR.js");
    }
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_js.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_js.php", "", true);
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_js_jquery.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_jsaddon.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_ajax.js");
    
    // chargement des js et css dans la méthode getHtmlHeader() ci-dessous
    
    self::$tabOnload=array();
    
    $oQueryGEdit = AlkFactory::getQuery(ALK_ATYPE_ID_GEDIT);
    $strUrlMobile = $oQueryGEdit->getHomeUrl($cont_id, -1, false, ALK_LG_BDD, true);
    if ( stristr($_SERVER['REQUEST_URI'], "/".$strUrlMobile)!==false) {
      $GLOBALS["bMobile"] = true;
      //$this->addScriptCss("mobile.css", "screen");
      //$this->addLink("apple-touch-icon", ALK_MEDIA_PATH."site/gen/maia_iphone.png");
      //self::$tabSrcJs=array();   
    } else {
      $GLOBALS["bMobile"] = false;   
    }
    
    $iTypeSheet = AlkRequest::getToken("iTypeSheet", ALK_TYPESHEET_CONSULT);
    $strPopup = ( $iTypeSheet == ALK_TYPESHEET_POPUP ? "_popup" : "" );
    if( $iTypeSheet == ALK_TYPESHEET_POPUP ) {
      $strPopup = "_popup";
      $this->addClassCss("body", "background-color:#ffffff;");
    } else {
      $strPopup = "";
    }
    
    if( !defined("ALK_INTERFACE_TYPE") ) {
      define("ALK_INTERFACE_TYPE", "internet");
    }
    
    $GLOBALS["oHtmlPage"]=$this;
        
    // Traitements sur les chargements des templates    
    $this->oTemplate =& AlkFactory::getTemplate();
    // utilisation du template par défaut
    $this->strTemplateFile = ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."alkanet/templates/alkhtmlpage".ALK_INTERFACE_TYPE.$strPopup.".tpl";
    $strNewTemplateFile = ALK_ALKANET_ROOT_PATH.ALK_ROOT_CONF."alkhtmlpage".ALK_INTERFACE_TYPE.$strPopup.".tpl";
    if( file_exists($strNewTemplateFile) && is_file($strNewTemplateFile)) {
      // utilisation du template spécifique
      $this->strTemplateFile = $strNewTemplateFile;
    }
  }

  public function getTabMeteo($ville_code, $ville_nom="")
  {
    setlocale(LC_TIME, "fr_FR"); // ou "fr"

    $tabMeteo = array();
    
    // ex. $ville_code = "FRXX0048"; $ville_nom = "Le Mans";
    $jours = 1;
    $url = "http://xoap.weather.com/weather/local/".$ville_code."?cc=*&unit=cc&dayf=".$jours;
    
    $strXml = file_get_contents($url);
    $strXml = ereg_replace("<!DOCTYPE[^>]*>", "", $strXml);
    $strXml = str_replace("&apos;", "'", $strXml);
    
    $oXml = simplexml_load_string($strXml);
    
    //var_dump($oXml->cc);
    
    $tabMeteo["ville"] = $oXml->cc->obst;
    $tabMeteo["date"] = date("d/m/y");//$oXml->cc->lsup;
    $tabMeteo["temp"] = $oXml->cc->t;
    $tabMeteo["temperature"] = round(($oXml->cc->tmp-32)*5/9);
    $tabMeteo["icone"] = "http://image.weather.com/web/common/wxicons/31/".$oXml->cc->icon.".gif?12122006";
    
    return($tabMeteo);
  }
  
    /**
   * @brief Retourne le code html du contenu de la page
   * @return string
   */
  protected function initBody()
  {
    $iTypeSheet = ALK_TYPESHEET_CONSULT;
    $iSheet     = ALK_SHEET_NONE;
    $iSSheet    = ALK_SHEET_NONE;
    $this->oAppli->getCurrentSheet($iTypeSheet, $iSheet, $iSSheet);
    
    $cont_id    = AlkRequest::getToken("cont_id",    "-1");
    $appli_id   = AlkRequest::getToken("appli_id",   "-1");
    $typeappli_id = AlkRequest::getToken("typeappli_id","-1");
    
    $user_id = AlkFactory::getSProperty("user_id", ALK_USER_ID_INTERNET); 
    
    $bPopup = ( $iTypeSheet == ALK_TYPESHEET_POPUP );
    if( !is_null($this->oAppli) ) {
      $this->oAppli->setTabSheets();
      $this->oAppli->getCurrentSheet($iTypeSheet, $iSheet, $iSSheet);
      $oSheetSelect = new AlkHtmlPanel("global");//$this->setPageSheets(false, "global");
      $this->addPanel($oSheetSelect);
      if( !is_null($oSheetSelect) ) {
        $oAppliPanel = $this->oAppli->getPanel();
        if ( is_null($oAppliPanel) ) return;
        $oSheetSelect->addPanel($oAppliPanel);
        if( $bPopup ) {
          $this->oTemplate->assign("mainTitle", $oAppliPanel->getTitle());
          if( $typeappli_id == ALK_B_ATYPE_EDITEUR ) {
            $this->oTemplate->assign("stylePopupContents", "margin:0px; padding:0px; width:100%;");
          }
          $oAppliPanel->setTitle("");
          $oAppliPanel->setLabel("");
        }
      }
    }

    if( $bPopup ) {
      $tokenClose = AlkRequest::getToken("tokenClose",   "");
      $popupCanClose = AlkRequest::getToken("popupCanClose",   "1");
      $popupAddTitle = AlkRequest::getToken("popupAddTitle",   "1");
      $this->oTemplate->assign("tokenClose", $tokenClose);  
      $this->oTemplate->assign("popupCanClose", $popupCanClose);  
      $this->oTemplate->assign("popupAddTitle", $popupAddTitle);  
    }

    $this->oTemplate->assign_by_ref("oSpace", $this->oSpace);
    
    /** assignation des contantes */
    $this->oTemplate->assign("alkAlkanetRootUrl", ALK_ALKANET_ROOT_URL);
    $this->oTemplate->assign("alkAlkanetRootPath", ALK_ALKANET_ROOT_PATH);
    $this->oTemplate->assign('alkRootTemplate', ALK_ROOT_TEMPLATE);
    $this->oTemplate->assign("user_id", AlkFactory::getSProperty("user_id"));
    $this->oTemplate->assign("user_name", AlkFactory::getSProperty("user_name"));
    $this->oTemplate->assign("user_mail", AlkFactory::getSProperty("user_mail"));
    
    $strLg = ALK_LG_REP;
    $strDbLg = ALK_LG_BDD;
    
    $tabAppliRss = $this->getTabIeditRss($strLg, $strDbLg);
    $this->oTemplate->assign("tabAppliRss", $tabAppliRss);
  }
  
  /**
   *  Retourne le code html de l'entete html
   * @return string
   */
  protected function getHtmlHeader()
  {
    // assignation des cas particuliers de css
    // assignation des cas particuliers de scripts js
      
    
    /* A ne charger que si nécessaire
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_formcheck.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_formdate.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_formnumber.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_formselect.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_form.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_formtxt.js");*/
    
    $this->addVarJs("ALK_APPLI_TOKEN", "'".AlkRequest::getEncodeParam("cont_id=".$this->oAppli->cont_id."&appli_id=".$this->oAppli->appli_id)."'");
    $this->addVarJs("ALK_CONT_ID", "'".$this->oAppli->cont_id."'");
    $this->addVarJs("ALK_APPLI_ID", "'".$this->oAppli->appli_id."'");
    if( $GLOBALS["bMobile"]==true ) { 
      $this->addMeta("viewport", "width=device-width; initial-scale=1.0; maximum-scale=1.0; user-scalable:no;");
      //$this->addMeta("viewport", "width=device-width, initial-scale=1.0");
      //self::$tabSrcJs=array();
    }
    
    if( isset($this->oTemplate->_tpl_vars["strPageTitreNav"]) ) {
      $tabDataUrl = getDataRewriteUrl($_SERVER["REQUEST_URI"]);
      $idData = (isset($tabDataUrl["data_id"]) && $tabDataUrl["data_id"] != "" ? $tabDataUrl["data_id"] : "" );
      $strCompleteTitle = "";
      if($idData != ""){
        foreach($this->oTemplate->_tpl_vars["tabBlocsPage"] as $bloc){
          if($bloc["bloc_id"] ==-1 && isset($bloc["tabContents"][0]) && isset($bloc["tabContents"][0]["data_id"]) && $bloc["tabContents"][0]["data_id"] == $idData){
            $strCompleteTitle = " - ".$bloc["tabContents"][0]["data_title"];
          }
        }
      }
      
      $this->setTitle($this->oSpace->getAppliProperty("CONT_INTITULE").
        ($this->oTemplate->_tpl_vars["strPageTitreNav"]!="" ? " - ".$this->oTemplate->_tpl_vars["strPageTitreNav"]: "").
        ($strCompleteTitle)
      );
    }
    
    if (isset($this->oTemplate->_tpl_vars["strPageDesc"])) {
      $this->addMeta("description", ($this->oTemplate->_tpl_vars["strPageDesc"]!="" ? $this->oTemplate->_tpl_vars["strPageDesc"] : ALK_APP_TITLE));
    }
    if (isset($this->oTemplate->_tpl_vars["strPageMotsCles"])) {
      $this->addMeta("keywords", ($this->oTemplate->_tpl_vars["strPageMotsCles"]!="" ? $this->oTemplate->_tpl_vars["strPageMotsCles"] : ALK_APP_TITLE));
    }
    
    $strLg = ALK_LG_REP;
    $strDbLg = ALK_LG_BDD;
    
    if ($GLOBALS["bMobile"]==false) {
    
      $tabAppliRss = $this->getTabIeditRss($strLg, $strDbLg);
     
      foreach ($tabAppliRss as $item) {
        $this->addLink("alternate", $item["url_rss"], "application/rss+xml", $item["appli_name"]);
      }
    }
    
    return parent::getHtmlHeader();
  }
  
  /**
   *  Retourne le code html du pied de page html
   * @return string
   */
  protected function getHtmlFooter()
  {
    return parent::getHtmlFooter();
  }
  
  
  /**
   *  Retourne le code html pour l'impression pdf si bPrint
   * @return string
   */
  public function getHtml()
  {
    
    if($this->bPrint){

      /**
      TODO
      $this->strPathDest
      $page_title
      */  
  
      $this->strPathDest = ALK_ALKANET_ROOT_PATH."/upload/cache/";
  
      //define("ALK_CMD_PHP", "/usr/bin/php");
      //define("ALK_CMD_WKHTMLTOPDF", "wkhtmltopdf");
      
      $strHtml = parent::getHtml();
             
      $strHtml = preg_replace("!(<a)([^>]+)(>)!ie", "'\\1'.stripslashes(str_replace('&', '&amp;', '\\2')).'\\3'", $strHtml);
      $strHtml = preg_replace("!(<img)([^>]+)(>)!ie", "'\\1'.stripslashes(str_replace('&', '&amp;', '\\2')).'\\3'", $strHtml);

      $strHtml = str_replace("src=\"/upload", "src=\"".ALK_ROOT_URL."/upload", $strHtml);

      //traitement des cartes interactives
      $strHtml = str_replace(ALK_ROOT_URL, ALK_ROOT_PDF_URL, $strHtml);

      $tabMaps = array();
      preg_match_all("!layer(\d+)\s*=.*?\"([^\"]+\?map=[^\"]+)\"!usim", $strHtml, $tabMaps, PREG_SET_ORDER);

      foreach ($tabMaps as $tabMapDesc){
        $map_id = $tabMapDesc[1];
        $map_url = $tabMapDesc[2]."&layers=all&mode=map&map_imagetype=png";
        $strHtml = preg_replace("!(<div id=[\"']carte".$map_id."[\"'][^>]+?width:(\d+)px;height:(\d+)px[^>]+?>)!usim", "$1<img src='".$map_url."&map_size=$2+$3'/>", $strHtml);
      }

      //return $strHtml;
      
      $page_title = AlkRequest::getToken("page_title", AlkRequest::_REQUEST("page_title", ALK_APP_TITLE));
      if ( $page_title=="" ){
        $page_title = ALK_APP_TITLE;
      }
      $page_title_file = strtr(utf8_decode($page_title), utf8_decode("éèêëàäâïîöôüûù"), "eeeeaaaiioouuu");
      $page_title_file = preg_replace("!\W!ui", "_", $page_title_file);
      
      $fileName = "alkanet_".session_id()."_".$page_title_file.".html";
      file_put_contents($this->strPathDest.$fileName, $strHtml);
      
      $strUrlSrc = str_replace(ALK_ROOT_PATH, ALK_ROOT_URL, $this->strPathDest).$fileName;

      $oPdf = AlkFactory::getHtml2Pdf($strUrlSrc, $strPathSrc="", $strFilerSrc="", $strHtml="",
                                        $this->strPathDest, $page_title_file, true, false);
      $oPdf->setSendSerializedMode(false);
      $oPdf->setExecuteByPHPCli(true);
      $oPdf->setModeOutput(AlkRequest::_GET("output", "BROWSERATTACHMENT"));
      $oPdf->requestParam();
      $oPdf->setParam("pixels", "800");

      echo nl2br($oPdf->getPdf());
      
    }else{
    
    
     return parent::getHtml();
    }
  }

  /**
   * Retourne l'aide de la page en cours de consultation
   */
  public function getHelp()
  {
    $strHtmlHelp = "";
    if( !is_null($this->oAppli) ) {
      $iTypeSheet = ALK_TYPESHEET_CONSULT;
      $iSheet     = ALK_SHEET_NONE;
      $iSSheet    = ALK_SHEET_NONE;
      $this->oAppli->getCurrentSheet($iTypeSheet, $iSheet, $iSSheet);
      $oPanel = $this->oAppli->getPanel();
      if( !is_null($oPanel) ) {
        $strHtmlHelp = $oPanel->getHelp();
      } else {
        $strHtmlHelp = "Aucune aide disponible pour cette page.";
      }
    } else {
      $strHtmlHelp = "Aucune aide disponible pour cette page.";
    }
    return $strHtmlHelp;
  }
  
  /**
   * Retourne le menu de la partie "en un clic"
   */
  public function getTabIeditRss($strLg=ALK_LG_REP, $strDbLg=ALK_LG_BDD)
  {
    $oAppliIedit  = AlkFactory :: getAppli(ALK_ATYPE_ID_IEDIT);
    $oQueryIedit  = AlkFactory :: getQuery(ALK_ATYPE_ID_IEDIT);
    $oQueryEspace = AlkFactory::getQuery(ALK_ATYPE_ID_ESPACE);
    
    $tabAppliRss   = array();
    
    $dsAppli      = $oQueryEspace->getDs_listeAppliByEspaceType($this->oAppli->cont_id, ALK_ATYPE_ID_IEDIT);
    $i            = 0;
            
    while ( $drAppli = $dsAppli->getRowIter() ) {
      $oAppliIedit->appli_id = $drAppli->getValueName("APPLI_ID");
      $strTokenPub = $oAppliIedit->getToken(ALK_TYPESHEET_CONSULT, ALK_SHEET_RSS, ALK_SHEET_NONE, "&datatype_id=".ALK_ATYPE_ID_ACTU."&data_id=-2&pub=1");
      //$strUrlRssPub   = ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."alkanet/".ALK_ALKANET_RSS."?token=".$strTokenPub;
      $strUrlRssPub   = ALK_ALKANET_RSS."?token=".$strTokenPub;
  
      $tabAppliRss[$i]["appli_id"]      = $drAppli->getValueName("APPLI_ID");
      $tabAppliRss[$i]["appli_name"]    = $drAppli->getValueName("APPLI_INTITULE");
      $tabAppliRss[$i]["url_rss"]       = $strUrlRssPub;
      $i++;
    }
     
    return $tabAppliRss;
  }
  
}

?>