<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Class::Form
Module fournissant les classes d'affichage Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlctrl.class.php");

/**
 * @package Alkanet_Class_Form
 * @class AlkHtmlHidden
 * 
 * Classe d'affichage d'un composant de saisie caché.
 *        génère : <input type=hidden>
 */
class AlkHtmlHidden extends AlkHtmlCtrl
{
  /** Ensemble des valeurs cachées d'un formulaire html */
  protected $tabKeyValue;
  

  /**
   *  Constructeur par défaut
   * @param oForm    référence sur l'objet formulaire
   * @param strName  Nom du controle de saisie
   * @param strValue Valeur par défaut du controle de saisie
   */
  public function __construct($oForm, $name, $value="")
  {
    parent::__construct($oForm, 0, $name, $value, "");
    $this->bHidden = true;
    $this->tabKeyValue = array();
    $this->addHidden($name, $value);
  }

  /**
   *  Ajoute dans la liste, un couple (Variable, valeur)
   *
   * @param name  Nom du controle de saisie
   * @param value Valeur par défaut du controle de saisie
   */
  public function addHidden($name, $value="")
  {
    $this->tabKeyValue[$name] = $value;
  }

  /**
   *  Ajoute dans la liste, un couple (Variable, valeur) à partir d'un objet AlkFormData
   *
   * @param oFormData AlkFormData   Descripteur du hidden à ajouter
   */
  public function addDataHidden(AlkFormData $oFormData)
  {
    $this->addHidden($oFormData->name, $oFormData->value);
  }

  /**
   *  Ajoute un événement dans la liste
   * 
   * @param strNom        Nom du champ sur lequel porte l'événement
   * @param strEvent      Nom de l'événement
   * @param strFunctionJS Nom de la fonction javascript appelée (pas nécessaire d'ajouter 'javascript:')
   */
  public function addEventOnHidden($strName, $strEvent, $strFunctionJS)
  {
    $_strEvents = mb_strtolower($strEvent);
    if ( !array_key_exists($strName, $this->tabEvents) ){
      $this->tabEvents[$strName] = array();
    }
    if ( array_key_exists($_strEvents, $this->tabEvents) ){
      $this->tabEvents[$strName][$_strEvents] .= $strFunctionJS;
    } else {
      $this->tabEvents[$strName][$_strEvents] = $strFunctionJS;
    }
  }

  /**
   *  Genere puis retourne tous les evenements liés au controle html
   *
   * @param strNom        Nom du champ sur lequel porte l'événement
   * @return Retourne les événements concaténés dans une chaine pour être inclus dans
   *         dans un tag html de type controle de saisie
   */
  protected function getHtmlEvent($strName="")
  {
    if ( !array_key_exists($strName, $this->tabEvents) )
      return "";
      
    $strHtml = "";
    foreach($this->tabEvents[$strName] as $strEvent => $strFunctionJs)
      $strHtml .= " ".$strEvent."=\"javascript:".$strFunctionJs."\"";
      
    return $strHtml;
  }
  
  /**
   *  Génère puis retourne le code html associé au controle de saisie
   */
  protected function getCtrlHtml($key=0, $tabLg=array())
  {
    $strHtml = "";
    foreach($this->tabKeyValue as $strName => $strValue) {
      $strValue = htmlspecialchars($strValue);
      $strGuid = $this->getGUIDForName($strName);
      $strHtml .= "<input type=\"hidden\" id=\"".$strGuid."\" name=\"".$strName."\" value=\"".$strValue."\"".$this->getHtmlEvent($strName)."/>";
    }
    return $strHtml;
  }
  
  /**
   *  indique si le controle est un controle de type hidden
   * @return boolean  
   */
  public function isHidden()
  {
    return true; 
  } 
  
  /**
   *  Affecte la propriété bHidden : le code généré sera celui d'un hidden
   * 
   * @param bHidden    =true si champ hidden, =false sinon
   */
  public function setHidden($bHidden)
  {
    //Toujours hidden
  }
}

?>