<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Class::Form
Module fournissant les classes d'affichage Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

if (!defined("ALK_DATE_DAYS")) define("ALK_DATE_DAYS",   1);
if (!defined("ALK_DATE_WEEKS")) define("ALK_DATE_WEEKS",  2);
if (!defined("ALK_DATE_MONTHS")) define("ALK_DATE_MONTHS", 3);

/**
 * @package Alkanet_Class_Form
 * @class AlkHtmlDate
 * 
 * Classe représentant un control de saisie date
 */
class AlkHtmlDate extends AlkHtmlText
{
  protected static $bCssCalendarWrite = false;
  protected $bJsCalendarWrite = false;
  
  protected $defaultValue;
  protected $oCtrlDay;
  protected $oCtrlMonth;
  protected $oCtrlYear;
  protected $date_min;
  protected $date_max;
  protected $urlBaseImg;
  protected $bWithCalendar;
  protected $bWithCtrl;
  protected $bWithIcon;
  protected $bSaveInHide;
  protected $language;
  protected $languageSave;
  protected $iModeCal;
  protected $bCloseOnChoose;
  protected $bWithLabel;
  

  /**
   *  Constructeur par défaut
   *
   * @param iMode     Mode du controle de saisie : =0 modif, =1 lecture
   * @param name      Nom du controle de saisie
   * @param value     Valeur par défaut du controle de saisie
   * @param label     Etiquette texte associée au controle de saisie
   * @param separator caractère séparateur entre jour mois et année ( / par défaut)
   */
  public function __construct($oForm, $iMode, $name, $value="jj/mm/aaaa", $label="", $date_min="", $date_max="")
  {
    parent::__construct($oForm, $iMode, $name, $value, $label, 1, 10, 10);
    
    $this->language = "fr";
    $this->languageSave = "fr";
    $this->defaultValue = $value;
    $this->date_min = $date_min;
    if ($this->date_min==""){
      $this->date_min = (defined("ALK_DEFAULT_DATEMIN") ? ALK_DEFAULT_DATEMIN : date("d/m/Y", AlkFactory::getLocalDate()));
    }
    $this->date_max = $date_max;
    if ($this->date_max==""){
      $this->date_max = (defined("ALK_DEFAULT_DATEMAX") ? ALK_DEFAULT_DATEMAX : $this->date_max);
    }
    if ($this->date_max=="-1"){
      $this->date_max = "";
    }
    
    $this->bWithLabel = false;
    $this->bCloseOnChoose = true;
    $this->bReadOnly = false;
    $this->bWithCalendar = true;
    $this->bWithCtrl = true;
    $this->bWithIcon = true;
    $this->iModeCal = ALK_DATE_DAYS;
    /*$oIcon = $this->addButtonIcon("link_".$this->guid, "javascript:OpenCalendar('".$this->guid."');",
                          "calendar",
                          "Open / close calendar");
    $oIcon->setProperty("alt", ($this->language=="fr" ? "Calendrier" : "Calendar"));*/
    $this->setDefaultCss("alkhtmldate.css");
    
  }
  
  
 protected function getCtrlHtml($key="0", $tabLg=array()){    
    $this->AddScriptJs($this->tabConstJs["CALENDAR"]); 
    $this->AddScriptJs($this->tabConstJs["DATE"]); 
     
    $strHtml = "";
    if ($this->language!=$this->languageSave){
      $value = $this->GetValueInLanguageSave();
      $oHide = AlkHtmlFactory::getNewHtmlHidden($this->oForm, "hide_".$this->name, $value);
    }
      
    $this->GetCalendarJsInit();
    if( $this->bWithCalendar && $this->iMode == 0 ) {
      $this->GetCalendarCss();      
    }
    
    if ($this->language!=$this->languageSave)
      $this->value = $this->GetValueInLanguageSave();
    $strHtml = parent::getCtrlHtml();
    return $strHtml;
  }
  /**
   *  Retourne le code html du controle de saisie date
   *
   * @return Retourne un string
   */
  public function getHtml()
  {    
    $this->AddScriptJs($this->tabConstJs["CALENDAR"]); 
    $this->AddScriptJs($this->tabConstJs["DATE"]); 
    
    $strHtml = "";
    if ($this->language!=$this->languageSave){
      $value = $this->GetValueInLanguageSave();
      $oHide = AlkHtmlFactory::getNewHtmlHidden($this->oForm, "hide_".$this->name, $value);
    }
      
    $this->GetCalendarJsInit();
    if( $this->bWithCalendar && $this->iMode == 0 ) {
      $this->GetCalendarCss();
      
    }
    
    
    if ($this->language!=$this->languageSave)
      $this->value = $this->GetValueInLanguageSave();
    $strHtml = parent::GetHtml();
    //$strHtml = str_replace(" name=\"", " id=\"input_".$this->name."\" name=\"".($this->language!=$this->languageSave ? "text_" : ""), $strHtml);
    return $strHtml;    
  }
  
  
  /**
   *  Retourne le code html et la fonction permettant de créer un calendrier ouvert
   *
   * @return Retourne un array = {"strCalHtml"=>strCalHtml, "strCtrlHtml"=>strCtrlHtml, "strJsFct"=>strJsFct}
   */
  public function getTabHtmlCalendar($align="")
  {
    $this->AddScriptJs($this->tabConstJs["CALENDAR"]); 
    $strCalHtml = "";
    $strCtrlHtml = "";
    $strJsFct = "";
    
    $this->GetCalendarCss();
    
    $strCalHtml = "<div id='".$this->guid."_allCalendarDiv' ".($align!="" ? "align='".$align."'" : "").
        " style='display:block;position:relative;float:left'>" .
         ( ALK_NAV==ALK_NAV_FIREFOX ? "top:16px;" : "" ).
        "'>" .
       ($this->bWithLabel ? "<span class='formLabel'>".$this->label."</span>" : "") .
        "<div id='".$this->guid."_calendarDiv' style='float:left'></div>" .
        "</div>";
    if ($this->bWithCtrl)
      $strCtrlHtml = str_replace(" name=", " id=\"input_".$this->guid."\" name=", parent::GetHtml());
    return array("strCalHtml"=>$strCalHtml, "strCtrlHtml"=>$strCtrlHtml);
  }
  
  /**
   *  Affecte l'attribut bWithIcon et change le label en lien si bWithIcon=false
   * 
   * @param bWithIcon Nouvelle valeur de l'attribut
   */
  public function setBWithIcon($bWithIcon)
  {
    $this->bWithIcon = $bWithIcon;
    if ($this->bWithIcon){
      if (isset($this->oldLabel))
        $this->label = $this->oldLabel;
             
      if (empty($this->tabHtmlLink)){
        $this->addLink("link_".$this->guid, "javascript:OpenCalendar('".$this->guid."');",
                       _t("Ouvrir / fermer le calendrier"),
                       "calendar.gif", "", $this->urlBaseImg);
      }
    }
    else {
      $this->oldLabel = $this->label;
      $oLink = new HtmlLink("javascript:OpenCalendar('".$this->guid."');", $this->label);
      $this->label = $oLink->GetHtml();
      $this->tabHtmlLink = array();
    }
  }

  /**
   *  Retourne le code Html d'écriture des CSS et d'inclusion du fichier calendrier.js du calendrier 
   * @return string html
   */
  public function GetCalendarJsInit()
  {          
    $this->addJs(" window.oParamCalendar['".$this->guid."'] = '".$this->guid."';");
    $this->bJsCalendarWrite = true; 
  }

  /**
   *  Retourne le code Html d'écriture des CSS et d'inclusion du fichier calendrier.js du calendrier 
   * @return string html
   */
  public function getCalendarCss()
  {
    $this->addDefaultCss(); 
  }
  
  /**
   *  Converti et retourne la date affichée dans le format de sauvegarde s'ils sont différents : 
   *        Format FR = jj/mm/aaaa ; Format EN = mm/jj/aaaa 
   */
  public function getValueInLanguageSave()
  {
    if ($this->iModeCal==ALK_DATE_DAYS && $this->language!=$this->languageSave){
      $tabDate = explode("/", $this->value);
      return $tabDate[1]."/".$tabDate[0]."/".$tabDate[2];
    }
    return $this->value;
  }
}
?>