/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Class::Form
Module fournissant les classes d'affichage Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

var ALK_PREFIXE_CKE = "cke_";

// anciennement ShowHideDiv
function HelpShowHideLayer(helpId, iNum, iWidth)
{
  helpId = "help_"+helpId;
  var oLayer = document.getElementById(helpId, "");
  oLayer.className = oLayer.className.replace("Open", "")+
                     ( oLayer.className.indexOf("Open")!=-1 ? "" : "Open");
  
  var oStyle = ( oLayer.style ? oLayer.style : oLayer);
  oStyle.width  = iWidth+"px";
}

/**
 * duplique le contenu du champ de la langue en cours dans les autres champs
 * Event onkeyup 
 */
function DuplicateFieldContent(champId, iKey, iModeML)
{
  if( iModeML == 2 ) return;
  eval(tabLang);
  strCurrentLg = (tabLang[iKey]!= null ? tabLang[iKey] :tabLang[0]);
  var strValue = document.getElementById(champId+strCurrentLg).value;
  for (var i=0; i<tabLang.length;i++){
  	var oDivField = document.getElementById(champId+tabLang[i]);
  	if (i != iKey){
  	   if (oDivField.className.indexOf(" idem", 0)!=-1)
    		oDivField.value = ( iModeML == 1 
    		                    ? strValue+tabLang[i]
    		                    : strValue );                    
	  }
  }
}

/**
 * vide le contenu d'un champ
 */
function FocusTexteField(oTexte)
{
  if (oTexte){
  	if (oTexte.className.indexOf(" idem", 0)!=-1)
  	  oTexte.value ="";
  }
}

/**
 * met à jour le champ
 * Event : onblur
 * Si le champ est vide, il est rempli par la valeur du champ de référence
 */
function fillField(champId, iKey, iCurrentKey, iModeML)
{
  if( iModeML == 2 ) return;
  eval(tabLang);
  strCurrentLg = (tabLang[iCurrentKey]!= null ? tabLang[iCurrentKey] :tabLang[0]);
  strLg = (tabLang[iKey]!= null ? tabLang[iKey] :tabLang[0]);
  
  var oFieldSrc = document.getElementById(champId+strCurrentLg);
  if( !oFieldSrc ) return;
  var strValue = oFieldSrc.value;
  var oField   = document.getElementById(champId+strLg);
  if( oField ) {
  	if( oField.value=="" ) {
      oField.value = ( iModeML == 1 
    		               ? strValue+strLg
    		               : strValue ); 
      oField.className = oField.className.replace(" idem", "") + " idem";
    } else {
    	// le champ n'est pas vide
    	if( oField.value != strValue ) {
    		oField.className = oField.className.replace(" idem", "");         
    	}
    }
  }
}

/**
 * affiche tous les div contenant les champs cachés des langues
 */
function LangShowHideLayer()
{
  var strField;
  var oLink;
  var tabDiv = new Array();
  var cpt = 0;
  
   eval(tabLang);
  
  if (arguments.length > 1){
    var strLinkId = arguments[0].replace("div", "link");
    var tabChampId = arguments[0].split("_");
	  var strLg = "_"+tabChampId[tabChampId.length*1 -1];
    strChampId = arguments[0].replace(strLg, "");
    var strLinkTemp = strLinkId.replace(strLg, "");

  	for (var i=0; i<tabLang.length;i++){
  		// on cache tous les champs
  		strField = document.getElementById(strChampId+tabLang[i]);
  		strField.style.display = "none";
  		// on annule tous les styles sélectionnés
  		oLink = document.getElementById(strLinkTemp+tabLang[i]);
  		oLink.className = "lang";
  	}
  	
  	// on cache le div de la langue courante
  	strField = document.getElementById("current_"+strChampId+tabLang[arguments[1]]);
  	if (strField)
  	  strField.style.display = "none";
  	
  	// on change le style du lien sélectionné
  	var oLinkId = document.getElementById(strLinkId);
  	if (oLinkId)
  	  oLinkId.className = oLinkId.className.replace("lang", "lang_selected");

  }else if (arguments.length > 0){
    var tabArg = arguments[0].split("_");
    var strType = tabArg[0];
    var arg = arguments[0].replace(strType+"_", "");
    if (strType=="0") { //afficher les champs cachés à partir du champ
      var oCtrl = document.getElementById(arg+'_block'); 
    	tabDiv = ( oCtrl ? oCtrl.children : new Array() );
    }else if (strType=="1"){ //afficher les champs cachés à partir du bloc
      var oCtrl = document.getElementById(arg);
    	tabDiv = ( oCtrl ? oCtrl.children : new Array() );
    	cpt = 1;
    }
  	for (var i=cpt; i<tabDiv.length;i++){
  		 var oDiv = tabDiv[i];
  		 
  		 if( oDiv.className.indexOf("ctrlblock") !=-1){
  	     var tabSubDiv = oDiv.children;
  	     for (var j=1; j<tabSubDiv.length;j++){
  		     var oSubDiv = tabSubDiv[j];
      		 if (oSubDiv.className.indexOf("open") !=-1){
      		   oSubDiv.className = oSubDiv.className.replace("open", "offscreen")
      		 } else if (oSubDiv.className.indexOf("offscreen") !=-1){
      		 	 oSubDiv.className = oSubDiv.className.replace("offscreen", "open")
      		 }
         }  		   
  		 } else {
    		 if (oDiv.className.indexOf("open") !=-1){
    		 	oDiv.className = oDiv.className.replace("open", "offscreen")
    		 } else if (oDiv.className.indexOf("offscreen") !=-1){
    		 	oDiv.className = oDiv.className.replace("offscreen", "open")
    		 }
    	} 
  	}
  }
}

function LoadEditor( oDiv, ikey )
{
  var element = document.getElementById(oDiv);
	// Find out the div that holds this element.
	  if ( element.className.indexOf( 'cke_editable' ) != -1 )
		  replaceDiv( element, ikey);
}

var editor;

function replaceDiv( div, ikey )
{
	// on recopie le contenu du div
	if ( editor ){
		editor.destroy();
	}
	var strChampId = div.id;
	LangShowHideLayer(strChampId, ikey);
	editor = CKEDITOR.replace( div );
}

function CopyField(champId, id)
{
  var strField;
  eval(tabLang);
  for (var i=0; i<tabLang.length;i++){
  	strField = document.getElementById(ALK_PREFIXE_CKE+champId+tabLang[i]); // généré par l'éditeur
  	if (strField) break;
  }
  
  var strChampCurrent = strField.id.replace(ALK_PREFIXE_CKE, "");
  if ( editor ){
  	var oCkF = CKEDITOR.instances[strChampCurrent].document.$.body;
  	oCkF.innerHTML = document.getElementById(champId+tabLang[id]).innerHTML;
  	document.getElementById(strChampCurrent).innerHTML = document.getElementById(champId+tabLang[id]).innerHTML;
  }
}
