<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Class::Form
Module fournissant les classes d'affichage Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlctrl.class.php");

/**
 * @package Alkanet_Class_Form
 * @class AlkHtmlCtrlColor
 * 
 * Classe d'affichage d'un composant de sélection de couleurs
 */
class AlkHtmlColor extends AlkHtmlCtrl
{
  /** Possibilité de selectionner aucune couleur : oui ou non */
  protected $strNoneAllowed;

  /**
   *  Constructeur par défaut
   * @param name           Nom ou identifiant du control
   * @param value          Couleur sélectionnée par défaut 
   * @param label          Label associée au control
   * @param iWidth         largeur du control
   * @param iHeight        hauteur du control
   * @param strNoneAllowed Aucune couleur selectionnable : oui ou non
   */
  public function __construct($oForm, $name, $value="", $label, $iWidth, $iHeight, $strNoneAllowed) 
  {
    parent::__construct($oForm, 0, $name, $value, $label);

    $this->iWidth = $iWidth;
    $this->iHeight = $iHeight;
    $this->strNoneAllowed = ($strNoneAllowed==_t("oui") ? true : ($strNoneAllowed==_t("non") ? false : $strNoneAllowed));
  }

  /**
   *  Génère puis retourne le code html associé au controle de saisie
   * @return string
   */
  protected function GetCtrlHtml($key=0, $tabLg=array()) 
  {
    $strHtml = "<input type='hidden' id='".$this->guid."' name='".$this->name."' value='".$this->value."' ".$this->getHtmlEvent()."/>";
    
    $strHtml .= "<div id='color_".$this->guid."'".
      " style='width:".$this->iWidth."px; padding-left:".$this->iWidth."px; height:".$this->iHeight."px; border:1px solid #000000; background-color:".$this->value."; display:inline;'".
      " onclick='javascript:OpenColorPallet_".$this->guid."()'>&nbsp;</div>".
      "<span id='value_".$this->guid."'".
      " style='width:50px; margin-left:4px;'>".
      "<a href='javascript:OpenColorPallet_".$this->guid."()'>".$this->value."</a></span>";
      
    $strHtml .= "<div id='allColorPallet_".$this->guid."' style='display:none;position:relative;float:left;z-index:1000'>".
      "<div id='colorPallet_".$this->guid."' style='position:absolute;float:left; background-color:#ffffff; border:1px solid #999999; padding:2px;'></div></div>";

    $this->addVarJs("g_url_img_vide", "'".ALK_ALKANET_ROOT_URL."media/images/transp.gif'");

    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_CLASSE."form/alkhtmlcolor.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_layer.js");

    $strJs = " var bColorPalett_".$this->guid." = false;" .
      " var oColorPalett_".$this->guid." = null;" .
      " var oColorInter_".$this->guid." = null;" .
      " function DefineColorPalett_".$this->guid."(){" .
      "  delete(oColorPalett_".$this->guid.");" .
      "  if ( typeof oColorPalett_".$this->guid." == 'undefined' || oColorPalett_".$this->guid." == null) {" .
      "    oColorPalett_".$this->guid." = new PaletteCouleurs('".$this->guid."', '".$this->name."', ".($this->strNoneAllowed ? "true" : "false").", '".substr($this->value, 1)."');".
      "    oColorInter_".$this->guid." = oColorPalett_".$this->guid.".ui;".
      "  }".
      "  bColorPalett_".$this->guid." = true;" .
      " }" .
      " function OpenColorPallet_".$this->guid."(){" .
      " if (!(bColorPalett_".$this->guid." && typeof oColorPalett_".$this->guid." != 'undefined' && oColorPalett_".$this->guid." != null) ) " .
      "   DefineColorPalett_".$this->guid."();".
      " oColorPalett_".$this->guid.".OpenCloseColorPallet();" .
      "}" ;
      
    $this->addJs($strJs);
    $this->addOnLoad(" DefineColorPalett_".$this->guid."();");

    return $strHtml;
  }
  

}

?>