<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Class::Form
Module fournissant les classes d'affichage Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlpanel.class.php");

if( !defined("ALK_HTMLFORM_NONE") ) { define("ALK_HTMLFORM_NONE", -1); }
if( !defined("ALK_HTMLFORM_1L2C") ) { define("ALK_HTMLFORM_1L2C", 0); }
if( !defined("ALK_HTMLFORM_2L1C") ) { define("ALK_HTMLFORM_2L1C", 1); }
if( !defined("ALK_HTMLFORM_1L1C") ) { define("ALK_HTMLFORM_1L1C", 2); }

/**
 * @package Alkanet_Class_Form
 * 
 * @class AlkHtmlBlock
 * @brief classe d'affichage des formulaires
 */
class AlkHtmlBlock extends AlkHtmlPanel
{
  /** Référence vers le formulaire contenant ce bloc*/
  protected $oForm;

  /** Indice du layerForm contenant ce block (=-1 par défaut) */
  protected $iSheet;
  
  /** Ensemble des controles constituant le bloc */
  protected $tabHtmlCtrl; 

  /** largeur dédiée au label du controle  */
  protected $iWidthLabel;
  
  /** largeur dédiée au controle de saisie */
  protected $iWidthCtrl;

  /** vrai si le titre du bloc est principal, faux pour un titre normal (par défaut) */
  protected $bMainTitle;

  /** classe css sur les titres de bloc */
  protected $cssBlock;
  
  /** Alignement de la table (chaine vide par défaut) */
  protected $strTableAlign;
  
  /** vrai si le bloc peut être rendu visible/invisible par le clic sur le titre */
  protected $bRetractable;
      
  /** vrai si le bloc est ouvert par défaut */
  protected $bOpen;

  /**
   *  Constructeur par défaut
   *
   * @param oForm       Formulaire propriétaire du block
   * @param name        identifiant du bloc
   * @param strTitle    titre du bloc
   * @param strDesc     descriptif du bloc
   * @param iWidthLabel largeur dédiée au label du controle (=180 par défaut)
   * @param iWidthCtrl  largeur dédiée au controle de saisie (=390 par défaut)
   * @param bMaintitle  vrai si le titre du bloc est principal, faux pour un titre normal (par défaut)
   * @param iSheet      Indice de l'onglet contenant ce block (=-1 par défaut)
   */
  function __construct(&$oForm, $name, $strTitle="", $strDesc="",
                       $iWidthLabel="180", $iWidthCtrl="390", $bMaintitle=false, $iSheet=0)
  {
    parent::__construct($name);

    $this->title  = $strTitle;
    $this->labelDesc = $strDesc;
    $this->iSheet = $iSheet;

    $this->oForm =& $oForm;
    $this->tabHtmlCtrl = array();

    $this->iWidthLabel = $iWidthLabel;
    $this->iWidthCtrl = $iWidthCtrl;
    $this->bMainTitle = $bMaintitle;

    $this->cssBlock = "formBlock";
    
    $this->strTableAlign    = "";
    $this->bRetractable			= false;
    $this->bOpen						= true;
    
    $this->setDefaultCss("alkhtmlblock.css");
  }
  
  /**
   *  Evalue l'ajout d'un objet de la hiérarchie panel au tableau de panels courant
   * 
   * @param  oPanel   Objet de type panel que l'on souhaite ajouter au tableau des panels
   * @return boolean
   */
  protected function canAddPanel($oPanel)
  {
    return $oPanel->isTypeOf(self::ALK_CLASS_HTMLCTRL) || $oPanel->isTypeOf(self::ALK_CLASS_HTMLBLOCK);    
  } 

  /**
   *  Ajoute un controle html au bloc
   *
   * @param oCtrl
   * @param strCodeChamp  Code du champ utilisé pour tester les droits [NOM FORM]_[NOM TABLE]_[NOM_CHAMP]
   * @param iTypeAff      Prend les valeurs de ALK_HTMLFORM_NONE, ALK_HTMLFORM_1L2C, ALK_HTMLFORM_2L1C ou ALK_HTMLFORM_1L1C
   * @param align         Alignement horizontal du controle
   */
  public function addCtrl($oCtrl, $iTypeAff=ALK_HTMLFORM_1L2C, $align="left")
  {
    if ( is_null($oCtrl) ) return;
    $iIndice = count($this->tabHtmlCtrl);
    $this->tabHtmlCtrl[$iIndice]["ctrl"] =& $oCtrl;
    $oCtrl->setBlock($this, true);
    $this->tabHtmlCtrl[$iIndice]["iTypeAff"] = $iTypeAff;
    $this->tabHtmlCtrl[$iIndice]["align"] = $align;
    if ($oCtrl->bMultiLanguage)
      $this->bMultiLanguage = true;
    parent::addPanel($oCtrl);
  }

  /**
   *  Retourne le code html du block complet
   *
   * @return Retourne un string
   */
  public function getHtml()
  {
    if ( empty($this->tabHtmlCtrl) )
      return "";
    $this->addDefaultCss();
    $nbNotHidden = 0;
    foreach ( $this->tabHtmlCtrl as $tabCtrl ){
      if ( !$tabCtrl["ctrl"]->isHidden() && !$tabCtrl["ctrl"]->isFieldNotView() && $tabCtrl["iTypeAff"]!=ALK_HTMLFORM_NONE )
        $nbNotHidden++;
    }  
    $strHtmlHidden = "";
    $strHtml = "";
    if ( $nbNotHidden!=0 )
      $strHtml .= $this->getHtmlTableCtrlHeader().      
        $this->getHtmlTableCtrlTitle();

    $iNbCtrlDraw = 0;
    
    // assignation des propriétés générales du block
    if( $this->strTemplateFile != "" ) {
    	// assignation du sheet manager
      $this->oTemplate->assign("sheetManager", $this->getHtmlSheets());
    
      $this->oTemplate->assign("title",   $this->getLabel());
      $this->oTemplate->assign("desc",    $this->getLabelDesc());
      $this->oTemplate->assign("warning", $this->getLabelWarning());
    
      $this->oTemplate->assign("panels_list",  array_keys($this->tabPanels));
      // assignation des sous panels
      foreach($this->tabPanels as  $guid => $oPanel) {
        $this->oTemplate->assign($guid,  $oPanel);
      }
    
      $this->oTemplate->assign("links_list",  array_keys($this->tabHtmlLink));
      // assignation des boutons
      foreach($this->tabHtmlLink as $oLink) {
        $this->oTemplate->assign($oLink->getName(), $oLink->getHtml());
      }
    
      // assignation de l'objet Panel
      $this->oTemplate->assign_by_ref("oPanel", $this);
    }
    
    for($i=0; $i< count($this->tabHtmlCtrl); $i++) {
      $oCtrl =& $this->tabHtmlCtrl[$i]["ctrl"];
      if( $oCtrl->isHidden() ) {
        $iNbCtrlDraw++;
        $strHtmlHidden .= $oCtrl->getHtml();
      } 
      else {
        if( $this->strTemplateFile == "" ) {
          $iNbCtrlDraw++;
          switch( $this->tabHtmlCtrl[$i]["iTypeAff"] ) {
          case ALK_HTMLFORM_1L2C: $strHtml .= $this->getHtmlTableCtrlLine($oCtrl, $this->tabHtmlCtrl[$i]["align"]);   break;
          case ALK_HTMLFORM_2L1C: $strHtml .= $this->getHtmlTableCtrl2Lines($oCtrl, $this->tabHtmlCtrl[$i]["align"]); break;
          case ALK_HTMLFORM_1L1C: $strHtml .= $this->getHtmlTableCtrlColumn($oCtrl, $this->tabHtmlCtrl[$i]["align"]); break;
          case ALK_HTMLFORM_NONE: $iNbCtrlDraw--; break;
          }
        } 
        else {
          $this->oTemplate->assign_by_ref($oCtrl->getName(), $oCtrl, array("getHtml"));
        }
      }
    }

    if ( $iNbCtrlDraw==0 && $this->strTemplateFile == "")
      return "";
    
    if( $this->strTemplateFile != "" ) {
      $strHtml .= $this->oTemplate->fetch($this->strTemplateFile);
    }
      
    if ( $nbNotHidden!=0 )
      $strHtml .= $this->getHtmlButtons() .
        $this->getHtmlTableCtrlFooter();
    
    return $strHtml.$strHtmlHidden;
  }
  
  /**
   *  Retourne le code html de la fin du formulaire
   *
   *  Retourne un string
   */
  public function getHtmlButtons()
  {
  	return parent::getHtmlButtons();
  	//return ($strHtml=="" ? "" : "<tr><td colspan='2'>".$strHtml."</td></tr>");
  }
  
  /**
   *  Retourne le code HTML API v2 de l'entete d'un tableau 
   *        formulaire de saisie  avec une largeur définie par 
   *        défaut à 570 = 180+390
   *        deux colonnes : label - valeur suivi d'un trait
   *
   * @return Retourne un string
   */
  protected function getHtmlTableCtrlHeader()
  {
    $iWidth = ( $this->iWidthLabel=="" ? "100%" : $this->iWidthLabel."px" );
    $this->iWidthLabel = ( $this->iWidthLabel=="" ? "100%" : $this->iWidthLabel );
    $iWidthTotal = $this->iWidthLabel+$this->iWidthCtrl;
    
    $iWidthTotal = $this->iWidthLabel+$this->iWidthCtrl;
    $strCss = "";
    $strCss .= '#'.$this->guid.' { width:'.($iWidth=="100%" ? "780px" : $iWidthTotal.'px').';}';
    $strCss .= '#'.$this->guid.' legend span, #'.$this->guid.' p.txtAdvice {width:'.($iWidth=="100%" ? "780px" : ($iWidthTotal-6).'px').';}'; // 2*(border=1 + padding=2)
    $strCss .= '#'.$this->guid.' div.ctrlline {width:'.($iWidth=="100%" ? $iWidth : $iWidthTotal.'px').';}';
    $strCss .= '#'.$this->guid.' label {width:'.( $iWidth=="100%" ? $iWidth : ($this->iWidthLabel-4).'px').';}'; // padding-right=4
    $strCss .= '#'.$this->guid.' div.ctrl {width:'.$this->iWidthCtrl.'px;}';
    $strCss .= '#'.$this->guid.' label.column, #'.$this->guid.' div.ctrl.column {width:'.($iWidth=="100%" ? $iWidth : $iWidthTotal.'px').';}';
    $this->addCss($strCss);
    return '<fieldset' .
      ' class="'.$this->cssBlock.''.( $this->strTableAlign!="" ? ' '.$this->strTableAlign : "" ).'"'.
      ' id="'.$this->guid.'">';
  }

  /**
   *  Retourne le code HTML de la fin de tableau du bloc de saisie
   *
   * @return Retourne un string
   */
  protected function getHtmlTableCtrlFooter()
  {
    return '</fieldset>';
  }
  
  /**
   *  Retourne le titre du bloc
   *	La fonction OpencloseHtmlBlock est implémentée dans /lib/lib_js.js
   * @return Retourne un string
   */
  protected function getHtmlTableCtrlTitle()
  {
  	$strEvent = ( $this->bRetractable 
                  ? ' onclick="OpenCloseHtmlBlock(\''.$this->getGUID().'\', \'\', \'offscreen\');"' 
                  : '' );  
    return 
      ( $this->title != ""
        ? '<legend '.( $this->bMainTitle ? 'class="main"' : '' ).' align="'.($this->strTableAlign!="" ? $this->strTableAlign : "left").'">' .
          '<span '.( $this->bMainTitle ? 'class="main"' : '' ).$strEvent.'>'.$this->title.
          ( $this->bMultiLanguage && $this->nbLangue > 1
            ? '&nbsp;&nbsp;<a title="'._t("Afficher toutes les langues").'" onclick="LangShowHideLayer(\'1_'.$this->getGUID().'\')">'.
              '<img border="0" alt="'._t("Afficher toutes les langues").'" class="SeeButton alkimgicon alkimgiconlocale" src="'.$this->urlBaseImg.'transp.gif"></a>'
            : '').
          '</span></legend>'
        : '' ).
      ( $this->labelDesc!=""
        ? '<div class="txtAdvice">'.$this->labelDesc.'</div>'
        : '' );
  }

  /**
   *  Retourne le code HTML d'une ligne de tableau à 2 colonnes
   *        contenant : label - controle de saisie
   *
   * @param oCtrl  référence vers l'objet ctrl à afficher
   * @return Retourne un string
   */
  protected function getHtmlTableCtrlLine(&$oCtrl, $align)
  {
    $tabHtmlCtrl = $oCtrl->getTabHtmlCtrl();  
    $strHtml = "";
    $idCtrl = $oCtrl->getGUID();
    $strClass = ( $this->bRetractable 
                  ? ( $this->bOpen 
                      ? '' 
                      : ' offscreen' ) 
                  : '' );
    
    if ($oCtrl->isTypeOf(AlkHtmlCtrl::ALK_CLASS_HTMLTEXT) && $oCtrl->bEditor) {
      $strIdDiv = ( $idCtrl != "" ? ' id="'.$idCtrl.'_line"' : '' );

      $strHtml .= '<div '.$strIdDiv.' class="ctrlline'.$strClass.'">'.
        '<label '.
        ( $oCtrl->isRequired() 
          ? 'class="required"'
          : '' ).
        ( $idCtrl!=""
          ? ' for="'.$idCtrl.'"'.
            ' id="label_'.$idCtrl.'"' 
          : '' ).
        '>'.
        $oCtrl->getLabel().'</label>'.
        '<div class="ctrl '.$align.'">'.$oCtrl->getHtml().'</div>'.
        '</div>';
    } else {
      $bFirst = true;
      $bMulti = false;
      foreach($tabHtmlCtrl as $strLgRep => $strHtmlCtrl) {
        $strLg = ( $strLgRep!="0" 
                   ? $strLgRep 
                   : "" );
        $bMulti = ($strLg != "");
        $idCtrlLg = $idCtrl.( $strLg != "" ? "_".strtoupper($strLg) : "");

        $strIdDiv = ( $idCtrlLg != "" ? 'id="'.$idCtrlLg.'_line"' : '' );
        
        $strClassLabel = ( !$bFirst ? " offscreenv" : "" ).( $oCtrl->isRequired() ? " required" : "");
        if( trim($strClassLabel) != "" ) {
          $strClassLabel = ' class="'.trim($strClassLabel).'"';
        } 
        
        $strLabel = $oCtrl->getLabel().
          ( $strLg != "" 
            ? '<abbr class="offscreen" title="'.$strLg.'"> '.$strLg.'</abbr>' 
            : '' );
            
        // vérifie que l'étoile (champ obligatoire) soit bien à la fin du label
        $strLabel = ( strpos($strLabel, "*") !== false
                      ? str_replace("*", "", $strLabel)."*"
                      : $strLabel );

        $strHtml .= '<div '.$strIdDiv.' class="ctrlline'.( $bFirst ? $strClass : '' ).( !$bFirst ? ' offscreen' : '' ).'">'.
          '<label '.$strClassLabel.
          ( $idCtrl!=""
            ? ' for="'.$idCtrlLg.'"'.
              ' id="label_'.$idCtrlLg.'"' 
            : '' ).
          '>'.$strLabel.'</label>'.
          '<div class="ctrl '.$align.'">'.$strHtmlCtrl.'</div>'.
          '</div>';
        $bFirst = false;
      }
      
      if( $bMulti ) {
        $strHtml = '<div id="'.$idCtrl.'_block" class="ctrlblock">'.$strHtml.'</div>';
      }
      
    }
    return $strHtml;
  }

  /**
   *  Retourne le code HTML d'une ligne de tableau à 1 colonne 
   *        contenant : controle de saisie
   *
   * @param oCtrl  référence vers l'objet ctrl à afficher
   * @return Retourne un string
   */
  protected function getHtmlTableCtrlColumn(&$oCtrl, $align)
  {
   $tabHtmlCtrl = $oCtrl->getTabHtmlCtrl();
   
   $strHtml  = "";
   $idCtrl   = $oCtrl->getGUID();
   $strClass = ( $this->bRetractable 
                 ? ( $this->bOpen 
                     ? '' 
                     : ' offscreen' )
                 : '');
    
    if( $oCtrl->isTypeOf(AlkHtmlCtrl::ALK_CLASS_HTMLTEXT) && $oCtrl->bEditor){
      $strIdDiv    = ( $idCtrl != "" ? ' id="'.$idCtrl.'_line"' : '' );

      $strHtml .= '<div class="ctrlline'.$strClass.'"'.$strIdDiv.'>'.
        '<div class="ctrl column '.$align.'">'.$oCtrl->getHtml().'</div>'.
        '</div>';
    } else {
      $bFirst = true;
      $bMulti = false;
      foreach($tabHtmlCtrl as $strLgRep => $strHtmlCtrl) {
        $strLg = ( $strLgRep!="0" 
                   ? $strLgRep 
                   : "" );
        $bMulti = ($strLg != "");
        $idCtrlLg = ( $idCtrl != ""
                      ? $idCtrl.( $strLg != "" ? "_".strtoupper($strLg) : "")
                      : "" );
        $strIdDiv    = ( $idCtrlLg != "" ? 'id="'.$idCtrlLg.'_line"' : '' );

        $strHtml .= '<div '.$strIdDiv.' class="ctrlline'.( $bFirst ? $strClass : '' ).( !$bFirst ? ' offscreen' : '').'">'.
          '<div class="ctrl column '.$align.'">'.$strHtmlCtrl.'</div>'.
          '</div>';
        $bFirst = false;
      }
      
      if( $bMulti ) {
        $strHtml = '<div id="'.$idCtrl.'_block" class="ctrlblock">'.$strHtml.'</div>';
      }
    }
    return $strHtml;
  }

  /**
   *  Retourne le code HTML d'une ligne de tableau à 2 lignes et 1 colonne 
   *        contenant : label / controle de saisie
   *
   * @param oCtrl  référence vers l'objet ctrl à afficher
   * @return Retourne un string
   */
  protected function getHtmlTableCtrl2Lines(&$oCtrl, $align)
  {
   $tabHtmlCtrl = $oCtrl->getTabHtmlCtrl();
   
   $strHtml = "";
   $idCtrl = $oCtrl->getGUID();
   $strClass = ( $this->bRetractable 
                 ? ( $this->bOpen 
                     ? '' 
                     : ' offscreen' )
                 : '');
    
    if( $oCtrl->isTypeOf(AlkHtmlCtrl::ALK_CLASS_HTMLTEXT) && $oCtrl->bEditor){
          $strId1  = ( $idCtrl!="" ? ' id="'.$idCtrl.'_line1"' : '' );
      $strId2  = ( $idCtrl!="" ? ' id="'.$idCtrl.'_line2"' : '' );

      $strHtml .= '<div'.$strId1.' class="ctrlline'.$strClass.'">'.
        '<label '.
        ( $oCtrl->isRequired() 
          ? 'class="required"'
          : '' ).
        ( $idCtrl!=""
          ? ' for="'.$idCtrl.'"'.
            ' id="label_'.$idCtrl.'"' 
          : '' ).
        '>'.
        $oCtrl->getLabel().'</label>'.
        '<div'.$strId2.' class="ctrl column '.$align.'">'.$oCtrl->getHtml().'</div>'.
        '</div>';
    } else {
      $bFirst = true;
      $bMulti = false;
      foreach($tabHtmlCtrl as $strLgRep => $strHtmlCtrl) {
        $strLg = ( $strLgRep!="0" 
                   ? $strLgRep 
                   : "" );
        $bMulti = ($strLg != "");
        $idCtrlLg = ( $idCtrl != ""
                      ? $idCtrl.( $strLg != "" ? "_".strtoupper($strLg) : "")
                      : '' );
                     
        $strId1  = ( $idCtrlLg!="" ? ' id="'.$idCtrlLg.'_line1"' : '' );
        $strId2  = ( $idCtrlLg!="" ? ' id="'.$idCtrlLg.'_line2"' : '' );

        $strLabel = $oCtrl->getLabel().
          ( $strLg != "" 
            ? '<abbr class="offscreen" title="'.$strLg.'"> '.$strLg.'</abbr>' 
            : '' );
            
        // vérifie que l'étoile (champ obligatoire) soit bien à la fin du label
        $strLabel = ( strpos($strLabel, "*") !== false
                      ? str_replace("*", "", $strLabel)."*"
                      : $strLabel );

        $strHtml .= '<div '.$strId1.' class="ctrlline'.( $bFirst ? $strClass : '' ).( !$bFirst ? ' offscreen' : '' ).'">'.
          '<label '.
          ( $oCtrl->isRequired() 
            ? 'class="required '.$align.'"' 
            : ( $align != ""
                ? 'class="'.$align.'"'
                : '' )).
          ( $idCtrl != ""
            ? ' for="'.$idCtrlLg.'"'.
              ' id="label_'.$idCtrlLg.'"' 
            : '' ).
          '>'.
          $strLabel.'</label>'.
          '<div '.$strId2.' class="ctrl column '.$align.'">'.$strHtmlCtrl.'</div>'.
          '</div>';
        $bFirst = false;
      }
      if( $bMulti ) {
        $strHtml = '<div id="'.$idCtrl.'_block" class="ctrlblock">'.$strHtml.'</div>';
      }
    }
    return $strHtml;
  }
  
  /**
   * accesseurs
   */
  
  /**
   *  retourne le formulaire auquel appartient le bloc
   * 
   * @return AlkHtmlForm ou null
   */
  public function getForm()
  {
    return $this->oForm;
  }
}
?>