function NavToolbarFontAwesome(icon){
  return "fa "+icon;
}
Prodige.Control = Prodige.Control || {};
Prodige.Control.ZoomIn = OpenLayers.Class(OpenLayers.Control.ZoomBox,{
  CLASS_NAME : "Prodige.Control.ZoomIn"
});
Prodige.Control.ZoomOut = OpenLayers.Class(OpenLayers.Control.ZoomBox,{
  out : true,
  CLASS_NAME : "Prodige.Control.ZoomOut"
});

Prodige.NavToolbar = OpenLayers.Class(OpenLayers.Control.Panel, {
  controlsDefinitions : {
    "Navigation" : {
      'zoomWheelEnabled': true,
      dragPanOptions: {
        enableKinetic: true
      },
      fontAwesome : NavToolbarFontAwesome("fa-arrows")
    },
    "ZoomIn" : {
      'zoomWheelEnabled': true,
      dragPanOptions: {
        enableKinetic: true
      },
      fontAwesome : NavToolbarFontAwesome("fa-search-plus")
    },
    "ZoomOut" : {
      'zoomWheelEnabled': true,
      dragPanOptions: {
        enableKinetic: true
      },
      type : OpenLayers.Control.TYPE_TOOL,
      fontAwesome : NavToolbarFontAwesome("fa-search-minus")
    },
    "ZoomToMaxExtent" : {
      fontAwesome : NavToolbarFontAwesome("fa-globe")
    }
  },
  initialize : function(options) {
    OpenLayers.Control.Panel.prototype.initialize.apply(this, [options]);
    var controls = [];
    this.displayClass = "prodigeControlNavToolbar";
    for(var klassName in this.controlsDefinitions ){
      if ( typeof Prodige.Control[klassName] == "undefined" ){
        Prodige.Control[klassName] = OpenLayers.Class(OpenLayers.Control[klassName], {CLASS_NAME : "Prodige.Control."+klassName});
      }
      var klass = Prodige.Control[klassName];
      var definition = this.controlsDefinitions[klassName];
      var control = new klass(definition);
      controls.push(control);
    }
    
    this.addControls(controls);
  },
  draw : function() {
    var div = OpenLayers.Control.Panel.prototype.draw.apply(this, arguments);
    if ( typeof this.defaultControl == "string" ){
      for(var i=0; i<this.controls.length; i++){
        if ( this.controls[i].type==OpenLayers.Control.TYPE_TOOL && this.controls[i].CLASS_NAME.toLowerCase().indexOf(this.defaultControl.toLowerCase())!=-1 ){
          this.defaultControl = this.controls[i];
          break;
        }
      }
      if ( typeof this.defaultControl == "string" ){
        this.defaultControl = null;
      }
    }
    if (this.defaultControl === null) {
      this.defaultControl = this.controls[0];
    }
    return div;
  },
  addControls: function(controls) {
    if ( !(controls instanceof Array) ){
      controls = [controls];
    }
    for(var i=0; i<controls.length; i++){
      controls[i].displayClass = "";
    }
    OpenLayers.Control.Panel.prototype.addControls.apply(this, [controls]);
  },
  createControlMarkup: function(control) {
    var div = document.createElement("div");
    if ( control.fontAwesome ){
      var awesome = document.createElement("i");
      awesome.className = control.fontAwesome;
      div.appendChild(awesome);
    }
    return div;
  },
  

  
  CLASS_NAME : "OpenLayers.Control.NavToolbar"
});