
/**
 * Class: Prodige.Map
 * 
 * Classe principale de l'API Prodige 
 * 
 * Instancie et gère un objet {OpenLayers.Map} ainsi que la légende et la carte de situation
 */
Prodige.Map = OpenLayers.Class(AbstractMapBuilder, {
	usage : 'API',
	
  DEFAULT_WIDTH : 500,
  DEFAULT_HEIGHT : 700,
  onlyActivCtrls : [
    "zoom"
  ],
  CLASS_NAME: "Prodige.Map",
  DEFAULTS : {
    defaultControl : 'pan'
  },
  
  /**
   * Property: id               
   * {String} - Identifiant unique de l'instance
   * (start code)
   * @api
   * (end)
   */
  id : null,
  
  /**
   * Property: renderTo  
   * {String|DOMElement} - Le domElement ou son ID dans lequel sera rendu la carte       
   * (start code)
   * @api
   * (end)
   */
  renderTo : null,
  /**
   * Property: owscontext       
   * {String} - The URL to request the OWS context for the map to show
   * (start code)
   * @api
   * @required
   * (end) 
   */
  owscontext : null,
  /**
   * Property: legendVisible    
   * {Boolean} - default=true - Permet d'afficher la légende
   * (start code)
   * @api
   * (end)
   */
  legendVisible : true,
  /**
   * Property: keymapVisible    
   * {Boolean} - default=true - Ajoute à la carte, une carte de situation
   * (start code)
   * @api
   * (end)
   */
  keymapVisible : true,
  /**
   * Property: defaultControl   
   * {String} - Le nom du controle activé par défaut (nom de la classe du controle)
   * (start code)
   * @api
   * (end)
   */
  defaultControl : null,
  
  /**
   * Property: legendRenderer   
   * {String|Prodige.Tree.DefaultRenderer} - default='default' - Le nom ou l'alias de la classe responsable du rendu de la légende.
   * 
   * Alias connus : 'default' et 'advanced'
   * 
   * (start code)
   * @api
   * (end)
   */
  legendRenderer : "default",

  
  toolbar : null,

  
  legend : null,
  
  keymap : null,
  
  /**
   * Constructor: Prodige.Map
   * Constructeur d'instances
   * 
   * Params:
   * {Object|String} - configuration de l'instance
   *                 - {Object} - Objet contenant au minimun l'URL du contexte de carte OWS à charger ainsi que les éventuelles autres propriétés 
   *                 - {String} - URL du contexte de carte OWS à charger
   * 
   * (start code)
   * Options de construction propres à la classe:
   * owscontext     - {String} {Obligatoire} URL du contexte de carte OWS à charger
   * id             - {String}  Identifiant de l'instance. 
   *                            Si fourni à l'initialisation, créée une variable globale de ce nom (si possible)
   * legendVisible  - {Boolean} Affiche la légende de carte si vaut TRUE. 
   *                            Légende visible par défaut
   * keymapVisible  - {Boolean} Affiche la carte de situation si vaut TRUE. 
   *                            Carte de situation visible par défaut
   * defaultControl - {String}  Nom du contrôle de navigation sélectionné par défaut. 
   *                            Le premier contrôle sera utilisé si la valeur est non fourni ou trouvée
   * (end)
   */
  initialize: function(options) {
    if ( typeof options=="string" ){
      options = {owscontext : options};
    }
    var me = this;
    options = options || {};
    OpenLayers.Util.extend(this, options);
    
    /////////////////////////////////////////
    this.legendRenderer = this.legendRenderer || "default";
    if ( typeof this.legendRenderer=="string" ){
      this.legendRenderer = eval("new "+Prodige.Tree.Renderer.ALIASES[this.legendRenderer]+"()");
    }

    if ( this.id && /^[a-z_]\w+$/i.test(this.id) ){
      eval(this.id+" = this;");
    }
    this.id = this.id || OpenLayers.Util.createUniqueID(this.CLASS_NAME+'-');
    
    this.mainPanel = OpenLayers.Util.getElement(this.renderTo || document.body) || document.body;
    this.mainPanel.style.width  = this.mainPanel.style.width   || (this.DEFAULT_WIDTH+'px'); 
    this.mainPanel.style.height = this.mainPanel.style.height || (this.DEFAULT_HEIGHT+'px'); 
    this.mainPanel.add = this.mainPanel.appendChild;
    
    this.ui = {
      getMainPanel : function(){return OpenLayers.Util.getElement(me.mainPanel);},
      doLayout : function(){} ,
      addToDataPanel : function(child){this.getMainPanel().appendChild(child);} 
    };
    this.defaultControl = this.defaultControl || this.DEFAULTS.defaultControl;
    
    this.loadContext();
  },
  
  /**
   * Function: getCurrentContext 
   * Retourne un objet OWSContext correspondant à la carte actuellement visible (extent, couches visibles, annotations, ...)
   * (start code)
   * @api
   * (end)
   * 
   * Params:
   * {Boolean} - default=true - Si vrai, alors inclus les annotations dans les contenus générés
   * 
   * Returns :
   * {<Prodige.OWSContext>} 
   */
  getCurrentContext : function(bWithAnnotation)
  {
  	if ( typeof bWithAnnotation == "undefined" ) bWithAnnotation = true;
  	if ( !(this.map && this.owscontext) ) {
  		return null;
  	}
  	
  	
    // extent
    this.owscontext.setExtent(this.map.getExtent());
    
    // layers visibility
    var layerMgr = this.layerTreeManager;
    var layersVisibility = layerMgr.getLayersVisibility();
    for (var i=0; i<layersVisibility.length; i++) {
      layerVis = layersVisibility[i];
      this.owscontext.setLayerVisibility(layerVis.layerIdx, layerVis.visible);
    }
    
    

    //console.log(layerMgr.serializeForContext());
    this.owscontext.setGeneralConfig(layerMgr.serializeForContext());
    
    
    // favorite areas
    var favoriteAreas = this.map.getControlsByClass('Carmen.Control.FavoriteAreas');
    if (favoriteAreas.length>0) {
      favoriteAreas = favoriteAreas[0];
      this.owscontext.setGeneralConfig(favoriteAreas.serializeForContext());
    }
    
    // annotations
    var annotation = this.map.getControlsByClass('Carmen.Control.AdvancedAnnotation');
    if (annotation.length>0) {
      annotation = annotation[0];
      if(bPrint){
        this.owscontext.setGeneralConfig({Annotation:annotation.exportFeatures()});
        this.owscontext.setGeneralConfig(annotation.exportLabels());
      }
      else {
        this.owscontext.setGeneralConfig(annotation.serializeForContext());
      }
    }
    return this.owscontext.getObj();
  
  },
  
  /**
   * Function: loadContext 
   * Charge une nouvelle carte
   * (start code)
   * @api
   * (end)
   * 
   * Params:
   * {String} - URL du contexte de carte OWS à charger. Recharge entièrement la carte
   */
  loadContext : function(owscontext)
  {
    var me = this;
    this.owscontext = owscontext || this.owscontext;
    
    if ( this.owscontext===null ){
      throw "Prodige.Map : the owscontext property is required for instanciation";
    }
    if ( typeof this.owscontext == "string" ){
      var request = new OpenLayers.Request.GET({
        url : this.owscontext,
        async : false,
        /**
         * @param <OpenLayers.Request.XMLHttpRequest>
         */
        success : function(request){
          me.owscontext = Prodige.OWSContextReader(request.responseXML || request.responseText);
        },
        failure : function(){
          throw "Prodige.Map : the owscontext property cant not be opened or read. ["+me.owscontext+"]";
        }
      });
    } else {
      this.owscontext = Prodige.OWSContextReader(this.owscontext);
    }

    AbstractMapBuilder.prototype.initialize.apply(this);
    this.legend = this.layerTreeManager;
    
  },
  
  /**
   * Function: addControl  
   * Ajoute un controle OpenLayers à la carte (si possible, l'ajoute à la barre d'outil de navigation)
   * (start code)
   * @api
   * (end)
   * 
   * Params:
   * {<OpenLayers.Control>|Array<OpenLayers.Control>} - Contrôle(s) à ajouter dans la barre d'outils 
   */
  addControl : function(control)
  {
    if ( this.toolbar ){
      switch ( control.type ){
        case OpenLayers.Control.TYPE_BUTTON :
        case OpenLayers.Control.TYPE_TOGGLE :
        case OpenLayers.Control.TYPE_TOOL :
          this.toolbar.addControls((control instanceof Array ? control : [control]));
        return;
      }
    }
    this.map.addControl(control);
  },
  
  /**
   * Function: getLayerTree 
   * Retourne la racine de l'arbre des couches
   * (start code)
   * @api
   * (end)
   * 
   * Return:
   * {<Prodige.Tree.Node>} - Racine de l'arbre des couches
   */
  getLayerTree : function()
  {
    return this.legend.getLayerTree();
  },
  
  /**
   * Function: getLegend 
   * Retourne le contrôleur de la légende
   * (start code)
   * @api
   * (end)
   * 
   * Return:
   * {<Prodige.Legend>} - Le contrôleur de la légende
   */
  getLegend : function()
  {
    return this.legend;
  },
  
  /**
   * Function: getKeymap 
   * Retourne le contrôleur de la carte de situation
   * (start code)
   * @api
   * (end)
   * 
   * Return:
   * {<Prodige.Keymap>} - Le contrôleur de la carte de situation
   */
  getKeymap : function()
  {
    return this.keymap;
  },
  
  addControls : function(){
    this.toolbar = new Prodige.NavToolbar({defaultControl : this.defaultControl});
    this.map.addControl(this.toolbar);
  }
  
});
