

NS = {  u'xsi:schemaLocation' : 'http://www.isotc211.org/2005/gmd http://schemas.opengis.net/iso/19139/20060504/gmd/gmd.xsd',
        u'xmlns:gmd' : 'http://www.isotc211.org/2005/gmd',
        u'xmlns:gco' : 'http://www.isotc211.org/2005/gco',
        u'xmlns:xsi' : 'http://www.w3.org/2001/XMLSchema-instance',
        u'xmlns:gml' : 'http://www.opengis.net/gml',
        u'xmlns:xlink' : 'http://www.w3.org/1999/xlink'
}

import xml.dom.minidom

def createNodeNS(parent, node, ns):
    a = ns+':'+node
    b = doc.createElementNS(NS['xmlns:'+ns], a)
    parent.appendChild(b)
    return b

def addText(node, value):
    v = doc.createTextNode(value)
    node.appendChild(v)


doc = xml.dom.minidom.Document()
MD_Metadata_Node = doc.createElementNS(NS['xmlns:gmd'], 'gmd:MD_Metadata')

for value in NS:
    MD_Metadata_Node.setAttribute(value, NS[value])
doc.appendChild(MD_Metadata_Node)


# MD_FileIdentifier
MD_FileIdentifier_Node = createNodeNS(MD_Metadata_Node, 'fileIdentifier', 'gmd')
CharacterString_Node = createNodeNS(MD_FileIdentifier_Node, 'CharacterString', 'gco')
addText(CharacterString_Node, "FileIdentifier_0123456789")


print(doc.toprettyxml(encoding="UTF-8"))

