<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" omit-xml-declaration="yes" encoding="UTF-8" indent="yes"/>

<!-- Transformation for table ca  -->


<xsl:template match="/">
 <xsl:apply-templates select="ROWSET"/>
</xsl:template>

<xsl:template match="ROWSET">
<table width="50%" border="1" cellspacing="1" cellpadding="1">
  <tr>
    <th></th>
  <th>Nom et OID</th>   
  </tr>
  
  <xsl:if test="count(ROW) = 0">
  <tr><td align="center" colspan="4">Aucune PV n'est actuellement associée à ce domaine de confiance</td></tr>
  </xsl:if>
  
  
  <xsl:for-each select="ROW">
	  <tr>
	  <xsl:if test="(position() mod 2) = 0">
		  <xsl:attribute name="class">
		  <xsl:text>altern0</xsl:text>
		  </xsl:attribute>
	  </xsl:if>
	  <xsl:if test="(position() mod 2) = 1">
		  <xsl:attribute name="class">
		  <xsl:text>altern1</xsl:text>
		  </xsl:attribute>
	  </xsl:if>
	   <td nowrap="true" align="center"> 
        <input type="radio" name="idvp" >
	        <xsl:attribute name="value"><xsl:value-of select="idvp"/></xsl:attribute>  	      
		 	<xsl:if test="isdefault = 'Y'">
		 	<xsl:attribute name="checked">checked</xsl:attribute>
		 	</xsl:if>
	 	</input>                
      </td>

	  <td nowrap="true" align="left"><xsl:value-of select="name" /> | <xsl:value-of select="idvp" /></td>
	 	  
	  </tr>
  </xsl:for-each>
  

</table>
</xsl:template>

</xsl:stylesheet>
