use svc;

DELIMITER $$


DROP PROCEDURE IF EXISTS getCAList;
CREATE PROCEDURE getCAList (IN id_ca INTEGER, IN id_vp VARCHAR(500), IN vers INTEGER, IN id_trustdom VARCHAR(500), 
					IN idcaroot INTEGER, IN idissuer INTEGER)

					
					
BEGIN

DECLARE v_idca INTEGER DEFAULT 0;
DECLARE v_idissuer INTEGER DEFAULT 0 ;
DECLARE v_order INTEGER DEFAULT 0 ;
DECLARE idx INTEGER DEFAULT 1;
DECLARE testnombre INTEGER DEFAULT 0;
DROP TABLE IF EXISTS temptablegetcalist;
CREATE TABLE temptablegetcalist (idca INTEGER);

IF (idcaroot IS NOT NULL) AND (idissuer IS NOT NULL) THEN
	/* ajouter id_ca */	
	INSERT INTO temptablegetcalist values (id_ca);
	
	SET v_idissuer := idissuer ;
	/* faire une boucle */

	la_boucle:LOOP 
		SET v_idca := v_idissuer;
		IF v_idca != id_ca THEN 			
			INSERT INTO temptablegetcalist VALUES (v_idca);	
		END IF;
		SELECT count(*) INTO testnombre FROM(
			SELECT idissuer, pathorder 
			FROM validpath
			WHERE idvp = id_vp  
			AND version = vers 
			AND idtrustdom = id_trustdom 
			AND idrootca = idcaroot
			AND idobject = v_idca 
			LIMIT 0,1)as temptable ;
		
		IF (testnombre = 0) THEN
		 SET v_order := 0;
		ELSE
			SELECT idissuer, pathorder 
			INTO v_idissuer, v_order
			FROM validpath
			WHERE idvp = id_vp  
			AND version = vers 
			AND idtrustdom = id_trustdom 
			AND idrootca = idcaroot
			AND idobject = v_idca 
			LIMIT 0,1;
		END IF;
				
		IF v_order = 0 THEN
			LEAVE la_boucle;
		END IF;
	END LOOP la_boucle ;
END IF;
		
/*SELECT * FROM temptablegetcalist;*/



END $$





DROP PROCEDURE IF EXISTS getCacInfo;
CREATE PROCEDURE getCacInfo(IN id_ca INTEGER, IN id_vp VARCHAR(500), IN vers INTEGER, IN id_trustdom VARCHAR(500)) 

BEGIN

DECLARE v_idcaroot INTEGER DEFAULT NULL;
DECLARE v_idca INTEGER DEFAULT NULL;
DECLARE v_idobject INTEGER DEFAULT NULL;
DECLARE v_isterminal INTEGER DEFAULT 0;
DECLARE testnombre INTEGER DEFAULT 0;


DECLARE EXIT HANDLER FOR SQLEXCEPTION
	ROLLBACK;


BEGIN
	DECLARE EXIT HANDLER FOR NOT FOUND 
	BEGIN
		SELECT 'no data found';
	END;

/* rechercher le CA du certificat */
	SELECT idrootca, idissuer 
	INTO v_idcaroot, v_idca
	FROM validpath
	WHERE idvp = id_vp  
	AND version = vers 
	AND idtrustdom = id_trustdom
	AND idobject = id_ca 
	LIMIT 0,1 ;
END;


/*

//A tester si le handler fait bien la "mme chose"...
SELECT 'no data found' ?

EXCEPTION
WHEN NO_DATA_FOUND THEN 
RAISE_APPLICATION_ERROR(-20000, '{Validation.getCacInfo: no data found}' ) ;*/
			
IF v_idcaroot IS NOT NULL THEN 
/* rechercher si le CA donne est terminal */
	BEGIN
		SELECT count(*) INTO testnombre 
		FROM (		
		SELECT idobject  
		FROM validpath
		WHERE idvp = id_vp  
		AND version = vers 
		AND idtrustdom = id_trustdom 
		AND idrootca = v_idcaroot
		AND idissuer = id_ca
		AND idobject != id_ca  
		LIMIT 0,1 ) as testtable;
		
		IF testnombre = 0 THEN
			SET v_isterminal := 1;
		ELSE
			SELECT idobject 
			INTO v_idobject 
			FROM validpath
			WHERE idvp = id_vp  
			AND version = vers 
			AND idtrustdom = id_trustdom 
			AND idrootca = v_idcaroot
			AND idissuer = id_ca
			AND idobject != id_ca  
			LIMIT 0,1; 
		END IF;
		
		
		
		CALL getCAList(id_ca,id_vp,vers,id_trustdom,v_idcaroot,v_idca);
		
		SELECT ca.idca, ca.dn, ca.larstatus, ca.certnum, ca.enddate, ca.data, validpath.pathorder, v_isterminal as isterminal 
		FROM validpath, ca  
		WHERE idvp = id_vp  
		AND version = vers 
		AND idtrustdom = id_trustdom
		AND idrootca = v_idcaroot 
		AND validpath.idobject = ca.idca 
		AND ca.idca IN (SELECT * FROM temptablegetcalist)
		order by validpath.pathorder ;
	
	END;	
		
END IF;		

/*
//TODO a tester voir si mme chose ?

EXCEPTION
    WHEN OTHERS THEN
        ROLLBACK ;
			IF SQLCODE > -20000 THEN
				RAISE_APPLICATION_ERROR(-20001, '{Validation.getCacInfo:' || SQLERRM || '}') ;
			ELSE
				RAISE ;
			END IF ;	

*/
	
			
END $$



DROP FUNCTION IF EXISTS getDownloadtimeByDNAndSerial;
CREATE FUNCTION getDownloadtimeByDNAndSerial(iss_dn VARCHAR(500), cert_num VARCHAR(500)) 
	RETURNS DATETIME 
/* RKO : SYNTAXE OK */
BEGIN

DECLARE v_downloadtime DATETIME DEFAULT NULL;
DECLARE v_idcrl	INTEGER DEFAULT NULL;
DECLARE v_idca	INTEGER DEFAULT NULL;
DECLARE v_tableRevo VARCHAR(255) DEFAULT NULL;
DECLARE v_hascrlpublisher	INTEGER DEFAULT NULL;
DECLARE testnombre INTEGER DEFAULT 0;
	
	
SELECT idca 
INTO v_idca 
FROM ca
WHERE dn = iss_dn and iscrlpublisher='N';

/* verifier si on a un certificat emetteur de CRL (GIP-CPS)*/ 
	
		
		SELECT count(*) INTO testnombre FROM(
		SELECT hascrlpublisher
		FROM ca
		WHERE idca = v_idca 
		LIMIT 0,1 ) as testtable;
				
		
		IF testnombre = 0 THEN
			SET v_hascrlpublisher := NULL ;
		ELSE
			SELECT hascrlpublisher
			INTO v_hascrlpublisher
			FROM ca
			WHERE idca = v_idca 
			LIMIT 0,1;
		END IF;
		
		IF v_hascrlpublisher IS NOT NULL THEN
		/* on a un certificat emetteur de CRL */
			SET v_idca := v_hascrlpublisher;
		END IF;
			


/*
				SET @sql_text := "SELECT idcrl INTO v_idcrl FROM REVOLINE_";
				SET @sql_text2 := " WHERE certnum=";
				SET @sql_text3 := CONCAT(sql_text,v_idca,sql_text2,cert_num);
				
				PREPARE stmt FROM @sql_text3;
				EXECUTE stmt;
*/

			
		/*
		
		v_tableRevo :=  'SELECT idcrl from REVOLINE_' || v_idca || ' WHERE certnum =' || cert_num;
    execute immediate v_tableRevo INTO v_idcrl;
		*/
	
	SELECT downloadtime 
	INTO v_downloadtime 
	FROM crl
	WHERE idcrl = v_idcrl;
	
	RETURN v_downloadtime;
		

END $$		
		
		
		
		
		
		
		
		
		
		
		
		
		
DROP FUNCTION IF EXISTS getDownloadtimeByDN;
CREATE FUNCTION getDownloadtimeByDN(iss_dn VARCHAR(500)) 
	RETURNS DATETIME 
BEGIN


/* SYNTAXE OK */

DECLARE v_downloadtime DATETIME DEFAULT NULL;
DECLARE v_idcrl INTEGER DEFAULT NULL ;
DECLARE v_idca	INTEGER DEFAULT NULL;
DECLARE v_selfcrl 	VARCHAR(1) DEFAULT 'N';
DECLARE v_hascrlpublisher	INTEGER DEFAULT NULL;
DECLARE testnombre INTEGER DEFAULT 0;


SELECT idca 
INTO v_idca 
FROM ca
WHERE dn = iss_dn and iscrlpublisher='N';	

/* verifier si on a un certificat emetteur de CRL (GIP-CPS)*/ 


	SELECT count(*) INTO testnombre FROM (
		SELECT hascrlpublisher
		FROM ca
		WHERE idca = v_idca 
		LIMIT 0,1) as testable1 ;
	
	IF testnombre = 0 THEN
		SET v_hascrlpublisher := NULL ;
	ELSE
		SELECT hascrlpublisher
		INTO v_hascrlpublisher
		FROM ca
		WHERE idca = v_idca 
		LIMIT 0,1;
	END IF;



	IF v_hascrlpublisher IS NOT NULL THEN
	/* on a un certificat emetteur de CRL */
		SET v_idca := v_hascrlpublisher;
	END IF;
	
	
		SELECT count(*) INTO testnombre FROM
		(SELECT idcrl
		FROM icrl
		WHERE idcertissuer = v_idca 
		LIMIT 0,1 ) as testtable2;
		
			IF testnombre = 0 THEN
				SET v_selfcrl := 'Y' ;
			ELSE
				SELECT idcrl
				INTO v_idcrl
				FROM icrl
				WHERE idcertissuer = v_idca 
				LIMIT 0,1;	
			END IF;
	
	
	IF (v_selfcrl = 'Y') THEN
		SELECT max(downloadtime) 
		INTO v_downloadtime 
		FROM crl
		WHERE idcrlissuer = v_idca
		group by idcrlissuer ;
	ELSE
		SELECT max(downloadtime)
		INTO v_downloadtime 
		FROM crl, icrl 
		WHERE	idcertissuer = v_idca
		AND crl.idcrl = icrl.idcrl 
		group by crl.idcrlissuer ;
	END IF;	
	
	return v_downloadtime;
			
END	$$
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
DROP PROCEDURE IF EXISTS getRevoInfo;
CREATE PROCEDURE getRevoInfo(IN iss_key VARCHAR(500), IN iss_dn VARCHAR(500), IN halgo VARCHAR(500), IN cert_num VARCHAR(500))
	
BEGIN

DECLARE v_code INTEGER DEFAULT 0 ;
DECLARE v_thisUpdate DATETIME DEFAULT NULL ;
DECLARE v_nextUpdate DATETIME DEFAULT NULL ;
DECLARE v_revoDate DATETIME DEFAULT NULL ;
DECLARE v_reason VARCHAR(1) DEFAULT NULL ;
DECLARE v_tableRevo VARCHAR(255) DEFAULT NULL ;

DECLARE v_idca INTEGER DEFAULT NULL;
DECLARE v_status 	VARCHAR(1) DEFAULT NULL;
DECLARE v_selfcrl 	VARCHAR(1) DEFAULT 'N';
DECLARE v_idcrl		INTEGER DEFAULT NULL ;
DECLARE v_idcrlissuer	INTEGER DEFAULT NULL;
DECLARE v_hascrlpublisher	INTEGER DEFAULT NULL;
DECLARE testnombre INTEGER DEFAULT 0;

DECLARE EXIT HANDLER FOR SQLEXCEPTION ROLLBACK;

DROP TABLE IF EXISTS temptablegetrevoinfo;
CREATE TABLE temptablegetrevoinfo( code INTEGER, thisUpdate DATETIME, nextUpdate DATETIME, revoDate DATETIME, reason VARCHAR(1));





		
	/* rechercher le CA du certificat */
	
		
		
		
		SELECT count(*) into testnombre FROM(	
		SELECT idca
		FROM hashca
		WHERE hpk = iss_key  AND hdn = iss_dn AND algo = halgo) as testtable1;
		
		IF testnombre = 0 THEN
			SET v_idca := NULL ;
		ELSE
			SELECT idca
			INTO v_idca
			FROM hashca
			WHERE hpk = iss_key  AND hdn = iss_dn AND algo = halgo;
		END IF;
		
	
	IF v_idca IS NULL THEN
		/* si CA n'est pas dans la base */
		SET v_code := 1;
		SET v_thisUpdate := sysdate();
	ELSE
		
		
		/* verifier si on a un certificat emetteur de CRL (GIP-CPS)*/ 
		
		SELECT count(*) INTO testnombre from(		
			SELECT hascrlpublisher
			
			FROM ca
			WHERE idca = v_idca 
			LIMIT 0,1) as testtable2 ;
		


		IF testnombre = 0 THEN
			SET v_hascrlpublisher := NULL ;	
		ELSE
			SELECT hascrlpublisher
			INTO v_hascrlpublisher
			FROM ca
			WHERE idca = v_idca 
			LIMIT 0,1;
		END IF;
			
		
		
		IF v_hascrlpublisher IS NOT NULL THEN
		/* on a un certificat emetteur de CRL */
		SET v_idca := v_hascrlpublisher;
		END IF;

		
		/* verifier le statut du ca */
		SELECT status 
		INTO v_status 
		FROM ca
		WHERE idca = v_idca;
		
		/* si le statut du CA est en 'A' ou 'E' */
		IF (v_status = 'E' OR v_status = 'A') THEN
			SET v_code := 2;
		END IF;
		
		/*statut try later*/
		IF v_status = 'M' THEN
			SET v_code := 3;
		END IF;
		
		/* si le statut du CA est en 'S'*/
		IF v_status = 'S' THEN
			SET v_code := 6;
		END IF;
										
			
		/* v_code = 0 par initialisation */
		
		/* verifier si CA signe la LCR : v_selfcrl est initialise a 'N' */ 
		SELECT count(*) INTO testnombre from(
			SELECT idcrlissuer
			FROM icrl
			WHERE idcertissuer = v_idca 
			LIMIT 0,1 ) as testtable3;
			
		IF testnombre = 0 THEN
			SET v_selfcrl := 'Y';
		ELSE
			SELECT idcrlissuer
			INTO v_idcrlissuer
			FROM icrl
			WHERE idcertissuer = v_idca 
			LIMIT 0,1 ;
		END IF ;
			
			
			
		
		
	END IF;	
	
	
	
	IF (v_code = 0) THEN 
		IF (v_selfcrl = 'Y') THEN
			/* acces direct dans la table revoline par (idcertissuer, certnum) */
			BEGIN			
				
				DECLARE EXIT HANDLER FOR NOT FOUND 
				BEGIN
					SET v_code := 4;
					SELECT max(thisUpdate),max(nextUpdate)
					INTO v_thisUpdate, v_nextUpdate
					FROM crl
					WHERE idcrlissuer = v_idca
					GROUP BY idcrlissuer;
				END;
				
				
				SET @sql_text := "SELECT idcrl,revodate,reason INTO v_idcrl, v_revodate, v_reason FROM REVOLINE_";
				SET @sql_text2 := " WHERE certnum=";
				SET @sql_text3 := CONCAT(sql_text,v_idca,sql_text2,cert_num);
				
				PREPARE stmt FROM @sql_text3;
				EXECUTE stmt;
				
				/*v_tableRevo :=  'SELECT idcrl, revodate, reason from REVOLINE_' || v_idca || ' WHERE certnum =' || cert_num;
        		execute immediate v_tableRevo INTO v_idcrl, v_revodate, v_reason;*/
				
			/*
				TODO : a tester voir si mme chose
				
				
			
			EXCEPTION
				WHEN NO_DATA_FOUND THEN 
					v_code := 4 ;	-- GOOD
					SELECT max(thisUpdate), max(nextUpdate) 
					INTO v_thisUpdate, v_nextUpdate 
					FROM crl
					WHERE	idcrlissuer = v_idca
					group by idcrlissuer ;
			END;
			
			*/
		
		
			IF v_idcrl IS NOT NULL THEN 
				SET v_code := 5;	-- REVOKED
				SELECT thisUpdate, nextUpdate
				INTO v_thisUpdate, v_nextUpdate 
				FROM crl
				WHERE	idcrl = v_idcrl;
			END IF;
		END ;
		ELSE
			/* acces direct dans la table revoline par (idcertissuer, certnum) */
			BEGIN			
				
				
				DECLARE EXIT HANDLER FOR NOT FOUND 
				BEGIN
					SET v_code := 4;
					SELECT max(thisUpdate),max(nextUpdate)
					INTO v_thisUpdate, v_nextUpdate
					FROM crl,icrl
					WHERE idcrlissuer = v_idca
					AND 
					crl.idcrl = icrl.idcrl
					GROUP BY idcrlissuer;
				END;
				
				
				SET @sql_text := "SELECT idcrl,revodate,reason INTO v_idcrl, v_revodate, v_reason FROM REVOLINE_";
				SET @sql_text2 := " WHERE certnum=";
				SET @sql_text3 := CONCAT(sql_text,v_idca,sql_text2,cert_num);
				
				PREPARE stmt FROM @sql_text3;
				EXECUTE stmt;
				
				
				/*
				v_tableRevo :=  'SELECT idcrl, revodate, reason from REVOLINE_' || v_idca || ' WHERE certnum =' || cert_num;
        		execute immediate v_tableRevo INTO v_idcrl, v_revodate, v_reason;*/
        		
				
			/* 
				TODO : A tester
			EXCEPTION
				WHEN NO_DATA_FOUND THEN 
					v_code := 4 ;	-- GOOD
					SELECT max(thisUpdate), max(nextUpdate)
					INTO v_thisUpdate, v_nextUpdate 
					FROM crl, icrl 
					WHERE	idcertissuer = v_idca
					AND crl.idcrl = icrl.idcrl 
					group by crl.idcrlissuer ;
					*/
			END;
		
			IF v_idcrl IS NOT NULL THEN 
				SET v_code := 5;	-- REVOKED
				SELECT thisUpdate, nextUpdate
				INTO v_thisUpdate, v_nextUpdate
				FROM crl
				WHERE	idcrl = v_idcrl;
			END IF;

		END IF;			
		
	END IF;
	
	
	/* A METTRE DANS LA TABLE TEMPORAIRE !!!! */
	INSERT INTO temptablegetrevoinfo VALUES (v_code, v_thisUpdate, v_nextUpdate, v_revoDate, v_reason);
	/*resultat.extend();
	resultat(1) := RevoInfoType(v_code, v_thisUpdate, v_nextUpdate, v_revoDate, v_reason);*/
	
	SELECT * FROM temptablegetrevoinfo;

	/* A TRAITER !!!! 
EXCEPTION
    WHEN OTHERS THEN
        ROLLBACK ;
			IF SQLCODE > -20000 THEN
				RAISE_APPLICATION_ERROR(-20001, '{Validation.getRevoInfo:' || SQLERRM || '}') ;
			ELSE
				RAISE ;
			END IF ;
			
			
			*/
END $$
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		DELIMITER ;