use svc;

DELIMITER $$

DROP PROCEDURE IF EXISTS getListCRL;
CREATE PROCEDURE getListCRL()
BEGIN

	SELECT idcrlissuer, idcrl, url, thisupdate, nextupdate, nextpoll
	FROM crl
	WHERE nextpoll is not null ;

END $$




DROP PROCEDURE IF EXISTS getListCRLFromCA;
CREATE PROCEDURE getListCRLFromCA (IN v_idcertissuer INTEGER)
BEGIN

	DECLARE v_idcrlissuer INTEGER ;
	DECLARE v_selfcrl VARCHAR(10) DEFAULT 'N';

	SET v_idcrlissuer:=v_idcertissuer;
		/* verifier si CA signe la LCR : v_selfcrl est initialise a 'N' */
    SELECT idcrlissuer
    INTO v_idcrlissuer
    FROM icrl WHERE idcertissuer = v_idcertissuer LIMIT 0,1;

    IF v_idcrlissuer = v_idcertissuer THEN
		SET v_selfcrl := "Y";
    END IF;

	IF v_selfcrl = "Y" THEN
		SELECT idcrl, idcrlissuer, type, thisupdate, nextupdate, nextpoll, valext, 'Valide' as status, errormsg, url
		FROM crl
	   	WHERE idcrlissuer = v_idcertissuer
		AND idcrl not in (select idcrl from icrl where idcrlissuer = v_idcertissuer)
		AND thisupdate <= sysdate() AND nextupdate >= sysdate()
		UNION
		SELECT idcrl, idcrlissuer, type, thisupdate, nextupdate, nextpoll, valext,'Invalide' as status, errormsg,url
		FROM crl
	   	WHERE idcrlissuer = v_idcertissuer
		AND idcrl not in (select idcrl from icrl where idcrlissuer = v_idcertissuer)
		AND ( thisupdate > sysdate() OR nextupdate < sysdate() OR thisupdate is null OR nextupdate is null );
	ELSE
		SELECT crl.idcrl, crl.idcrlissuer, type, thisupdate, nextupdate, nextpoll, valext, 'Valide' as status, errormsg, url
		FROM crl, icrl
		WHERE icrl.idcertissuer = v_idcertissuer
		AND icrl.idcrl = crl.idcrl
		AND thisupdate <= sysdate() AND nextupdate >= sysdate()
		UNION
		SELECT crl.idcrl, crl.idcrlissuer, type, thisupdate, nextupdate, nextpoll, valext, 'Invalide' as status, errormsg, url
		FROM crl, icrl
		WHERE icrl.idcertissuer = v_idcertissuer
		AND icrl.idcrl = crl.idcrl
		AND ( thisupdate > sysdate() OR nextupdate < sysdate() OR thisupdate is null OR nextupdate is null );	
	END IF;	
END$$





DROP PROCEDURE IF EXISTS getLastestCRLFileFromCA;
CREATE PROCEDURE getLastestCRLFileFromCA(IN v_idcertissuer INTEGER)

BEGIN

DECLARE v_selfcrl VARCHAR(1) DEFAULT "N" ;
DECLARE v_idcrlissuer INTEGER;

SET v_idcrlissuer := v_idcertissuer;

		SELECT idcrlissuer
		INTO v_idcrlissuer
		FROM icrl
		WHERE idcertissuer = v_idcertissuer
		LIMIT 0,1 ;
	
	IF v_idcrlissuer = v_idcertissuer THEN
		SET v_selfcrl := "Y";
    END IF;

	IF v_selfcrl = "Y" THEN

		
			select date_format(hcrl.thisupdate,'%d/%m/%Y %T'), max(hcrl.data)
			from crl, hcrl
			where crl.idcrl = hcrl.idcrl
			and crl.thisupdate = hcrl.thisupdate
			and idcrlissuer = v_idcrlissuer
			AND crl.idcrl not in (select idcrl from icrl where idcrlissuer = v_idcertissuer)
			group by hcrl.idcrl,hcrl.thisupdate ;
	ELSE

		
			select date_format(hcrl.thisupdate,'%d/%m/%Y %T'), max(hcrl.data)
			from crl, icrl, hcrl
			where crl.idcrl = icrl.idcrl
			and icrl.idcertissuer = v_idcertissuer
			and crl.idcrl = hcrl.idcrl
			and crl.thisupdate = hcrl.thisupdate
			group by hcrl.idcrl,hcrl.thisupdate ;

	END IF;

END$$



















DROP PROCEDURE IF EXISTS getListCRLFileFromCA;
CREATE PROCEDURE getListCRLFileFromCA (IN v_idcertissuer INTEGER, IN begindate VARCHAR(30), IN enddate VARCHAR(30))


BEGIN

DECLARE v_selfcrl VARCHAR(1) DEFAULT "N";
/* v_idcrlissuer = v_idcertissuer par defaut */
DECLARE v_idcrlissuer INTEGER ;

SET v_idcrlissuer := v_idcertissuer ;

	/* verifier si CA signe la LCR : v_selfcrl est initialise a 'N' */

		SELECT idcrlissuer
		INTO v_idcrlissuer
		FROM icrl
		WHERE idcertissuer = v_idcertissuer
		LIMIT 0,1;

		 IF v_idcrlissuer = v_idcertissuer THEN
			SET v_selfcrl := "Y";
		END IF;
		
		
	IF v_selfcrl = 'Y' THEN

		
			select date_format(hcrl.thisupdate,'%d/%m/%Y %T'),max(hcrl.data)
			from crl, hcrl
			where crl.idcrl = hcrl.idcrl
			and idcrlissuer = v_idcertissuer
			and hcrl.thisupdate >= str_to_date(begindate,'%d/%m/%Y')
			and hcrl.thisupdate <= str_to_date(enddate,'%d/%m/%Y')
			AND crl.idcrl not in (select idcrl from icrl where idcrlissuer = v_idcertissuer)
			group by hcrl.idcrl,hcrl.thisupdate
			order by hcrl.thisupdate ;
	ELSE

		
			select date_format(hcrl.thisupdate,'%d/%m/%Y %T'),max(hcrl.data)
			from crl, icrl, hcrl
			where crl.idcrl = icrl.idcrl
			and icrl.idcertissuer = v_idcertissuer
			and crl.idcrl = hcrl.idcrl
			and hcrl.thisupdate >= str_to_date(begindate,'%d/%m/%Y')
			and hcrl.thisupdate <= str_to_date(enddate,'%d/%m/%Y')
			group by hcrl.idcrl,hcrl.thisupdate
			order by hcrl.thisupdate ;

	END IF;

	

END $$





DROP PROCEDURE IF EXISTS getHistoricCRLFromCA;
CREATE PROCEDURE getHistoricCRLFromCA (IN v_idcertissuer INTEGER, IN begindate varchar(30), IN enddate varchar(30))

BEGIN        
DECLARE v_selfcrl VARCHAR(1) DEFAULT 'N';
/* v_idcrlissuer = v_idcertissuer par defaut */
DECLARE v_idcrlissuer INTEGER ;
SET v_idcrlissuer := v_idcertissuer;



	/* verifier si CA signe la LCR : v_selfcrl est initialise a 'N' */

		SELECT idcrlissuer
		INTO v_idcrlissuer
		FROM icrl
		WHERE idcertissuer = v_idcertissuer
		LIMIT 0,1;

		 IF v_idcrlissuer = v_idcertissuer THEN
		SET v_selfcrl := "Y";
    END IF;
		
		
	IF v_selfcrl = 'Y' THEN

		
			select hcrl.idcrl, hcrl.crlnum, hcrl.basenum,
			date_format(hcrl.thisupdate,'%d/%m/%Y %T') thisupdate,
			date_format(hcrl.nextupdate,'%d/%m/%Y %T') nextupdate,hcrl.data
			from crl, hcrl
			where crl.idcrl = hcrl.idcrl
			and idcrlissuer = v_idcertissuer
			and hcrl.thisupdate >= str_to_date(begindate,'%d/%m/%Y')
			and hcrl.thisupdate <= str_to_date(enddate,'%d/%m/%Y')
			AND crl.idcrl not in (select idcrl from icrl where idcrlissuer = v_idcertissuer)
			order by hcrl.thisupdate ;
	ELSE

		
			select hcrl.idcrl, hcrl.crlnum, hcrl.basenum,
			date_format(hcrl.thisupdate,'%d/%m/%Y %T') thisupdate,
			date_format(hcrl.nextupdate,'%d/%m/%Y %T') nextupdate,hcrl.data
			from crl, icrl, hcrl
			where crl.idcrl = icrl.idcrl
			and icrl.idcertissuer = v_idcertissuer
			and crl.idcrl = hcrl.idcrl
			and hcrl.thisupdate >= str_to_date(begindate,'%d/%m/%Y')
			and hcrl.thisupdate <= str_to_date(enddate,'%d/%m/%Y')
			order by hcrl.thisupdate ;

	END IF;

END $$





















DROP PROCEDURE IF EXISTS getListTypeCRLFromCA;
CREATE PROCEDURE getListTypeCRLFromCA (IN v_idcertissuer INTEGER)

BEGIN
DECLARE v_selfcrl VARCHAR(1) DEFAULT 'N';
/* v_idcrlissuer = v_idcertissuer par defaut */
DECLARE v_idcrlissuer	INTEGER;
SET v_idcrlissuer := v_idcertissuer;


	/* verifier si CA signe la LCR : v_selfcrl est initialise a 'N' */
	
		SELECT idcrlissuer
		INTO v_idcrlissuer
		FROM icrl
		WHERE idcertissuer = v_idcertissuer
		LIMIT 0,1 ;
	
	
	 IF v_idcrlissuer = v_idcertissuer THEN
		SET v_selfcrl := "Y";
    END IF;

	IF v_selfcrl = 'Y' THEN


			select type, count(idcrl) nbr
			from crl
			where idcrlissuer = v_idcertissuer
			AND idcrl not in (select idcrl from icrl where idcrlissuer = v_idcertissuer)
			group by type;
	ELSE


			SELECT type, count(crl.idcrl) nbr
			FROM crl, icrl
			WHERE icrl.idcertissuer = v_idcertissuer
			AND icrl.idcrl = crl.idcrl
			group by type;

	END IF;



END $$










































DROP PROCEDURE IF EXISTS getCAInfos;
CREATE PROCEDURE getCAInfos (IN v_idcrl INTEGER,
			IN v_idcrlissuer INTEGER)


BEGIN
			
DECLARE v_selfcrl VARCHAR(1) DEFAULT 'N';
DECLARE v_idca INTEGER DEFAULT 0;
DECLARE v_idcertissuer	INTEGER DEFAULT 0;
DECLARE v_status	VARCHAR(1) DEFAULT 'N';
DECLARE v_validity	INTEGER DEFAULT 0;
DECLARE v_pollinterval	INTEGER DEFAULT 0;
DECLARE v_iddom	INTEGER DEFAULT 0;
DECLARE v_valext INTEGER DEFAULT 0;
DECLARE v_dn VARCHAR(255);
DECLARE v_oidpc		VARCHAR(256) DEFAULT '';
DECLARE v_categorie	VARCHAR(150);
DECLARE v_type		VARCHAR(150);
DECLARE v_service       VARCHAR(150);
DECLARE v_niveau        INTEGER DEFAULT 0;



/* verifier si CA signe la LCR : v_selfcrl est initialise a 'N' */
	
		SELECT idcertissuer
		INTO v_idca
		FROM icrl
		WHERE idcrlissuer = v_idcrlissuer
		AND idcrl = v_idcrl ;
	
	
	 IF v_idcrlissuer = v_idcertissuer THEN
		SET v_selfcrl := "Y";
    END IF;


	IF v_selfcrl = 'Y' THEN
		BEGIN
		
		
			DECLARE testnombre INTEGER ;
			SELECT count(*) INTO testnombre
			FROM
				(SELECT idca, status, iddom, validity, pollinterval, dn
				
				FROM ca, policy
				WHERE ca.idpol = policy.idpol
				AND ca.idca = v_idcrlissuer) as testtable ;
			
			IF testnombre = 0 THEN
				SET v_idca := 0;
			ELSE
				SELECT idca, status, iddom, validity, pollinterval, dn
				INTO v_idca, v_status, v_iddom, v_validity, v_pollinterval, v_dn
				FROM ca, policy
				WHERE ca.idpol = policy.idpol
				AND ca.idca = v_idcrlissuer;
			END IF;
		
		END;
		
		
		
		
		
	ELSE
		/* si un autre CA signe la LCR */
		BEGIN
		
			DECLARE testnombre INTEGER ;
			
			SELECT count(*) INTO testnombre FROM
			(
			SELECT idca, status, iddom, validity, pollinterval, dn
			
			FROM ca, policy
			WHERE ca.idpol = policy.idpol
			AND ca.idca = v_idca ) as testtable;
			
			IF testnombre = 0 THEN
				SET v_idca := 0;
			ELSE
				SELECT idca, status, iddom, validity, pollinterval, dn
				INTO v_idca, v_status, v_iddom, v_validity, v_pollinterval, v_dn
				FROM ca, policy
				WHERE ca.idpol = policy.idpol
				AND ca.idca = v_idca;
			END IF;
		
		END;

	END IF;

	SELECT valext INTO v_valext
	FROM crl
	WHERE idcrl = v_idcrl;

        BEGIN
			DECLARE testnombre INTEGER;
			SELECT count(*) INTO testnombre FROM (
		
		
                SELECT pcparam.oidpc, categorie, pcparam.type, service, niveau
                FROM ca, pcparam
                WHERE ca.oidpc = pcparam.oidpc
                AND ca.idca = v_idcrlissuer ) as testtables;
				
			IF testnombre = 0 THEN
				SET v_oidpc := '';
			ELSE
				SELECT pcparam.oidpc, categorie, pcparam.type, service, niveau
                INTO v_oidpc, v_categorie, v_type, v_service, v_niveau
                FROM ca, pcparam
                WHERE ca.oidpc = pcparam.oidpc
                AND ca.idca = v_idcrlissuer ;
			END IF;
		END;
		
		SELECT v_idca AS IDCA, v_status AS STATUS, v_validity AS VALIDITY,
			v_pollinterval AS POLLINTERVAL, v_valext AS VALEXT, v_dn AS DN,
                        v_oidpc AS OIDPC, v_categorie AS PCATEGORY, v_type AS PTYPE, 
                        v_service AS SERVICE, v_niveau AS NIVEAU
		FROM DUAL ;

	

/*
SQL> var res refcursor;
SQL> exec :res := CRLInfo.getCAInfos(1,1);
*/

END $$





DELIMITER ;