<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" omit-xml-declaration="yes" encoding="UTF-8" indent="yes"/>

<!-- Transformation for table ca  -->


<xsl:template match="/">
 <xsl:apply-templates select="ROWSET"/>
</xsl:template>

<xsl:template match="ROWSET">
<table width="60%" border="1" cellspacing="1" cellpadding="1">
  <tr>
  
  <th>Nom</th>
  <th>OID</th>
  
  </tr>
  
  <xsl:if test="count(ROW) = 0">
  <tr><td align="center" colspan="4">Aucun extendedKeyUsage</td></tr>
  </xsl:if>
  
  
  <xsl:for-each select="ROW">
	  <tr>
	  <xsl:if test="(position() mod 2) = 0">
		  <xsl:attribute name="class">
		  <xsl:text>altern0</xsl:text>
		  </xsl:attribute>
	  </xsl:if>
	  <xsl:if test="(position() mod 2) = 1">
		  <xsl:attribute name="class">
		  <xsl:text>altern1</xsl:text>
		  </xsl:attribute>
	  </xsl:if>
	  
	
	  <td nowrap="true" align="center"><xsl:value-of select="name" /></td>
	  <td nowrap="true" align="left"><xsl:value-of select="oid" /></td>
	 
	  
	  </tr>
  </xsl:for-each>
  

</table>
</xsl:template>

</xsl:stylesheet>
