<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" omit-xml-declaration="yes" encoding="UTF-8" indent="yes"/>

<!-- Transformation for table crl  -->


<xsl:template match="/">
 <xsl:apply-templates select="ROWSET"/>
</xsl:template>

<xsl:template match="ROWSET">
<table width="100%" border="1" cellspacing="1" cellpadding="1">
  <tr>
  <th></th>
  <th>Identifiant</th>
  <th>Type</th>
  <th>ThisUpdate</th>
  <th>NextUpdate</th>
  <th>NextPoll</th>
  <th>Délai de grâce</th>
  <th>Statut</th>
  <th>Process</th>
  <th>Url</th>
  </tr>
  
  <xsl:if test="count(ROW) = 0">
  <tr><td align="center" colspan="8">Aucune LCR</td></tr>
  </xsl:if>
  
  <xsl:for-each select="ROW">
	  <tr>
		  <xsl:if test="(position() mod 2) = 0">
			  <xsl:attribute name="class">
			  <xsl:text>altern0</xsl:text>
			  </xsl:attribute>
		  </xsl:if>
		  <xsl:if test="(position() mod 2) = 1">
			  <xsl:attribute name="class">
			  <xsl:text>altern1</xsl:text>
			  </xsl:attribute>
		  </xsl:if>
		  <td nowrap="true" align="center"> 
	        <input type="radio" name="idcrl" >
	        <xsl:attribute name="value"><xsl:value-of select="idcrl"/></xsl:attribute>  	      
		 	<xsl:if test="(position()) = 1">
			  <xsl:attribute name="checked">
			  <xsl:text>checked</xsl:text>
			  </xsl:attribute>
		  	</xsl:if>
		 	</input>                
	      </td>
		  <td nowrap="true" align="center"><xsl:value-of select="idcrl" /></td>
		  <td nowrap="true" align="center"><xsl:value-of select="type" /></td>
		  <td nowrap="true" align="center"><xsl:value-of select="thisupdate" /></td>
		  <td nowrap="true" align="center"><xsl:value-of select="nextupdate" /></td>
		  <td nowrap="true" align="center"><xsl:value-of select="nextpoll" /></td>
		  <td nowrap="true" align="center"><xsl:value-of select="valext" /></td>
		  <td nowrap="true" align="center"><xsl:value-of select="status" /></td>
		  <td nowrap="true" align="center"><xsl:value-of select="errormsg" /></td>
		  <td nowrap="true" align="left">
			  <a href="{URL}">
			  <xsl:value-of select="URL" />
			  </a>
		  </td>
	  </tr>
  </xsl:for-each>
  

</table>
</xsl:template>

</xsl:stylesheet>
