<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:geonet="http://www.fao.org/geonetwork" xmlns:xalan="http://xml.apache.org/xalan">
	<xsl:include href="GS_metadata-iso19115Fra_2.xsl"/>
	<xsl:include href="GS_metadata-iso19115Fra_OpView.xsl"/>
	<!--
	default: in simple mode just a flat list
	-->
	<xsl:template mode="iso19115Fra" match="*|@*">
		<xsl:param name="schema"/>
		<xsl:param name="edit"/>
		<xsl:param name="title"/>
		<!-- do not show empty elements in view mode -->
		<xsl:choose>
			<xsl:when test="$edit=true()">
				<xsl:apply-templates mode="element" select=".">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="true()"/>
					<xsl:with-param name="title" select="$title"/>
					<xsl:with-param name="flat" select="$currTab='simple'"/>
				</xsl:apply-templates>
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="empty">
					<xsl:apply-templates mode="iso19115FraIsEmpty" select="."/>
				</xsl:variable>
				<xsl:if test="$empty!=''">
					<xsl:apply-templates mode="element" select=".">
						<xsl:with-param name="schema" select="$schema"/>
						<xsl:with-param name="edit" select="false()"/>
						<xsl:with-param name="title" select="$title"/>
						<xsl:with-param name="flat" select="$currTab='simple'"/>
					</xsl:apply-templates>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	these elements should be boxed
	-->
	<xsl:template mode="iso19115Fra" match="mdContact|dataIdInfo|distInfo|graphOver|spatRepInfo|idPoC|onLineSrc|dqInfo|refSysInfo|equScale|projection|ellipsoid|dataExt|geoBox|distributor|FC_FeatureCatalogue|frRefConstraints|gfc_producer">
		<xsl:param name="schema"/>
		<xsl:param name="edit"/>
		<xsl:apply-templates mode="complexElement" select=".">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
		</xsl:apply-templates>
	</xsl:template>
	<!--
	Metadata
	-->
	<xsl:template mode="iso19115Fra" match="Metadata">
		<xsl:param name="schema"/>
		<xsl:param name="edit"/>
		<xsl:choose>
			<!-- metadata tab -->
			<xsl:when test="$currTab='metadata'">						
			<xsl:call-template name="iso19115FraMetadata">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="$edit"/>
				</xsl:call-template>				
			</xsl:when>
			<!-- identification tab -->
			<xsl:when test="$currTab='identification'">
				<xsl:call-template name="iso19115FraIdentification">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="$edit"/>
				</xsl:call-template>
			</xsl:when>
			<!-- maintenance tab -->
			<xsl:when test="$currTab='maintenance'">
				<xsl:apply-templates mode="elementEP" select="dataIdInfo/resMaint|dataIdInfo/geonet:child[string(@name)='resMaint']">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="$edit"/>
				</xsl:apply-templates>
			</xsl:when>
			<!-- constraints tab -->
			<xsl:when test="$currTab='constraints'">
				<xsl:apply-templates mode="elementEP" select="dataIdInfo/resConst|dataIdInfo/geonet:child[string(@name)='resConst']">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="$edit"/>
				</xsl:apply-templates>
			</xsl:when>
			<!-- spatial tab -->
			<xsl:when test="$currTab='spatial'">
				<xsl:call-template name="iso19115FraSpatial">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="$edit"/>
				</xsl:call-template>
			</xsl:when>
			<!-- spatial2 tab -->
			<xsl:when test="$currTab='spatial2'">
				<xsl:apply-templates mode="elementEP" select="spatRepInfo|geonet:child[string(@name)='spatRepInfo']">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="$edit"/>
				</xsl:apply-templates>
			</xsl:when>
			<!-- refSys tab -->
			<xsl:when test="$currTab='refSys'">
				<xsl:apply-templates mode="elementEP" select="refSysInfo|geonet:child[string(@name)='refSysInfo']">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="$edit"/>
				</xsl:apply-templates>
			</xsl:when>
			<!-- distribution tab -->
			<xsl:when test="$currTab='distribution'">
				<xsl:apply-templates mode="elementEP" select="distInfo|geonet:child[string(@name)='distInfo']">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="$edit"/>
				</xsl:apply-templates>
			</xsl:when>
			<!-- dataQuality tab -->
			<xsl:when test="$currTab='dataQuality'">
				<xsl:apply-templates mode="elementEP" select="dqInfo|geonet:child[string(@name)='dqInfo']">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="$edit"/>
				</xsl:apply-templates>
			</xsl:when>
			<!-- appSchInfo tab -->
			<xsl:when test="$currTab='appSchInfo'">
				<xsl:apply-templates mode="elementEP" select="appSchInfo|geonet:child[string(@name)='appSchInfo']">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="$edit"/>
				</xsl:apply-templates>
			</xsl:when>
			<!-- porCatInfo tab -->
			<xsl:when test="$currTab='porCatInfo'">
				<xsl:apply-templates mode="elementEP" select="porCatInfo|geonet:child[string(@name)='porCatInfo']">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="$edit"/>
				</xsl:apply-templates>
			</xsl:when>
			<!-- featCatInfo tab -->
			<xsl:when test="$currTab='featCatInfo'">
				<!--
        <xsl:apply-templates mode="iso19115Fra" select="FC_FeatureCatalogue|geonet:child[string(@name)='FC_FeatureCatalogue']">
          <xsl:with-param name="schema" select="$schema"/>
          <xsl:with-param name="edit"   select="$edit"/>
        </xsl:apply-templates>
 -->
				<xsl:apply-templates mode="elementEP" select="FC_FeatureCatalogue|geonet:child[string(@name)='FC_FeatureCatalogue']">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="$edit"/>
				</xsl:apply-templates>
			</xsl:when>
			<!-- metadata OpView tab -->
			<xsl:when test="$currTab='onglet_1'">
				<xsl:call-template name="iso19115Fra_onglet_1">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="$edit"/>
				</xsl:call-template>
			</xsl:when>
			<!-- desc data OpView tab -->
			<xsl:when test="$currTab='onglet_2'">
				<xsl:call-template name="iso19115Fra_onglet_2">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="$edit"/>
				</xsl:call-template>
			</xsl:when>
			<!-- others data OpView tab -->
			<xsl:when test="$currTab='onglet_3'">
				<xsl:call-template name="iso19115Fra_onglet_3">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="$edit"/>
				</xsl:call-template>
			</xsl:when>
			<!-- dataQuality OpView tab -->
			<xsl:when test="$currTab='onglet_4'">
				<xsl:call-template name="iso19115Fra_onglet_4">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="$edit"/>
				</xsl:call-template>
			</xsl:when>
			<!-- distribution OpView tab -->
			<xsl:when test="$currTab='onglet_5'">
				<xsl:call-template name="iso19115Fra_onglet_5">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="$edit"/>
				</xsl:call-template>
			</xsl:when>
			<!-- print tab-->
			<xsl:when test="$currTab='print'">
			<xsl:call-template name="iso19115Fra_onglet_1">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="$edit"/>
				</xsl:call-template>
				<xsl:call-template name="iso19115Fra_onglet_2">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="$edit"/>
				</xsl:call-template>
				<xsl:call-template name="iso19115Fra_onglet_3">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="$edit"/>
				</xsl:call-template>
				<xsl:call-template name="iso19115Fra_onglet_4">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="$edit"/>
				</xsl:call-template>
				<xsl:call-template name="iso19115Fra_onglet_5">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="$edit"/>
				</xsl:call-template>
			</xsl:when>	
			
			
			<!-- default -->
			<xsl:otherwise>
				<xsl:call-template name="iso19115Fra_onglet_1">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="$edit"/>
					<xsl:with-param name="flat" select="$currTab='simple'"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="iso19115FraSimple">
		<xsl:param name="schema"/>
		<xsl:param name="edit"/>
		<xsl:param name="flat"/>
		<xsl:apply-templates mode="elementEP" select="dataIdInfo|geonet:child[string(@name)='dataIdInfo']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
			<xsl:with-param name="flat" select="$flat"/>
		</xsl:apply-templates>
		<xsl:apply-templates mode="elementEP" select="distInfo|geonet:child[string(@name)='distInfo']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
			<xsl:with-param name="flat" select="$flat"/>
		</xsl:apply-templates>
		<xsl:apply-templates mode="elementEP" select="spatRepInfo|geonet:child[string(@name)='spatRepInfo']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
			<xsl:with-param name="flat" select="$flat"/>
		</xsl:apply-templates>
		<xsl:apply-templates mode="elementEP" select="refSysInfo|geonet:child[string(@name)='refSysInfo']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
			<xsl:with-param name="flat" select="$flat"/>
		</xsl:apply-templates>
		<xsl:apply-templates mode="elementEP" select="appSchInfo|geonet:child[string(@name)='appSchInfo']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
			<xsl:with-param name="flat" select="$flat"/>
		</xsl:apply-templates>
		<xsl:apply-templates mode="elementEP" select="porCatInfo|geonet:child[string(@name)='porCatInfo']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
			<xsl:with-param name="flat" select="$flat"/>
		</xsl:apply-templates>
		<xsl:apply-templates mode="elementEP" select="dqInfo|geonet:child[string(@name)='dqInfo']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
			<xsl:with-param name="flat" select="$flat"/>
		</xsl:apply-templates>
		<xsl:call-template name="complexElementGui">
			<xsl:with-param name="title" select="/root/gui/strings/metadata"/>
			<xsl:with-param name="content">
				<xsl:call-template name="iso19115FraSimple2">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="$edit"/>
					<xsl:with-param name="flat" select="$flat"/>
				</xsl:call-template>
			</xsl:with-param>
			<xsl:with-param name="schema" select="$schema"/>
		</xsl:call-template>
		<xsl:apply-templates mode="elementEP" select="contInfo|geonet:child[string(@name)='contInfo']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
			<xsl:with-param name="flat" select="$flat"/>
		</xsl:apply-templates>
		<xsl:apply-templates mode="elementEP" select="mdExtInfo|geonet:child[string(@name)='mdExtInfo']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
			<xsl:with-param name="flat" select="$flat"/>
		</xsl:apply-templates>
	</xsl:template>
	<xsl:template name="iso19115FraSimple2">
		<xsl:param name="schema"/>
		<xsl:param name="edit"/>
		<xsl:param name="flat"/>
		<xsl:apply-templates mode="elementEP" select="mdFileID|geonet:child[string(@name)='mdFileID']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
			<xsl:with-param name="flat" select="$flat"/>
		</xsl:apply-templates>
		<xsl:apply-templates mode="elementEP" select="mdLang|geonet:child[string(@name)='mdLang']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
			<xsl:with-param name="flat" select="$flat"/>
		</xsl:apply-templates>
		<xsl:apply-templates mode="elementEP" select="mdChar|geonet:child[string(@name)='mdChar']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
			<xsl:with-param name="flat" select="$flat"/>
		</xsl:apply-templates>
		<xsl:apply-templates mode="elementEP" select="mdParentID|geonet:child[string(@name)='mdParentID']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
			<xsl:with-param name="flat" select="$flat"/>
		</xsl:apply-templates>
		<xsl:apply-templates mode="elementEP" select="mdHrLv|geonet:child[string(@name)='mdHrLv']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
			<xsl:with-param name="flat" select="$flat"/>
		</xsl:apply-templates>
		<xsl:apply-templates mode="elementEP" select="mdHrLvName|geonet:child[string(@name)='mdHrLvName']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
			<xsl:with-param name="flat" select="$flat"/>
		</xsl:apply-templates>
		<xsl:apply-templates mode="elementEP" select="mdDateSt|geonet:child[string(@name)='mdDateSt']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
			<xsl:with-param name="flat" select="$flat"/>
		</xsl:apply-templates>
		<xsl:apply-templates mode="elementEP" select="mdStanName|geonet:child[string(@name)='mdStanName']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
			<xsl:with-param name="flat" select="$flat"/>
		</xsl:apply-templates>
		<xsl:apply-templates mode="elementEP" select="mdStanVer|geonet:child[string(@name)='mdStanVer']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
			<xsl:with-param name="flat" select="$flat"/>
		</xsl:apply-templates>
		<xsl:apply-templates mode="elementEP" select="mdConst|geonet:child[string(@name)='mdConst']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
			<xsl:with-param name="flat" select="$flat"/>
		</xsl:apply-templates>
		<xsl:apply-templates mode="elementEP" select="mdMaint|geonet:child[string(@name)='mdMaint']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
			<xsl:with-param name="flat" select="$flat"/>
		</xsl:apply-templates>
		<xsl:apply-templates mode="elementEP" select="mdContact|geonet:child[string(@name)='mdContact']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
			<xsl:with-param name="flat" select="$flat"/>
		</xsl:apply-templates>
	</xsl:template>
	<xsl:template name="iso19115FraMetadata">
		<xsl:param name="schema"/>
		<xsl:param name="edit"/>
		<xsl:apply-templates mode="elementEP" select="mdFileID|geonet:child[string(@name)='mdFileID']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
		</xsl:apply-templates>
		<xsl:apply-templates mode="elementEP" select="mdLang|geonet:child[string(@name)='mdLang']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
		</xsl:apply-templates>
		<xsl:apply-templates mode="elementEP" select="mdChar|geonet:child[string(@name)='mdChar']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
		</xsl:apply-templates>
		<xsl:apply-templates mode="elementEP" select="mdParentID|geonet:child[string(@name)='mdParentID']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
		</xsl:apply-templates>
		<xsl:apply-templates mode="elementEP" select="mdHrLv|geonet:child[string(@name)='mdHrLv']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
		</xsl:apply-templates>
		<xsl:apply-templates mode="elementEP" select="mdHrLvName|geonet:child[string(@name)='mdHrLvName']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
		</xsl:apply-templates>
		<xsl:apply-templates mode="elementEP" select="mdDateSt|geonet:child[string(@name)='mdDateSt']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
		</xsl:apply-templates>
		<xsl:apply-templates mode="elementEP" select="mdStanName|geonet:child[string(@name)='mdStanName']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
		</xsl:apply-templates>
		<xsl:apply-templates mode="elementEP" select="mdStanVer|geonet:child[string(@name)='mdStanVer']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
		</xsl:apply-templates>
		<xsl:apply-templates mode="elementEP" select="mdContact|geonet:child[string(@name)='mdContact']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
		</xsl:apply-templates>
		<xsl:apply-templates mode="elementEP" select="contInfo|geonet:child[string(@name)='contInfo']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
		</xsl:apply-templates>
		<xsl:apply-templates mode="elementEP" select="mdExtInfo|geonet:child[string(@name)='mdExtInfo']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
		</xsl:apply-templates>
		<xsl:apply-templates mode="elementEP" select="mdConst|geonet:child[string(@name)='mdConst']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
		</xsl:apply-templates>
		<xsl:apply-templates mode="elementEP" select="mdMaint|geonet:child[string(@name)='mdMaint']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
		</xsl:apply-templates>
	</xsl:template>
	<xsl:template name="iso19115FraIdentification">
		<xsl:param name="schema"/>
		<xsl:param name="edit"/>
		<xsl:apply-templates mode="elementEP" select="dataIdInfo/idCitation/resTitle|dataIdInfo/geonet:child[string(@name)='resTitle']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
		</xsl:apply-templates>
		<xsl:apply-templates mode="elementEP" select="dataIdInfo/idCitation/resAltTitle|dataIdInfo/idCitation/geonet:child[string(@name)='resAltTitle']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
		</xsl:apply-templates>
		<xsl:apply-templates mode="elementEP" select="dataIdInfo/idCitation/resEd|dataIdInfo/idCitation/geonet:child[string(@name)='resEd']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
		</xsl:apply-templates>
		<xsl:apply-templates mode="elementEP" select="dataIdInfo/idCitation/resRefDate|dataIdInfo/idCitation/geonet:child[string(@name)='resRefDate']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
		</xsl:apply-templates>
		<xsl:apply-templates mode="elementEP" select="dataIdInfo/idPoC|dataIdInfo/geonet:child[string(@name)='idPoC']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
		</xsl:apply-templates>
		<xsl:apply-templates mode="elementEP" select="dataIdInfo/idAbs|dataIdInfo/geonet:child[string(@name)='idAbs']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
		</xsl:apply-templates>
		<xsl:apply-templates mode="elementEP" select="dataIdInfo/suppInfo|dataIdInfo/geonet:child[string(@name)='suppInfo']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
		</xsl:apply-templates>
		<xsl:apply-templates mode="elementEP" select="dataIdInfo/idPurp|dataIdInfo/geonet:child[string(@name)='idPurp']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
		</xsl:apply-templates>
		<xsl:apply-templates mode="elementEP" select="dataIdInfo/idCredit|dataIdInfo/geonet:child[string(@name)='idCredit']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
		</xsl:apply-templates>
		<xsl:apply-templates mode="elementEP" select="dataIdInfo/status|dataIdInfo/geonet:child[string(@name)='status']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
		</xsl:apply-templates>
		<xsl:apply-templates mode="elementEP" select="dataIdInfo/resMaint|dataIdInfo/geonet:child[string(@name)='resMaint']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
		</xsl:apply-templates>
		<xsl:apply-templates mode="elementEP" select="dataIdInfo/tpCat|dataIdInfo/geonet:child[string(@name)='tpCat']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
		</xsl:apply-templates>
		<xsl:apply-templates mode="elementEP" select="dataIdInfo/descKeys|dataIdInfo/geonet:child[string(@name)='descKeys']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
		</xsl:apply-templates>
		<xsl:apply-templates mode="elementEP" select="dataIdInfo/graphOver|dataIdInfo/geonet:child[string(@name)='graphOver']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
		</xsl:apply-templates>
		<xsl:apply-templates mode="elementEP" select="spatRepInfo|geonet:child[string(@name)='spatRepInfo']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
		</xsl:apply-templates>
		<xsl:apply-templates mode="elementEP" select="dataIdInfo/spatRpType|dataIdInfo/geonet:child[string(@name)='spatRpType']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
		</xsl:apply-templates>
		<xsl:apply-templates mode="elementEP" select="dataIdInfo/dataScale|dataIdInfo/geonet:child[string(@name)='dataScale']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
		</xsl:apply-templates>
		<xsl:apply-templates mode="elementEP" select="dataIdInfo/geoBox|dataIdInfo/geonet:child[string(@name)='geoBox']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
		</xsl:apply-templates>
		<xsl:apply-templates mode="elementEP" select="dataIdInfo/geoDesc|dataIdInfo/geonet:child[string(@name)='geoDesc']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
		</xsl:apply-templates>
		<!--SILOGIC-->
		<xsl:apply-templates mode="GS_elementEP" select="dataIdInfo/dataExt|dataIdInfo/geonet:child[string(@name)='dataExt']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
			<xsl:with-param name="title" select="/root/gui/strings/GS/dataExt"/>
		</xsl:apply-templates>
		<!--FIN SILOGIC-->
	</xsl:template>
	<xsl:template name="iso19115FraSpatial">
		<xsl:param name="schema"/>
		<xsl:param name="edit"/>
		<xsl:apply-templates mode="elementEP" select="dataIdInfo/spatRpType|dataIdInfo/geonet:child[string(@name)='spatRpType']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
		</xsl:apply-templates>
		<xsl:apply-templates mode="elementEP" select="dataIdInfo/dataScale|dataIdInfo/geonet:child[string(@name)='dataScale']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
		</xsl:apply-templates>
		<xsl:apply-templates mode="elementEP" select="dataIdInfo/geoBox|dataIdInfo/geonet:child[string(@name)='geoBox']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
		</xsl:apply-templates>
		<xsl:apply-templates mode="elementEP" select="dataIdInfo/geoDesc|dataIdInfo/geonet:child[string(@name)='geoDesc']">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
		</xsl:apply-templates>
	</xsl:template>
	<xsl:template name="iso19115FraDataQuality">
		<xsl:param name="schema"/>
		<xsl:param name="edit"/>
		<xsl:param name="flat"/>
		<xsl:call-template name="complexElementGui">
			<xsl:with-param name="title">Qualité des données</xsl:with-param>
			<xsl:with-param name="content">
				<xsl:call-template name="complexElementGui">
					<xsl:with-param name="title">Domaine concernant la qualité</xsl:with-param>
					<xsl:with-param name="content">
						<xsl:apply-templates mode="elementEP" select="dqInfo/dqScope/scpLvl|geonet:child[string(@name)='scpLvl']">
							<xsl:with-param name="schema" select="$schema"/>
							<xsl:with-param name="edit" select="$edit"/>
							<xsl:with-param name="flat" select="$flat"/>
						</xsl:apply-templates>
					</xsl:with-param>
					<xsl:with-param name="schema" select="$schema"/>
				</xsl:call-template>
			</xsl:with-param>
			<xsl:with-param name="schema" select="$schema"/>
		</xsl:call-template>
		<xsl:call-template name="complexElementGui">
			<xsl:with-param name="title">Généalogie de la donnée</xsl:with-param>
			<xsl:with-param name="content">
				<xsl:apply-templates mode="elementEP" select="dqInfo/dataLineage/statement">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="$edit"/>
					<xsl:with-param name="flat" select="$flat"/>
				</xsl:apply-templates>
			</xsl:with-param>
			<xsl:with-param name="schema" select="$schema"/>
		</xsl:call-template>
		<xsl:call-template name="complexElementGui">
			<xsl:with-param name="title">Source</xsl:with-param>
			<xsl:with-param name="content">
				<xsl:apply-templates mode="elementEP" select="dqInfo/dataLineage/dataSource/srcDesc">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="$edit"/>
					<xsl:with-param name="flat" select="$flat"/>
				</xsl:apply-templates>
				<xsl:apply-templates mode="elementEP" select="dqInfo/dataLineage/dataSource/srcScale/rfDenom">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="$edit"/>
					<xsl:with-param name="flat" select="$flat"/>
				</xsl:apply-templates>
				<xsl:apply-templates mode="elementEP" select="dqInfo/dataLineage/dataSource/srcRefSys">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="$edit"/>
					<xsl:with-param name="flat" select="$flat"/>
				</xsl:apply-templates>
			</xsl:with-param>
			<xsl:with-param name="schema" select="$schema"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="iso19115FraDistribution">
		<xsl:param name="schema"/>
		<xsl:param name="edit"/>
		<xsl:param name="flat"/>
		<!--AD-->
		<xsl:for-each select="distInfo/distributor">
			<xsl:call-template name="complexElementGui">
				<xsl:with-param name="title">Distributeur</xsl:with-param>
				<xsl:with-param name="content">
					<xsl:call-template name="complexElementGui">
						<xsl:with-param name="title">Contact de distribution</xsl:with-param>
						<xsl:with-param name="content">
							<xsl:apply-templates mode="elementEP" select="./distorCont/rpIndName">
								<xsl:with-param name="schema" select="$schema"/>
								<xsl:with-param name="edit" select="$edit"/>
								<xsl:with-param name="flat" select="$flat"/>
							</xsl:apply-templates>
							<xsl:apply-templates mode="elementEP" select="./distorCont/rpOrgName">
								<xsl:with-param name="schema" select="$schema"/>
								<xsl:with-param name="edit" select="$edit"/>
								<xsl:with-param name="flat" select="$flat"/>
							</xsl:apply-templates>
							<xsl:apply-templates mode="elementEP" select="./distorCont/role|geonet:child[string(@name)='role']">
								<xsl:with-param name="schema" select="$schema"/>
								<xsl:with-param name="edit" select="$edit"/>
								<xsl:with-param name="flat" select="$flat"/>
							</xsl:apply-templates>
						</xsl:with-param>
						<xsl:with-param name="schema" select="$schema"/>
					</xsl:call-template>
					<xsl:call-template name="complexElementGui">
						<xsl:with-param name="title">Processus de distribution et de commande</xsl:with-param>
						<xsl:with-param name="content">
							<xsl:apply-templates mode="elementEP" select="distInfo/distributor/distorOrdPrc/resFees">
								<xsl:with-param name="schema" select="$schema"/>
								<xsl:with-param name="edit" select="$edit"/>
								<xsl:with-param name="flat" select="$flat"/>
							</xsl:apply-templates>
							<xsl:apply-templates mode="elementEP" select="distInfo/distributor/distorOrdPrc/rdInstr">
								<xsl:with-param name="schema" select="$schema"/>
								<xsl:with-param name="edit" select="$edit"/>
								<xsl:with-param name="flat" select="$flat"/>
							</xsl:apply-templates>
						</xsl:with-param>
						<xsl:with-param name="schema" select="$schema"/>
					</xsl:call-template>
				</xsl:with-param>
				<xsl:with-param name="schema" select="$schema"/>
			</xsl:call-template>
		</xsl:for-each>
		<!--AD-->
		<xsl:call-template name="complexElementGui">
			<xsl:with-param name="title">Options de transfert digital</xsl:with-param>
			<xsl:with-param name="content">
				<xsl:apply-templates mode="elementEP" select="distInfo/istTranOps/unitsODist">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="$edit"/>
					<xsl:with-param name="flat" select="$flat"/>
				</xsl:apply-templates>
				<xsl:call-template name="complexElementGui">
					<xsl:with-param name="title">Sources on-line</xsl:with-param>
					<xsl:with-param name="content">
						<xsl:choose>
							<xsl:when test="$edit=true()">
								<xsl:apply-templates mode="elementEP" select="distInfo/istTranOps/onLineSrc/linkage">
									<xsl:with-param name="schema" select="$schema"/>
									<xsl:with-param name="edit" select="$edit"/>
									<xsl:with-param name="flat" select="$flat"/>
								</xsl:apply-templates>
								<xsl:apply-templates mode="elementEP" select="distInfo/istTranOps/onLineSrc/protocol">
							<xsl:with-param name="schema" select="$schema"/>
							<xsl:with-param name="edit" select="$edit"/>
							<xsl:with-param name="flat" select="$flat"/>
						</xsl:apply-templates>						
							</xsl:when>
							<xsl:otherwise>
								<xsl:apply-templates mode="simpleElement" select="distInfo/istTranOps/onLineSrc/linkagedistInfo/istTranOps/onLineSrc/linkage">
									<xsl:with-param name="schema" select="$schema"/>
									<xsl:with-param name="text">
										<a href="{linkage}" target="_new">
											<xsl:choose>
												<xsl:when test="string(orDesc)!=''">
													<xsl:value-of select="orDesc"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="linkage"/>
												</xsl:otherwise>
											</xsl:choose>
										</a>
									</xsl:with-param>
								</xsl:apply-templates>
							</xsl:otherwise>
						</xsl:choose>
						
						<xsl:apply-templates mode="elementEP" select="distInfo/istTranOps/onLineSrc/orName">
							<xsl:with-param name="schema" select="$schema"/>
							<xsl:with-param name="edit" select="$edit"/>
							<xsl:with-param name="flat" select="$flat"/>
						</xsl:apply-templates>
						<xsl:apply-templates mode="elementEP" select="distInfo/istTranOps/onLineSrc/orFunct|geonet:child[string(@name)='orFunct']">
							<xsl:with-param name="schema" select="$schema"/>
							<xsl:with-param name="edit" select="$edit"/>
							<xsl:with-param name="flat" select="$flat"/>
						</xsl:apply-templates>
					</xsl:with-param>
					<xsl:with-param name="schema" select="$schema"/>
				</xsl:call-template>
				<xsl:call-template name="complexElementGui">
					<xsl:with-param name="title">Sources off-line</xsl:with-param>
					<xsl:with-param name="content">
						<xsl:apply-templates mode="elementEP" select="distInfo/onLineMed/medName">
							<xsl:with-param name="schema" select="$schema"/>
							<xsl:with-param name="edit" select="$edit"/>
							<xsl:with-param name="flat" select="$flat"/>
						</xsl:apply-templates>
					</xsl:with-param>
					<xsl:with-param name="schema" select="$schema"/>
				</xsl:call-template>
			</xsl:with-param>
			<xsl:with-param name="schema" select="$schema"/>
		</xsl:call-template>
		<xsl:call-template name="complexElementGui">
			<xsl:with-param name="title">Format</xsl:with-param>
			<xsl:with-param name="content">
				<xsl:apply-templates mode="elementEP" select="distInfo/distFormat/formatName">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="$edit"/>
					<xsl:with-param name="flat" select="$flat"/>
				</xsl:apply-templates>
				<xsl:apply-templates mode="elementEP" select="distInfo/distFormat/formatName/formatVer">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="$edit"/>
					<xsl:with-param name="flat" select="$flat"/>
				</xsl:apply-templates>
			</xsl:with-param>
			<xsl:with-param name="schema" select="$schema"/>
		</xsl:call-template>
		<xsl:call-template name="complexElementGui">
			<xsl:with-param name="title">Contraintes générales</xsl:with-param>
			<xsl:with-param name="content">
				<xsl:apply-templates mode="elementEP" select="dataIdInfo/resConst/Consts/useLimit">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="$edit"/>
					<xsl:with-param name="flat" select="$flat"/>
				</xsl:apply-templates>
				<xsl:call-template name="complexElementGui">
					<xsl:with-param name="title">Documents explicitant les contraintes</xsl:with-param>
					<xsl:with-param name="content">
						<xsl:call-template name="complexElementGui">
							<xsl:with-param name="title">Citation</xsl:with-param>
							<xsl:with-param name="content">
								<xsl:apply-templates mode="elementEP" select="dataIdInfo/resConst/frRefConstraints/resTitle">
									<xsl:with-param name="schema" select="$schema"/>
									<xsl:with-param name="edit" select="$edit"/>
									<xsl:with-param name="flat" select="$flat"/>
								</xsl:apply-templates>
								<xsl:apply-templates mode="elementEP" select="dataIdInfo/resConst/frRefConstraints/resAltTitle">
									<xsl:with-param name="schema" select="$schema"/>
									<xsl:with-param name="edit" select="$edit"/>
									<xsl:with-param name="flat" select="$flat"/>
								</xsl:apply-templates>
							</xsl:with-param>
							<xsl:with-param name="schema" select="$schema"/>
						</xsl:call-template>
						<xsl:call-template name="complexElementGui">
							<xsl:with-param name="title">Date</xsl:with-param>
							<xsl:with-param name="content">
								<xsl:apply-templates mode="elementEP" select="dataIdInfo/resConst/frRefConstraints/resRefDate">
									<xsl:with-param name="schema" select="$schema"/>
									<xsl:with-param name="edit" select="$edit"/>
									<xsl:with-param name="flat" select="$flat"/>
								</xsl:apply-templates>
								<xsl:apply-templates mode="elementEP" select="dataIdInfo/resConst/frRefConstraints/refDateType|geonet:child[string(@name)='refDateType']">
									<xsl:with-param name="schema" select="$schema"/>
									<xsl:with-param name="edit" select="$edit"/>
									<xsl:with-param name="flat" select="$flat"/>
								</xsl:apply-templates>
							</xsl:with-param>
							<xsl:with-param name="schema" select="$schema"/>
						</xsl:call-template>
						<xsl:call-template name="complexElementGui">
							<xsl:with-param name="title">Identification</xsl:with-param>
							<xsl:with-param name="content">
								<xsl:apply-templates mode="elementEP" select="dataIdInfo/resConst/frRefConstraints/citId">
									<xsl:with-param name="schema" select="$schema"/>
									<xsl:with-param name="edit" select="$edit"/>
									<xsl:with-param name="flat" select="$flat"/>
								</xsl:apply-templates>
								<xsl:apply-templates mode="elementEP" select="dataIdInfo/resConst/frRefConstraints/refDateType|geonet:child[string(@name)='refDateType']">
									<xsl:with-param name="schema" select="$schema"/>
									<xsl:with-param name="edit" select="$edit"/>
									<xsl:with-param name="flat" select="$flat"/>
								</xsl:apply-templates>
							</xsl:with-param>
							<xsl:with-param name="schema" select="$schema"/>
						</xsl:call-template>
					</xsl:with-param>
					<xsl:with-param name="schema" select="$schema"/>
				</xsl:call-template>
			</xsl:with-param>
			<xsl:with-param name="schema" select="$schema"/>
		</xsl:call-template>
		<xsl:call-template name="complexElementGui">
			<xsl:with-param name="title">Contraintes légales</xsl:with-param>
			<xsl:with-param name="content">
				<xsl:apply-templates mode="elementEP" select="dataIdInfo/resConst/LegConsts/accessConsts|geonet:child[string(@name)='accessConsts']">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="$edit"/>
					<xsl:with-param name="flat" select="$flat"/>
				</xsl:apply-templates>
				<xsl:apply-templates mode="elementEP" select="dataIdInfo/resConst/LegConsts/useConsts|geonet:child[string(@name)='useConsts']">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="$edit"/>
					<xsl:with-param name="flat" select="$flat"/>
				</xsl:apply-templates>
				<xsl:apply-templates mode="elementEP" select="dataIdInfo/resConst/LegConsts/othConsts">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="$edit"/>
					<xsl:with-param name="flat" select="$flat"/>
				</xsl:apply-templates>
				<xsl:call-template name="complexElementGui">
					<xsl:with-param name="title">Documents explicitant les contraintes</xsl:with-param>
					<xsl:with-param name="content">
						<xsl:call-template name="complexElementGui">
							<xsl:with-param name="title">Citation</xsl:with-param>
							<xsl:with-param name="content">
								<xsl:apply-templates mode="elementEP" select="dataIdInfo/resConst/LegConsts/resTitle">
									<xsl:with-param name="schema" select="$schema"/>
									<xsl:with-param name="edit" select="$edit"/>
									<xsl:with-param name="flat" select="$flat"/>
								</xsl:apply-templates>
								<xsl:apply-templates mode="elementEP" select="dataIdInfo/resConst/LegConsts/resAltTitle">
									<xsl:with-param name="schema" select="$schema"/>
									<xsl:with-param name="edit" select="$edit"/>
									<xsl:with-param name="flat" select="$flat"/>
								</xsl:apply-templates>
							</xsl:with-param>
							<xsl:with-param name="schema" select="$schema"/>
						</xsl:call-template>
						<xsl:call-template name="complexElementGui">
							<xsl:with-param name="title">Date</xsl:with-param>
							<xsl:with-param name="content">
								<xsl:apply-templates mode="elementEP" select="dataIdInfo/resConst/LegConsts/resRefDate">
									<xsl:with-param name="schema" select="$schema"/>
									<xsl:with-param name="edit" select="$edit"/>
									<xsl:with-param name="flat" select="$flat"/>
								</xsl:apply-templates>
								<xsl:apply-templates mode="elementEP" select="dataIdInfo/resConst/LegConsts/refDateType|geonet:child[string(@name)='refDateType']">
									<xsl:with-param name="schema" select="$schema"/>
									<xsl:with-param name="edit" select="$edit"/>
									<xsl:with-param name="flat" select="$flat"/>
								</xsl:apply-templates>
							</xsl:with-param>
							<xsl:with-param name="schema" select="$schema"/>
						</xsl:call-template>
						<xsl:call-template name="complexElementGui">
							<xsl:with-param name="title">Identification</xsl:with-param>
							<xsl:with-param name="content">
								<xsl:apply-templates mode="elementEP" select="dataIdInfo/resConst/LegConsts/citId">
									<xsl:with-param name="schema" select="$schema"/>
									<xsl:with-param name="edit" select="$edit"/>
									<xsl:with-param name="flat" select="$flat"/>
								</xsl:apply-templates>
								<xsl:apply-templates mode="elementEP" select="dataIdInfo/resConst/LegConsts/refDateType|geonet:child[string(@name)='refDateType']">
									<xsl:with-param name="schema" select="$schema"/>
									<xsl:with-param name="edit" select="$edit"/>
									<xsl:with-param name="flat" select="$flat"/>
								</xsl:apply-templates>
							</xsl:with-param>
							<xsl:with-param name="schema" select="$schema"/>
						</xsl:call-template>
					</xsl:with-param>
					<xsl:with-param name="schema" select="$schema"/>
				</xsl:call-template>
			</xsl:with-param>
			<xsl:with-param name="schema" select="$schema"/>
		</xsl:call-template>
		<xsl:call-template name="complexElementGui">
			<xsl:with-param name="title">Contraintes de sécurité</xsl:with-param>
			<xsl:with-param name="content">
				<xsl:apply-templates mode="elementEP" select="dataIdInfo/resConst/SecConsts/class|geonet:child[string(@name)='class']">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="$edit"/>
					<xsl:with-param name="flat" select="$flat"/>
				</xsl:apply-templates>
				<xsl:call-template name="complexElementGui">
					<xsl:with-param name="title">Documents explicitant les contraintes</xsl:with-param>
					<xsl:with-param name="content">
						<xsl:call-template name="complexElementGui">
							<xsl:with-param name="title">Citation</xsl:with-param>
							<xsl:with-param name="content">
								<xsl:apply-templates mode="elementEP" select="dataIdInfo/resConst/SecConsts/frRefConstraints/resTitle">
									<xsl:with-param name="schema" select="$schema"/>
									<xsl:with-param name="edit" select="$edit"/>
									<xsl:with-param name="flat" select="$flat"/>
								</xsl:apply-templates>
								<xsl:apply-templates mode="elementEP" select="dataIdInfo/resConst/SecConsts/frRefConstraints/resAltTitle">
									<xsl:with-param name="schema" select="$schema"/>
									<xsl:with-param name="edit" select="$edit"/>
									<xsl:with-param name="flat" select="$flat"/>
								</xsl:apply-templates>
							</xsl:with-param>
							<xsl:with-param name="schema" select="$schema"/>
						</xsl:call-template>
						<xsl:call-template name="complexElementGui">
							<xsl:with-param name="title">Date</xsl:with-param>
							<xsl:with-param name="content">
								<xsl:apply-templates mode="elementEP" select="dataIdInfo/resConst/SecConsts/frRefConstraints/resRefDate">
									<xsl:with-param name="schema" select="$schema"/>
									<xsl:with-param name="edit" select="$edit"/>
									<xsl:with-param name="flat" select="$flat"/>
								</xsl:apply-templates>
								<xsl:apply-templates mode="elementEP" select="dataIdInfo/resConst/SecConsts/frRefConstraints/refDateType|geonet:child[string(@name)='refDateType']">
									<xsl:with-param name="schema" select="$schema"/>
									<xsl:with-param name="edit" select="$edit"/>
									<xsl:with-param name="flat" select="$flat"/>
								</xsl:apply-templates>
							</xsl:with-param>
							<xsl:with-param name="schema" select="$schema"/>
						</xsl:call-template>
						<xsl:call-template name="complexElementGui">
							<xsl:with-param name="title">Identification</xsl:with-param>
							<xsl:with-param name="content">
								<xsl:apply-templates mode="elementEP" select="dataIdInfo/resConst/SecConsts/frRefConstraints/citId">
									<xsl:with-param name="schema" select="$schema"/>
									<xsl:with-param name="edit" select="$edit"/>
									<xsl:with-param name="flat" select="$flat"/>
								</xsl:apply-templates>
								<xsl:apply-templates mode="elementEP" select="dataIdInfo/resConst/SecConsts/frRefConstraints/refDateType|geonet:child[string(@name)='refDateType']">
									<xsl:with-param name="schema" select="$schema"/>
									<xsl:with-param name="edit" select="$edit"/>
									<xsl:with-param name="flat" select="$flat"/>
								</xsl:apply-templates>
							</xsl:with-param>
							<xsl:with-param name="schema" select="$schema"/>
						</xsl:call-template>
					</xsl:with-param>
					<xsl:with-param name="schema" select="$schema"/>
				</xsl:call-template>
			</xsl:with-param>
			<xsl:with-param name="schema" select="$schema"/>
		</xsl:call-template>
	</xsl:template>
	<!--
  <xsl:template mode="iso19115Fra" match="refSysInfo/DirectReferenceSystem">
    <xsl:param name="schema"/>
    <xsl:param name="edit"/>
    <xsl:param name="flat"/>

	 <xsl:apply-templates mode="iso19115Fra_2" select=".">
		<xsl:with-param name="schema"  select="$schema"/>
	      <xsl:with-param name="edit"    select="$edit"/>
	      <xsl:with-param name="title" select="/root/gui/strings/GS/refSysInfo_direct"/>
	    </xsl:apply-templates>

  </xsl:template>
  
  <xsl:template mode="iso19115Fra" match="refSysInfo/InDirectReferenceSystem">
    <xsl:param name="schema"/>
    <xsl:param name="edit"/>
    <xsl:param name="flat"/>

	 <xsl:apply-templates mode="iso19115Fra_2" select=".">
		<xsl:with-param name="schema"  select="$schema"/>
	      <xsl:with-param name="edit"    select="$edit"/>
	      <xsl:with-param name="title" select="/root/gui/strings/GS/refSysInfo_indirect"/>
	    </xsl:apply-templates>
  </xsl:template>
  -->
	<xsl:template mode="iso19115Fra" match="dataIdInfo">
		<xsl:param name="schema"/>
		<xsl:param name="edit"/>
		<xsl:param name="flat"/>
		<xsl:apply-templates mode="iso19115Fra_2" select="Consts">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
			<xsl:with-param name="title" select="/root/gui/strings/GS/LegConsts"/>
		</xsl:apply-templates>
		<xsl:apply-templates mode="iso19115Fra_2" select="SecConsts">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
			<xsl:with-param name="title" select="/root/gui/strings/GS/SecConsts"/>
		</xsl:apply-templates>
		<xsl:apply-templates mode="iso19115Fra_2" select="LegConsts">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
			<xsl:with-param name="title" select="/root/gui/strings/GS/LegConsts"/>
		</xsl:apply-templates>
	</xsl:template>
	<!--
	codelists
	-->
	<xsl:template mode="iso19115Fra" match="*[(substring(name(*), string-length(name(*))-1, 2)='Cd' and name(.)!='mdChar') or name(*)='languageCode']">
		<xsl:param name="schema"/>
		<xsl:param name="edit"/>
		<xsl:call-template name="iso19115FraCodelist">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="iso19115FraCodelist">
		<xsl:param name="schema"/>
		<xsl:param name="edit"/>
		<xsl:apply-templates mode="simpleElement" select=".">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
			<xsl:with-param name="text">
				<xsl:apply-templates mode="iso19115FraGetAttributeText" select="*/@value">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="$edit"/>
				</xsl:apply-templates>
			</xsl:with-param>
		</xsl:apply-templates>
	</xsl:template>
	<xsl:template mode="iso19115FraGetAttributeText" match="@*">
		<xsl:param name="schema"/>
		<xsl:param name="edit"/>
		<xsl:call-template name="getAttributeText">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	make the following fields always not editable:
	mdDateSt
	mdStanName
	mdStanVer
	mdFileID
	mdChar
	-->
	<xsl:template mode="iso19115Fra" match="mdDateSt|mdStanName|mdStanVer|mdFileID">
		<xsl:param name="schema"/>
		<xsl:param name="edit"/>
		<xsl:apply-templates mode="element" select=".">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="false()"/>
		</xsl:apply-templates>
	</xsl:template>
	<xsl:template mode="iso19115Fra" match="mdChar">
		<xsl:param name="schema"/>
		<xsl:param name="edit"/>
		<xsl:call-template name="iso19115FraCodelist">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="false()"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	online resources
	-->
	<xsl:template mode="iso19115Fra" match="onLineSrc">
		<xsl:param name="schema"/>
		<xsl:param name="edit"/>
		<xsl:choose>
			<xsl:when test="$edit=true()">
				<xsl:apply-templates mode="iso19115FraEditOnlineRes" select=".">
					<xsl:with-param name="schema" select="$schema"/>
				</xsl:apply-templates>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates mode="simpleElement" select=".">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="text">
						<a href="{linkage}" target="_new">
							<xsl:choose>
								<xsl:when test="string(orDesc)!=''">
									<xsl:value-of select="orDesc"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="linkage"/>
								</xsl:otherwise>
							</xsl:choose>
						</a>
					</xsl:with-param>
				</xsl:apply-templates>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template mode="iso19115FraEditOnlineRes" match="*">
		<xsl:param name="schema"/>
		<xsl:apply-templates mode="complexElement" select=".">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="true()"/>
			<xsl:with-param name="content">
				<xsl:apply-templates mode="elementEP" select="linkage|geonet:child[string(@name)='linkage']">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="true()"/>
				</xsl:apply-templates>
				<xsl:apply-templates mode="elementEP" select="protocol|geonet:child[string(@name)='protocol']">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="true()"/>
				</xsl:apply-templates>
				<xsl:apply-templates mode="elementEP" select="appProfile|geonet:child[string(@name)='appProfile']">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="true()"/>
				</xsl:apply-templates>
				<xsl:choose>
					<xsl:when test="protocol='WWW:DOWNLOAD-1.0-http--download' and string(orName)!=''">
						<xsl:apply-templates mode="iso19115FraFileRemove" select="orName">
							<xsl:with-param name="access" select="'private'"/>
						</xsl:apply-templates>
					</xsl:when>
					<xsl:when test="protocol='WWW:DOWNLOAD-1.0-http--download' and orName">
						<xsl:apply-templates mode="iso19115FraFileUpload" select="orName">
							<xsl:with-param name="access" select="'private'"/>
						</xsl:apply-templates>
					</xsl:when>
					<xsl:when test="protocol='WWW:LINK-1.0-http--link'"/>
					<!-- hide orName for www links -->
					<xsl:otherwise>
						<xsl:apply-templates mode="elementEP" select="orName|geonet:child[string(@name)='orName']">
							<xsl:with-param name="schema" select="$schema"/>
							<xsl:with-param name="edit" select="true()"/>
						</xsl:apply-templates>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:apply-templates mode="elementEP" select="orDesc|geonet:child[string(@name)='orDesc']">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="true()"/>
				</xsl:apply-templates>
				<xsl:apply-templates mode="elementEP" select="orFunct|geonet:child[string(@name)='orFunct']">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="true()"/>
				</xsl:apply-templates>
			</xsl:with-param>
		</xsl:apply-templates>
	</xsl:template>
	<!--
	online resources: WMS get map
	-->
	<xsl:template mode="iso19115Fra" match="onLineSrc[starts-with(protocol,'OGC:WMS-') and contains(protocol,'-get-map') and orName]">
		<xsl:param name="schema"/>
		<xsl:param name="edit"/>
		<xsl:choose>
			<xsl:when test="$edit=true()">
				<xsl:apply-templates mode="iso19115FraEditOnlineRes" select=".">
					<xsl:with-param name="schema" select="$schema"/>
				</xsl:apply-templates>
			</xsl:when>
			<xsl:when test="string(../../../geonet:info/dynamic)='true'">
				<xsl:apply-templates mode="simpleElement" select=".">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="title" select="/root/gui/strings/interactiveMap"/>
					<xsl:with-param name="text">
						<a href="javascript:popInterMap('{/root/gui/url}/intermap/srv/{/root/gui/language}/map.addServicesExt?url={linkage}&amp;service={orName}&amp;type=2')" title="{/root/strings/interactiveMap}">
							<xsl:choose>
								<xsl:when test="string(orDesc)!=''">
									<xsl:value-of select="orDesc"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="orName"/>
								</xsl:otherwise>
							</xsl:choose>
						</a>
					</xsl:with-param>
				</xsl:apply-templates>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!--
	online resources: WMS get capabilities
	-->
	<xsl:template mode="iso19115Fra" match="onLineSrc[starts-with(protocol,'OGC:WMS-') and contains(protocol,'-get-capabilities') and orName]">
		<xsl:param name="schema"/>
		<xsl:param name="edit"/>
		<xsl:choose>
			<xsl:when test="$edit=true()">
				<xsl:apply-templates mode="iso19115FraEditOnlineRes" select=".">
					<xsl:with-param name="schema" select="$schema"/>
				</xsl:apply-templates>
			</xsl:when>
			<xsl:when test="string(../../../geonet:info/dynamic)='true'">
				<xsl:apply-templates mode="simpleElement" select=".">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="title" select="/root/gui/strings/interactiveMap"/>
					<xsl:with-param name="text">
						<a href="javascript:popInterMap('{/root/gui/url}/intermap/srv/{/root/gui/language}/map.addServicesExt?url={linkage}&amp;type=2')" title="{/root/strings/interactiveMap}">
							<xsl:choose>
								<xsl:when test="string(orDesc)!=''">
									<xsl:value-of select="orDesc"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="orName"/>
								</xsl:otherwise>
							</xsl:choose>
						</a>
					</xsl:with-param>
				</xsl:apply-templates>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!--
	online resources: ARCIMS
	-->
	<xsl:template mode="iso19115Fra" match="onLineSrc[starts-with(./protocol,'ESRI:AIMS-') and contains(./protocol,'-get-image') and ./orName]">
		<xsl:param name="schema"/>
		<xsl:param name="edit"/>
		<xsl:choose>
			<xsl:when test="$edit=true()">
				<xsl:apply-templates mode="iso19115FraEditOnlineRes" select=".">
					<xsl:with-param name="schema" select="$schema"/>
				</xsl:apply-templates>
			</xsl:when>
			<xsl:when test="string(../../../geonet:info/dynamic)='true'">
				<xsl:apply-templates mode="simpleElement" select=".">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="title" select="/root/gui/strings/interactiveMap"/>
					<xsl:with-param name="text">
						<a href="javascript:popInterMap('{/root/gui/url}/intermap/srv/{/root/gui/language}/map.addServicesExt?url={linkage}&amp;service={orName}&amp;type=1')" title="{/root/strings/interactiveMap}">
							<xsl:choose>
								<xsl:when test="string(orDesc)!=''">
									<xsl:value-of select="orDesc"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="orName"/>
								</xsl:otherwise>
							</xsl:choose>
						</a>
					</xsl:with-param>
				</xsl:apply-templates>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!--
	online resources: download
	-->
	<xsl:template mode="iso19115Fra" match="onLineSrc[starts-with(./protocol,'WWW:DOWNLOAD-') and contains(./protocol,'http--download') and ./orName]">
		<xsl:param name="schema"/>
		<xsl:param name="edit"/>
		<xsl:choose>
			<xsl:when test="$edit=true()">
				<xsl:apply-templates mode="iso19115FraEditOnlineRes" select=".">
					<xsl:with-param name="schema" select="$schema"/>
				</xsl:apply-templates>
			</xsl:when>
			<xsl:when test="string(../../../geonet:info/download)='true'">
				<xsl:apply-templates mode="simpleElement" select=".">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="title" select="/root/gui/strings/downloadData"/>
					<xsl:with-param name="text">
						<a href="{linkage}" target="_blank">
							<xsl:choose>
								<xsl:when test="string(orDesc)!=''">
									<xsl:value-of select="orDesc"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="orName"/>
								</xsl:otherwise>
							</xsl:choose>
						</a>
					</xsl:with-param>
				</xsl:apply-templates>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!--
	protocol
	-->
	<xsl:template mode="iso19115Fra" match="protocol">
		<xsl:param name="schema"/>
		<xsl:param name="edit"/>
		<xsl:choose>
			<xsl:when test="$edit=true()">
				<xsl:apply-templates mode="simpleElement" select=".">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="text">
						<xsl:variable name="value" select="string(.)"/>
						<select name="_{geonet:element/@ref}" size="1">
							<xsl:if test="string(.)=''">
								<option value=""/>
							</xsl:if>
							<xsl:for-each select="/root/gui/strings/protocolChoice[@value]">
								<option>
									<xsl:if test="string(@value)=$value">
										<xsl:attribute name="selected"/>
									</xsl:if>
									<xsl:attribute name="value"><xsl:value-of select="string(@value)"/></xsl:attribute>
									<xsl:value-of select="string(.)"/>
								</option>
							</xsl:for-each>
						</select>
					</xsl:with-param>
				</xsl:apply-templates>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates mode="element" select=".">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="false()"/>
				</xsl:apply-templates>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	eMailAdd
	-->
	<xsl:template mode="iso19115Fra" match="eMailAdd">
		<xsl:param name="schema"/>
		<xsl:param name="edit"/>
		<xsl:choose>
			<xsl:when test="$edit=true()">
				<xsl:apply-templates mode="element" select=".">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="true()"/>
				</xsl:apply-templates>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates mode="simpleElement" select=".">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="text">
						<a href="mailto:{string(.)}">
							<xsl:value-of select="string(.)"/>
						</a>
					</xsl:with-param>
				</xsl:apply-templates>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template mode="iso19115Fra" match="FC_FeatureCatalogue">
		<xsl:param name="schema"/>
		<xsl:param name="edit"/>
		<xsl:variable name="content">
			<xsl:apply-templates mode="elementEP" select="gfc_name|geonet:child[string(@name)='gfc_name']">
				<xsl:with-param name="schema" select="$schema"/>
				<xsl:with-param name="edit" select="true()"/>
			</xsl:apply-templates>
			<xsl:apply-templates mode="elementEP" select="gfc_scope|geonet:child[string(@name)='gfc_scope']">
				<xsl:with-param name="schema" select="$schema"/>
				<xsl:with-param name="edit" select="true()"/>
			</xsl:apply-templates>
			<xsl:apply-templates mode="elementEP" select="gfc_versionNumber|geonet:child[string(@name)='gfc_versionNumber']">
				<xsl:with-param name="schema" select="$schema"/>
				<xsl:with-param name="edit" select="true()"/>
			</xsl:apply-templates>
			<xsl:apply-templates mode="elementEP" select="gfc_versionDate|geonet:child[string(@name)='gfc_versionDate']">
				<xsl:with-param name="schema" select="$schema"/>
				<xsl:with-param name="edit" select="true()"/>
			</xsl:apply-templates>
			<xsl:apply-templates mode="elementEP" select="gfc_language|geonet:child[string(@name)='gfc_language']">
				<xsl:with-param name="schema" select="$schema"/>
				<xsl:with-param name="edit" select="true()"/>
			</xsl:apply-templates>
			<xsl:apply-templates mode="elementEP" select="characterSet|geonet:child[string(@name)='characterSet']">
				<xsl:with-param name="schema" select="$schema"/>
				<xsl:with-param name="edit" select="true()"/>
			</xsl:apply-templates>
			<xsl:apply-templates mode="elementEP" select="gfc_producer|geonet:child[string(@name)='gfc_producer']">
				<xsl:with-param name="schema" select="$schema"/>
				<xsl:with-param name="edit" select="true()"/>
			</xsl:apply-templates>
			<xsl:apply-templates mode="elementEP" select="gfc_featureType|geonet:child[string(@name)='gfc_featureType']">
				<xsl:with-param name="schema" select="$schema"/>
				<xsl:with-param name="edit" select="true()"/>
			</xsl:apply-templates>
		</xsl:variable>
		<xsl:apply-templates mode="complexElement" select=".">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
			<xsl:with-param name="content" select="$content"/>
		</xsl:apply-templates>
	</xsl:template>
	<xsl:template mode="iso19115Fra" match="gfc_featureType">
		<xsl:param name="schema"/>
		<xsl:param name="edit"/>
		<xsl:variable name="content">
			<xsl:apply-templates mode="elementEP" select="gfc_typeName|geonet:child[string(@name)='gfc_typeName']">
				<xsl:with-param name="schema" select="$schema"/>
				<xsl:with-param name="edit" select="true()"/>
			</xsl:apply-templates>
			<xsl:apply-templates mode="elementEP" select="gfc_definition|geonet:child[string(@name)='gfc_definition']">
				<xsl:with-param name="schema" select="$schema"/>
				<xsl:with-param name="edit" select="true()"/>
			</xsl:apply-templates>
			<xsl:apply-templates mode="elementEP" select="gfc_code|geonet:child[string(@name)='gfc_code']">
				<xsl:with-param name="schema" select="$schema"/>
				<xsl:with-param name="edit" select="true()"/>
			</xsl:apply-templates>
			<xsl:apply-templates mode="elementEP" select="gfc_isAbstract|geonet:child[string(@name)='gfc_isAbstract']">
				<xsl:with-param name="schema" select="$schema"/>
				<xsl:with-param name="edit" select="true()"/>
			</xsl:apply-templates>
			<xsl:apply-templates mode="elementEP" select="gfc_carrierOfCharacteristics|geonet:child[string(@name)='gfc_carrierOfCharacteristics']">
				<xsl:with-param name="schema" select="$schema"/>
				<xsl:with-param name="edit" select="true()"/>
			</xsl:apply-templates>
		</xsl:variable>
		<xsl:apply-templates mode="complexElement" select=".">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
			<xsl:with-param name="content" select="$content"/>
		</xsl:apply-templates>
	</xsl:template>
	<!--xsl:template mode="iso19115Fra" match="gfc_carrierOfCharacteristics">
    <xsl:param name="schema"/>
    <xsl:param name="edit"/>

          <xsl:variable name="content">

		      <xsl:apply-templates mode="elementEP" select="gfc_typeName|geonet:child[string(@name)='gfc_typeName']">
		          <xsl:with-param name="schema" select="$schema"/>
		          <xsl:with-param name="edit"   select="true()"/>
		        </xsl:apply-templates>
		        
		         <xsl:apply-templates mode="elementEP" select="gfc_definition|geonet:child[string(@name)='gfc_definition']">
		          <xsl:with-param name="schema" select="$schema"/>
		          <xsl:with-param name="edit"   select="true()"/>
		        </xsl:apply-templates>
		        
		         <xsl:apply-templates mode="elementEP" select="gfc_code|geonet:child[string(@name)='gfc_code']">
		          <xsl:with-param name="schema" select="$schema"/>
		          <xsl:with-param name="edit"   select="true()"/>
		        </xsl:apply-templates>
		        
		         <xsl:apply-templates mode="elementEP" select="gfc_isAbstract|geonet:child[string(@name)='gfc_isAbstract']">
		          <xsl:with-param name="schema" select="$schema"/>
		          <xsl:with-param name="edit"   select="true()"/>
		        </xsl:apply-templates>
		        
		
       
   		</xsl:variable>

    <xsl:apply-templates mode="complexElement" select=".">
    <xsl:with-param name="schema"  select="$schema"/>
      <xsl:with-param name="edit"    select="$edit"/>
      <xsl:with-param name="content" select="$content"/>
    </xsl:apply-templates>
        
 
  </xsl:template-->
	<!--
	descKeys
	-->
	<xsl:template mode="iso19115Fra" match="descKeys">
		<xsl:param name="schema"/>
		<xsl:param name="edit"/>
		<xsl:choose>
			<xsl:when test="$edit=true()">
				<xsl:apply-templates mode="element" select=".">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="true()"/>
				</xsl:apply-templates>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates mode="simpleElement" select=".">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="text">
						<xsl:for-each select="keyword">
							<xsl:if test="position() &gt; 1">,	</xsl:if>
							<xsl:value-of select="."/>
						</xsl:for-each>
						<xsl:if test="keyTyp/KeyTypCd/@value!=''">
							<xsl:text> (</xsl:text>
							<xsl:value-of select="keyTyp/KeyTypCd/@value"/>
							<xsl:text>)</xsl:text>
						</xsl:if>
						<xsl:text>.</xsl:text>
					</xsl:with-param>
				</xsl:apply-templates>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	place keyword; only called in edit mode (see descKeys template)
	-->
	<xsl:template mode="iso19115Fra" match="keyword[following-sibling::keyTyp/KeyTypCd/@value='place']">
		<xsl:param name="schema"/>
		<xsl:param name="edit"/>
		<xsl:variable name="text">
			<xsl:variable name="ref" select="geonet:element/@ref"/>
			<xsl:variable name="keyword" select="string(.)"/>
			<input class="md" type="text" name="_{$ref}" value="{text()}" size="50"/>
		</xsl:variable>
		<xsl:apply-templates mode="simpleElement" select=".">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="true()"/>
			<xsl:with-param name="text" select="$text"/>
		</xsl:apply-templates>
	</xsl:template>
	<!--
	geoBox
	-->
	<xsl:template mode="iso19115Fra" match="geoBox">
		<xsl:param name="schema"/>
		<xsl:param name="edit"/>
		<xsl:variable name="geoBox">
			<xsl:apply-templates mode="iso19115FraGeoBox" select=".">
				<xsl:with-param name="schema" select="$schema"/>
				<xsl:with-param name="edit" select="$edit"/>
			</xsl:apply-templates>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$edit=true()">
				<xsl:variable name="places">
					<xsl:variable name="ref" select="geonet:element/@ref"/>
					<xsl:variable name="keyword" select="string(.)"/>
					<xsl:variable name="selection" select="concat(westBL,';',eastBL,';',southBL,';',northBL)"/>
					<select name="place" size="1" onChange="javascript:setRegion(document.mainForm._{westBL/geonet:element/@ref}, document.mainForm._{eastBL/geonet:element/@ref}, document.mainForm._{southBL/geonet:element/@ref}, document.mainForm._{northBL/geonet:element/@ref}, this.options[this.selectedIndex].value)">
						<option value=""/>
						<xsl:for-each select="/root/gui/regions/region">
							<xsl:sort select="name_en" order="ascending"/>
							<xsl:variable name="value" select="concat(west,';',east,';',south,';',north)"/>
							<option value="{$value}">
								<xsl:if test="$value=$selection">
									<xsl:attribute name="selected"/>
								</xsl:if>
								<xsl:value-of select="name_en"/>
							</option>
						</xsl:for-each>
					</select>
				</xsl:variable>
				<xsl:apply-templates mode="complexElement" select=".">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="$edit"/>
					<xsl:with-param name="content">
						<tr>
							<td align="center">
								<xsl:copy-of select="$geoBox"/>
							</td>
							<td>
								<xsl:copy-of select="$places"/>
							</td>
						</tr>
					</xsl:with-param>
				</xsl:apply-templates>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates mode="complexElement" select=".">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="$edit"/>
					<xsl:with-param name="content">
						<tr>
							<td align="center">
								<xsl:copy-of select="$geoBox"/>
							</td>
						</tr>
					</xsl:with-param>
				</xsl:apply-templates>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template mode="iso19115FraGeoBox" match="*">
		<xsl:param name="schema"/>
		<xsl:param name="edit"/>
		<table>
			<tr>
				<td/>
				<td class="padded" align="center">
					<xsl:apply-templates mode="iso19115FraVertElement" select="northBL">
						<xsl:with-param name="schema" select="$schema"/>
						<xsl:with-param name="edit" select="$edit"/>
					</xsl:apply-templates>
				</td>
				<td/>
			</tr>
			<tr>
				<td class="padded" align="center">
					<xsl:apply-templates mode="iso19115FraVertElement" select="westBL">
						<xsl:with-param name="schema" select="$schema"/>
						<xsl:with-param name="edit" select="$edit"/>
					</xsl:apply-templates>
				</td>
				<xsl:variable name="md">
					<xsl:apply-templates mode="brief" select="../.."/>
				</xsl:variable>
				<xsl:variable name="metadata" select="xalan:nodeset($md)/*[1]"/>
				<td width="100" height="100" align="center">
					<xsl:call-template name="thumbnail">
						<xsl:with-param name="metadata" select="$metadata"/>
					</xsl:call-template>
				</td>
				<td class="padded" align="center">
					<xsl:apply-templates mode="iso19115FraVertElement" select="eastBL">
						<xsl:with-param name="schema" select="$schema"/>
						<xsl:with-param name="edit" select="$edit"/>
					</xsl:apply-templates>
				</td>
			</tr>
			<tr>
				<td/>
				<td class="padded" align="center">
					<xsl:apply-templates mode="iso19115FraVertElement" select="southBL">
						<xsl:with-param name="schema" select="$schema"/>
						<xsl:with-param name="edit" select="$edit"/>
					</xsl:apply-templates>
				</td>
				<td/>
			</tr>
		</table>
	</xsl:template>
	<xsl:template mode="iso19115FraVertElement" match="*">
		<xsl:param name="schema"/>
		<xsl:param name="edit"/>
		<xsl:variable name="title">
			<xsl:call-template name="getTitle">
				<xsl:with-param name="name" select="name(.)"/>
				<xsl:with-param name="schema" select="$schema"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="helpLink">
			<xsl:call-template name="getHelpLink">
				<xsl:with-param name="name" select="name(.)"/>
				<xsl:with-param name="schema" select="$schema"/>
			</xsl:call-template>
		</xsl:variable>
		<b>
			<xsl:choose>
				<xsl:when test="$helpLink!=''">
					<a href="javascript:popNew('{$helpLink}')">
						<xsl:value-of select="$title"/>
					</a>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$title"/>
				</xsl:otherwise>
			</xsl:choose>
		</b>
		<br/>
		<xsl:call-template name="getElementText">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
			<xsl:with-param name="cols" select="10"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	idAbs
	-->
	<xsl:template mode="iso19115Fra" match="idAbs">
		<xsl:param name="schema"/>
		<xsl:param name="edit"/>
		<xsl:apply-templates mode="simpleElement" select=".">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
			<xsl:with-param name="text">
				<xsl:call-template name="getElementText">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="$edit"/>
					<xsl:with-param name="rows" select="10"/>
				</xsl:call-template>
			</xsl:with-param>
		</xsl:apply-templates>
	</xsl:template>
	<!--
	suppInfo
	idPurp
	-->
	<xsl:template mode="iso19115Fra" match="suppInfo|idPurp">
		<xsl:param name="schema"/>
		<xsl:param name="edit"/>
		<xsl:apply-templates mode="simpleElement" select=".">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
			<xsl:with-param name="text">
				<xsl:call-template name="getElementText">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="$edit"/>
					<xsl:with-param name="rows" select="5"/>
				</xsl:call-template>
			</xsl:with-param>
		</xsl:apply-templates>
	</xsl:template>
	<xsl:template mode="iso19115Fra" match="statement">
		<xsl:param name="schema"/>
		<xsl:param name="edit"/>
		<xsl:param name="title"/>
		<xsl:apply-templates mode="GS_simpleElement" select=".">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="$edit"/>
			<xsl:with-param name="title" select="$title"/>
			<xsl:with-param name="text">
				<xsl:call-template name="getElementText">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="$edit"/>
					<xsl:with-param name="rows" select="5"/>
				</xsl:call-template>
			</xsl:with-param>
		</xsl:apply-templates>
	</xsl:template>
	<!--
	DateTime (format = %Y-%m-%dT%H:%M:00)
	measDateTm
	stepDateTm
	usageDate
	planAvDtTm
	begin (with TM_Period as parent element)
	end (with TM_Period as parent element)
	clkTime (should only select time, not date. so not added at this point as the calendar is maybe not the best option for this)
	-->
	<xsl:template mode="iso19115Fra" match="measDateTm|stepDateTm|usageDate|planAvDtTm|begin[parent::TM_Period]|end[parent::TM_Period]">
		<xsl:param name="schema"/>
		<xsl:param name="edit"/>
		<xsl:choose>
			<xsl:when test="$edit=true()">
				<xsl:apply-templates mode="simpleElement" select=".">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="text">
						<xsl:variable name="ref" select="geonet:element/@ref"/>
						<table width="100%">
							<tr>
								<td>
									<input class="md" type="text" name="_{$ref}" id="_{$ref}_cal" value="{text()}" size="30" readonly="1"/>
								</td>
								<td align="center" width="30" valign="middle">
									<img src="{/root/gui/url}/images/GS/icone_calendrier.jpg" id="_{$ref}_trigger" style="cursor: pointer; border: 1px solid;" title="Date selector" onmouseover="this.style.background='red';" onmouseout="this.style.background=''"/>
									<script type="text/javascript">
                    Calendar.setup(
                    {
                    inputField  : &quot;_<xsl:value-of select="$ref"/>_cal&quot;,         // ID of the input field
                    ifFormat    : "%Y-%m-%dT%H:%M:00",                                // the date format
                    showsTime   : true, // Show the time
                    button      : &quot;_<xsl:value-of select="$ref"/>_trigger&quot;  // ID of the button
                    }
                    );
                    Calendar.setup(
                    {
                    inputField  : &quot;_<xsl:value-of select="$ref"/>_cal&quot;,         // ID of the input field
                    ifFormat    : "%Y-%m-%dT%H:%M:00",                                // the date format
                    showsTime   : true, // Show the time
                    button      : &quot;_<xsl:value-of select="$ref"/>_cal&quot;  // ID of the button
                    }
                    );
                  </script>
								</td>
								<td align="left" width="100%">
									<xsl:text>  </xsl:text>
									<a href="JavaScript:clear{$ref}();">
										<xsl:value-of select="/root/gui/strings/clear"/>
									</a>
									<script type="text/javascript">
                    function clear<xsl:value-of select="$ref"/>()	{
                    document.mainForm._<xsl:value-of select="$ref"/>.value = &quot;&quot;
                    }
                  </script>
								</td>
							</tr>
						</table>
					</xsl:with-param>
				</xsl:apply-templates>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates mode="element" select=".">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="$edit"/>
				</xsl:apply-templates>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- Date (format = %Y-%m-%d)
	refDate (child from CI_Date)
	resEdDate
	dateNext
	calDate
	mdDateSt is not editable (!we use DateTime instead of only Date!)
	-->
	<xsl:template mode="iso19115Fra" match="refDate|resEdDate|dateNext|calDate|gfc_versionDate">
		<xsl:param name="schema"/>
		<xsl:param name="edit"/>
		<xsl:choose>
			<xsl:when test="$edit=true()">
				<xsl:apply-templates mode="simpleElement" select=".">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="text">
						<xsl:variable name="ref" select="geonet:element/@ref"/>
						<table width="100%">
							<tr>
								<td>
									<input class="md" type="text" name="_{$ref}" id="_{$ref}_cal" value="{text()}" size="30" readonly="1"/>
								</td>
								<td align="center" width="30" valign="middle">
									<img src="{/root/gui/url}/images/GS/icone_calendrier.jpg" id="_{$ref}_trigger" style="cursor: pointer; border: 1px solid;" title="Date selector" onmouseover="this.style.background='red';" onmouseout="this.style.background=''"/>
									<script type="text/javascript">
                    Calendar.setup(
                    {
                    inputField  : &quot;_<xsl:value-of select="$ref"/>_cal&quot;,         // ID of the input field
                    ifFormat    : "%Y-%m-%d",                                // the date format
                    showsTime : false, // Do not show the time
                    button      : &quot;_<xsl:value-of select="$ref"/>_trigger&quot;  // ID of the button
                    }
                    );
                    Calendar.setup(
                    {
                    inputField  : &quot;_<xsl:value-of select="$ref"/>_cal&quot;,         // ID of the input field
                    ifFormat    : "%Y-%m-%d",                                // the date format
                    showsTime : false, // Do not show the time
                    button      : &quot;_<xsl:value-of select="$ref"/>_cal&quot;  // ID of the button
                    }
                    );
                  </script>
								</td>
								<td align="left" width="100%">
									<xsl:text>  </xsl:text>
									<a href="JavaScript:clear{$ref}();"> clear</a>
									<script type="text/javascript">
                    function clear<xsl:value-of select="$ref"/>()	{
                    document.mainForm._<xsl:value-of select="$ref"/>.value = &quot;&quot;
                    }
                  </script>
								</td>
							</tr>
						</table>
					</xsl:with-param>
				</xsl:apply-templates>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates mode="element" select=".">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="$edit"/>
				</xsl:apply-templates>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	file upload/download utilities
	-->
	<xsl:template mode="iso19115FraFileUpload" match="*">
		<xsl:param name="access" select="'public'"/>
		<xsl:call-template name="simpleElementGui">
			<xsl:with-param name="title" select="/root/gui/strings/file"/>
			<xsl:with-param name="text">
				<table width="100%">
					<tr>
						<xsl:variable name="ref" select="geonet:element/@ref"/>
						<td width="70%">
							<input type="file" class="content" name="f_{$ref}" value="{string(.)}"/>&#160;
            </td>
						<td align="right">
							<button class="content" onclick="javascript:doFileUploadAction('{/root/gui/locService}/resources.upload','{$ref}',document.mainForm.f_{$ref}.value,'{$access}')">
								<xsl:value-of select="/root/gui/strings/upload"/>
							</button>
						</td>
					</tr>
				</table>
			</xsl:with-param>
			<xsl:with-param name="schema"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template mode="iso19115FraFileRemove" match="*">
		<xsl:param name="access" select="'public'"/>
		<xsl:call-template name="simpleElementGui">
			<xsl:with-param name="title" select="/root/gui/strings/file"/>
			<xsl:with-param name="text">
				<table width="100%">
					<tr>
						<xsl:variable name="ref" select="geonet:element/@ref"/>
						<td width="70%">
							<xsl:value-of select="string(.)"/>
						</td>
						<td align="right">
							<button class="content" onclick="javascript:doFileRemoveAction('{/root/gui/locService}/resources.del','{$ref}','{$access}')">
								<xsl:value-of select="/root/gui/strings/remove"/>
							</button>
						</td>
					</tr>
				</table>
			</xsl:with-param>
			<xsl:with-param name="schema"/>
		</xsl:call-template>
	</xsl:template>
	<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
	<!-- iso19115Fra brief formatting -->
	<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
	<xsl:template name="iso19115FraBrief">
		<metadata>
			<xsl:variable name="id" select="geonet:info/id"/>
			<xsl:if test="dataIdInfo/idCitation/resTitle">
				<title>
					<xsl:value-of select="dataIdInfo/idCitation/resTitle"/>
				</title>
			</xsl:if>
			<xsl:if test="mdHrLv/ScopeCd/@value">
				<mdHrLv>
					<xsl:value-of select="mdHrLv/ScopeCd/@value"/>
				</mdHrLv>
			</xsl:if>
			<xsl:if test="dataIdInfo/idAbs">
				<abstract>
					<xsl:value-of select="dataIdInfo/idAbs"/>
				</abstract>
			</xsl:if>
			<xsl:for-each select="dataIdInfo/descKeys/keyword[text()]">
				<xsl:copy-of select="."/>
			</xsl:for-each>
			<xsl:if test="mdDateSt">
				<mdDateSt>
					<xsl:value-of select="mdDateSt"/>
				</mdDateSt>
			</xsl:if>
			<xsl:if test="dataIdInfo/dataScale/equScale/rfDenom">
				<rfDenom>
					<xsl:value-of select="dataIdInfo/dataScale/equScale/rfDenom"/>
				</rfDenom>
			</xsl:if>
			<xsl:if test="dataIdInfo/dataScale/scaleDist/value">
				<scaleDistValue>
					<xsl:value-of select="dataIdInfo/dataScale/scaleDist/value"/>
				</scaleDistValue>
			</xsl:if>
			<xsl:if test="dataIdInfo/dataScale//uomName">
				<unity>
					<xsl:value-of select="dataIdInfo/dataScale//uomName"/>
				</unity>
			</xsl:if>
			<xsl:for-each select="distInfo/distTranOps/onLineSrc">
				<xsl:choose>
					<xsl:when test="starts-with(./protocol,'WWW:DOWNLOAD-') and contains(./protocol,'http--download') and ./orName">
						<!-- FIXME -->
						<link type="download">
							<xsl:value-of select="linkage"/>
						</link>
					</xsl:when>
					<xsl:when test="starts-with(./protocol,'ESRI:AIMS-') and contains(./protocol,'-get-image') and ./orName">
						<link type="arcims">
							<xsl:value-of select="concat('javascript:popInterMap(&#34;',/root/gui/url,'/intermap/srv/',/root/gui/language,'/map.addServicesExt?url=',linkage,'&amp;service=',orName,'&amp;type=1&#34;)')"/>
						</link>
					</xsl:when>
					<xsl:when test="starts-with(./protocol,'OGC:WMS-') and contains(./protocol,'-get-map') and ./orName">
						<link type="wms">
							<xsl:value-of select="concat('javascript:popInterMap(&#34;',/root/gui/url,'/intermap/srv/',/root/gui/language,'/map.addServicesExt?url=',linkage,'&amp;service=',orName,'&amp;type=2&#34;)')"/>
						</link>
					</xsl:when>
					<xsl:when test="starts-with(./protocol,'OGC:WMS-') and contains(./protocol,'-get-capabilities') and ./orName">
						<link type="wms">
							<xsl:value-of select="concat('javascript:popInterMap(&#34;',/root/gui/url,'/intermap/srv/',/root/gui/language,'/map.addServicesExt?url=',linkage,'&amp;type=2&#34;)')"/>
						</link>
					</xsl:when>
					<xsl:when test="linkage[text()]">
						<link type="url">
							<xsl:value-of select="linkage[text()]"/>
						</link>
					</xsl:when>
				</xsl:choose>
			</xsl:for-each>
			<xsl:if test="dataIdInfo/geoBox">
				<geoBox>
					<westBL>
						<xsl:value-of select="dataIdInfo/geoBox/westBL"/>
					</westBL>
					<eastBL>
						<xsl:value-of select="dataIdInfo/geoBox/eastBL"/>
					</eastBL>
					<southBL>
						<xsl:value-of select="dataIdInfo/geoBox/southBL"/>
					</southBL>
					<northBL>
						<xsl:value-of select="dataIdInfo/geoBox/northBL"/>
					</northBL>
				</geoBox>
			</xsl:if>
			<!--
			<xsl:if test="not(geonet:info/server) and (string(geonet:info/source)=string(/root/gui/env/siteId))">
				<xsl:for-each select="dataIdInfo/graphOver">
					<xsl:choose>
						<xsl:when test="string(bgFileDesc)='thumbnail' and string(bgFileName)!=''">
							<image type="thumbnail"><xsl:value-of select="concat(/root/gui/locService,'/resources.get?id=',$id,'&amp;fname=',bgFileName,'&amp;access=public')"/></image>
						</xsl:when>
						<xsl:when test="string(bgFileDesc)='large_thumbnail' and string(bgFileName)!=''">
							<image type="overview"><xsl:value-of select="concat(/root/gui/locService,'/graphover.show?id=',$id,'&amp;fname=',bgFileName,'&amp;access=public')"/></image>
						</xsl:when>
					</xsl:choose>
				</xsl:for-each>
			</xsl:if>
			-->
			<xsl:if test="not(geonet:info/server)">
				<xsl:variable name="siteId" select="string(/root/gui/env/siteId)"/>
				<xsl:variable name="source" select="string(geonet:info/source)"/>
				<xsl:variable name="uuid" select="string(geonet:info/uuid)"/>
				<xsl:for-each select="dataIdInfo/graphOver">
					<xsl:choose>
						<xsl:when test="string(bgFileDesc)='thumbnail' and string(bgFileName)!=''">
							<xsl:choose>
								<xsl:when test="$source=$siteId">
									<image type="thumbnail">
										<xsl:value-of select="concat(/root/gui/locService,'/resources.get?id=',$id,'&amp;fname=',bgFileName,'&amp;access=public')"/>
									</image>
								</xsl:when>
								<xsl:when test="/root/gui/sources/source[string(code)=$source]">
									<image type="thumbnail">
										<xsl:value-of select="concat(/root/gui/sources/source[string(code)=$source]/baseURL,'/srv/en/resources.get2?uuid=',$uuid,'&amp;fname=',bgFileName,'&amp;access=public')"/>
									</image>
								</xsl:when>
							</xsl:choose>
						</xsl:when>
						<xsl:when test="string(bgFileDesc)='large_thumbnail' and string(bgFileName)!=''">
							<xsl:if test="$source=$siteId">
								<image type="overview">
									<xsl:value-of select="concat(/root/gui/locService,'/graphover.show?id=',$id,'&amp;fname=',bgFileName,'&amp;access=public')"/>
								</image>
							</xsl:if>
						</xsl:when>
					</xsl:choose>
				</xsl:for-each>
			</xsl:if>
			<xsl:copy-of select="geonet:info"/>
		</metadata>
	</xsl:template>
	<!--
	graphOver
	-->
	<xsl:template mode="iso19115Fra" match="graphOver">
		<xsl:param name="schema"/>
		<xsl:param name="edit"/>
		<xsl:if test="$edit=true() and $currTab!='simple'">
			<xsl:apply-templates mode="iso19115Fra_EditGraphOver" select=".">
				<xsl:with-param name="schema" select="$schema"/>
			</xsl:apply-templates>
		</xsl:if>
	</xsl:template>
	<xsl:template mode="iso19115Fra_EditGraphOver" match="*">
		<xsl:param name="schema"/>
		<xsl:apply-templates mode="complexElement" select=".">
			<xsl:with-param name="schema" select="$schema"/>
			<xsl:with-param name="edit" select="true()"/>
			<xsl:with-param name="content">
				<xsl:choose>
					<xsl:when test="(string(bgFileDesc)='thumbnail' or string(bgFileDesc)='large_thumbnail') and string(bgFileName)!=''">
						<xsl:apply-templates mode="iso19115Fra_FileRemove" select="bgFileName"/>
					</xsl:when>
					<xsl:when test="string(bgFileDesc)='thumbnail' or string(bgFileDesc)='large_thumbnail'">
						<xsl:apply-templates mode="iso19115Fra_FileUpload" select="bgFileName"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:apply-templates mode="elementEP" select="bgFileName|geonet:child[string(@name)='bgFileName']">
							<xsl:with-param name="schema" select="$schema"/>
							<xsl:with-param name="edit" select="true()"/>
						</xsl:apply-templates>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:apply-templates mode="elementEP" select="bgFileDesc|geonet:child[string(@name)='bgFileDesc']">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="true()"/>
				</xsl:apply-templates>
				<xsl:apply-templates mode="elementEP" select="bgFileType|geonet:child[string(@name)='bgFileType']">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="true()"/>
				</xsl:apply-templates>
			</xsl:with-param>
		</xsl:apply-templates>
	</xsl:template>
	<!--
	bgFileDesc
	-->
	<xsl:template mode="iso19115Fra" match="bgFileDesc">
		<xsl:param name="schema"/>
		<xsl:param name="edit"/>
		<xsl:choose>
			<xsl:when test="$edit=true()">
				<xsl:apply-templates mode="simpleElement" select=".">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="text">
						<xsl:variable name="value" select="string(.)"/>
						<select name="_{geonet:element/@ref}" size="1">
							<xsl:if test="string(.)=''">
								<option value=""/>
							</xsl:if>
							<xsl:for-each select="/root/gui/strings/bgFileDescChoice[@value]">
								<option value="{string(@value)}">
									<xsl:if test="string(@value)=$value">
										<xsl:attribute name="selected"/>
									</xsl:if>
									<xsl:value-of select="string(.)"/>
								</option>
							</xsl:for-each>
						</select>
					</xsl:with-param>
				</xsl:apply-templates>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates mode="element" select=".">
					<xsl:with-param name="schema" select="$schema"/>
					<xsl:with-param name="edit" select="false()"/>
				</xsl:apply-templates>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	file upload/download utilities
	-->
	<xsl:template mode="iso19115Fra_FileUpload" match="*">
		<xsl:param name="access" select="'public'"/>
		<xsl:call-template name="simpleElementGui">
			<xsl:with-param name="title" select="/root/gui/strings/file"/>
			<xsl:with-param name="text">
				<table width="100%">
					<tr>
						<xsl:variable name="ref" select="geonet:element/@ref"/>
						<td width="70%">
							<input type="file" class="content" name="f_{$ref}" value="{string(.)}"/>&#160;</td>
						<td align="left">
							<button class="content" onclick="javascript:doFileUploadAction('{/root/gui/locService}/resources.upload','{$ref}',document.mainForm.f_{$ref}.value,'{$access}')">
								<xsl:value-of select="/root/gui/strings/upload"/>
							</button>
						</td>
					</tr>
				</table>
			</xsl:with-param>
			<xsl:with-param name="schema"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template mode="iso19115Fra_FileRemove" match="*">
		<xsl:param name="access" select="'public'"/>
		<xsl:call-template name="simpleElementGui">
			<xsl:with-param name="title" select="/root/gui/strings/file"/>
			<xsl:with-param name="text">
				<table width="100%">
					<tr>
						<xsl:variable name="ref" select="geonet:element/@ref"/>
						<td width="70%">
							<xsl:value-of select="string(.)"/>
						</td>
						<td align="left">
							<button class="content" onclick="javascript:doFileRemoveAction('{/root/gui/locService}/resources.del','{$ref}','{$access}')">
								<xsl:value-of select="/root/gui/strings/remove"/>
							</button>
						</td>
					</tr>
				</table>
			</xsl:with-param>
			<xsl:with-param name="schema"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	iso19115Fra complete tab template
	-->
	<xsl:template name="iso19115FraCompleteTab">
		<xsl:param name="tabLink"/>
		<xsl:call-template name="displayTab">
			<xsl:with-param name="tab" select="'complete'"/>
			<!-- just a non-existing tab -->
			<xsl:with-param name="text" select="/root/gui/strings/completeTab"/>
			<xsl:with-param name="tabLink" select="$tabLink"/>
		</xsl:call-template>
		<xsl:call-template name="displayTab">
			<xsl:with-param name="tab" select="'metadata'"/>
			<xsl:with-param name="text" select="/root/gui/strings/metadata"/>
			<xsl:with-param name="indent" select="'&#xA0;&#xA0;&#xA0;'"/>
			<xsl:with-param name="tabLink" select="$tabLink"/>
		</xsl:call-template>
		<xsl:call-template name="displayTab">
			<xsl:with-param name="tab" select="'identification'"/>
			<xsl:with-param name="text" select="/root/gui/strings/identificationTab"/>
			<xsl:with-param name="indent" select="'&#xA0;&#xA0;&#xA0;'"/>
			<xsl:with-param name="tabLink" select="$tabLink"/>
		</xsl:call-template>
		<xsl:call-template name="displayTab">
			<xsl:with-param name="tab" select="'maintenance'"/>
			<xsl:with-param name="text" select="/root/gui/strings/maintenanceTab"/>
			<xsl:with-param name="indent" select="'&#xA0;&#xA0;&#xA0;'"/>
			<xsl:with-param name="tabLink" select="$tabLink"/>
		</xsl:call-template>
		<xsl:call-template name="displayTab">
			<xsl:with-param name="tab" select="'constraints'"/>
			<xsl:with-param name="text" select="/root/gui/strings/constraintsTab"/>
			<xsl:with-param name="indent" select="'&#xA0;&#xA0;&#xA0;'"/>
			<xsl:with-param name="tabLink" select="$tabLink"/>
		</xsl:call-template>
		<xsl:call-template name="displayTab">
			<xsl:with-param name="tab" select="'spatial'"/>
			<xsl:with-param name="text" select="/root/gui/strings/spatialTab"/>
			<xsl:with-param name="indent" select="'&#xA0;&#xA0;&#xA0;'"/>
			<xsl:with-param name="tabLink" select="$tabLink"/>
		</xsl:call-template>
		<xsl:call-template name="displayTab">
			<xsl:with-param name="tab" select="'spatial2'"/>
			<xsl:with-param name="text" select="/root/gui/strings/spatial2Tab"/>
			<xsl:with-param name="indent" select="'&#xA0;&#xA0;&#xA0;'"/>
			<xsl:with-param name="tabLink" select="$tabLink"/>
		</xsl:call-template>
		<xsl:call-template name="displayTab">
			<xsl:with-param name="tab" select="'refSys'"/>
			<xsl:with-param name="text" select="/root/gui/strings/refSysTab"/>
			<xsl:with-param name="indent" select="'&#xA0;&#xA0;&#xA0;'"/>
			<xsl:with-param name="tabLink" select="$tabLink"/>
		</xsl:call-template>
		<xsl:call-template name="displayTab">
			<xsl:with-param name="tab" select="'distribution'"/>
			<xsl:with-param name="text" select="/root/gui/strings/distributionTab"/>
			<xsl:with-param name="indent" select="'&#xA0;&#xA0;&#xA0;'"/>
			<xsl:with-param name="tabLink" select="$tabLink"/>
		</xsl:call-template>
		<xsl:call-template name="displayTab">
			<xsl:with-param name="tab" select="'dataQuality'"/>
			<xsl:with-param name="text" select="/root/gui/strings/dataQualityTab"/>
			<xsl:with-param name="indent" select="'&#xA0;&#xA0;&#xA0;'"/>
			<xsl:with-param name="tabLink" select="$tabLink"/>
		</xsl:call-template>
		<xsl:call-template name="displayTab">
			<xsl:with-param name="tab" select="'appSchInfo'"/>
			<xsl:with-param name="text" select="/root/gui/strings/appSchInfoTab"/>
			<xsl:with-param name="indent" select="'&#xA0;&#xA0;&#xA0;'"/>
			<xsl:with-param name="tabLink" select="$tabLink"/>
		</xsl:call-template>
		<xsl:call-template name="displayTab">
			<xsl:with-param name="tab" select="'porCatInfo'"/>
			<xsl:with-param name="text" select="/root/gui/strings/porCatInfoTab"/>
			<xsl:with-param name="indent" select="'&#xA0;&#xA0;&#xA0;'"/>
			<xsl:with-param name="tabLink" select="$tabLink"/>
		</xsl:call-template>
		<xsl:call-template name="displayTab">
			<xsl:with-param name="tab" select="'featCatInfo'"/>
			<xsl:with-param name="text" select="/root/gui/strings/featCatInfoTab"/>
			<xsl:with-param name="indent" select="'&#xA0;&#xA0;&#xA0;'"/>
			<xsl:with-param name="tabLink" select="$tabLink"/>
		</xsl:call-template>
	</xsl:template>
	<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
	<!-- utilities -->
	<!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
	<xsl:template mode="iso19115FraIsEmpty" match="*|@*">
		<!--xsl:message>GS_metadata-iso19115Fra mode="iso19115FraIsEmpty" match="*|@*"  
 		 </xsl:message-->
		<xsl:choose>
			<!-- normal element -->
			<xsl:when test="*">
				<xsl:apply-templates mode="iso19115FraIsEmpty"/>
			</xsl:when>
			<!-- text element -->
			<xsl:when test="text()!=''">txt</xsl:when>
			<!-- empty element -->
			<xsl:otherwise>
				<!-- codelist? -->
				<xsl:variable name="name" select="name(.)"/>
				<xsl:if test="substring($name, string-length($name)-1, 2)='Cd' or $name='languageCode'">
					<xsl:if test="@value!=''">cdl</xsl:if>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template mode="iso19115Fra" match="geonet:child">
		<xsl:param name="schema"/>
		<xsl:param name="edit" select="false()"/>
		<xsl:variable name="name" select="@name"/>
		<xsl:variable name="prevBrother" select="preceding-sibling::*[1]"/>
		<xsl:if test="$currTab!='simple' and (geonet:choose or name($prevBrother)!=$name)">
			<xsl:variable name="text">
				<xsl:if test="geonet:choose">
					<select class="md" name="_{../geonet:element/@ref}_{@name}" size="1">
						<xsl:for-each select="geonet:choose">
							<option value="{@name}">
								<xsl:call-template name="getTitle">
									<xsl:with-param name="name" select="@name"/>
									<xsl:with-param name="schema" select="$schema"/>
								</xsl:call-template>
							</option>
						</xsl:for-each>
					</select>
				</xsl:if>
			</xsl:variable>
			<xsl:variable name="addLink">
				<xsl:choose>
					<xsl:when test="geonet:choose">
						<xsl:value-of select="concat('javascript:doNewORElementAction(',$apos,/root/gui/locService,'/metadata.elem.add',$apos,',',../geonet:element/@ref,',',$apos,@name,$apos,',document.mainForm._',../geonet:element/@ref,'_',@name,'.value);')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat('javascript:doNewElementAction(',$apos,/root/gui/locService,'/metadata.elem.add',$apos,',',../geonet:element/@ref,',',$apos,@name,$apos,');')"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="helpLink">
				<xsl:call-template name="getHelpLink">
					<xsl:with-param name="name" select="@name"/>
					<xsl:with-param name="schema" select="$schema"/>
				</xsl:call-template>
			</xsl:variable>
			<xsl:call-template name="simpleElementGui">
				<xsl:with-param name="title">
					<xsl:call-template name="getTitle">
						<xsl:with-param name="name" select="@name"/>
						<xsl:with-param name="schema" select="$schema"/>
					</xsl:call-template>
				</xsl:with-param>
				<xsl:with-param name="text" select="$text"/>
				<xsl:with-param name="addLink" select="$addLink"/>
				<xsl:with-param name="helpLink" select="$helpLink"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>
