<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
	xmlns:geonet="http://www.fao.org/geonetwork"
	xmlns:xalan= "http://xml.apache.org/xalan" exclude-result-prefixes="xalan">

	<!--GEOSOURCE-->
	<xsl:include href="GS_metadata-iso19115Fra.xsl"/>
	<!--FIN GEOSOURCE-->
	
	<!--
	hack to extract geonet URI; I know, I could have used a string constant like
	<xsl:variable name="geonetUri" select="'http://www.fao.org/geonetwork'"/>
	but this is more interesting
	-->
	<xsl:variable name="geonetUri">
		<xsl:variable name="geonetNodeSet"><geonet:dummy/></xsl:variable>
		<xsl:value-of select="namespace-uri(xalan:nodeset($geonetNodeSet)/*)"/>
	</xsl:variable>

	<xsl:variable name="currTab">
		<xsl:choose>
			<xsl:when test="/root/gui/currTab"><xsl:value-of select="/root/gui/currTab"/></xsl:when>
			<xsl:otherwise>simple</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	
	<!-- GEOSOURCE -->
	<xsl:variable name="schema">
			<xsl:value-of select="//geonet:info/schema"/>
	</xsl:variable>
<!-- FIN GEOSOURCE -->

	<xsl:template match="*" mode="schema">
		<xsl:choose>
			<xsl:when test="string(geonet:info/schema)!=''"><xsl:value-of select="geonet:info/schema"/></xsl:when>
			<xsl:when test="name(.)='Metadata'">iso19115</xsl:when>
			<xsl:when test="name(.)='metadata'">fgdc-std</xsl:when>
			<xsl:otherwise>UNKNOWN</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- summary: copy it -->
	<xsl:template match="summary" mode="brief">
		<xsl:copy-of select="."/>
	</xsl:template>

	<!-- brief -->
	<xsl:template match="*" mode="brief">
		<xsl:param name="schema">
			<xsl:apply-templates mode="schema" select="."/>
		</xsl:param>

		<xsl:choose>
			<!-- ISO 19115 FRA-->
			<xsl:when test="$schema='iso19115Fra'">
				<xsl:call-template name="iso19115FraBrief"/>
			</xsl:when>

			<!-- default, no schema-specific formatting -->
			<xsl:otherwise>
				<metadata>
					<xsl:apply-templates mode="copy" select="*"/>
				</metadata>
			</xsl:otherwise>

		</xsl:choose>
	</xsl:template>

	<!--
	creates a thumbnail image, possibly with a link to larger image
	-->
	<xsl:template name="thumbnail">
		<xsl:param name="metadata"/>

		<xsl:choose>

			<!-- small thumbnail -->
			<xsl:when test="$metadata/image[@type='thumbnail']">

				<xsl:choose>

					<!-- large thumbnail link -->
					<xsl:when test="$metadata/image[@type='overview']">
						<a href="javascript:popWindow('{$metadata/image[@type='overview']}')">
							<img src="{$metadata/image[@type='thumbnail']}" alt="{/root/gui/strings/thumbnail}"/>
						</a>
					</xsl:when>

					<!-- no large thumbnail -->
					<xsl:otherwise>
							<img src="{$metadata/image[@type='thumbnail']}" alt="{/root/gui/strings/thumbnail}"/>
					</xsl:otherwise>
				</xsl:choose>

			</xsl:when>

			<!-- papermaps thumbnail -->
			<!-- FIXME
			<xsl:when test="/root/gui/paperMap and string(dataIdInfo/idCitation/presForm/PresFormCd/@value)='mapHardcopy'">
				<a href="PAPERMAPS-URL">
					<img src="{/root/gui/paperMap}" alt="{/root/gui/strings/paper}" title="{/root/gui/strings/paper}"/>
				</a>
			</xsl:when>
			-->

			<!-- no thumbnail -->
			<xsl:otherwise>
				<img src="{/root/gui/locUrl}/images/nopreview.gif" alt="{/root/gui/strings/thumbnail}"/>
			</xsl:otherwise>
		</xsl:choose>
		<br/>
		
	</xsl:template>

	<!--
	standard metadata buttons (edit/delete/admin/categories)
	-->
	<xsl:template name="buttons" match="*">
		<xsl:param name="metadata" select="."/>
		
		<!-- create button --> 
		<!-- When a user with access to the metadata.duplicate.form can see a template, he can use it. 
			  Also when not allowed to edit the template himself -->
		<!--ADD GEOSOURCE-->
		<!--
		<xsl:if test="(geonet:info/isTemplate='y' or geonet:info/source=/root/gui/env/siteId) and /root/gui/services/service/@name='metadata.duplicate.form'">
			<button type="button" class="content" onclick="load('{/root/gui/locService}/metadata.duplicate.form?id={$metadata/geonet:info/id}')"><xsl:value-of select="/root/gui/strings/create"/></button>
		&#160;			
		</xsl:if>
		-->
		<!--FIN ADD GEOSOURCE-->
		
		<!-- GEOSOURCE - ADDED SILOGIC - download button -->		
		<!-- TODO n'afficher que si possede les droits -->
		<xsl:if test="geonet:info/download='true'">

			<!--input class="content" type="checkbox" id="chk{./geonet:info/id}"  onclick="javascript:metadataselect({./geonet:info/id})" value="{./geonet:info/selected}" checked="checked"/-->

			<xsl:variable name="isSelected" select="geonet:info/selected" />
			<xsl:if test="$isSelected='true'">	

				<input class="content"  type="checkbox" id="chk{geonet:info/id}" name="chk{geonet:info/id}" onclick="javascript:metadataselect({geonet:info/id}, this.checked)"  checked="true"/>
				&#160;
				<button type="button"  class="content" onclick="load('{/root/gui/locService}/metadata.download?access=private&amp;id={geonet:info/id}')"><xsl:value-of select="/root/gui/strings/download"/></button>
    			&#160;

			</xsl:if>
			<xsl:if test="$isSelected='false'">

				<input class="content" type="checkbox" onclick="javascript:metadataselect({geonet:info/id}, this.checked)"/>
				&#160;	
				<button type="button"  class="content" onclick="load('{/root/gui/locService}/metadata.download?access=private&amp;id={geonet:info/id}')"><xsl:value-of select="/root/gui/strings/download"/></button>
    			&#160;
					
			</xsl:if>
    			&#160;
		</xsl:if>
			
		<!-- button PRINT always available ADDED PL BRGM-->
    			&#160;
				<button type="button" class="content" onclick="doPrint('{/root/gui/locService}/GS_metadata.print?id={geonet:info/id}')"><xsl:value-of select="/root/gui/strings/GS/print"/></button>
		<!-- button EXPORT available only if download is authorized-->
				<xsl:if test="geonet:info/download='true'">
				&#160;	
				<button type="button"  class="content" onclick="load('{/root/gui/locService}/metadata.download?access=private&amp;id={geonet:info/id}')"><xsl:value-of select="/root/gui/strings/download"/></button>			
				</xsl:if>
			<!-- END ADDED PL BRGM-->
			
			
		<xsl:if test="geonet:info/edit='true'">
			
	
		
			<!-- Only local metadata can be edited -->
			<xsl:if test="geonet:info/source = /root/gui/env/siteId">
				<!-- edit button -->
    			&#160;
				<button type="button" class="content" onclick="load('{/root/gui/locService}/metadata.edit?id={geonet:info/id}')"><xsl:value-of select="/root/gui/strings/edit"/></button>
			</xsl:if>
			
			<!-- GEOSOURCE -->
				<!-- duplicate button -->
    			&#160;
				<button type="button" class="content" onclick="load('{/root/gui/locService}/GS_metadata.duplicate.form?id={geonet:info/id}')"><xsl:value-of select="/root/gui/strings/duplicate"/></button>
			<!--
			&#160;
					<button class="content" onclick="load('{/root/gui/locService}/metadata.getStatus?id={$metadata/geonet:info/id}')"><xsl:value-of select="Status?"/></button>
			-->
			<!-- FIN GEOSOURCE -->

			<!-- delete button -->
			<!--ADD GEOSOURCE-->
			<!--
			&#160;
			<button type="button" class="content" onclick="return doConfirm('{/root/gui/locService}/metadata.delete?id={geonet:info/id}', '{/root/gui/strings/confirmDelete}')"><xsl:value-of select="/root/gui/strings/delete"/></button>
			-->
			<!-- FIN GEOSOURCE -->
			
			<!-- GS - ADDED SILOGIC - freeze button -->
			<!-- GEOSOURCE - ADDED SILOGIC - freeze button -->
			<!-- TODO Afficher que si des groupes ont des droits sur la metadata sans avoir celui Edit ou le groupe Internet a des privileges -->
    			&#160;
			<button type="button" class="content" onclick="return doConfirm('{/root/gui/locService}/metadata.freeze?id={geonet:info/id}', '{/root/gui/strings/confirmFreeze}')"><xsl:value-of select="/root/gui/strings/freeze"/></button>

			<!-- GEOSOURCE - ADDED SILOGIC - publish button -->
    			&#160;
			<button type="button"  class="content" onclick="load('{/root/gui/locService}/metadata.publish.form?id={geonet:info/id}')"><xsl:value-of select="/root/gui/strings/publish"/></button>
		</xsl:if>

		<xsl:if test="geonet:info/admin='true'">

			<!-- privileges button -->
    			&#160;
			<button type="button" class="content" onclick="load('{/root/gui/locService}/metadata.admin.form?id={geonet:info/id}')"><xsl:value-of select="/root/gui/strings/privileges"/></button>
			
			<!-- categories button -->
    		<!-- 	&#160;
			<button type="button" class="content" onclick="load('{/root/gui/locService}/metadata.category.form?id={geonet:info/id}')"><xsl:value-of select="/root/gui/strings/categories"/></button>
		-->
		</xsl:if>
		
	</xsl:template>

	<xsl:template name="formattedButtons" match="*">
		<xsl:param name="metadata" select="."/>
		
			
		<!-- GEOSOURCE - ADDED SILOGIC - download button -->		
		<!-- TODO n'afficher que si possede les droits -->

<!--
		<xsl:if test="geonet:info/download='true'">
			<xsl:variable name="isSelected" select="geonet:info/selected" />
			<xsl:if test="$isSelected='true'">	

    			<tr>
						<td>
							<table>
								<tr>
									<td>
										<input class="content"  type="checkbox" id="chk{geonet:info/id}" name="chk{geonet:info/id}" onclick="javascript:metadataselect({geonet:info/id}, this.checked)"  checked="true"/>
									</td>
									<td>
										<button type="button"  class="content" onclick="load('{/root/gui/locService}/metadata.download?access=private&amp;id={geonet:info/id}')"><xsl:value-of select="/root/gui/strings/download"/></button>
									</td>
								</tr>
							</table>
    				</td>
					</tr>
					
			</xsl:if>
			<xsl:if test="$isSelected='false'">

    			<tr>
						<td>
							<table>
								<tr>
									<td>
										<input class="content" type="checkbox" onclick="javascript:metadataselect({geonet:info/id}, this.checked)"/>
									</td>
									<td>
										<button type="button"  class="content" onclick="load('{/root/gui/locService}/metadata.download?access=private&amp;id={geonet:info/id}')"><xsl:value-of select="/root/gui/strings/download"/></button>
									</td>
								</tr>
							</table>
    				</td>
					</tr>
					
			</xsl:if>
		</xsl:if>
-->
		<xsl:if test="geonet:info/edit='true'">
			
			<!-- Only local metadata can be edited -->
			<xsl:if test="geonet:info/source = /root/gui/env/siteId">
				<!-- edit button -->
 					 		<button type="button" class="content" style="margin:2px" onclick="load('{/root/gui/locService}/metadata.edit?id={geonet:info/id}')"><xsl:value-of select="/root/gui/strings/edit"/></button>
 			<br/>
 			</xsl:if>
			
			<!-- GEOSOURCE -->
				<!-- duplicate button -->
 					 		<button type="button" class="content" style="margin:2px" onclick="load('{/root/gui/locService}/GS_metadata.duplicate.form?id={geonet:info/id}')"><xsl:value-of select="/root/gui/strings/duplicate"/></button>
 			<br/>	
			<!-- GS - ADDED SILOGIC - freeze button -->
			<!-- GEOSOURCE - ADDED SILOGIC - freeze button -->
			<!-- GEOSOURCE - ADDED SILOGIC - publish button -->
 					 		<button type="button"  class="content" style="margin:2px" onclick="load('{/root/gui/locService}/metadata.publish.form?id={geonet:info/id}')"><xsl:value-of select="/root/gui/strings/publish"/></button>
	<br/>
 			<!-- TODO Afficher que si des groupes ont des droits sur la metadata sans avoir celui Edit ou le groupe Internet a des privileges -->
 					 		<button type="button" class="content" style="margin:2px" onclick="return doConfirm('{/root/gui/locService}/metadata.freeze?id={geonet:info/id}', '{/root/gui/strings/confirmFreeze}')"><xsl:value-of select="/root/gui/strings/freeze"/></button>
 	
 	 			<br/>
  			<!-- FIN GEOSOURCE -->

			<!-- delete button -->
			<button type="button" class="content" style="margin:2px" onclick="return doConfirm('{/root/gui/locService}/metadata.delete?id={geonet:info/id}', '{/root/gui/strings/confirmDelete}')"><xsl:value-of select="/root/gui/strings/delete"/></button>
 	
 	</xsl:if>		
		
		
	</xsl:template>

	<!--
	editor left tab
	-->
	<xsl:template name="tab">
		<xsl:param name="schema">
			<xsl:apply-templates mode="schema" select="."/>
		</xsl:param>
		<xsl:param name="tabLink"/>
		
		<table width="100%">
		
			<!-- simple tab -->
			<xsl:call-template name="displayTab">
				<xsl:with-param name="tab"     select="'simple'"/>
				<xsl:with-param name="text"    select="/root/gui/strings/simpleTab"/>
				<xsl:with-param name="tabLink" select="$tabLink"/>
			</xsl:call-template>
			
			<!--  complete tab(s) -->
			<xsl:choose>
				<xsl:when test="$currTab='xml' or $currTab='simple'">
					<xsl:call-template name="displayTab">
						<xsl:with-param name="tab"     select="'metadata'"/>
						<xsl:with-param name="text"    select="/root/gui/strings/completeTab"/>
						<xsl:with-param name="tabLink" select="$tabLink"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
				
					<!-- metadata type-specific complete tab -->
					<xsl:choose>
						
	<!--GEOSOURCE-->
						<xsl:when test="$schema='iso19115Fra'">
							<xsl:call-template name="iso19115FraCompleteTab">
								<xsl:with-param name="tabLink" select="$tabLink"/>
							</xsl:call-template>
						</xsl:when>
	<!--FIN GEOSOURCE-->

						<!-- default, no schema-specific formatting -->
						<xsl:otherwise>
							<xsl:call-template name="completeTab">
								<xsl:with-param name="tabLink" select="$tabLink"/>
							</xsl:call-template>
						</xsl:otherwise>
						
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
			
			<!-- xml tab -->
			<xsl:choose>
				<xsl:when test="contains($tabLink,'metadata.show')">
					<xsl:call-template name="displayTab">
						<xsl:with-param name="tab"     select="'xml'"/>
						<xsl:with-param name="text"    select="/root/gui/strings/xmlTab"/>
						<xsl:with-param name="tabLink" select="$tabLink"/>
				</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="displayTab">
						<xsl:with-param name="tab"     select="'xml'"/>
						<xsl:with-param name="text"    select="/root/gui/strings/xmlTab"/>
						<xsl:with-param name="tabLink" select="$tabLink"/>
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
			

		
			
		</table>
	</xsl:template>
	
	<!--
	default complete tab template
	-->
	<xsl:template name="completeTab">
		<xsl:param name="tabLink"/>
		
		<xsl:call-template name="displayTab">
			<xsl:with-param name="tab"     select="'metadata'"/>
			<xsl:with-param name="text"    select="/root/gui/strings/completeTab"/>
			<xsl:with-param name="tabLink" select="$tabLink"/>
		</xsl:call-template>
		<!--
		<xsl:call-template name="displayTab">
			<xsl:with-param name="tab"     select="'metadata'"/>
			<xsl:with-param name="text"    select="/root/gui/strings/metadata"/>
			<xsl:with-param name="indent"  select="'&#xA0;&#xA0;'"/>
			<xsl:with-param name="tabLink" select="$tabLink"/>
		</xsl:call-template>
		-->
	</xsl:template>
	
	<!--
	shows a tab
	-->
	<xsl:template name="displayTab">
		<xsl:param name="tab"/>
		<xsl:param name="text"/>
		<xsl:param name="indent"/>
		<xsl:param name="tabLink"/>
		
		<xsl:variable name="currTab" select="/root/gui/currTab"/>
	
		<tr><td class="banner-leftmenu">
			<xsl:value-of select="$indent"/>
			
			<xsl:choose>
				<!-- not active -->
				<xsl:when test="$tabLink=''"><font class="banner-passive"><xsl:value-of select="$text"/></font></xsl:when>
				
				<!-- selected -->
				<xsl:when test="$currTab=$tab"><font class="banner-active-leftmenu"><xsl:value-of select="$text"/></font></xsl:when>
				
				<!-- not selected -->				
				<xsl:otherwise><a class="palette" href="javascript:doTabAction('{$tabLink}','{$tab}')"><xsl:value-of select="$text"/></a></xsl:otherwise>
			</xsl:choose>
		</td></tr>
	</xsl:template>
	
		<!--CONSTRUCTION DES ONGLETS DE LA VUE ESSENTIELLE-->
	<xsl:template name="editOnglets">
 		<xsl:param name="tab_1" select="'onglet_1'"/>
 		<xsl:param name="tab_2" select="'onglet_2'"/>
  		<xsl:param name="tab_3" select="'onglet_3'"/>
  		<xsl:param name="tab_4" select="'onglet_4'"/>
		<xsl:param name="tab_5" select="'onglet_5'"/>
		
	<div>									
		<ul id="maintab" class="shadetabs">
		
  		
			<xsl:choose>
		 	<xsl:when test="$currTab=$tab_1 or $currTab='simple' or $currTab=''">
 					<li class="selected"><a href="{$tab_1}" rel="ajaxcontentarea"><xsl:copy-of select="/root/gui/strings/GS/onglet_1"/></a></li>
 											
 			</xsl:when>
			<xsl:otherwise>
					<li><a href="{$tab_1}" rel="ajaxcontentarea"><xsl:copy-of select="/root/gui/strings/GS/onglet_1"/></a></li>
			</xsl:otherwise>
		</xsl:choose>
 		<xsl:choose>
		 	<xsl:when test="$currTab=$tab_2">
 					<li class="selected"><a href="{$tab_2}" rel="ajaxcontentarea"><xsl:copy-of select="/root/gui/strings/GS/onglet_2"/></a></li>									
 			</xsl:when>
			<xsl:otherwise>
					<li><a href="{$tab_2}" rel="ajaxcontentarea"><xsl:copy-of select="/root/gui/strings/GS/onglet_2"/></a></li>
			</xsl:otherwise>
		</xsl:choose>
		
 		<xsl:choose>
		 	<xsl:when test="$currTab=$tab_3">
 					<li class="selected"><a href="{$tab_3}" rel="ajaxcontentarea"><xsl:copy-of select="/root/gui/strings/GS/onglet_3"/></a></li>									
 			</xsl:when>
			<xsl:otherwise>
					<li><a href="{$tab_3}" rel="ajaxcontentarea"><xsl:copy-of select="/root/gui/strings/GS/onglet_3"/></a></li>
			</xsl:otherwise>
		</xsl:choose>
		
 		<xsl:choose>
		 	<xsl:when test="$currTab=$tab_4">
 					<li class="selected"><a href="{$tab_4}" rel="ajaxcontentarea"><xsl:copy-of select="/root/gui/strings/GS/onglet_4"/></a></li>									
 			</xsl:when>
			<xsl:otherwise>
					<li><a href="{$tab_4}" rel="ajaxcontentarea"><xsl:copy-of select="/root/gui/strings/GS/onglet_4"/></a></li>
			</xsl:otherwise>
		</xsl:choose>
		
 		<xsl:choose>
		 	<xsl:when test="$currTab=$tab_5">
 					<li class="selected"><a href="{$tab_5}" rel="ajaxcontentarea"><xsl:copy-of select="/root/gui/strings/GS/onglet_5"/></a></li>									
 			</xsl:when>
			<xsl:otherwise>
					<li><a href="{$tab_5}" rel="ajaxcontentarea"><xsl:copy-of select="/root/gui/strings/GS/onglet_5"/></a></li>
			</xsl:otherwise>
		</xsl:choose>
	
			</ul>
		<div id="ajaxcontentarea" class="contentstyle"/>
	</div>
	
	</xsl:template>

	

</xsl:stylesheet>
