<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:geonet="http://www.fao.org/geonetwork">
	<!--
	show metadata form
	-->
	<xsl:include href="main.xsl"/>
	<xsl:include href="metadata.xsl"/>
	<!--
	additional scripts
	-->
	<xsl:template mode="script" match="/">
		<script language="JavaScript1.2" type="text/javascript">

				function doPrint(action)
			{
				msgWindow=window.open("about","popWindow","location=no, toolbar=yes, directories=no, status=no, menubar=yes, scrollbars=yes, resizable=yes, width=800, 		height=600");
		msgWindow.focus();
				document.mainForm.action = action;
				oldTarget = document.mainForm.target;
				document.mainForm.target = 'popWindow';
				document.mainForm.currTab.value = 'print';
				goSubmit('mainForm');
				document.mainForm.target = oldTarget;
			}
			
			function doAction(action)
			{
				// alert("In doAction(" + action + ")"); // DEBUG
				document.mainForm.action = action;
				goSubmit('mainForm');
			}
			
			function doTabAction(action, tab)
			{
				// alert("In doTabAction(" + action + ", " + tab + ")"); // DEBUG
				document.mainForm.currTab.value = tab;
				doAction(action);
			}
			//variable globale permettant d'indiquer si on est en mode edition ou non
			var isEditMode = false;
		</script>
	</xsl:template>
	<!--
	page content
	-->
	<xsl:template name="content">
		<!-- Set image "choose tab" in an absolute manner -->
		<xsl:call-template name="imgChoose"/>
		<table width="100%" height="100%">
			<xsl:for-each select="/root/*[name(.)!='gui']">
				<!-- just one -->
				<tr height="100%">
					<td class="leftmenu-content" width="100px" valign="top">
						<table width="100%">
							<!-- Set left menu lines -->
							<xsl:call-template name="leftMenuLines"/>
							<tr>
								<td class="leftmenu-content" width="100px" valign="top">
									<xsl:call-template name="tab">
										<xsl:with-param name="tabLink" select="concat(/root/gui/locService,'/metadata.show')"/>
									</xsl:call-template>
								</td>
							</tr>
						</table>
					</td>
					<td class="content" valign="top">
						<table width="100%">
							<xsl:variable name="buttons">
								<tr>
									<td colspan="2" class="padded-content" height="30px" align="center" valign="top">
										<xsl:call-template name="buttons"/>
									</td>
								</tr>
							</xsl:variable>
							<xsl:if test="$buttons!=''">
								<xsl:copy-of select="$buttons"/>
							</xsl:if>
							<!-- Set title (as a caption) above tabs -->
							<xsl:call-template name="tabsCaption">
								<xsl:with-param name="caption" select="/root/gui/strings/titleMdc"/>
							</xsl:call-template>
							<!-- <tr><td class="padded-content"> -->
							<tr>
								<!-- Set image "onglet" -->
								<xsl:call-template name="imgOnglet"/>
								<td class="padded-content">
									<!--<table class="md" width="100%">-->
									<form name="mainForm" accept-charset="UTF-8" method="POST" action="{/root/gui/locService}/metadata.edit">
										<input type="hidden" name="id" value="{geonet:info/id}"/>
										<input type="hidden" name="currTab" value="{/root/gui/currTab}"/>
										<!--GEOSOURCE-->
										<input type="hidden" name="context" value="{/root/gui/locService}"/>
										<input type="hidden" name="baseUrl" value="{/root/gui/url}"/>
										<!--FIN GEOSOURCE-->
										<xsl:choose>
											<!--GEOSOURCE-->
											<!-- DEFAULT VIEW -->
											<xsl:when test="$currTab='simple' or $currTab='onglet_1'
											or $currTab='onglet_2' or $currTab='onglet_3'
											or $currTab='onglet_4' or $currTab='onglet_5'">
												<!---->
												<xsl:choose>
													<xsl:when test="$schema='iso19115Fra'">
														<xsl:call-template name="editOnglets"/>
													</xsl:when>
													<xsl:otherwise>
														<table class="md" width="100%">
															<xsl:apply-templates mode="elementEP" select=".">
																<xsl:with-param name="edit" select="false()"/>
															</xsl:apply-templates>
														</table>
													</xsl:otherwise>
												</xsl:choose>
												<!---->
											</xsl:when>
											<!--FIN GEOSOURCE-->
											<xsl:when test="$currTab='xml'">
												<xsl:apply-templates mode="xmlDocument" select="."/>												
											</xsl:when>
											<xsl:otherwise>
												<xsl:apply-templates mode="elementEP" select="."/>
											</xsl:otherwise>
										</xsl:choose>
									</form>
									<!--</table>-->
								</td>
							</tr>
							<xsl:if test="$buttons!=''">
								<xsl:copy-of select="$buttons"/>
							</xsl:if>
						</table>
					</td>
				</tr>
			</xsl:for-each>
			<tr>
				<td class="blue-content" colspan="3"/>
			</tr>
		</table>
	</xsl:template>
</xsl:stylesheet>
