<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:geonet="http://www.fao.org/geonetwork">
	<!--
	show metadata form
	-->
     <xsl:include href="GS_main-work.xsl"/>
	<xsl:include href="metadata.xsl"/>
	<!--
	additional scripts
	-->
	<xsl:template mode="script" match="/">
		<script language="JavaScript1.2" type="text/javascript">
		
			
			function doAction(action)
			{
				// alert("In doAction(" + action + ")"); // DEBUG
				document.mainForm.action = action;
				goSubmit('mainForm');
			}
			
			function doTabAction(action, tab)
			{
				// alert("In doTabAction(" + action + ", " + tab + ")"); // DEBUG
				document.mainForm.currTab.value = tab;
				doAction(action);
			}
			//variable globale permettant d'indiquer si on est en mode edition ou non
			var isEditMode = false;
		</script>
	</xsl:template>
	<!--
 global page
	-->
    <xsl:template match="/">
  		<xsl:call-template name="mainPage"><xsl:with-param name="popup" select="'true'"/></xsl:call-template>
	</xsl:template>	
		<!--			-->
	
	<!--
	page content
	-->
	<xsl:template name="content">
		
		
		<table width="85%" height="100%">
			<xsl:for-each select="/root/*[name(.)!='gui']">
				<!-- just one -->
				<tr height="100%">
					<!--<td class="leftmenu-content" width="100px" valign="top">
						<table width="100%">

							<xsl:call-template name="leftMenuLines"/>
							<tr>
								<td class="leftmenu-content" width="100px" valign="top">
									<xsl:call-template name="tab">
										<xsl:with-param name="tabLink" select="concat(/root/gui/locService,'/metadata.show')"/>
									</xsl:call-template>
								</td>
							</tr>
						</table>
					</td>-->
					<td class="content" valign="top">
						<table width="100%">

							<!-- Set title (as a caption) above tabs -->
							<xsl:call-template name="tabsCaption">
								<xsl:with-param name="caption" select="/root/gui/strings/titleMdc"/>
							</xsl:call-template>
							<!-- <tr><td class="padded-content"> -->
							<tr>
								<!-- Set image "onglet" -->
								<td class="padded-content">
									<!--<table class="md" width="100%">-->
									<form name="mainForm" accept-charset="UTF-8" method="POST" action="{/root/gui/locService}/metadata.edit">
										<input type="hidden" name="id" value="{geonet:info/id}"/>
										<input type="hidden" name="currTab" value="{/root/gui/currTab}"/>
										<!--GEOSOURCE-->
										<input type="hidden" name="context" value="{/root/gui/locService}"/>
										<input type="hidden" name="baseUrl" value="{/root/gui/url}"/>
										<!--FIN GEOSOURCE-->												
										<table class="md" width="100%">
											<xsl:apply-templates mode="elementEP" select=".">
												<xsl:with-param name="edit" select="false()"/>
											</xsl:apply-templates>
										</table>
									</form>
									<!--</table>-->
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</xsl:for-each>
			<tr>
				<td class="blue-content" colspan="3"/>
			</tr>
		</table>
	</xsl:template>
</xsl:stylesheet>
