<?php
/**********************************************
Conversion des fichiers php4 vers php5
***********************************************
Date:    Le 02/07/2007
Auteur : Alexis DUBOIS
Contributeur : Mryl HOBIN
***********************************************/
// -----------------------------------------------
// -------------- CONFIGURATION ------------------
// Repertoire des fichiers sources
define("C_SOURCE_PATH", "./origine/");
// Repertoire des fichiers modifies
// Il faut le creer au prealable
define("C_RESULT_PATH", "./resultat/");
// ------------------------------------------------
// Ne rien ecrire sous cette ligne
// ------------------------------------------------

// Augmentation du TimeOut
// Attention si SafeMode activ&eacute; alors il faut modifier le 'php.ini'
set_time_limit(10000);

// Debut du rendu HTML
echo "<html>";
echo "<head>";
echo "<title>Convertisseur PHP4-PHP5</title>";
echo "</head>";
echo "<body bgcolor='#2E3577' text='white' link='orange' vlink='orange' alink='orange' style='font-family:Arial,sans-serif; font-size:12pt; color:white;'>";

// Fonction recursive sur les repertoires
// --------------------------------------
function parcourir($rep, $ssrep) {
    if( $dir = opendir($rep) ) {
        while( FALSE !== ($fich = readdir($dir))) {
            $chemin = "$rep$fich";
            if ($fich != "." && $fich != ".." && $fich != "spaw" && $fich != "fckeditor" && $fich != "lib") {
                if (is_dir($chemin)) {
                    echo "Parcours du r&eacute;pertoire : <b>".$chemin."</b><BR>";                    
                    if ($ssrep == '') {
                        $tmp = $fich;
                    } else {
                        $tmp = $ssrep.'/'.$fich;
                    }
                    // Creation du repertoire dans le path de result
                    mkdir(C_RESULT_PATH.$tmp);
                    // Appel recursif de la methode
                    parcourir($chemin.'/', $tmp);
                } else {
                    if ($ssrep=='') {
                        $fFichier = $fich;
                    } else {
                        $fFichier = $ssrep.'/'.$fich;
                    }
                    echo "Fichier courant : ".$fFichier."<br>";
                    // Execute la transformation du fichier
                    if(transformeFichier($fFichier, C_SOURCE_PATH)) {
                        echo "La transformation du fichier : ".$fFichier." est termin&eacute;e<br>";  
                    } else {
                        echo "La transformation du fichier : ".$fFichier." <font color='red'>a &eacute;chou&eacute;e</font><br>";  
                    }
                }
            } else {
                // Copie de tout le repertoire
                if ($fich != "." && $fich != "..") {
                    // Creation du repertoire dans le path de result
                    $tmp = $chemin;
                    $vers = str_replace(C_SOURCE_PATH, C_RESULT_PATH, $tmp);
                    mkdir($vers);
                    echo "<font color='red'>On est dans le r&eacute;pertoire suivant : <b>".$chemin."/"."</b></font><br>";
                    copieDir($chemin.'/', '');
                }
            }
        }
    }
}

// Fonction pour la copie des repertoires non parcourus par la moulinette
// ----------------------------------------------------------------------
function copieDir ($rep, $ssrep) {
    if( $dir = opendir($rep) ) {
        while( FALSE !== ($fich = readdir($dir))) {
            $chemin = "$rep$fich";
            if ($fich != "." && $fich != "..") {
                if (is_dir($chemin)) {
                    echo "Parcours du r&eacute;pertoire : <b>".$chemin."</b><BR>";                    
                    if ($ssrep == '') {
                        $tmp = $fich;
                    } else {
                        $tmp = $ssrep.'/'.$fich;
                    }
                    // Creation du repertoire dans le path de result
                    $cheminTmp = $chemin;
                    $vers = str_replace(C_SOURCE_PATH, C_RESULT_PATH, $cheminTmp);
                    // Cr&eacute;ation physique du r&eacute;pertoire
                    echo "Cr&eacute;ation du r&eacute;pertoire : ".$vers."<br>";
                    mkdir($vers);
                    // Appel recursif de la methode
                    copieDir($chemin.'/', $tmp);
                } else {
                    if ($ssrep=='') {
                        $fFichier = $fich;
                    } else {
                        $fFichier = $ssrep.'/'.$fich;
                    }
                    // Remplacement de la source par la destination
                    $tmp = $chemin;
                    $vers = str_replace(C_SOURCE_PATH, C_RESULT_PATH, $tmp);
                    echo "Copie du fichier de ".$chemin." vers ".$vers." sans conversion<br>";
                    // Copie effective du fichier
                    copy($chemin, $vers);
                }
            }
        }
    }
}

// Fonction de conversion des fichiers de php4 vers php5
// -----------------------------------------------------
function transformeFichier($fFichier, $sChemin) {
    $sContenu = "";
    $newLigne = "";
    $arr_file = array();
    // Recherche si fichier '.php' ou '.class'
    // Sinon recherche si fichier '.xml'
    // Sinon copie du fichier de la source vers le result sans transformation
    if (ereg(".class|.php" ,$fFichier) == 1) {
        echo "Conversion du fichier :".$sChemin.$fFichier."<br>";
        $arr_file = file($sChemin.$fFichier);
        if(!$arr_file) {
            echo "Impossible de lire $fFichier ou le fichier est vide<br>";
        } else {
            // Initialisation d'une variable pour la premiere ligne
            $i = 1;
            foreach($arr_file as $sLigne) {
                // POUR LES BESOINS DES TESTS
                $newLigne = $sLigne;
                if ($i == 1) {
                    $newLigne = str_replace("<?", "<?php", $newLigne);
                    $newLigne = str_replace("phpphp", "php", $newLigne);
                }
                // Remplacement des premiers cles obligatoires pour php5
                // Evite ainsi les leve d erreur
                // Convention de syntaxe
                $newLigne = str_replace("var $", "public $", $newLigne);
                // Pour le fichier Feeder.class
                $newLigne = str_replace("prt_formpublics_dependance", "prt_formvars_dependance", $newLigne);
                // Pour le fichier PortletCache.class
                $newLigne = str_replace("formpublics", "formvars", $newLigne);
                // Convention de syntaxe
                $newLigne = str_replace("function", "public function", $newLigne);
                // Pour le fichier Feeder.class et XMLArticle.class
                $newLigne = str_replace("public function_exists", "function_exists", $newLigne);
                // Remplacement des appels aux variables postees
                // Par precautions nous ne limitons pas ces remplacements aux seuls fichiers du noyau,
                // leur utilsation est possible pour des besoins specifique dans les developpements
                $newLigne = str_replace("HTTP_POST_VARS", "_POST", $newLigne);
                $newLigne = str_replace("HTTP_GET_VARS", "_GET", $newLigne);
                $newLigne = str_replace("HTTP_POST_FILES", "_FILES", $newLigne);
                // Remplacement specifiques a certains fichiers
                // Page.class du BackOffice
                if (ereg("Page.class", $fFichier)) {
                    $newLigne = str_replace("feeder", "Feeder", $newLigne);
                }
                // Feeder.class du noyau
                if (ereg("Feeder.class", $fFichier)) {
                    $newLigne = str_replace('!= "portlet"', '!= "Portlet"', $newLigne);
                }
                // XMLMapper.class du noyau
                if (ereg("XMLMapper.class", $fFichier)) {
                    $newLigne = str_replace('xml_parser_set_option($p, XML_OPTION_CASE_FOLDING, 0);', 'xml_parser_set_option($p, XML_OPTION_CASE_FOLDING, 0);xml_parser_set_option($p, XML_OPTION_TARGET_ENCODING, "ISO-8859-1");', $newLigne);
                    $newLigne = str_replace('$sOut = "<?xml version=\"1.0\"?>";', '$sOut = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>";', $newLigne);
                }
                // Reference aux '&' (par defaut dans php5)
                $newLigne = str_replace("&&", "_##_##_", $newLigne);
                $newLigne = str_replace("&new", "new", $newLigne);
                $newLigne = str_replace("& new", "new", $newLigne);
                $newLigne = str_replace("=&", "=", $newLigne);
                $newLigne = str_replace("&$", "$", $newLigne);
                $newLigne = str_replace("& $", "$", $newLigne);
                $newLigne = str_replace("_##_##_", "&&", $newLigne);
                // Construction du nouveau contenu
                $sContenu .= $newLigne;
                // Incrementation du compteur de ligne
                $i++;
            }
        }
    } elseif (ereg(".xml" ,$fFichier) == 1) {
        echo "Travail sur le fichier :".$sChemin.$fFichier."<br>";
        $arr_file = file($sChemin.$fFichier);
        if(!$arr_file) {
            echo "Impossible de lire $fFichier<br>";
        } else {
            foreach($arr_file as $sLigne) {
                // Remplacement de l'entete '.xml' quelque soit la syntaxe initiale
                // POUR LES BESOINS DE TESTS
                $newLigne = $sLigne;
                $newLigne  = str_replace('<?xml version="1.0"?>', '<?xml version="1.0" encoding="ISO-8859-1"?>', $newLigne);
                $newLigne  = str_replace('<?xml version="1.0" ?>', '<?xml version="1.0"encoding="ISO-8859-1"?>', $newLigne);
                $newLigne  = str_replace('<?xml version="1.0"encoding="UTF-8"?>', '<?xml version="1.0" encoding="ISO-8859-1"?>', $newLigne);
                $newLigne  = str_replace('<?xml version="1.0" encoding="UTF-8"?>', '<?xml version="1.0" encoding="ISO-8859-1"?>', $newLigne);
                $newLigne  = str_replace('<?xml version="1.0"encoding="UTF-8 "?>', '<?xml version="1.0" encoding="ISO-8859-1"?>', $newLigne);
                $newLigne  = str_replace('<?xml version="1.0" encoding="UTF-8 "?>', '<?xml version="1.0" encoding="ISO-8859-1"?>', $newLigne);
                $newLigne  = str_replace('<?xml version="1.0"encoding="UTF-8" ?>', '<?xml version="1.0" encoding="ISO-8859-1"?>', $newLigne);
                $newLigne  = str_replace('<?xml version="1.0" encoding="UTF-8" ?>', '<?xml version="1.0" encoding="ISO-8859-1"?>', $newLigne);
                $newLigne  = str_replace('<?xml version="1.0"encoding="UTF-8 " ?>', '<?xml version="1.0" encoding="ISO-8859-1"?>', $newLigne);
                $newLigne  = str_replace('<?xml version="1.0" encoding="UTF-8" ?>', '<?xml version="1.0" encoding="ISO-8859-1"?>', $newLigne);
                // Construction du nouveau contenu
                $sContenu .= $newLigne;
            }
        }
    } else {
        // Copie du fichier de la source vers le result
        if(copy($sChemin.$fFichier, C_RESULT_PATH.$fFichier)) {
            echo "Le fichier a &eacute;t&eacute; copi&eacute; avec succ&egrave;s sans transformation<br>";
            return true;
        } else {
            echo "Le fichier n'a pas &eacute;t&eacute; copi&eacute; avec succ&egrave;s sans transformation<br>";
            return false;
        }
    }
    // Ecriture du contenu si il fichier non vide
    if ($sContenu != "") {
        $fp = fopen(C_RESULT_PATH.$fFichier, "w+");
        fputs($fp, $sContenu);
        fclose($fp);
        return true;
    } else {
        return false;
    }
} // END FUNCTION

// Lancement de la conversion
// --------------------------
parcourir(C_SOURCE_PATH, '');

echo "</body>";
echo "</html>";
?>