# -*- coding: utf-8 -*-
#
# File: .py
#
# Copyright (c) 2006 atReal
#
# GNU General Public License (GPL)
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
# 02110-1301, USA.
#

"""
$Id: meeting.py 917 2006-12-22 10:30:32Z drjnut $
"""
__author__ = """atReal <contact@atreal.net> : T.Benita, M.Broquet & J-N.Bes"""
__docformat__ = 'plaintext'
__licence__ = 'GPL'


from AccessControl import ClassSecurityInfo
from Products.Archetypes.atapi import *
from Products.PloneDelib.config import *
from Products.CMFCore.utils import getToolByName
from Products.ATContentTypes.content.base import ATCTOrderedFolder
from Products.ATContentTypes.content.schemata import ATContentTypeSchema
from Products.AddRemoveWidget import AddRemoveWidget
from Products.Archetypes import transaction


schema = Schema((

    DateTimeField(
        name='meetingDate',
        required=1,
        index='FieldIndex',
        widget=CalendarWidget(
            label='Date de la séance du conseil',
            label_msgid='PloneDelib_label_meetingDate',
            i18n_domain='PloneDelib',
            show_hm=False,
        )
    ),
    LinesField(
        name='categories',
        vocabulary='getExistingCategories',
        isMetadata=True,
        widget=AddRemoveWidget(
            allow_add=1,
            label='Rubriques',
            description="Choisissez les rubriques de l'ordre du jour.",
            label_msgid='PloneDelib_label_categories',
            i18n_domain='PloneDelib',
        )
    ),

),
)

Meeting_schema = ATCTOrderedFolder.schema.copy() + schema

Meeting_schema['relatedItems'].widget.visible={'view': "invisible", 'edit': "invisible", }
Meeting_schema['title'].widget.visible={'view': "invisible", 'edit': "invisible", }
Meeting_schema['title'].required=0
Meeting_schema['description'].widget.description="S'il y a des commentaires à rajouter à la séance, vous pouvez les saisir ici (facultatif)."
Meeting_schema['description'].widget.label='Notes'
Meeting_schema['description'].widget.i18n_domain='plonedelib'

class Meeting(ATCTOrderedFolder):
    """Plone Content Type
    """
    security = ClassSecurityInfo()

    # This name appears in the 'add' box
    archetype_name = 'Séance du conseil'

    meta_type = 'Meeting'
    portal_type = 'Meeting'
    allowed_content_types = [
                             'Category',
                             'Agenda', 
                             'Proxy', 
                             'Presence', 
                             'ShortReport', 
                             'FullReport', 
                            ]
    filter_content_types = 1
    #global_allow = 0
    #immediate_view = 'base_view'
    default_view = 'meeting_view'
    content_icon = "meeting_icon.gif"
    #suppl_views = ()
    typeDescription = "Meeting"
    typeDescMsgId = 'description_edit_meeting'

    _at_rename_after_creation = True

    schema = Meeting_schema
   
    # used to detect a meetingDate changement
    dateWitness = ""
    
    security.declarePrivate('at_post_edit_script')
    def at_post_create_script(self):
      """ Création de l'ID, Title, puis on crée les rubriques souhaitées
      """ 
     # import pdb; pdb.set_trace()
      self.dateWitness = self.toLocalizedTime(self.meetingDate)
      self.updateTitleAndId(self.dateWitness)
      pu = getToolByName(self, 'plone_utils')
      catList = [(pu.normalizeString(item),item) for item in self.getCategories()]
      self.createCategories(catList)
      

    security.declarePrivate('at_post_edit_script')
    def at_post_edit_script(self):
      # loading tools
      pc = getToolByName(self, 'portal_catalog')
      pu = getToolByName(self, 'plone_utils')
      # computing categories
      path="/".join(self.getPhysicalPath())
      existingCat = set([(item.getId,item.Title) for item in pc(portal_type="Category",path=path)])
      newCat = set([(pu.normalizeString(item),item) for item in self.getCategories()])
      toDelete = existingCat - newCat
      toCreate = newCat - existingCat
      self.deleteCategories(toDelete)
      self.createCategories(toCreate)
      # id & title update if necessary
      actualDate = self.toLocalizedTime(self.meetingDate)
      if self.dateWitness!=actualDate:
        self.updateTitleAndId(actualDate)
        self.dateWitness=actualDate
    
 
    security.declarePrivate('updateTitleAndId')
    def updateTitleAndId(self,newDate):
      """ Affecte ID et Title.       
      """
      plone_utils = getToolByName(self, 'plone_utils', None)
      title = unicode("Séance du %s",'utf-8') % newDate
      new_id = plone_utils.normalizeString(title)
      container = self.aq_parent
      if not new_id in container.keys():
        id = new_id
        myversion = 0 
      else:
        import re
        suffix = re.compile("%s_version-(.*)$" % new_id)
        versions = [int(suffix.search(id).group(1)) for id in container.keys() if suffix.search(id)] 
        myversion = 1
        if len(versions):
          myversion = max(versions)+1
        id = "%s_version-%s" % (new_id,str(myversion)) 
      #the savepoint is mandatory for portal_factory
      transaction.savepoint(optimistic=True)
      # XXX bizarre bizarre -> dirty hack by drjnut
      #try:
      self.setId(id)
      #except AttributeError:
      #  pass
      if myversion:
        title=title+" - v%s" % myversion
      self.setTitle(title)
      self.reindexObject()
      container.reindexObject() 


    security.declarePrivate('createCategories')
    def createCategories(self,catList):
      tt = getToolByName(self, 'portal_types')
      for id,title in catList: 
        print "Id : %s -- Title : %s" % (id,title)
        if not id in self.keys():
          try:
            tt.constructContent(type_name="Category", container=self, id=id, title=title)
            self[id].reindexObject()
          except:
            print "Erreur lors de la création de la rubrique %s." \
                  % (title)
          continue
        else:
          print "La rubrique %s existe déjà." % title
      self.reindexObject()
        
    
    security.declarePrivate('deleteCategories')
    def deleteCategories(self,catList):
      for id,title in catList:
        if id in self.keys():
          try:
            self.manage_delObjects([id])
          except:
            print "Erreur lors de la suppression de la rubrique %s." \
                % title 
          continue
      self.reindexObject()
           

    security.declarePrivate('getExistingCategories')
    def getExistingCategories(self):
      """ Renvoie les rubriques déja existantes dans l'application.
      """
      uniqueCat = []
      pc = getToolByName(self,'portal_catalog')
      brains = pc(portal_type='Category')
      for item in brains: 
        if item.Title not in uniqueCat:
          uniqueCat.append(item.Title)
      return uniqueCat

    constrainTypesMode=0

    def getConstrainTypesMode(self):
      """Dummy"""
      return self.constrainTypesMode
    
    def getNotAddableTypes(self):
      """Overload to control some documents cardinality"""
      #notAvailTypes = list(ATCTOrderedFolder.getNotAddableTypes(self))
      notAvailTypes = ['Favorite']
      for type in ['Agenda', 'Proxy', 'Presence', 'ShortReport', 'FullReport']:
        if len(self.portal_catalog(portal_type=type, path="/".join(self.getPhysicalPath())))>0:
          notAvailTypes.append(type)
      return tuple(notAvailTypes)
    
    def getLost(self):
      """Debug"""
      import pdb; pdb.set_trace()
      print "Youpi."

registerType(Meeting, PROJECTNAME)
