"""

$Id: Install.py,v 1.3 2005/06/06 08:07:58 roeder Exp $

"""



__author__  = ''

__docformat__ = 'restructuredtext'



# Python imports

from StringIO import StringIO

import string



# CMF imports

from Products.CMFCore.utils import getToolByName



# Archetypes imports

from Products.Archetypes.Extensions.utils import installTypes, install_subskin

from Products.Archetypes.public import listTypes



# Products imports

from Products.FileSystemStorage.config import PROJECTNAME, GLOBALS, fss_prefs_configlet

from Products.FileSystemStorage.FSSTool import FSSTool



def install(self):

    out = StringIO()



    # Install types

    type_info = listTypes(PROJECTNAME)

    installTypes(self, out, type_info, PROJECTNAME)



    # Install tools

    add_tool = self.manage_addProduct[PROJECTNAME].manage_addTool

    if not self.objectIds(spec=FSSTool.meta_type):

        add_tool(FSSTool.meta_type)

    

    # Install skin

    install_subskin(self, out, GLOBALS)

    

    # Install configlet

    cp_tool = getToolByName(self, 'portal_controlpanel')

    try:
        cp_tool.registerConfiglet(**fss_prefs_configlet)
    except:
        pass
    

    out.write('Installation completed.\n')

    return out.getvalue()





def uninstall(self):

    out = StringIO()



    # Uninstall configlets

    try:

        cp_tool = getToolByName(self, 'portal_controlpanel')

        cp_tool.unregisterApplication(PROJECTNAME)

    except:

        pass



    out.write('Uninstallation completed.\n')

    return out.getvalue()

