# -*- coding: utf-8 -*-
#
# File: content/delink.py
#
# Copyright (c) 2006 atReal
#
# GNU General Public License (GPL)
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
# 02110-1301, USA.
#

"""
$Id$
"""

__author__ = """atReal <contact@atreal.net> : T.Benita, J-N.Bes & M.Broquet"""
__docformat__ = 'plaintext'
__licence__ = 'GPL'

from Products.Archetypes.public import *
from Products.Archetypes import transaction
from Products.ATContentTypes.content.base import *
from Products.PloneDelib.config import PROJECTNAME

# CMF imports
from Products.CMFCore import CMFCorePermissions
from Products.CMFCore.utils import getToolByName
from Products.CMFCore.permissions import View

from Products.ATContentTypes.content.base import updateAliases, updateActions

from AccessControl import ClassSecurityInfo

Delink_schema = BaseSchema.copy() + Schema((
    TextField('description',
                searchable=1,
                required=1,
                default="",
                schemata="metadata",
                accessor="Description",
                widget=TextAreaWidget(
                  label="Description",
                  visible={'edit': 'visible', 'view': 'invisible'}
                )
    ),
    StringField('targetUID',
        default='',
        widget=StringWidget(
            label='Identifiant Cible',
            invisible = {'view': "invisible", 'edit': "invisible"}
        ),
    ),
))

class Delink(BaseContent):
    """
    A link which presents a view of a content independently of its permissions.
    """
    
    global_allow = False
    
    immediate_view = 'delink_view'
    default_view = 'delink_view'
    suppl_views = ()
  
    
    schema = Delink_schema
    
    security = ClassSecurityInfo()
    
    actions = (
        {
            'id':            "view",
            'name':          "View",
            'action':        "string:${object_url}/delink_view",
            'permissions':   (View,),
        },
    )
    
    content_icon = "delink_icon.gif"
    
    isPrincipiaFolderish=True


    def __bobo_traverse__(self, REQUEST, name):
        '''transparent access to document subobjects
        '''
        brains=self.uid_catalog(UID=self.getTargetUID())
        if len(brains)==0:
            #the link's target doesn't exists anymore
            raise NotFound
        delibe = brains[0].getObject()
        if (not hasattr(delibe,"document_subobjects")) or (delibe.document_subobjects is None) or (not (name in delibe.document_subobjects.keyz)):
            return BaseContent.__bobo_traverse__(self, REQUEST, name)
        try:
            submapper = delibe.document_subobjects
        except AttributeError:
            data = None
        else:
            data = submapper.__of__(delibe).traverse(name)
        if data is not None:
            return data
        else:
            # fallback
            return BaseContent.__bobo_traverse__(self, REQUEST, name)
    
    def getTargetedObject(self):
        '''get the original object'''
        if 'delinkTarget' in self.REQUEST.keys():
          return self.REQUEST['delinkTarget']
        brains=self.uid_catalog(UID=self.getTargetUID())
        if len(brains)==0:
            #the link's target doesn't exists anymore
            raise NotFound
        obj = brains[0].getObject()
        self.REQUEST['delinkTarget']=obj
        return obj
    
    def getTargetedTitle(self):
        return self.getTargetedObject().Title()
    
    def getTargetedDescription(self):
        return self.getTargetedObject().Description()
    
    def getTargetedUrl(self):
        return self.getTargetedObject().absolute_url()
    
    def getHTMLPreview(self):
        '''get the HtmlPreview from original object'''
        return self.getTargetedObject().getHTMLPreview()
    
    def getMetas(self):
        '''get the metadatas from original object'''
        return self.getTargetedObject().getMetas()
    
    def manage_beforeDelete(self, item, container):
        BaseContent.manage_beforeDelete(self, item, container)
        target = self.getTargetedObject()
        self.portal_workflow.doActionFor(target, 'unplan')


registerType(Delink, PROJECTNAME)
