# -*- coding: utf-8 -*-
#
# File: content/category.py
#
# Copyright (c) 2006 atReal
#
# GNU General Public License (GPL)
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
# 02110-1301, USA.
#

"""
$Id$
"""

__author__ = """atReal <contact@atreal.net> : T.Benita, J-N.Bes & M.Broquet"""
__docformat__ = 'plaintext'
__licence__ = 'GPL'

from AccessControl import ClassSecurityInfo
from Products.Archetypes.atapi import *
from Products.Archetypes.public import *
from Products.PloneDelib.config import *
from Products.CMFCore.utils import getToolByName
from Products.ATContentTypes.content.base import ATCTOrderedFolder
from Products.ATContentTypes.content.schemata import ATContentTypeSchema


Category_schema = ATCTOrderedFolder.schema.copy()

Category_schema['relatedItems'].widget.visible={'view': "invisible", 'edit': "invisible", }

class Category(ATCTOrderedFolder):
    """ Rubrique de l'ordre du jour.
    """
    security = ClassSecurityInfo()

    # This name appears in the 'add' box
    archetype_name = 'Rubrique'

    meta_type = 'Category'
    portal_type = 'Category'
    allowed_content_types = ['Delink']
    filter_content_types = 1
    #global_allow = 0
    #immediate_view = 'base_view'
    #default_view = 'base_view'
    #suppl_views = ()
    typeDescription = "Category"
    typeDescMsgId = 'description_edit_category'

    _at_rename_after_creation = True

    schema = Category_schema

    security.declarePrivate('at_post_edit_script')
    def at_post_create_script(self):
      """ Il faut rajouter la rubrique au LinesField du conteneur 
      """ 
      container = self.aq_parent
      # a category can be added via the Meeting creation mecanism.
      # In this case, the category is yet in container.getCategories()
      # XXX change utf-8 to get the charset from the portal
      actualCat = [unicode(cat, 'utf-8') for cat in container.getCategories()]
      if self.title not in actualCat:
        actualCat.append(self.title)
        container.setCategories(actualCat)

    security.declarePrivate('manage_beforeDelete')
    def manage_beforeDelete(self, item, container):
      meeting = self.aq_parent
      # XXX change utf-8 to get the charset from the portal
      actualCat = [unicode(cat, 'utf-8') for cat in container.getCategories()]
      if self.title in actualCat:
        actualCat.remove(self.title)
        meeting.setCategories(actualCat)
      ATCTOrderedFolder.manage_beforeDelete(self, item, container)


registerType(Category, PROJECTNAME)
