# -*- coding: utf-8 -*-
#
# File: content/annexe.py
#
# Copyright (c) 2006 atReal
#
# GNU General Public License (GPL)
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
# 02110-1301, USA.
#

"""
$Id$
"""

__author__ = """atReal <contact@atreal.net> : T.Benita, J-N.Bes & M.Broquet"""
__docformat__ = 'plaintext'
__licence__ = 'GPL'

from Products.ARFilePreview.content import FilePreview
from AccessControl import ClassSecurityInfo
from Products.Archetypes.atapi import *
from Products.PloneDelib.config import *

Annex_schema = FilePreview.schema.copy()# + schema.copy()

Annex_schema['OriginalFile'].widget.description="Choisissez le fichier à uploader en cliquant sur 'Parcourir'"
Annex_schema['OriginalFile'].widget.label='Document annexe'
Annex_schema['description'].widget.description="Brève description de l'annexe (facultatif)"
Annex_schema['description'].widget.label='Description'
Annex_schema['description'].widget.i18n_domain='plonedelib'

class Annex(FilePreview):
    """ Une classe simple dérivant de FilePreview, pour ajouter
        des fichier annexes avec prévisu à une délibération.
    """
    security = ClassSecurityInfo()

    # This name appears in the 'add' box
    archetype_name = 'Annexe'

    meta_type = 'Annex'
    portal_type = 'Annex'
    immediate_view = 'filepreview_view'
    default_view = 'filepreview_view'
    #global_allow = 0
    typeDescription = "Annex"
    typeDescMsgId = 'description_edit_annex'

    _at_rename_after_creation = True

registerType(Annex, PROJECTNAME)
