# -*- coding: utf-8 -*-
#
# File: __init__.py
#
# Copyright (c) 2006 atReal
#
# GNU General Public License (GPL)
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
# 02110-1301, USA.
#

"""
$Id$
"""

__author__ = """atReal <contact@atreal.net> : T.Benita, J-N.Bes & M.Broquet"""
__docformat__ = 'plaintext'
__licence__ = 'GPL'

from Products.Archetypes.public import process_types, listTypes
from Products.CMFCore import utils
from Products.CMFCore.DirectoryView import registerDirectory

from Products.PloneDelib.config import PROJECTNAME, SKINS_DIR, GLOBALS

registerDirectory(SKINS_DIR, GLOBALS)

def initialize(context):
  ##Import Types here to register them
  print "=================================================="
  print "atReal : PloneDelib initialization in progress"
  import content

  content_types, constructors, ftis = process_types(
       listTypes(PROJECTNAME), PROJECTNAME)
  
  allTypes = zip(content_types, constructors)
  
  from tool import PloneDelibTool
  tools= (PloneDelibTool, )
  
  utils.ToolInit('PloneDelib Tool', tools=tools,
                     icon='tool.gif',
                    ).initialize(context)
  for atype, constructor in allTypes:
    print "atReal : initialize %s: %s" % (PROJECTNAME, atype.archetype_name)
    utils.ContentInit(
       "%s: %s" % (PROJECTNAME, atype.archetype_name),
       content_types      = (atype,),
       permission         = "PloneDelib: Add "+atype.portal_type, #One permission per content-type
       extra_constructors = (constructor,),
       fti                = ftis,
       ).initialize(context)
  print "=================================================="
