#
# Generated by dumpDCWorkflow.py written by Sebastien Bigaret
# Original workflow id/title: act_workflow/Act Workflow [PloneDelib]
# Date: 2006/12/22 14:15:36.269 GMT+1
#
# WARNING: this dumps does NOT contain any scripts you might have added to
# the workflow, IT IS YOUR RESPONSABILITY TO MAKE BACKUPS FOR THESE SCRIPTS.
#
# No script detected in this workflow
#
"""
Programmatically create a workflow type.
"""
__version__ = "$Id: dumpDCWorkflow.py 31159 2006-09-28 21:40:48Z encolpe $"

from Products.CMFCore.WorkflowTool import addWorkflowFactory
from Products.DCWorkflow.DCWorkflow import DCWorkflowDefinition
from Products.PythonScripts.PythonScript import PythonScript
from Products.ExternalMethod.ExternalMethod import ExternalMethod

def setup_act_workflow(wf):
    """Setup the workflow
    """
    wf.setProperties(title='Act Workflow [PloneDelib]')

    for s in ('pending', 'planned', 'visible'):
        wf.states.addState(s)
    for t in ('plan', 'reject', 'retract', 'submit', 'unplan'):
        wf.transitions.addTransition(t)
    for v in ('action', 'actor', 'comments', 'review_history', 'time'):
        wf.variables.addVariable(v)
    for l in ('reviewer_queue',):
        wf.worklists.addWorklist(l)
    for p in ('Access contents information',
              'Change portal events',
              'Modify portal content',
              'View',
              'List folder contents',
              'PloneDelib: Add Annex'):
        wf.addManagedPermission(p)

    # Initial State
    wf.states.setInitialState('visible')

    # State Initialization
    sdef = wf.states['pending']
    sdef.setProperties(title='Pending',
                       description='',
                       transitions=('plan', 'reject', 'retract'))
    sdef.setPermission('Access contents information', 1,
                       ['Manager', 'RefCon', 'RefDir', 'Reviewer'])
    sdef.setPermission('Change portal events', 0,
                       ['Manager', 'Reviewer'])
    sdef.setPermission('Modify portal content', 0,
                       ['Manager', 'Reviewer'])
    sdef.setPermission('View', 1,
                       ['Manager', 'RefCon', 'RefDir', 'Reviewer'])
    sdef.setPermission('List folder contents', 0,
                       ['Manager'])
    sdef.setPermission('PloneDelib: Add Annex', 0,
                       ['Manager'])

    sdef = wf.states['planned']
    sdef.setProperties(title='',
                       description='',
                       transitions=('unplan',))
    sdef.setPermission('Access contents information', 1,
                       ['Manager'])
    sdef.setPermission('Change portal events', 0,
                       ['Manager'])
    sdef.setPermission('Modify portal content', 0,
                       ['Manager'])
    sdef.setPermission('View', 1,
                       ['Manager'])
    sdef.setPermission('List folder contents', 0,
                       ['Manager'])
    sdef.setPermission('PloneDelib: Add Annex', 0,
                       ['Manager'])

    sdef = wf.states['visible']
    sdef.setProperties(title='Public Draft',
                       description='',
                       transitions=('submit',))
    sdef.setPermission('Access contents information', 1,
                       ['Anonymous', 'Manager', 'Reviewer'])
    sdef.setPermission('Change portal events', 0,
                       ['Manager', 'RefDir'])
    sdef.setPermission('Modify portal content', 0,
                       ['Manager', 'RefDir'])
    sdef.setPermission('View', 1,
                       ['Anonymous', 'Manager', 'Reviewer'])
    sdef.setPermission('List folder contents', 0,
                       ['Manager', 'RefDir'])
    sdef.setPermission('PloneDelib: Add Annex', 0,
                       ['Manager', 'RefDir'])

    # Transition Initialization
    tdef = wf.transitions['plan']
    tdef.setProperties(title='The act is added to a meeting',
                       description='',
                       new_state_id='planned',
                       trigger_type=1,
                       script_name='',
                       after_script_name='',
                       actbox_name='',
                       actbox_url='',
                       actbox_category='workflow',
                       props=None,
                       )

    tdef = wf.transitions['reject']
    tdef.setProperties(title='Reviewer rejects submission',
                       description='',
                       new_state_id='visible',
                       trigger_type=1,
                       script_name='',
                       after_script_name='',
                       actbox_name='Reject',
                       actbox_url='%(content_url)s/content_reject_form',
                       actbox_category='workflow',
                       props={'guard_roles': 'RefCon'},
                       )

    tdef = wf.transitions['retract']
    tdef.setProperties(title='Member retracts submission',
                       description='',
                       new_state_id='visible',
                       trigger_type=1,
                       script_name='',
                       after_script_name='',
                       actbox_name='Retract',
                       actbox_url='%(content_url)s/content_retract_form',
                       actbox_category='workflow',
                       props={'guard_roles': 'RefDir'},
                       )

    tdef = wf.transitions['submit']
    tdef.setProperties(title='Member requests publishing',
                       description='',
                       new_state_id='pending',
                       trigger_type=1,
                       script_name='',
                       after_script_name='',
                       actbox_name='Submit',
                       actbox_url='%(content_url)s/content_submit_form',
                       actbox_category='workflow',
                       props={'guard_roles': 'RefDir'},
                       )

    tdef = wf.transitions['unplan']
    tdef.setProperties(title='The act is removed from a meeting',
                       description='',
                       new_state_id='pending',
                       trigger_type=1,
                       script_name='',
                       after_script_name='',
                       actbox_name='',
                       actbox_url='',
                       actbox_category='workflow',
                       props=None,
                       )

    # State Variable
    wf.variables.setStateVar('review_state')

    # Variable Initialization
    vdef = wf.variables['action']
    vdef.setProperties(description='The last transition',
                       default_value='',
                       default_expr='transition/getId|nothing',
                       for_catalog=0,
                       for_status=1,
                       update_always=1,
                       props=None)

    vdef = wf.variables['actor']
    vdef.setProperties(description='The ID of the user who performed the last transition',
                       default_value='',
                       default_expr='user/getId',
                       for_catalog=0,
                       for_status=1,
                       update_always=1,
                       props=None)

    vdef = wf.variables['comments']
    vdef.setProperties(description='Comments about the last transition',
                       default_value='',
                       default_expr="python:state_change.kwargs.get('comment', '')",
                       for_catalog=0,
                       for_status=1,
                       update_always=1,
                       props=None)

    vdef = wf.variables['review_history']
    vdef.setProperties(description='Provides access to workflow history',
                       default_value='',
                       default_expr='state_change/getHistory',
                       for_catalog=0,
                       for_status=0,
                       update_always=0,
                       props={'guard_permissions': 'Request review; Review portal content'})

    vdef = wf.variables['time']
    vdef.setProperties(description='Time of the last transition',
                       default_value='',
                       default_expr='state_change/getDateTime',
                       for_catalog=0,
                       for_status=1,
                       update_always=1,
                       props=None)

    # Worklist Initialization
    ldef = wf.worklists['reviewer_queue']
    ldef.setProperties(description='Reviewer tasks',
                       actbox_name='Pending (%(count)d)',
                       actbox_url='%(portal_url)s/search?review_state=pending',
                       actbox_category='global',
                       props={'guard_permissions': 'Review portal content',
                              'var_match_review_state': 'pending'})

def create_act_workflow(id):
    """Create, setup and return the workflow.
    """
    ob = DCWorkflowDefinition(id)
    setup_act_workflow(ob)
    return ob

addWorkflowFactory(create_act_workflow,
                   id='act_workflow',
                   title='Act Workflow [PloneDelib]')
