## Script (Python) "get"
##title=Get content stored by FileSystemStorage
##bind container=container
##bind context=context
##bind namespace=
##bind script=script
##bind subpath=traverse_subpath

NotFound = "NotFound"
request = context.REQUEST
response = request.RESPONSE

if len(traverse_subpath) < 1:
    raise NotFound, "Unknown page."

name = traverse_subpath[0]
field = context.getField(name)

if not field:
    raise NotFound, "Unknown page."

accessor = field.getAccessor(context)

if accessor is None:
    raise NotFound, "Unknown page."

value = accessor()

if len(traverse_subpath) > 1:
    # Maybe call method of object
    cmd_name = traverse_subpath[1]
    cmd = getattr(value, 'evalCmd')
    value = cmd(cmd_name)
else:
    # Add headers
    if hasattr(value, 'filename'):
        response.setHeader('Content-Disposition', 'inline; filename="%s"' % value.filename)
    if hasattr(value, 'content_type'):
        response.setHeader('Content-Type', value.content_type)
    if hasattr(value, 'size'):
        response.setHeader('Content-Length', value.size)

return value
