"""
$Id: __init__.py,v 1.4 2005/03/22 15:22:57 clebeaupin Exp $
"""

__author__  = ''
__docformat__ = 'restructuredtext'

# Python imports
import os
import sys
from Globals import package_home

# CMF imports
from Products.CMFCore.utils import ContentInit, ToolInit
from Products.CMFCore import CMFCorePermissions
from Products.CMFCore.DirectoryView import registerDirectory

# Archetypes imports
from Products.Archetypes.public import process_types, listTypes

# Products imports
from Products.FileSystemStorage.config import \
    SKINS_DIR, \
    GLOBALS, \
    PROJECTNAME, \
    DEBUG, \
    INSTALL_EXAMPLE_TYPES_ENVIRONMENT_VARIABLE

registerDirectory(SKINS_DIR, GLOBALS)

def initialize(context):
    install_types = DEBUG or \
        os.environ.get(INSTALL_EXAMPLE_TYPES_ENVIRONMENT_VARIABLE)
    
    if install_types:
        # Import example types
        from Products.FileSystemStorage.examples import FSSItem
    
        content_types, constructors, ftis = process_types(listTypes(PROJECTNAME),
                                                          PROJECTNAME)
        ContentInit('%s Content' % PROJECTNAME,
                    content_types = content_types,
                    permission = CMFCorePermissions.AddPortalContent,
                    extra_constructors = constructors,
                    fti = ftis,
                    ).initialize(context)
    
    # Import tool
    from Products.FileSystemStorage.FSSTool import FSSTool
    
    ToolInit(
        '%s Tool' % PROJECTNAME,
        tools=(FSSTool,),
        product_name=PROJECTNAME,
        icon='tool.gif').initialize(context)
