# -*- coding: utf-8 -*-
#
# File: content/shortreport.py
#
# Copyright (c) 2006 atReal
#
# GNU General Public License (GPL)
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
# 02110-1301, USA.
#

"""
$Id$
"""

__author__ = """atReal <contact@atreal.net> : T.Benita, M.Broquet & J-N.Bes"""
__docformat__ = 'plaintext'
__licence__ = 'GPL'


from AccessControl import ClassSecurityInfo
from Products.Archetypes.atapi import *
from Products.PloneDelib.config import *
from Products.CMFCore.utils import getToolByName
from Products.ATContentTypes.content.base import ATCTFolder
from Products.ATContentTypes.content.schemata import ATContentTypeSchema
from Products.ARFilePreview.content import * 


ShortReport_schema = FilePreview.schema.copy()

ShortReport_schema['description'].widget.visible={'view': "invisible", 'edit': "invisible", }
ShortReport_schema['title'].required=1
ShortReport_schema['title'].widget.visible={'view': "visible", 'edit': "invisible", }
ShortReport_schema['OriginalFile'].widget.description="Choisissez le fichier à uploader en cliquant sur 'Parcourir'"
ShortReport_schema['OriginalFile'].widget.label='Procès Verbal succint'
ShortReport_schema['OriginalFile'].required=0


class ShortReport(FilePreview):
    """ Procès verbal succint. Dérive de FilePreview pour stocker le 
        fichier bureautique en question.
    """
    security = ClassSecurityInfo()

    # This name appears in the 'add' box
    archetype_name = 'Procès verbal succint'

    meta_type = 'ShortReport'
    portal_type = 'ShortReport'
    global_allow = 1
    immediate_view = 'filepreview_view'
    default_view = 'filepreview_view'
    #content_icon = 'ShortReport.gif'
    typeDescription = "ShortReport"
    typeDescMsgId = 'description_edit_legislativeshortreport'

    _at_rename_after_creation = True

    schema = ShortReport_schema
registerType(ShortReport, PROJECTNAME)
