<?php

/**
* 
*   This script uses the MiniWiki class to generate the XHTML documentation
*   of the MiniWiki class. 
* Usage: go to URL http://install_server/install_path/MiniWikiDoc.php and you
*   obtain the user manual in a XHTML page on your browser; ypu can also save
*   this page in  local XHTML file.
* Note1: the first doc is written in French only (sorry:-)
* Note2: The CSS-2 style is embedded in a local <style> clause to improve the
*   portability.
* 
* $Id: MiniWikiDoc.php,v 1.3 2005/08/31 05:10:55 deveaux Exp $
* 
* @author Daniel Deveaux <daniel.deveaux@univ-ubs.fr>
* 
* @package Text_MiniWiki
* @version 0.01
* @license LGPL
* 
*/
require_once "MiniWiki.php";
require_once "../info/func.php";

$mode = stripslashes($_GET['mode']);

function build_page($header, $wiki_text, $footer) {
        $output = "$header\n<!-- end header -->\n\n$wiki_text\n\n".
                  "<!-- begin footer -->\n$footer\n";
	print $output;
}

$style = "  <style>
    body, p, br, td, th {
        font-family: \"Lucida Grande\", Verdana, Arial, Geneva;
        color: black;
        background-color: #acc;
        }
        
    div.text {
        margin: 0.5ex 3em 0.5ex 5em;
        text_align: justify;
        }
    .center { text-align: center; }
    address { text-align: center; padding: 1ex 1em;}
    #main {
        margin: 0 3em 0 3em; padding 1em;
        background-color: white;
        border: 3pt solid #899;
        -moz-border-radius: 10px;
        }
    #header {
        margin: 1em 3em 0 3em; padding 1em;
        border: 3pt solid #899;
        background-color: #ddd;
        -moz-border-radius: 10px;
        }
    #foot {
        margin: 0 3em 1em 3em; padding 1em;
        border: 3pt solid #899;
        background-color: #ddd;
        -moz-border-radius: 10px;
        }
    
    
    h1, h2, h3 { color: #dc5045; }
    h1 { font-size: 200%; text-align: center;}
    h2 { 
        font-size: 170%; 
        color: #dc5045; 
        background: #ddd; 
        border-left: 1px solid #899; 
        border-bottom: 1px solid #899; 
        -moz-border-radius: 0 0 0 8px;
        margin: 1em 1em 0.5ex 1em; padding: 3px 0.3em;}
    h3 { font-size: 140%; margin: 1ex 0 0 1.3em;}
    h4 { font-size: 120%; margin: 0.5ex 0 0 2em;}
    h5 { font-size: 100%; font-style: italic; margin: 0.3ex 0 0 3em;}
    
    blockquote {
        border: 1px solid silver;
        background: #eee;
        margin: 0.5ex 2em;
        padding: 4px 1em;
        }
    
    a:link, a:active, a:visited {
        color: #b43;
        text-decoration: none;
        border-bottom: 1px none #b43;
        }
    
    a:hover {
        color: #b43;
        text-decoration: none;
        border-bottom: 1px dotted #b43;
        }
    
    ul, li {
        margin-top: 0;
        margin-bottom: 0;
        }
    dt {color: #b43; font-weight:700;}
        
    p { margin: 4px 0; padding: 0; text-align: justify; 
        background-color: transparent;}
    q {font-style: italic;}
    div.box {
        margin: 0.5ex 2em;
        border: 1px dashed #dc5045;
        background: #eee;
        padding: 0.5ex;
        }
        
    pre {
        margin: 0; padding: 0;
        font-family: ProFont, Monaco, Courier, \"Andale Mono\", monotype;
        font-size: 90%;
        }
    
</style>
";

$header = "<?xml version='1.0' encoding='iso-8859-1'?>
<html xmlns='http://www.w3.org/1999/xhtml'>
<head>
  <meta http-equiv='Content-Type'
  content='application/xhtml+xml; charset=iso-8859-1' />
  <title>MiniWiki: manuel d'utilisation</title>
  <meta name='generator' content='MiniWikiDoc' />
  $style
</head>

<body>
";
$title = "<div id='header'>
 <h1>MiniWiki : traduction Wiki vers XHTML</h1>
 <p class='center'>--o--<br /><big><b>Daniel Deveaux</b></big></p>
</div>
<div id='main'>
";

$footer="<p>&nbsp;</p>
</div>
<div id='foot'>
<address><small>Copyright &copy; 2005 -- D.Deveaux -- UBS -- IUT de Vannes<br />--o--<br />
Gnr le ".date("d/m/Y")."</small></address>
</div>
</body>
</html>
";

$txt = "
++ Gnralits
Les \"\"langages Wiki\"\" sont ns avec les sites de support d'dition cooprative sur le web nomms Wikis ; ils permettent de saisir trs facilement des textes structurs et organiss sans encombrer le texte avec des balises lourdes et compliques comme en HTML ou XML. En fait ces langages sont des avatars des [http://docutils.sourceforge.net/rst.html {{reStructuredText}}] dvelopps initialement pour la documentation embarque des programmes en Python (les premiers systmes Wikis ont t dvelopps en Python, ce n'est pas un hasard).
Le langage Wiki dcrit dans cette page est celui qui est trait par les scripts **MiniWiki** (disponibles en {{PhP}} et en {{python}}; c'est le rsultat d'une compilation entre les styles de langages Wiki de [http://tavi.sourceforge.net/ WikkiTikkiTavi] et de [http://develnet.org/ cpWiki].
Tous les textes sont saisis comme du simple texte (''plain text'') et sont convertis en XHTML par les scripts distribus. Cette organisation permet une saisie trs facile dans de simples formulaires web, tout en permettant une expressivit importante qui permet de mettre en place une organisation du texte avec des titres, des paragraphes et des listes, l'utilisation de styles typographiques et l'insertion de liens et de figures ; tout ceci sans manipulation d'aucune balise HTML.
Il suffit de saisir le texte en mode continu (auto-wrap soft) et de taper '{{Return}}' pour crer des paragraphes ; quelques conventions d'criture simples donnent des possibilits larges de mise en forme.

+++ Outils et installation
Les outils {{MiniWiki}} sont diffuss dans deux distributions :
* une distribution **{{Python}}**, la classe {{text/MiniWiki.py}} et le script de gnration de documentation {{text/MiniWikiDoc.py}} ;
* une distribution **{{PhP}}**, la classe {{Text/MiniWiki.php}} et le script de gnration de documentation {{Text/MiniWikiDoc.php}}.

Les deux scripts de documentation gnrent cette documentation en XHTML  partir d'un source en format \"\"Wiki\"\" stock sous forme d'une chaine de caractres.
Pour l'une ou l'autre des distributions, l'installation consiste simplement  copier le fichier contenant la classe {{MiniWiki}} dans un rpertoire reconnu comme un espace de bibliothque du langage avec le chemin relatif {{text/...}} (pour {{Python}}) ou {{Text/...}} (pour {{PhP}}).

+++ Utilisation
L'emploi de cette classe est trs simple, elle n'a actuellement aucune configuration : il suffit d'importer la classe, de crer un objet {{MiniWiki}} et d'activer la mthode {{transform()}}.
En Python
{{{    from text.MiniWiki import MiniWiki
    wiki = MiniWiki()
    txt_wiki = ...
    txt_xhtml = wiki.transform(txt_wiki)
    print txt_xhtml
}}}                                      
En PhP
{{{    require \"Text/MiniWiki.php\";
    \$wiki = new MiniWiki();
    \$txt_wiki = ...;
    \$txt_xhtml = \$wiki->transform(\$txt_wiki);
    print \$txt_xhtml;
}}}                                      

Le paquettage {{MiniWiki}} est associ au paquetage de mini-bases de donnes XML {{xml/Collection}} qui est le composant de base principal de la majorit des plugins associes  [//phpcms.de/index.en.html phpCMS] dans le cadre du **[http://goblin.adullact.net/ Projet Goblin]** dvelop  l'UBS (DESS ASIR et IUT de Vannes).

+++ Evolution
Toute l'analyse du texte source est ralise  l'aide d'un ''**parseur  expressions rgulires**'' ; toutes les expressions rgulires utilises sont regroupes dans un tableau dfini en tte du source de la classe, l'adaptation  un autre langage Wiki dfinissant les mmes structures avec une syntaxe diffrente est trs rapide (on pourrait facilement en faire une classe adaptable par configuration).

[[[ ,,**Reste  faire** : la dfinition et la construction des tableaux sont prvues, mais pas encore implantes.,,
]]]

++ Emploi du style MiniWiki 

Le style de prsentation qui est utilis dans ce document dpend entirement du style CSS utilis, la classe {{MiniWiki}} ne gnre que de pures structures {{XHTML}} sans aucun choix de prsentation, vous pouvez donc adapter la typographie, la couleur et la disposition comme bon vous semble.

+++ Formatage en ligne
Les enrichissements typographiques sont obtenus en ''balisant'' le texte avec des rptitions peu courantes de caractres habituels en pur ASCII.
Exemple :
{{{    ''texte en valeur'',  **texte en gras** ou 
''**texte en valeur et en gras**''
    {{texte mode tltype}} et \"\"texte entre quotes\"\"
    ,,texte crit petit,, ou ;;au contraire gros;;
    @@--- texte effac +++ et insr @@
    @@+++ texte insr seul @@
    @@--- texte effac seul @@
}}}
[[[ donne
''texte en valeur'',  **texte en gras** ou 
''**texte en valeur et en gras**''
    {{texte mode tltype}} et \"\"texte entre quotes\"\"
    ,,texte crit petit,, ou ;;au contraire gros;;
   @@--- texte effac +++ et insr @@
   @@+++ texte insr seul @@
   @@--- texte effac seul @@
]]]

En aucun cas les balises {{HTML}} ne sont prises en compte pour le formatage, elles sont <i>affiches</i> telles que <b>saisies</b> dans le texte.
[[[ ,,**Reste  faire** : le texte entre paires de quotes inverses {{``}} devrait apparatre tel sans formatage mme s'il contient des balises, mais ce n'est pas encore implant.,,
]]]

+++ Structuration du texte
++++ Niveaux de titres 
Les titres de sections sont dfinis sur des lignes qui comportent une srie de signes {{+}} en dbut ; le nombre de signes dtermine le niveau du titre  insrer, celui-ci peut aller de 2  6. Les titres de cette section sont dfinis par :
{{{    +++ Structuration du texte
    ++++ Niveaux de titres
}}}

On peut facilement insrer une ligne horizontale en plaant (au moins) quatre signes {{-}} ({{----}}) en dbut de ligne, comme ici :
----

[[[ ,,**Reste  faire** : une ligne contenant la chaine {{[[toc]]}} devrait permettre d'insrer un table des matires active ; ceci reste  implanter.,,
]]]

++++ Listes
+++++ Listes  puces
Elles sont dfinies en plaant des astrisks en dbut de ligne, une par niveau
{{{    * premier niveau
    ** un sous-niveau imbriqu
    * retour au premier niveau
}}}
[[[ donne
* premier niveau
** un sous-niveau imbriqu
* retour au premier niveau
]]]

+++++ Listes numres
Mme principe de dfinition en remplaant les astrisks par des dizes :
{{{    # premier niveau
    ## un sous-niveau imbriqu
    avec suite (sous-paragraphe)
    ## autre item
    ### avec un tage de plus
    # retour au premier niveau
}}}
[[[ donne
# premier niveau
## un sous-niveau imbriqu
avec suite (sous-paragraphe)
## autre item
### avec un tage de plus
# retour au premier niveau
]]]

+++++ Listes de dfinitions (dictionnaires)
{{{    :Terme: avec sa dfinition
    :Autre terme: avec une dfinition.
    Plus longue avec des sous paragraphes.
    :Troisime terme: et un dfinition
    
    Laisser une ligne blanche permet de sortir de la liste.
}}}
[[[ donne
:Terme: avec sa dfinition
:Autre terme: avec une dfinition
plus longue
:Troisime terme: et un dfinition
    
Laisser une ligne blanche permet de sortir de la liste.
]]]

+++++ Mlanges de listes
Il est possible d'imbriquer les diffrentes listes les unes dans les autres, sans limitation. Pour les listes  puces et les listes numres, il faut simplement respecter le niveau d'imbrication (nombre d'toiles ou de dizes) ; les listes de dfinitions s'insrent au niveau o elles sont dfinies.
Dans tous les cas, l'insertion d'une ligne blanche marque la fin de la liste en cours.
Les fins de blocs et les changements de sections provoquent la fermeture (en bon ordre) de toutes les listes en cours.
{{{    # Number one
    ** Bullet
    ** Bullet
    # Number two
    ** Bullet
    :A: def de A
    #### item 1 dans A
    #### item 2 dans A
    
    :B: def de B
    ** Bullet
    *** Sub-bullet
    #### Sub-sub-number
    [[[ avec un bloc indent imbriqu
    ]]]
    #### Sub-sub-number
    
    #### reprise d'une autre liste numre
    {{{    avec un bloc prformat 
        imbriqu
    }}}
    #### Sub-sub-number
    # Number three
    ** Bullet
    ** Bullet:Terme: avec sa dfinition
}}}
[[[ donne
# Number one
** Bullet
** Bullet
# Number two
** Bullet
:A: def de A
#### item 1 dans A
#### item 2 dans A

:B: def de B
** Bullet
*** Sub-bullet
#### Sub-sub-number
[[[ avec un bloc indent imbriqu
]]]
#### Sub-sub-number

#### reprise d'une autre liste numre
{{{    avec un bloc prformat 
    imbriqu
}}}
#### Sub-sub-number
# Number three
** Bullet
** Bullet:Terme: avec sa dfinition
]]]
++++ Les blocs
Contrairement aux structures prcdentes, les blocs ont une balise de dbut et une balise de fin. Ceci permet de les imbriquer rcursivement.
+++++ Blocs indents (citations)
Les balises d'ouverture et de fermeture sont constitues par des triples crochets \"{{[[[}}\" et \"{{]]]}}\" en dbut de ligne ; le texte du bloc doit commencer sur la ligne de la balise ouvrante avec au moins un espace de sparation, la balise fermante est seule sur sa ligne.
Voir exemple dans les listes imbriques ci-dessus.
[[[ ,,**Note** : le code XHTML produit est une simple paire de balises {{<blockquote>}} ; dans le document prsent, c'est la dfinition du CSS qui fait apparaitre les blocs comme des cadres griss.,,
]]]

+++++ Blocs prformats
Organiss comme les blocs indents, les balises tant des triplets d'accolades ; voir l'exemple dans la section \"\"Listes imbriques\"\".
Ces blocs sont interprts en XHTML comme des blocs prformats ({{<pre>}} inclus dans une division de classe \"\"box\"\" {{<div class='box'>}}.
Dans un bloc prformat, aucun code Wiki n'est interprt ; ils ne peuvent donc pas inclure d'autres blocs.

+++++ Imbriquer blocs et listes
Voir les exemples du prsent document qui utilisent des blocs prformats pour le code et des blocs indents pour les zones de dmonstation ; la section \"\"Listes imbriques\"\" montre en outre des imbrications de blocs dans des listes.

+++ Les Liens et Images
++++ Liens Wiki et InterWiki
Ils ne sont pas grs par la classe {{MiniWiki}}; le but ici, n'est pas de construire un moteur de site Wiki, mais de proposer un outil pour mise en forme simple des saisies dans les formulaires et la gnration de textes structurs  partir de documents labors en groupe sur des wikis. Cette fonctionnalit n'a alors pas d'intret.
++++ Les URLs
La simple saisie d'une URL bien forme provoque la cration automatique d'un lien sur cette URL ; les protocoles reconnus sont {{http}}, {{https}}, {{mailto}} et {{ftp}}.
En utilisant une paire de crochets, on peut dfinir un champ d'activation avec un autre libell et ainsi masquer l'URL  la lecture.
{{{    Une URL visible : http://web.iu-vannes.fr/depts/info/
    On peut aussi la cacher 
    [http://web.iu-vannes.fr/depts/info/ IUT Info].
}}}
[[[ donne
Une URL visible : http://web.iu-vannes.fr/depts/info/
On peut aussi la cacher [http://web.iu-vannes.fr/depts/info/ IUT Info].
]]]

++++ Les images
Pour insrer une image dans le texte, il suffit d'crire l'URL (absolue ou relative) du fichier qui la contient et l'image sera insre ; les extensions reconnues sont  {{.png}}, {{.gif}} et {{.jpg}}.
{{{    C'est verrouill $base_url/images/minilock.png .
}}}
[[[ donne
C'est verrouill $base_url/images/minilock.png .
]]]
++ Reste  faire
Plusieurs dveloppements  complter sont indiqus sous forme de notes dans le corps de ce document. En plus de ceci, les points suivants restent  travailler :
* dispositif simple de formatage de tableaux ; exemple de syntaxe :
{{{|| lines must start and end || with double vertical bars || nothing ||
|| cells are separated by || double vertical bars || nothing ||
|||| you can span multiple columns by || starting each cell ||
|| with extra cell |||| separators ||
|||||| but perhaps an example is the easiest way to see ||
}}}
* possibilit de cadrage ( gauche, centr,  droite, float)
* fabriquer un format de sortie {{XHTML}} structur par des divisions de sectionnement telles que dfinies dans le projet [http://web.iu-vannes.fr/docinfo/ssites/Produits_locaux/EX_DocTools/ {{DocTools}}] ; ceci permettrait de reprendre des documents saisis dans des formulaires web ou labors sur des Wikis et de les transformer en {{LaTeX}} ou {{DocBook}}  l'aide des transformations {{XSLT}} de {{DocTools}}.
";

$helptxt = "
++ Emploi du style MiniWiki 

+++ Formatage en ligne
{{{    ''texte en valeur'',  **texte en gras** ou 
''**texte en valeur et en gras**''
    {{texte mode tltype}} et \"\"texte entre quotes\"\"
    ,,texte crit petit,, ou ;;au contraire gros;;
    @@--- texte effac +++ et insr @@
    @@+++ texte insr seul @@
    @@--- texte effac seul @@
}}}
[[[ donne
''texte en valeur'',  **texte en gras** ou 
''**texte en valeur et en gras**''
    {{texte mode tltype}} et \"\"texte entre quotes\"\"
    ,,texte crit petit,, ou ;;au contraire gros;;
   @@--- texte effac +++ et insr @@
   @@+++ texte insr seul @@
   @@--- texte effac seul @@
]]]

+++ Structuration du texte
On peut facilement insrer une ligne horizontale en plaant (au moins) quatre signes {{-}} ({{----}}) en dbut de ligne, comme ici :
----

++++ Listes
+++++ Listes  puces
{{{    * premier niveau
    ** un sous-niveau imbriqu
    * retour au premier niveau
}}}
[[[ donne
* premier niveau
** un sous-niveau imbriqu
* retour au premier niveau
]]]

+++++ Listes numres
{{{    # premier niveau
    ## un sous-niveau imbriqu
    avec suite (sous-paragraphe)
    ## autre item
    # retour au premier niveau
}}}
[[[ donne
# premier niveau
## un sous-niveau imbriqu
avec suite (sous-paragraphe)
## autre item
# retour au premier niveau
]]]

+++++ Listes de dfinitions (dictionnaires)
{{{    :Terme: avec sa dfinition
    :Autre terme: avec une dfinition.
    Plus longue avec des sous paragraphes.
    :Troisime terme: et un dfinition
    
    Laisser une ligne blanche permet de sortir de la liste.
}}}
[[[ donne
:Terme: avec sa dfinition
:Autre terme: avec une dfinition
plus longue
:Troisime terme: et un dfinition
    
Laisser une ligne blanche permet de sortir de la liste.
]]]

Il est possible d'imbriquer les diffrentes listes les unes dans les autres, sans limitation.
++++ Les blocs
Ils ont une balise de dbut et une balise de fin. Ceci permet de les imbriquer rcursivement.
+++++ Blocs indents (citations)
Les balises d'ouverture et de fermeture sont constitues par des triples crochets \"{{[[[}}\" et \"{{]]]}}\" en dbut de ligne ; le texte du bloc doit commencer sur la ligne de la balise ouvrante avec au moins un espace de sparation, la balise fermante est seule sur sa ligne.

+++++ Blocs prformats
Organiss comme les blocs indents, les balises tant des triplets d'accolades

+++ Les Liens et Images
++++ Les URLs
La simple saisie d'une URL bien forme provoque la cration automatique d'un lien sur cette URL ; protocoles : {{http}}, {{https}}, {{mailto}} et {{ftp}}.
{{{    Une URL visible : http://web.iu-vannes.fr/depts/info/
    On peut aussi la cacher 
    [http://web.iu-vannes.fr/depts/info/ IUT Info].
}}}
[[[ donne
Une URL visible : http://web.iu-vannes.fr/depts/info/
On peut aussi la cacher [http://web.iu-vannes.fr/depts/info/ IUT Info].
]]]

++++ Les images
Les extensions reconnues sont  {{.png}}, {{.gif}} et {{.jpg}}.
{{{    C'est verrouill $base_url/images/minilock.png .
}}}
[[[ donne
C'est verrouill $base_url/images/minilock.png .
]]]
";

$wiki = new MiniWiki();
if ( $mode == 'help' ) {
    $otxt = $wiki->transform($helptxt);
    $hd = $header."<p style='text-align: right; font-style: italic;'>Voir la <a href='".
                  $_SERVER["PHP_SELF"]."'>documentation complte</a>.</p>";
} else {
    $otxt = $wiki->transform($txt);
    $hd = $header.$title;
}
build_page($hd, $otxt, $footer);

?>