#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-
#-----------------------------------------------------------------------------
"""
Manage a UF collection
"""
__version__ = "$Revision: 1.10 $"[11:-2]
__copyr__ = """Copyright (c) 2001 - UBS-Valoria"""
__rcs_info__ = {
    #  Creation Information
    #
    'module_name'  : '$RCSfile: UF.py,v $',
    'rcs_id'       : '$Id: UF.py,v 1.10 2005/11/22 06:59:45 deveaux Exp $',
    'creator'      : 'D.Deveaux <daniel.deveaux@univ-ubs.fr>',
    'project'      : 'aglae.pyAglae',
    'created'      : '2001/05/23',

    #  Current Information
    #
    'author'       : '$Author: deveaux $'[11:-2],
    'state'	   : '$State: Exp $'[8:-2],
    'date'         : '$Date: 2005/11/22 06:59:45 $'[7:-2],
}

#
#   Standard modules importation
#
import string, re, os

import xml.dom.minidom
from StringIO import StringIO

from Subst import Subst, makeSubst
from Collection import Collection

RE_comment = re.compile (r'^<!--')


#
#    Texts for HTML generation
#
ht_txt1 = u"""<div class='duree'>
  <p class="boxed"><b>Formation Initiale</b><br />
    Cours : {ini-dur-crs} h -- TD/TP : %d h<br />
    Travail tutor : {ini-dur-tt} h</p>
  <p class="boxed"><b>APPC</b><br />
    Cours : {appc-dur-crs} h -- TD/TP : %d h<br />
    Travail tutor : {appc-dur-tt} h</p>
</div>
<div class='text'>
  <p>Coordonnateur de l'UF : <b><!-- MAILCRYPT {resp-em},{resp} --></b><br />
  <SP><SP><small><em>Enseignants en formation initiale :</em</small> {ini-ens}<br />
  <SP><SP><small><em>Enseignants en APPC :</em</small> {appc-ens}</p>
</div>
<div class="sec">
  <h3>Objectif de l'UF</h3>
  <div class='text'>
    <p>{objectif}</p>
  </div>
  <h4>Comptences acquises</h3>
  <div class='text'>
    <p>{compet}</p>
  </div>
</div>
<div class='sec'>
  <h3>Thmes abords</h3>
  <div class='text'>
    <p>{contenu}</p>
  </div>
</div>
"""
ht_txt41 = u"""<div class='sec'>
  <h3>Bibliographie</h3>
  <div class='text'>
    <p>{biblio}</p>
  </div>
</div>
"""
ht_txt42 = u"""<div class='sec'>
  <h3>Modalits pratiques</h3>
  <h4>Bibliographie</h4>
  <div class='text'>
    <p>{biblio}</p>
  </div>
  <h4>Travail tutor</h4>
  <div class='text'>
    <p>{tpers}</p>
  </div>
  <h4>Evaluation</h4>
  <div class='text'>
    <p>{evaluation}</p>
  </div>
<div class="box" style='width: 80%%; margin: 0.5ex auto;'>
<div class="tab">
<table border="0" width="100%%">
  <tbody>
    <tr>
      <td width="50%%">Prrequis : {ic-prer}</td>
      <td width="50%%">Complments : {ic-compl}</td>
    </tr>
  </tbody>
</table>

<table border="0" width="100%%">
  <tbody>
    <tr>
      <td width="33%%" class="center">Support de cours : %s</td>
      <td width="34%%" class="center">Support de TP : %s</td>
      <td width="33%%" class="center">Documentation en ligne : %s</td>
    </tr>
    <tr>
      <td></td>
      <td class="center"><a href='../support/{composante}/%s/'>Supports de cours</a></td>
      <td></td>
    <tr>
  </tbody>
</table>
</div>
</div>
</div>
"""

ht_id_txt1 = """<div class='sec'>
  <h3><a href='{id}.htm' target="_blank">{ident}</a> : <q>{titre}</q></h3>
  <div class='text'>
    <p class="left">Coordinateur : <b><!-- MAILCRYPT {resp-em},{resp} --></b>
    <SP><SP><SP><SP>-- Enseignants : {ini-ens}, {appc-ens}</p>
    <p class="right"><small>Cours : <b>%d h</b> -- TD/TP : <b>%d h</b> --
      Travail tutor : <b>%d h</b></small></p>
    <hr />
    <!--p style="clear: both"><SP></p-->
  </div>
</div>
"""

class UF:
    """Manage UF data and doc generation
    """
    def __init__(self, file_name):
	"""Init function : read the file, create courses table
	"""
        ##print "UF filename : %s" % file_name
	self.collec = Collection('uf', file_name)
	self.ctab = {}
	for ues in self.collec.get_elements():
	    self._init_values(ues)
    # ------------------------------------------------------------- __init__()

    def _init_values(self, anue):
	"""Store the main UF characteristics in the hash 'ctab'
	"""
	st = self.collec.subst_tab(anue)
	mh = {}
	mh['elt'] = anue
	mh['code'] = st['{ident}']
	mh['titre'] = st['{titre}']
	mh['resp'] = st['{resp}']
	mh['resp-em'] = st['{resp-em}']
        for k in ('ini-dur-crs', 'ini-dur-td', 'ini-dur-tp', 'ini-dur-tt', 
                  'appc-dur-crs', 'appc-dur-td', 'appc-dur-tp', 'appc-dur-tt'):
            k1 = "{%s}" % k
            if st[k1]: 
                mh[k] = self._as_float(st[k1], st['{ident}'])
                ## print mh[k], st[k1]
            else: 
                mh[k] = 0
	self.ctab[st['{id}']] = mh
    # --------------------------------------------------------- _init_values()

    def _as_float(self, value, id):
	"""convertit une chaine en float, mme si elle est un peu tordue
	"""
	value = value.replace(',', '.')
        value = value.replace('h', '.')
        try:
	    if ( '*' in value ):
                (op1, op2) = string.split(value, '*')
	        value = float(op1) * float(op2)
	    else:
                value = float(value)
        except ValueError:
            print "ERREUR: valeur flottante invalide %s dans '%s'<br />" % (value, id)
            value = .0
	return value
    # --------------------------------------------------------- _as_float()
	
    def get_keys(self):
	"""Get the UF keys as a sorted array
	"""
	ar = self.ctab.keys()
	ar.sort()
	return ar
    # ------------------------------------------------------------- get_keys()

    def get_basic_info(self, akey):
	"""Get the basic information hash of the UF marked with 'akey'
	"""
	if self.ctab.has_key(akey):
	    ret = self.ctab[akey]
	else:
	    ret = None
	return ret
    # ------------------------------------------------------- get_basic_info()

    def get_subst_tab(self, akey, with_br=0):
	"""Get the substitution table for the element 'akey'
	"""
	if self.ctab.has_key(akey):
	    elt = self.ctab[akey]['elt']
	    ret = self.collec.subst_tab(elt, with_br)
	else:
	    ret = None
	return ret
    # -------------------------------------------------------- get_subst_tab()

    def mk_html_etud(self, akey):
	"""Make an HTML description of the course for student public
	"""
	if not self.ctab.has_key(akey):	return None
	bi = self.get_basic_info(akey)
	d1 = bi['ini-dur-td'] + bi['ini-dur-tp']
	d2 = bi['appc-dur-td'] + bi['appc-dur-tp']
	st = self.get_subst_tab (akey, 1)
	sub = Subst()
	sub.setSubstTabAsHash(st)
	buf = StringIO()
	buf.write(makeSubst(sub, ht_txt1 % (d1, d2)))
##	for pre in ('ini', 'appc'):
##	    k1 = "{%s-contenu}" % (pre)
##	    k2 = "{%s-ens}" % (pre)
##	    if st[k1]:
##                d1 = bi['dcrs%s'%pre] ; d2 = bi['dtd%s'%pre] + bi['dtp%s'%pre]
##                d3 = bi['dtt%s'%pre]	
##		buf.write(ht_txt2 % (st[k1], st[k2], d1, d2, d3))
##	    else:       break
##	buf.write (makeSubst (sub, ht_txt3))
	s1 = s2 = s3 = 'non'
	if st['{ic-supp-crs}'] == 'on':		s1 = 'oui'
	if st['{ic-supp-td}'] == 'on':		s2 = 'oui'
	if st['{ic-doc-web}'] == 'on':		s3 = 'oui'
        s4 = st['{id}'].lower()
	buf.write(makeSubst(sub, ht_txt42 % (s1, s2, s3, s4)))
	return buf.getvalue()
	# ----------------------------------------------------- mk_html_etud()

    def mk_html_extra(self, akey):
	"""Make an HTML description of the course for all public
	"""
	if not self.ctab.has_key(akey):	return None
	bi = self.get_basic_info(akey)
##	d1 = bi['dcrs'] ; d2 = bi['dtd'] + bi['dtp'] ; d3 = bi['dtt']
        d1 = d2 = d3 = 0
	st = self.get_subst_tab(akey, 1)
	sub = Subst()
	sub.setSubstTabAsHash(st)
	buf = StringIO()
	buf.write(makeSubst(sub, ht_txt1 % (d1, d2, d3, d1, d2, d3)))
##	for pre in ('ini', 'appc'):
##	    k1 = "{p%d-contenu}" % (n + 1)
##	    k2 = "{p%d-ens}" % (n + 1)
##	    if st[k1]:
##		buf.write(ht_txt2 % (st[k1], st[k2]))
##	    else:       break
##	buf.write(makeSubst(sub, ht_txt3))
	buf.write(makeSubst(sub, ht_txt41))
	return buf.getvalue()
	# ---------------------------------------------------- mk_html_extra()

    def mk_html_sec_index(self, akey):
	"""Make an HTML index section with UE and its courses
	"""
	if not self.ctab.has_key(akey):	return None
	bi = self.get_basic_info(akey)
	st = self.get_subst_tab(akey, 1)
	sub = Subst()
	sub.setSubstTabAsHash(st)
	buf = StringIO()
	d1 = bi['ini-dur-crs']
        d2 = bi['ini-dur-td'] + bi['ini-dur-tp']
        d3 = bi['ini-dur-tt']
        
	buf.write(makeSubst(sub, ht_id_txt1 % (d1, d2, d3)))
##	buf.write(makeSubst(sub, ht_id_txt3))
	return buf.getvalue()
	# -------------------------------------------------- mk_html_sec_index()


