<?php
    $lib = dirname(dirname(__FILE__)).'/lib';
    $ip = ini_get ('include_path');
    ini_set ('include_path', "$lib:".$ip);

    include_once "info/func.php";
    require_once "xml/collection.php";

    if ( strcmp(PHP_VERSION, '4.3.0') < 0 ) {
        include_once "Compat/Function/file_get_contents.php";
    }
    
    $news_base = "$info_data/news";

    $cat = stripslashes($_GET['cat']);
    $vis = stripslashes($_GET['vis']);

    /* build the categories index */
    $txt = file_get_contents("$news_base/categories.dat");
    $lines = explode("\n", $txt);
    $cat_id = array();
    foreach ( $lines as $line ) {
	list ($key, $cat_lib) = explode("::", $line);
	$cat_id[$key] = $cat_lib;
    }

    /* and compose the text of the page */
    $txt = "<?xml version='1.0' encoding='iso-8859-1'?>
<!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Transitional//EN'
       'http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd'>
<html xmlns='http://www.w3.org/1999/xhtml'>
<head>
  <title>News du Dpartement Info</title>
  <link rel='stylesheet' href='../style/style.css' type='text/css' />
</head>
<body>
<div class='text'>\n";
    if ( $cat == '' ) {
	$txt .= listCategories();
    } else {
	$txt .= listACategory($cat);
    }
    $txt .= "<hr style='width: 40%; text-align: center' />";
//<p class='center'><b>[<a href='add_new.php";
//    if ( $cat ) { $txt .= "?cat=$cat"; }
//    $txt .= "'>Ajouter une nouvelle</a>]</b><br />
// </p>\n</div>\n</body>\n</html>\n";

    print $txt;

    function listCategories() {
	global $cat_id, $news_base, $vis;

	$txt = "<h2 class='center'>Choisissez une catgorie de nouvelles</h2>
<table width='60%' border='0' style='margin: 3ex auto 1ex auto'>
 <colgroup><col width='75%' /><col width='25%' /></colgroup>
 <tbody>\n";
        $cfile = "$news_base/news.xml";
        $col =& new XmlCollection ($cfile);
        $selvis = ($vis) ? "vis.$vis" : '';
        $argvis = ($vis) ? "&vis=$vis" : '';
	while (list ($key, $val) = each ($cat_id)) {
	    if ( $key ) {
                $sel = 'cat.'.$key;
                $selvis = ($vis) ? "vis.$vis" : '';
	        $lkeys = $col->sorted_keys ('elt-key', '', '', $sel, $selvis);
		$nbl = count($lkeys);
                // print_r($lkeys);
		$mot = ($nbl < 2) ? 'nouvelle&nbsp;&nbsp;' : 'nouvelles';
		$lib = $cat_id[$key];
		$txt .= "  <tr>\n   <td class='left'>";
		if ( $nbl >= 1 ) {
		   $txt .= "<a href=\"oldnews.php?cat=$key$argvis\">".
		           "<b>$val</b></a>";
		} else {
		   $txt .= $val;
		}
		$txt .= "</td>\n   <td class='right'>$nbl $mot</td>\n  </tr>";
	    }
	}
	$txt .= " </tbody>\n</table>\n";
        return $txt;
    }


    function listACategory($key) {
	global $cat_id, $news_base, $vis, $phpurl;
        $cfile = "$news_base/news.xml";
	$cat = $cat_id[$key];
        $selecvis = ($vis) ? "vis.$vis" : '';
	$txt = "<h2 class='center'>Nouvelles de la catgorie <q>$cat</q></h2>\n".
	"<hr style='width: 40%; text-align: center' />\n";
	$txt .= list_handle($cfile,
              "<p style='float: right; text-align: right;'>".
              "<small><em>Post le *date*<br />\n".
              "par <a href='mailto:*email*'><b>*auteur*</b></a></small></p>\n".
              "<dt>*titre*</dt>\n<dd>*accro* <a href='$phpurl/show_new.php?key=*elt-key*'>".
              "<em>en savoir plus ...</a>\n".
              "<hr style='width: 20%; text-align: left; clear: both;'/></dd>\n", 
              'elt-key', 'rev', '', 'cat.'.$key, $selecvis);
	$txt .= "<p class='center'><b>[<a ".
		"href='oldnews.php'>Retour au ".
		"menu</a>]</b></p>\n";
	return $txt;
    }

    function list_handle ($file, $templ, $sorttmpl, $order='', $limit='',
                          $select='', $select2='') {
	$collec = new XmlCollection ($file);

	$ltxt = "<div class='text'><dl>\n";
//	$lkeys = $collec->sorted_ids ($order, $limit, $select);
//        print "$sorttmpl -- $select -- $select2";
	$lkeys = $collec->sorted_keys ($sorttmpl, $order, $limit, $select,
	                               $select2);
	$ltxt .= $collec->asTemplateLines ($templ, $lkeys);
//	$ltxt .= $collec->asHTMLArray ($sorttmpl);
	$ltxt .= "</dl></div>\n";
	return $ltxt;
    }
?>

