<?php
    $ip = ini_get('include_path');
    $dr = $_SERVER['DOCUMENT_ROOT'];
    ini_set('include_path', "$dr/include:".$ip);
    
    include_once "pes/func.php";
    require_once "pes/doc_pes.php";
    require_once "xml/collection.php";
    
    class Adresse {
        var $titre = 'Mr';
        var $nom = '';
        var $prenom = '';
        var $adr1 = '';
        var $adr2 = '';
        var $code = '';
        var $ville = '';
        var $pays = '';
    
        /** Constructeur */
        function Adresse($carnet, $id) {
            global $pes_data;
            // print "$id === $carnet<br>";
            $adr = new XmlCollection ("$pes_data/$carnet.xml");
            $adref =& $adr->getAnElt($id);
            if ( $adref ) {
                //print_r($adref);
                $this->titre = '';
                if ( $carnet == 'adresses' ) {
                    $this->nom = $adref->valueAt('nom');
                    $this->prenom = $adref->valueAt('prenom');
                    $this->adr1 = $adref->valueAt('adresse');
                    $this->adr2 = '';
                } else {
                    $this->nom = '';
                    $this->prenom = '';
                    if ( $adref ) {
                        $at = $adref->attributesAt('contact');
                        $contact = $at['ref'];
                        // print "$contact<br>";
                        if ( ! $contact ) { 
                            $at = $adref->attributesAt('president');
                            $contact = $at['ref'];
                        }
                        if ( $contact ) {
                            $padr = new XmlCollection ("$pes_data/adresses.xml");
                            $padref =& $padr->getAnElt($contact);
                            if ( $padref ) {
                                $this->nom = $padref->valueAt('nom');
                                $this->prenom = $padref->valueAt('prenom');
                            }
                        }
                        $this->adr1 = $adref->valueAt('nom');
                        $this->adr2 = $adref->valueAt('adresse');
                    }
                }
                $this->code = $adref->valueAt('code');
                $this->ville = $adref->valueAt('ville');
                $this->pays = '';
            } else {
                $this->titre = 'Non trouv';
                $this->nom = '';
                $this->prenom = '';
                $this->adr1 = '';
                $this->adr2 = '';
                $this->code = '';
                $this->ville = '';
                $this->pays = '';
            }
        }
    
        function setAuteur($tit, $nom, $prenom) {
            $this->titre = $tit;
            $this->nom = $nom;
            $this->prenom = $prenom;        
        }
        
        function adrImg() {
            if ( $this->titre ) { $txt = $this->titre." "; }
            else { $txt = ''; }
            $txt .= $this->prenom." ".$this->nom."\n";
            $txt .= $this->adr1."\n";
            if ( $this->adr2 ) { $txt .= $this->adr2."\n"; }
            $txt .= $this->code." ".$this->ville;
            if ( $this->pays ) { $txt .= "\n".$this->pays; }
            return $txt;
        }
    }
    
    $adr_PES = new Adresse('associations', 'pouevr_et_seu');
    
    class PES_Lettre extends Doc_PES {

        var $pdfurl = "/extra/pdf/lettres/";
        var $pdfdir;
        var $content = array();
        var $items = array(
            'id'        => array('@id', 'Identification', '0'),
            'etat'      => array('@etat', 'Etat', '0'),
            'date'      => array('@date', '', '0'),
            'titre'     => array('exp_titre', 'Titre', "sel,,Mr,Mme,Mlle"),
            'prenom'    => array('exp_prenom', 'Prnom', '20'),
            'nom'       => array('exp_nom', 'Nom', '30'),
            'ref'       => array('exp_ref', 'Rfrence auteur', '5'),
            'la'        => array('dest@carnet', "Liste d'adresses", '0'),
            'refdest'   => array('dest@ref', 'Rfrence destinataire', 'sel'),
            'objet'     => array('objet', 'Objet du courrier', '60'),
            'pj'        => array('pieces_jointes', 'Pices jointes', '60'),
            'intro'     => array('intro', "Formule d'introduction", '40'),
            'texte'     => array('texte', "Texte de la lettre", '70x20')
            );
        
        /** Constructeur */
        function PES_Lettre() {
            global $dr;
            $this->Doc_PES();
            $this->pdfdir = $dr.$this->pdfurl;
        }
        
        function setLA($la) {
            $this->content['la'] = $la;
        }
    
        /** Initialise le contenu */
        function setContent($values) {
            global $adr_PES;
            $keys = array_keys($this->items);
            foreach ($keys as $k) {
                $this->content[$k] = stripslashes($values[$k]);
            }
            $this->_postInit();
        }
        
        /** Return the Id of the letter */
        function getId() {
            return $this->content['fname'];
        }
        
        /** post-init function used by setContent() and initFromXML() */
        function _postInit() {
            global $adr_PES;
            $adr_PES->setAuteur($this->content['titre'], $this->content['nom'],
                                $this->content['prenom']);
            $this->content['sign'] = $this->content['prenom']." ".
                                     $this->content['nom'];
            $this->content['dest'] = new Adresse($this->content['la'],
                                                 $this->content['refdest']);
            if ( !array_key_exists('fname', $this->content) || 
                 !$this->content['fname']) {
                $this->content['fname'] = todayAnsiLong()."_".
                         keepGoodChars(strtolower($this->content['dest']->nom));
            }
            if ( !preg_match('{^PES//}i', $this->content['ref']) ) {
                $this->content['ref'] = "PES//".$this->content['ref']."//".
                                        todayAnsiLong();
            }
            // print $this->content['dest']->adrImg()."<br>\n";
            // print_r ($this->content); print "<br>\n";
        }
    
        /** Initialise le contenu depuis un fichier XML */
        function initFromXML($filename) {
            global $adr_PES;
            // print "$filename<br>";
            $xml = new XMLfile();
            $xml->read_file($filename);
            // $xml->show();
            // print "$filename<br>";
            $keys = array_keys($this->items);
            foreach ($keys as $k) {
                $tp = $this->items[$k]; $x = $tp[0];
                $v = $xml->getValueByPath($x);
                // print "$k - $x -$v<br>";
                $this->content[$k] = $v;
            }
            // print_r($this->content);
            $this->_postInit();
        }
    
        /** Compose : compose la lettre et fabrique le fichier de sortie */
        function compose($in_pdf_file=1) {
            global $adr_PES, $pes_doc;
            // print_r ($this->content); print "<br>\n";
            $this->initDefaultMargins(40, 25, 35, 35);
            $this->SetFont('Times','', 12);
            // adresses
            $this->adresse($adr_PES, 'pes');
            $this->Text(95, 47, '');
            $this->adresse($this->content['dest']);
            $this->Objet();
            $this->Text(120, 90, $adr_PES->ville.", le ".todayFrench());
            $this->SetFont('Times','', 12);
            $this->Text(35, 125, $this->content['intro']);
            $this->setXY(35,129);
            $this->Justify(5, $this->content['texte']);
            $this->Signe();
            
            if ( $in_pdf_file ) {
                $filename = $this->pdfdir.$this->content['fname'].".pdf";
                $fileurl = $this->pdfurl.$this->content['fname'].".pdf";
                $this->Output($filename, false);
                // print "$filename crit<br>\n";
            } else {
                $filename = '';
                $fileurl = '';
                $this->Output();
            }
            return $fileurl;
        }
    
        /** Sauvegarde du fichier XML */
        function saveXMLFile() {
            global $pes_data;
            // print_r ($this->content); print "<br>\n";
            $filename = "$pes_data/lettres/".$this->content['fname'].".xml";
            $xml =& new XMLfile();
            $xml->create_root();
            $root =& $xml->roottag;
            $root->name = 'lettre';
            $root->set_attributes(array ('id' => $this->content['fname'],
                                          'etat' => 'S',
                                          'date' => todayAnsi()));
            $child =& $root->add_subtag('exp_titre', array ());
            $child->set_cdata_from_text($this->content['titre']);
            $child =& $root->add_subtag('exp_prenom', array ());
            $child->set_cdata_from_text($this->content['prenom']);
            $child =& $root->add_subtag('exp_nom', array ());
            $child->set_cdata_from_text($this->content['nom']);
            $child =& $root->add_subtag('exp_ref', array ());
            $child->set_cdata_from_text($this->content['ref']);
            $child =& $root->add_subtag('dest', array (
                                         'carnet' => $this->content['la'],
                                         'ref' => $this->content['refdest']));
            $child =& $root->add_subtag('objet', array ());
            $child->set_cdata_from_text($this->content['objet']);
            $child =& $root->add_subtag('pieces_jointes', array ());
            $child->set_cdata_from_text($this->content['pj']);
            $child =& $root->add_subtag('intro', array ());
            $child->set_cdata_from_text($this->content['intro']);
            $child =& $root->add_subtag('texte', array ());
            $child->set_cdata_from_text($this->content['texte']);
            $xml->write_file($filename);
            // print "$filename crit<br>\n";
            return $filename;
        }
        
        // Affichage identification
        function Objet() {
            $this->SetFont ('Arial', '', 8);
            $this->SetDrawColor(170);
            $this->SetTextColor(170);
            $this->Line(9, 102, 29, 102);
            $this->Line(180, 102, 200, 102);
            $this->Text(13, 96, "Ref: ".$this->content['ref']);
            $this->SetFont ('Arial', 'U', 10);
            if ( $this->content['objet'] ) {
                $this->Text(13, 100, "Objet: ".$this->content['objet']);
            }
            if ( $this->content['pj'] ) {
                $this->Text(13, 275, "Pices jointes: ".$this->content['pj']);
            }
            $this->SetDrawColor(0);
            $this->SetTextColor(0);
            $this->SetFont ('Times', '', 12);
        }
    
        /** affiche un bloc d'adresse
         */
         function adresse($adr, $which='dest') {
             $h = 30;       // hauteur d'adresse (mm)
             $w = 60;       // largeur (mm)
             if ( $which == 'dest' ) {
                 $lm = 120;
                 $this->setY(50);
             } else {
                 $lm = 13;
                 $this->setY(25);
             }
             $txt = $adr->adrImg();
             $this->Block($txt, $h, $lm, $w);
         }
         
        // Signature
        function Signe() {
            $this->SetFont('Times', '', 12 );
            $this->Ln(15);
            $this->SetX(120);
            $this->Write(5, $this->content['sign']);
        }
        
        /** genere le formulaire de saisie ou modification */
        function htmlForm($modif=false) {
            global $pes_data;
            $addr = new XmlCollection ("$pes_data/".$this->content['la'].".xml");
            $current = ($modif) ? $this->content['refdest'] : '';
            $sel_adr = $addr->getIdsAsSelectBlock('refdest', $current);
            $txt = "<input type='hidden' name='la' value='".
                   $this->content['la']."'>\n<table width='92%' ".
                   "style='background-color: #ddd; margin: 0.1ex auto;'>\n".
                   "<colgroup><col width='30%'/><col width='70%'/></colgroup>".
                   "\n<tbody>\n";
            foreach (array ('titre', 'prenom', 'nom', 'ref', 'refdest',
                            'objet', 'pj', 'intro') as $key) {
                $txt .= "<tr>\n<td class='left'>".$this->items[$key][1]."</td>".
                        "\n<td class='left'>";
                $parts = array();
                if ( $this->items[$key][2] == 'sel' ) {
                    $txt .= $sel_adr;
                } elseif ( preg_match("/^(\d+)$/", $this->items[$key][2], 
                                       $parts) ) {
                    $txt .= "<input type='text' size='".$parts[1].
                            "' name='$key'";
                    if ( $modif ) {
                        $txt .= " value='".$this->content[$key]."'";
                    }
                    $txt .= ">";
                } elseif ( preg_match("/^sel,(.*)$/", $this->items[$key][2], 
                                       $parts) ) {
                    $chx = preg_split("/,/", $parts[1]);
                    $txt .= "<select name='$key' style='width: 5em'>\n";
                    foreach ($chx as $c) {
                        $txt .= "  <option value='$c'";
                        if ( $modif && $c == $this->content[$key] ) { 
                            $txt .= " selected"; 
                        }
                        $txt .= ">$c</option>\n";
                    }
                    $txt .= "</select>\n";
                } else {;}
            }    
            $txt .= "</td>\n</tr>\n";
            $txt .= "</tbody>\n</table>\n<div ".
                    "style='width: 92%; background-color: #ddd; ".
                    "margin: 0.1ex auto;'>\n<p style='padding: 0.6ex;'".
                    "<b>".$this->items['texte'][1]."</b><br />\n";
            list ($c, $l) = explode('x', $this->items['texte'][2]);
            $txt .= "<textarea cols='$c' rows='$l' name='texte' ".
                    "style='margin: 1ex 2em;'>";
            if ( $modif ) { $txt .= $this->content[$key]; }
	    $txt .= "</textarea></p></div>\n";
            return $txt;
        }

    
    }
    
    // Test de la classe
    
/*   $txt = "Comme nous en avons convenu lors de nos entretiens tlphoniques, vous trouverez ci-joint deux exemplaires signs par nous des conventions de prestations du groupe \"Pouvr'et Seu\" pour la Fte du Golfe 2005  Arradon.
    Si les termes vous conviennent, je vous serais reconnaissant de bien vouloir nous retourner un exemplaire sign et de conserver l'autre ; sinon, prenez contact par tlphone avec moi pour que nous puissions ensemble amander notre proposition.
    Au nom de l'association PES je vous souhaite une entire russite pour cette animation  laquelle nous essaierons de contribuer de notre mieux.
    Cordialement
    "; */
    
/*   $pdf = new PES_Lettre();
    $txt = $pdf->htmlForm();
    print $txt;
    $pdf->initFromXML("$pes_data/lettres/20041228_voeux.xml"); */
/*    $pdf->setContent(array('titre' => '', 'prenom' => 'Daniel', 'nom' => 'Deveaux',
                       'ref' => 'DD', 'la' => 'associations', 
                       'refdest' => 'pouevr_et_seu',
                       'objet' => 'Convention pour la prestation PES de la Fte du Golfe 2005',
                       'pj' => 'deux exemplaires des deux conventions', 
                       'intro' => 'Madame, ', 'texte' => $txt)); */
//    $pdf->compose();
//    $pdf->saveXMLFile();
    
?>
