<?php
/** This file groups utility functions used in other scripts
 */
    $base = dirname(dirname(dirname(dirname(dirname(__FILE__)))));
    $base_url = str_replace($_SERVER['DOCUMENT_ROOT'], '', $base);

    $info_data = "$base/admin/xml-data";
    $info_esp = array('etud','ens','admin');
    $phpdir = "$base/parser/plugs/lib";
    $phpurl = "$base_url/services";

    $self = $_SERVER['PHP_SELF'];
    $path = $_SERVER['PATH_TRANSLATED'];
    
    /** Remove all character other than a-zA-Z0-9_ */
    function keepGoodChars($text, $sep='') {
      // $text = strtolower($text);
      $text = preg_replace ('/<!--.*-->\\s*(.*)$/i', "\$1", $text);
      $text = preg_replace ('/[]/', 'a', $text);
      $text = preg_replace ('/[]/', 'e', $text);
      $text = preg_replace ('/[]/', 'i', $text);
      $text = preg_replace ('/[]/', 'o', $text);
      $text = preg_replace ('/[]/', 'u', $text);
      $text = preg_replace ('/[]/', 'A', $text);
      $text = preg_replace ('/[]/', 'E', $text);
      $text = preg_replace ('/[]/', 'I', $text);
      $text = preg_replace ('/[]/', 'O', $text);
      $text = preg_replace ('/[]/', 'U', $text);
      $text = preg_replace("/[^a-zA-Z0-9_]/", $sep, $text);
      if ( $sep ) { 
          $text = preg_replace("/$sep+/", $sep, $text);
          $text = trim($text, $sep);
      }
      return $text;
    }

    /** stripslashes function for arrays
     */
    function array_stripslashes($arr) {
        // arrays are ignored
        if (!is_array($arr)){
            return $arr;
        }
        
        $rs = array();
        while (list($key, $val) = each($arr)) {
            if ( is_array($arr[$key]) ) {
                $rs[$key] = array_stripslashes($arr[$key]); 
            } else {
                $rs[$key] = htmlspecialchars(stripslashes($val), ENT_QUOTES);
            }
        }
        return $rs;
    }
    
    /** return the today date in french format				*/
    function todayFrench () {
	$now = time();
	$today = date ("d", $now)."/".date("m", $now)."/".date("Y", $now);
	return $today;
    }

    /** return the today date in ansi format				*/
    function todayAnsi () {
	$now = time();
	$today = date ("Y", $now)."-".date("m", $now)."-".date("d", $now);
	return $today;
    }

    /** return the today date in ansi format without '-'				*/
    function todayAnsiLong () {
	$now = time();
	$today = date ("Y", $now).date("m", $now).date("d", $now);
	return $today;
    }

    /** build an ansi date string					*/
    function ansiDate ($year=0, $month=0, $day=0) {
	if ($year == 0) {
	    $now = time();
	    $date = date ("Y", $now)."-".date("m", $now)."-".date("d", $now);
	} else { $date = "$year-$month-$day"; }
	return $date;
    }

    /** build an ansi date as long image string					*/
    function ansiLongDate ($year=0, $month=0, $day=0) {
	if ($year == 0) {
	    $now = time();
	    $date = date ("Y", $now).date("m", $now).date("d", $now);
	} else { $date = "$year$month$day"; }
	return $date;
    }

    /** build a french date string					*/
    function frenchDate ($year=0, $month=0, $day=0) {
	if ($year == 0) {
	    $now = time();
	    $date = date ("d", $now)."/".date("m", $now)."/".date("Y", $now);
	} else { $date = "$day/$month/$year"; }
	return $date;
    }

    /** prepare a date form section					*/
    function formDate ($aid='annee', $va=0, $mid='mois', $vm=0, $did='jour',
                       $vd=0, $annb=5) {
	$curan = date ('Y', time());
	if ( $va == 0 ) { $va = $curan; }
	if ( $va < $curan ) { $curan = $va; }
	if ( $vm == 0 ) { $vm = '01'; }
	if ( $vd == 0 ) { $va = '01'; }
	$ret = "<select name='$aid'>\n";
	for ( $i = 0 ; $i < $annb ; $i++ ) {
	    $ret .= " <option value='$curan'";
	    if ( $va == $curan ) { $ret .= " selected"; }
	    $ret .= ">$curan</option>\n";
	    $curan += 1;
	}
	$ret .= "</select>\n<select name='$mid'>\n";
	$i = 0;
	foreach ( array ('jan', 'fev', 'mar', 'avr', 'mai', 'jun', 'jul',
	                 'aou', 'sep', 'oct', 'nov', 'dec') as $m) {
	    $i++ ; $im = str_pad ($i, 2, '0', STR_PAD_LEFT);
	    $ret .= " <option value='$im'";
	    if ( $vm == $im ) { $ret .= " selected"; }
	    $ret .= ">$m</option>\n";
	}
	$ret .= "</select>\n<select name='$did'>\n";
        for ( $i = 1 ; $i <= 31 ; $i++ ) {
	    $v = str_pad ($i, 2, '0', STR_PAD_LEFT);
	    $ret .= " <option value='$v'";
	    if ( $vd == $v ) { $ret .= " selected"; }
	    $ret .= ">$v</option>\n";
	}
	$ret .= "</select> ";
	return $ret;
    }

    /** prepare a hour form section					*/
    function formHour ($hid='heure', $vh=0, $hdef='9', $mid='mn', $vm='00') {
	if ( $vh == 0 ) { $vh = $hdef; }
	$ret = "<select name='$hid'>\n";
	if ( $hdef == '-' ) {
	    $ret .= " <option value='-'";
	    if ( $vh == $hdef ) { $ret .= " selected"; }
	    $ret .= ">-</option>\n";
	}
	for ( $i = $hdef + 1 ; $i < 24 ; $i++ ) {
	    $v = str_pad ($i, 2, '0', STR_PAD_LEFT);
	    $ret .= " <option value='$v'";
	    if ( $vh == $v ) { $ret .= " selected"; }
	    $ret .= ">$v</option>\n";
	}
	$ret .= "</select>h<select name='$mid'>\n";
	foreach (array ('00', '15', '30', '45') as $v) {
	    $ret .= " <option value='$v'";
	    if ( $vm == $v ) { $ret .= " selected"; }
	    $ret .= ">$v</option>\n";
	}
	$ret .= "</select>mn&nbsp;&nbsp;";
	return $ret;
    }

?>
