<?php
/*
 *   Classe formulaire inspir de 'fiche-projet.phtml' de G.Mogurou
 *   - saisie et contrle des donnes
 *   - si ok, envoi de la demande par mail au(x) destinataire(s)
 *     avec copie au demandeur
 *
 *   NB1 : les demandes ne sont pas conserves, donc ni numro d'ordre,
 *         ni ticket, ni suivi, etc. Toute la gestion des demandes, en
 *	   particulier une ventuelle mise en ligne de la page HTML produite
 *         est laisse  l'initiative des destinataires du courrier.
 *
 *   NB2 : php 3 ! Donc pas de session... Donc on utilise les hidden input
 *
 */
require_once 'Text/MiniWiki.php';

$auteur   = "daniel.deveaux";
$version  = "1.0";
$date_maj = "$Date: 2005/12/05 22:30:58 $";

set_magic_quotes_runtime(0);

class BasicForm {

    var $buffer = '';		// local text buffer
    var $sorted_keys = array(); // ordered tab of param keys
    var $param = array();	// table that contains actual parameters
    var $templates = array();   // table of parameters templates
    var $strings = array();	// table that contains strings
    var $dest = '';		// destination directory
    var $action = '';		// action associated to POST
    var $pagetemplate ='';      // filename of page template

    /** BasicForm constructor
     */
    function BasicForm ($sk, $tmpls, $strs, $url, $dest) {
	$this->init_buffer();
	$this->sorted_keys = $sk;
        $this->templates = $tmpls;
	$this->strings = $strs;
        $this->url = $url;
	$this->dest = $dest."/";
	$this->param['dest'] = $this->strings['dest'];
	$this->param['copies'] = $this->strings['copies'];
    }

    /** make a filename with current date in it
     */
    function dated_file_name($ext) {
	//$fname = str_replace (" ", "_", strtolower ($basename));
	$basename = $this->uniq_id();
	$filename = $basename . $ext;
	return $filename;
    }

    /** (re)init the text buffer
     */
    function init_buffer() {
        $this->buffer = '';
    }

    /** add textual data to text buffer
     */
    function add_to_buffer($chaine) {
        $this->buffer .= $chaine;
    }

    /** make uniq id of the file
     */
    function uniq_id() {
	$basename = $this->param['id'];
	if ( $this->strings['keysup'] ) {
	    $basename .= "_".$this->param[$this->strings['keysup']];
	}
	$basename = ereg_replace("[ \-\']", "_", strtolower ($basename));
	$basename = strtr ($basename, "", "aaeeeiioouuu");
	$dstr = strftime("%Y%m%d");
	$basename = $dstr . '_' . $basename;
        $this->uid = $basename;
	return $basename;
    }

    /** reverse function of php function htmlspecialchars()
     */
    function unhtmlspecialchars( $string ) {
	$string = str_replace( '&#039;', '\'', $string );
	$string = str_replace( '&quot;', '\"', $string );
	$string = str_replace( '&lt;', '<', $string );
	$string = str_replace( '&gt;', '>', $string );
	$string = str_replace( '&amp;', '&', $string );
	return $string;
    }

    /** create a email and send it to dest and copies
     */
    function send_mail() {
	$subject = $this->strings['subject'] .' '. $this->param['id'];
	$orig = $this->param[$this->strings['orig']];
	if ( ($this->strings['copie'] != '') &&
	     (array_key_exists($this->strings['copie'], $this->param)) ) {
	    $copie = $this->param[$this->strings['copie']];
	} else {
	    $copie = $this->strings['copie'];
	}
	$dest = $this->param['dest'];
        if ( !(strpos($orig, '@') === false) ) {
            $dest .= ','.$orig;
	}
	$reply = $this->param['dest'];

	$message = '';
	for ( reset($this->sorted_keys) ;
	      list($i, $key) = each($this->sorted_keys) ;) {
	    $message .= strtoupper($this->templates[$key]['question']);
	    $message .= ": ". $this->param[$key]."\n";
	}
        $message .= $this->strings['end_msg1']. $this->action;
	$message .= $this->strings['end_msg2']. $this->strings['dest'];

	// headers contains all information not in 'mail()' arguments
	// From, Reply-To, Cc  and X-Mailer

	$headers = "Reply-To: ". $reply ."\nCc: ". $copie.
	           "\nX-Mailer: PHP/" . phpversion();
 	// c'est prt, on envoie
	mail($dest, $subject, $message, $headers);
    } // fin send_mail

    /** create an XML file that retains all data
     */
    function save_xml() {

	$message = "<fiche id='". $this->uniq_id() ."'>\n";
	for ( reset($this->sorted_keys) ;
	      list($i, $key) = each($this->sorted_keys) ;) {
	    $message .= '  <'. $key .'>'. htmlspecialchars($this->param[$key]);
	    $message .= '</'. $key .">\n";
	}
	$message .= "</fiche>\n";
	// save the message body in a file
	$filename = $this->strings['directory'].$this->dated_file_name('.xml');
	$fp = fopen($filename, "w");
	if ( $fp != false ) {
	    fwrite($fp, $message);
	    if ( ! fclose ($fp) ) {
		echo("ERREUR: l'criture de '$filename' a chou<br/>\n");
		$ret = false;
	    }
	}
    } // fin save_xml

    /** initialise parameters with the default values if empty and strip
     *  the slashes.
     */
    function init($act, $par) {
	$this->action = $act;
	if ( $par ) {
	    for ( reset($par) ; list($k, $v) = each($par) ;) {
		$this->param[$k] = $this->unhtmlspecialchars(stripslashes($v));
	    }
	}
	for ( reset($this->sorted_keys) ;
	      list($i, $key) = each($this->sorted_keys) ;) {
	    if ( $this->param[$key] == '' ) {
	        $this->param[$key] = $this->templates[$key]['default'];
	    }
	    $this->param[$key] = $this->unhtmlspecialchars(stripslashes($this->param[$key]));
	}
    }

    /** adjust the question
     */
    function lib_question($key) {
	$q = $this->templates[$key]['question'];
	$q = str_replace(" ", "&nbsp;", $q);
	return $q;
    }

    /** display the form for typing
     */
    function display_form($emptyform=FALSE) {
        global $phpurl;
        
	if ($emptyform) {
	    $this->display_error($this->strings['emptyform']);
	} else {
	    $this->display_errors();
	}
        $wikidoc = "$phpurl/MiniWikiDoc.php?mode=help";
        $this->add_to_buffer("<div style='margin: 3em 5em 1em 5em; padding: 0.3ex 2ex;
            background-color: #d9e9e9; border: 1px solid black;'>
<p style='text-align: center'>Merci de <b style='color: red;'>ne pas faire de copier/coller</b> depuis
une page d'dition ou de visualisation de HTML, Word ou OO <em>(par contre, un 
copier/coller depuis un xterm ou un diteur texte fonctionne bien).</em><br />
Vous pouvez employer des <a href='$wikidoc' target='_new'><b>constructions 
Wiki</b></a> pour remplir et structurer les champs de ce formulaire.</p>
</div>\n");
        $this->add_to_buffer("
	    <form action='". $this->action ."' method='POST'>
            <input type=hidden name='state' value=''>
            <input type=hidden name='dest' value='".
	    $this->param['dest'] ."'>\n<input type=hidden name='copies' ".
	    "value='". $this->param['copies'] ."'>\n");
	$this->add_to_buffer("	<table cellspacing='0' cellpadding='5' ".
	                      "width='85%' align='center'>\n".
	      "<colgroup><col width='40%'/><col width='60%'/></colgroup>\n");
	$in_table = false;
	for ( reset($this->sorted_keys) ; list($i, $key) = each($this->sorted_keys) ;) {
	    $pos = strpos($this->templates[$key]['type'], ',');
	    if ( !($pos == false) ) { // textarea
		if ( $in_table ) {
		    $this->add_to_buffer("</table>\n");
		    $in_table = false;
		}
		list ($c, $l) = explode(',', $this->templates[$key]['type']);
		$this->add_to_buffer("<div width='85%' align='center'>\n<p>".
		                      $this->lib_question ($key) .
		                      " :<br />\n");
		$this->add_to_buffer("<textarea cols='$c' rows='$l' ".
		                      "name='$key'>".$this->param[$key].
				      "</textarea><br />&nbsp;</p></div>\n");
	    } else {
		if ( ! $in_table ) {
		    $in_table = true;
		    $this->add_to_buffer("<table cellspacing='0' ".
		             "cellpadding='5' width='80%' align='center'>\n" .
	      "<colgroup><col width='40%'/><col width='60%'/></colgroup>\n");
		}
		$this->add_to_buffer(" <tr>\n".
		                      "  <td class='left'>".
				      $this->lib_question ($key) .
				      "</td>\n  <td class='left'>");
		if ( $this->templates[$key]['type'] == 'select' ) {
		    $pilote = $this->templates[$key]['apilote'];
		    $this->add_to_buffer("<select style='width: 15em;' name='".
					  $key ."'>" );
		    for (reset($pilote); list($k, $v) = each($pilote);) {
			$this->add_to_buffer("<option value=\"$k\"");
			if ($key == $this->param[$key]) {
			    $this->add_to_buffer(" selected");
			}
			$this->add_to_buffer(">$v</option>\n");
		    }
		    $this->add_to_buffer("</select>\n");
		} elseif ( $this->templates[$key]['type'] == 'on' ) {
		    $this->add_to_buffer("<input type='checkbox' ".
					  "name='$key'>");
		} elseif ( $this->templates[$key]['type'] == 'sep' ) {
		    $this->add_to_buffer("<hr width='60%' />\n");
		} else {  // text
		    $l = $this->templates[$key]['type'];
		    $this->add_to_buffer("<input type='text' size='$l' ".
					  "name='$key' value=\"".
					  $this->param[$key] ."\">");
		}
		$this->add_to_buffer("</td>\n </tr>\n");
	    }
	}
	if ( $in_table ) {
	    $this->add_to_buffer("</table>\n");
	}
        $this->add_to_buffer("<hr/>\n<input type=submit value='".
			      $this->strings['showbut'] ."'>\n</form>\n");
    }

    /** display the data in readable format
     */
    function display_data() {

	$wiki =& new MiniWiki();
        $in_table = false ;
	for ( reset ($this->sorted_keys) ;
	      list ($i, $key) = each ($this->sorted_keys) ;) {
	    $pos = strpos ($this->templates[$key]['type'], ',');
	    if ( $pos == false ) { // its not a textarea
		if ( ! $in_table ) {
		    $in_table = true;
		    $this->add_to_buffer("<table width='100%'>\n" .
	      "<colgroup><col width='40%'/><col width='60%'/></colgroup>\n");
		}
		$this->add_to_buffer(" <tr>\n  <td class='left'><b>".
	                             $this->lib_question ($key).
				     ":</b></td>\n".
				     "  <td class='left'>");
	        if ( $this->templates[$key]['type'] == "on" ) {
		    if ( $this->param[$key] == "on" ) {
			$val = "oui";
		    } else { $val = "non"; }
		} else {
		    $val = $this->param[$key];
		    $val = $wiki->transform ($this->param[$key]);
		}
	        if ( $this->templates[$key]['emph'] ) {
		    $emp = $this->templates[$key]['emph'] ;
		    $this->add_to_buffer("<$emp>$val</$emp>");
		} else {
		    $this->add_to_buffer($val);
		}
		$this->add_to_buffer("</td>\n</tr>\n");
	    } else { // element is a texarea
		if ( $in_table ) {
		    $this->add_to_buffer("</table>\n<hr/>\n");
		    $in_table = false;
		}
		$this->add_to_buffer("<p><b>".
	                             $this->lib_question ($key) .
				     "</b>:<br/>\n");
/*		$text = htmlspecialchars ($this->param[$key]);
		$text = nl2br ($text);
		$text = str_replace ("<br>", "<br />", $text);
	        if ( $this->templates[$key]['emph'] ) {
		    $emp = $this->templates[$key]['emph'] ;
		    $this->add_to_buffer("<$emp>".$this->param[$key].
		                          "</$emp>");
		} else {
		    $this->add_to_buffer ($text);
		}
		$this->add_to_buffer("</p><p>&nbsp;</p>\n");  */
		$result = $wiki->transform ($this->param[$key]);
		$this->add_to_buffer("<div class='text'>\n$result\n</div>\n");
	    }
	}
	if ( $in_table ) {
	    $this->add_to_buffer("</table>\n<hr/>\n");
	}
    }

    /** place an hidden form in the page to transmit data to next step
     *  the only shown elements are buttons
     */
    function hidden_form($state, $message) {
        $this->add_to_buffer("<hr/>
            <!-- $state button with all parameters -->
            <form action='". $this->action ."' method='POST'>
            <input type='hidden' name='state' value='". $state ."'>
            <input type='hidden' name='dest' value='".
	    $this->param['dest'] ."'>
            <input type='hidden' name='copies' value='".
	    $this->param['copies'] ."'>
	    \n");
	for ( reset($this->sorted_keys) ;
	      list($i, $key) = each($this->sorted_keys) ;) {
	    $this->add_to_buffer("<input type='hidden' name='$key' ".
	                   "value=\"" . addslashes(htmlspecialchars($this->param[$key])).
			   "\">\n");
	}
         $this->add_to_buffer("<input type='submit' value=\"".$message."\">
            </form>\n");
    }

    /** display the acquisition page
     */
    function acquisition($empty) {
	$this->init_buffer();
	$this->display_form($empty);
        print $this->buffer;
    }

    /** display the control page
     */
    function control_display() {
	$this->init_buffer();
	$this->display_data();
	$this->hidden_form('send', $this->strings['sendbut']);
	$this->hidden_form('modif', $this->strings['modbut']);
        print $this->buffer;
    }

    /** compose and save the HTML page
     */
    function save_html() {
	$this->init_buffer();
        $this->add_to_buffer($this->strings['header']);
	$this->display_data();
        $this->add_to_buffer($this->strings['footer']);
	if ( $this->strings['dirhtml'] ) {
	    $html = $this->buffer;
	    // save on file
	    $filename = $this->strings['dirhtml'].
	                $this->dated_file_name ('.htm');
	    $fp = fopen ($filename, "w");
	    if ( $fp != false ) {
		fwrite ($fp, $html);
		if ( ! fclose ($fp) ) {
		    echo ("ERREUR: l'criture de '$filename' a chou<br/>\n");
		    $ret = false;
		}
	    }
	}
	// save as XML and send an email
	$this->save_xml();
	$this->send_mail();
	// and display an acknowledgment
        print "Id : <b>" . basename($filename, '.htm') ."</b><br />";
	print $this->strings['ack'];
    }

    /** display an error message
     */
    function display_error($message="Erreur !") {
        $this->add_to_buffer("<p class='red'>".$message."</p>\n");
    }

    /** Is the form empty?
     */
    function empty_form() {
	$ret = true;
	for ( reset($this->sorted_keys) ;
	      list($i, $key) = each($this->sorted_keys) ;) {
	    if ( $this->param[$key] != '' &&
	        $this->param[$key] != $this->templates[$key]['default'] ) {
		$ret = false;
		break;
	    }
	}
	return $ret;
    }

    /** detect one error on one parameter
     */
    function has_error($key) {
	if ( $this->templates[$key]['type'] != "on" &&
	     $this->templates[$key]['type'] != "sep") {
	    $ret = ($this->param[$key] == "" ||
		    $this->param[$key] == $this->templates[$key]['default']);
	} else { $ret = false; }
	return $ret;
    }

    /** display one error on one parameter
     */
    function detect_error($key) {
	if ( $this->has_error ($key) ) {
	    $this->display_error ($this->strings['err_not_def'].
	                          $this->templates[$key]['type'].
	                          $this->templates[$key]['question']."'");
	}
    }

    /** detect all errors in the form
     */
    function has_errors() {
	$ret = false;
 	for ( reset ($this->sorted_keys) ;
	      list ($i, $key) = each ($this->sorted_keys) ;) {
	    $ret |= $this->has_error ($key);
	}
	return $ret;
    }

    /** display all errors in the form
     */
    function display_errors() {
 	for ( reset ($this->sorted_keys) ;
	      list ($i, $key) = each ($this->sorted_keys) ;) {
	    $this->detect_error ($key);
	}
    }

    /** execute all the action following the current state
     */
    function go($act, $par) {
        $this->init($act, $par);
	$empty = $this->empty_form();
	// dans quel etat j'erre ?
	if ($this->param['state'] == "") {
	    // soit on vient d'ouvrir un formulaire vide,
	    // soit on vient de corriger des erreurs
	    if ( $empty || $this->has_errors() ) {
		$this->param['state']='modif';
	    }
	    else {
		$this->param['state']='control';
	    }
	}
	if ($this->param['state'] == 'modif') {
	    // 1ere etape : saisir correctement les infos demandees
	    // on sort en etat de contrle ("control")
	    $this->acquisition($empty);
	} elseif ($this->param['state'] == 'control') {
	    // 2e etape : relire et envoyer la demande
	    // on sort en state "envoi" si accepte ou "modifier" si retour a la saisie
	    $this->control_display();
	} elseif ($this->param['state'] == 'send') {
	    // 3e etape : message de fin
	    // cette etape n'est plus un formulaire
	    $this->save_html();
	} else {
	    print "<h2>Bug!</h2>
	    Le formulaire est dans un tat inconnu : '".
	    $this->param['state'] ."<br />
	    Merci de signaler ce problme...";
	}
    }
}

?>
