#! /usr/bin/env python -- # -*- python -*-
# -*- coding: iso-8859-1 -*-
#-----------------------------------------------------------------------------
#	file	Xtmpl.py
#	role	a simple template class compatible with xtmpl.php templates
#	maj	$Date: 2005/06/13 00:22:40 $
#
#
#  Copyright (c) 2004 - UBS-UFR-SSI-Valoria
#
#  This software is distributed under FSF GPL -- read details in
#  GNU_LICENSE and COPYING files provided with this distribution.
#
#
import sys, string, re, os

from Subst import Subst

RE_comment = re.compile (r'^<!--')

class Xtmpl:
    """A simple template class compatible with xtmpl.php templates
    """
    def __init__ (self, filepath):
	"""initialization method
	"""
	self._tmpl_file = filepath
	fp = open (filepath, 'r')
	self._text = unicode(fp.read(), 'iso-8859-1')
	fp.close()
	self._sub = None
        # --------------------------------------------------------- __init__()

    def init_subst (self):
	"""Add a new value in the substitution table
	"""
	self._sub = Subst()
        # --------------------------------------------------------- addSubst()

    def add_subst (self,
    	newkey,			# new substitution key
	newvalue		# new value
	):
	"""Add a new value in the substitution table
	"""
	self._sub.addSubst ("\*%s\*" % newkey, newvalue)
        # --------------------------------------------------------- addSubst()

    def apply_template (self):
	"""Use a XTPL template to generate an HTML file.

	Return the finalized text
	"""
	lines = string.split (self._text, "\n")
	for line in lines:
	    if RE_comment.match (line):
		continue
	    self._sub.write (line + "\n")
	return self._sub.getvalue()
	# --------------------------------------------------- apply_template()


    # ------------------------------------------------------------ class Xtmpl

