#! /usr/bin/env python -- # -*- python -*-
# -*- coding: iso-8859-15 -*-
#-----------------------------------------------------------------------------
#	file	ubs.text.Subst.py
#	role	text accumulator with substitutions
#	maj	2001/05/23
#
#	Look at '__rcs_info__' section and 'docstring' below for more
#	information
#
#  Copyright(c) 2001 - UBS-Valoria
#
#  This software is distributed under FSF GPL -- read details in
#  GNU_LICENSE and COPYING files provided with this distribution.
#
#-----------------------------------------------------------------------------
#
# DISCLAIMER
#
#   This software is provided by 'UBS - Valoria' "as is" and any
#   expressed or implied warranties, including, but not limited to, the
#   implied warranties of merchantability and fitness for a particular
#   purpose are disclaimed.  In no event shall 'UBS - Valoria' or its
#   contributors be liable for any direct, indirect, incidental,
#   special, exemplary, or consequential damages(including, but not
#   limited to, procurement of substitute goods or services; loss of
#   use, data, or profits; or business interruption) however caused and
#   on any theory of liability, whether in contract, strict liability,
#   or tort(including negligence or otherwise) arising in any way out
#   of the use of this software, even if advised of the possibility of
#   such damage.
#
#-----------------------------------------------------------------------------
#
#   The module, classes and methods 'docinfo' strings and meta-information
#   defined bellow are used to produce documentation through 'HappyDoc'
#   documentation tool: complete it carefully.
#
"""text accumulator with substitutions

    This module defines the class 'ubs.text.Subst'. This class defines a
    string accumulator handled as a StringIO; each write operation implies
    a replacement tokens substitution.

    Look at class documentation for an overview of functionalities and all
    features.

    This module uses 'StringIO' standard module

"""
__version__ = "$Revision: 1.1.1.1 $"[11:-2]
__copyr__ = """Copyright(c) 2001 - UBS-Valoria"""
__rcs_info__ = {
    #  Creation Information
    #
    'module_name'  : '$RCSfile: Subst.py,v $',
    'rcs_id'       : '$Id: Subst.py,v 1.1.1.1 2005/06/13 00:22:36 deveaux Exp $',
    'creator'      : 'D.Deveaux <daniel.deveaux@univ-ubs.fr>',
    'project'      : 'aglae.pyAglae',
    'created'      : '2001/05/23',

    #  Current Information
    #
    'author'       : '$Author: deveaux $'[11:-2],
    'state'	   : '$State: Exp $'[8:-2],
    'date'         : '$Date: 2005/06/13 00:22:36 $'[7:-2],
}

#
#   Standard modules importation
#
import string, re, os
from StringIO import StringIO

#
#   Specific modules importation
#

#
#   Module-level informations
#


# --------------------------------------------------------------------------

def makeSubst(subobj, text, html=1):
    """make the standard subtitutions in the passed text.

    Returns a new text
    """
    subobj.write(text)
    txtsub = subobj.getvalue() ; subobj.close()
    if html:
	txtsub = string.replace(txtsub, "&", "&amp;")
    return txtsub
    # ------------------------------------------------------------ makeSubst()

# --------------------------------------------------------------------------


RE_bvt = re.compile(r'begin{verbatimtab}')
RE_evt = re.compile(r'end{verbatimtab}')
RE_tir = re.compile(r'\\,')

class Subst:
    """'ubs.text.Subst' class.

    This class handles ...
    """


    def __init__(self, modeLaTeX=0):
	"""Subst constructor.

	"""
	#  instance variables definition and initialisation ----------
        self.coding = 'iso-8859-15'     # the default encoding for the buffer
	self.cb = StringIO()		# the text accumulation buffer
	self.substTab = []		# substitution table
	self.modeltx = modeLaTeX	# choice of LaTeX mode
	self.inVerb = 0
        # --------------------------------------------------------- __init__()

    #
    #	Accessors ------------------------------------------------------------
    #
    def	getvalue(self):
    	"""Get the value of the text buffer
    	"""
    	return self.cb.getvalue()
        # --------------------------------------------------------- getvalue()

    def	getsubstTab(self):
    	"""Get the value of the substitution table
    	"""
    	return self.substTab
        # ------------------------------------------------------ getsubstTab()

    #
    #	Modifiers ------------------------------------------------------------
    #
    def setSubstTab(self,
    	*newTab			# new substitution table(list args)
	):
	"""Initialize the substitution table
	"""
	self.substTab = []
        i = 0
	for i in range(0, len(newTab), 2):
            rew = re.compile("%s" % newTab[i])
	    self.substTab.append((rew, newTab[i+1].encode(self.coding)))
        # ------------------------------------------------------ setSubstTab()

    def setSubstTabAsHash(self,
    	newTab			# new substitution table(hash)
	):
	"""Initialize the substitution table
	"""
	self.substTab = []
	for k in newTab.keys():
            ##print newTab[k].encode(self.coding)
            rew = re.compile(k)
	    self.substTab.append((rew, newTab[k].encode(self.coding)))
        # ------------------------------------------------ setSubstTabAsHash()

    def addSubst(self,
    	newkey,			# new substitution key
	newvalue		# new value
	):
	"""Add a new value in the substitution table
	"""
	rew = re.compile(newkey)
	self.substTab.append((rew, newvalue.encode(self.coding)))
        # --------------------------------------------------------- addSubst()

    def write(self,
	txt			# text to substitute and write
	):
	"""Write a text in string buffer.

	All substitutions are made on 'txt' before storage.
	"""
	txt = txt.encode(self.coding)
	lines = txt.split(u"\n")
	for line in lines:
	    if RE_bvt.search(line):
		self.inVerb = 1
	    elif RE_evt.search(line):
		self.inVerb = 0
	    else:
		if((not self.inVerb) and len(self.substTab) > 0 ):
		    for a in self.substTab:
			(rew, newv) = a
			if rew.search(line):
			    line = rew.sub(newv, line)
		    if line[0:2] == "%%":
			line = RE_tir.sub('', line)
            self.cb.write(line + "\n")
        # ------------------------------------------------------------write()

    def close(self):
        """close the text buffer
        """
        self.cb.close()
        self.cb = StringIO()
        # ------------------------------------------------------------close()


    # ------------------------------------------------------------------------
    #	Testing Units implementing methods
    #

    def _TST_create(self):
    	"""Creation testing unit.
        """

        print "\n## Subst object initialisation\n"
        # ------------------------------------------------------- TST_create()

    def _TST_unit(self):
    	"""Creation testing unit.
        """
        self.setSubstTab(u'<role>', u'un role', u'<nom>', u'nom du fichier')
	print "table de valeurs  substituer", self.getsubstTab()
        txt = u"""#file	<nom>.py
        #role	<role>
        <role>
        This module defines the composite widget '<nom>'. This widget ...
	"""
        print "\ntexte de base\n",txt
	self.write(txt)
        print "\ntexte modifi\n",self.getvalue()
        self.close()
        print "\n## End of _TST_unit\n"
        # --------------------------------------------------------- TST_unit()


# ---------------------------------------------------------------- class Subst
#
#   Main testing function called for self-test
#
def test():
    """Main testing function

    Launched by direct execution of module: "python ubs.text.Subst.py"
    """

    import sys, getopt

    testedObj = Subst()
    testedObj._TST_create()
    testedObj._TST_unit()
    print "\n## Test finished\n"
    # ----------------------------------------------------------------- test()

#   Launch test if called standalone
if __name__=="__main__": test()

# --------------------------------------------------------------- module Subst

