#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-
#-----------------------------------------------------------------------------
"""
Gives an interface to read XML collection files
"""
__version__ = "$Revision: 1.1.1.1 $"[11:-2]
__copyr__ = """Copyright (c) 2004 - UBS-Valoria"""
__rcs_info__ = {
    #  Creation Information
    #
    'module_name'  : '$RCSfile: Collection.py,v $',
    'rcs_id'       : '$Id: Collection.py,v 1.1.1.1 2005/06/13 00:22:20 deveaux Exp $',
    'creator'      : 'D.Deveaux <daniel.deveaux@univ-ubs.fr>',
    'project'      : 'site web DESS-ASIR',
    'created'      : '2004/02/20',

    #  Current Information
    #
    'author'       : '$Author: deveaux $'[11:-2],
    'state'	   : '$State: Exp $'[8:-2],
    'date'         : '$Date: 2005/06/13 00:22:20 $'[7:-2],
}

#
#   Standard modules importation
#
import string, re, os

import xml.dom.minidom
from MiniWiki import MiniWiki

class Collection:
    """Implements a collection connected with an XML file (read only)
    """

    def __init__ (self, fname, file_path):
	"""Init function for collection object

	Read the XML file 'file_path' abd load the associated DOM.
	"""
	self.elname = fname
	self.fname = file_path
	self.dom = xml.dom.minidom.parse(self.fname)
	self.wiki = MiniWiki()
    # ------------------------------------------------------------- __init__()

    def get_elements (self, with_template=0):
	"""Get an array of the 'cours' elements of the collection

	If 'with_template' is true, the first (template) element is in the
	array, removed else
	"""
        elts = self.dom.getElementsByTagName (self.elname)
	if not with_template:
	    elts = elts[1:]
	## print elts
	return elts
    # --------------------------------------------------------- get_elements()

    def _get_text (self, nodelist, with_br=0):
	"""Text extractor for the 'subst_tab()' function
	"""
	rc = ""
	for node in nodelist:
	    if node.nodeType == node.TEXT_NODE:
		rc = rc + node.data
	    elif node.nodeType == node.ELEMENT_NODE and node.nodeName == 'br':
		##if with_br:
		##    rc += "<br />\n"
		##else:
                rc += "\n"
##	txt = unicode (rc, 'iso_8859-1')
        txt = rc.replace ("\n\n", "\n")
	(txt, status) = self.wiki.transform(txt)
	if status:
	    print "Erreurs dtectes dans source :\n%s" % status
	if txt:		txt = txt.encode('iso_8859-15')
	return txt
	# -------------------------------------------------------- _get_text()

    def subst_tab (self, elt, with_br=0):
	"""Define the substitution table for an element 'elt'
	"""
	# make the substitution table
	stab = {}
	stab['{id}'] = (elt.getAttribute ('id').encode ('iso_8859-15'))
	for node in elt.childNodes:
	    if node.nodeType == node.ELEMENT_NODE:
		key = node.tagName
		if node.hasAttribute ('ref'):
		    stab['{%s}' % key] = unicode (
		                   node.getAttribute ('ref'), 'iso_8859-15')
		else:
		    text = self._get_text (node.childNodes, with_br)
		    stab["{%s}" % key] = text
	return stab
	# -------------------------------------------------------- subst_tab()


